<?php

/*
 * This file is part of Sulu.
 *
 * (c) Sulu GmbH
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */

namespace Sulu\Component\Webspace\Analyzer\Attributes;

use Sulu\Component\Localization\Localization;
use Sulu\Component\Webspace\Manager\WebspaceManagerInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Extracts attributes from request for the sulu-admin.
 */
class AdminRequestProcessor implements RequestProcessorInterface
{
    /**
     * @var WebspaceManagerInterface
     */
    private $webspaceManager;

    /**
     * @var string
     */
    private $environment;

    public function __construct(WebspaceManagerInterface $webspaceManager, $environment)
    {
        $this->webspaceManager = $webspaceManager;
        $this->environment = $environment;
    }

    public function process(Request $request, RequestAttributes $requestAttributes)
    {
        $attributes = [];
        $attributes['webspaceKey'] = $request->get('webspace');
        $attributes['locale'] = $request->get('locale', $request->get('language'));

        if ($attributes['locale']) {
            $attributes['localization'] = Localization::createFromString($attributes['locale']);
        }

        if (empty($attributes['webspaceKey'])) {
            return new RequestAttributes($attributes);
        }

        $attributes['webspace'] = $this->webspaceManager->findWebspaceByKey($attributes['webspaceKey']);

        if (null === $attributes['locale']) {
            return new RequestAttributes($attributes);
        }

        $attributes['localization'] = $attributes['webspace']->getLocalization($attributes['locale']);

        return new RequestAttributes($attributes);
    }

    public function validate(RequestAttributes $attributes)
    {
        return true;
    }
}
