<?php

/*
 * This file is part of Sulu.
 *
 * (c) Sulu GmbH
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */

namespace Sulu\Component\SmartContent\Orm;

/**
 * Provides interface for DataProvider repository.
 */
interface DataProviderRepositoryInterface
{
    /**
     * Returns filtered entities.
     * When pagination is active the result count is pageSize + 1 to determine has next page.
     *
     * @param array $filters array of filters: tags, tagOperator
     * @param int $page
     * @param int $pageSize
     * @param int $limit
     * @param string $locale
     * @param mixed[] $options
     *
     * @return object[]
     */
    public function findByFilters($filters, $page, $pageSize, $limit, $locale, $options = []/*, ?UserInterface $user*/);
}
