<?php

/*
 * This file is part of Sulu.
 *
 * (c) Sulu GmbH
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */

namespace Sulu\Bundle\MediaBundle\Media\ImageConverter;

/**
 * Defines the interface for loading the binary data of an image representing a file.
 */
interface MediaImageExtractorInterface
{
    /**
     * Extracts an image out of the given resource.
     *
     * @param resource $resource
     *
     * @return resource
     */
    public function extract($resource/*, string $resourceMimeType */);
}
