// @flow

export type FilterCriteria = {|
    audienceTargeting: ?boolean,
    // TODO rename to categoryIds
    categories: ?Array<number>,
    categoryOperator: ?Conjunction,
    // TODO rename to datasourceId
    dataSource: ?string | number,
    // TODO rename to includeSubElements
    includeSubFolders: ?boolean,
    // TODO rename to limit
    limitResult: ?number,
    // TODO rename to presentation
    presentAs: ?string,
    sortBy: ?string,
    // TODO rename to sortOrder
    sortMethod: ?SortOrder,
    tagOperator: ?Conjunction,
    tags: ?Array<string | number>,
    types: ?Array<string>,
|};

export type SortOrder = 'asc' | 'desc';

export type Conjunction = 'or' | 'and';

export type Sorting = {
    name: ?string,
    value: string,
};

export type Presentation = {
    name: string,
    value: string,
};

export type Type = {
    name: string,
    value: string,
}

export type SmartContentConfig = {
    audienceTargeting: boolean,
    categories: boolean,
    datasourceAdapter?: string,
    datasourceListKey?: string,
    datasourceResourceKey?: string,
    limit: boolean,
    presentAs: boolean,
    resultToView?: {[string]: string},
    sorting: Array<Sorting>,
    tags: boolean,
    types: Array<Type>,
    view?: string,
};

export type SmartContentConfigs = {[key: string]: SmartContentConfig};
