// @flow
import type {ElementRef} from 'react';

export type InputProps<T: ?string | ?number> = {|
    alignment: 'left' | 'center' | 'right',
    autocomplete?: string,
    collapsed?: boolean,
    disabled: boolean,
    headline?: boolean,
    icon?: string,
    iconClassName?: string,
    iconStyle?: Object,
    id?: string,
    inputClass?: string,
    inputMode?: string,
    inputRef?: (ref: ?ElementRef<'input'>) => void,
    labelRef?: (ref: ?ElementRef<'label'>) => void,
    loading?: boolean,
    max?: ?T,
    maxCharacters?: number,
    maxSegments?: number,
    min?: ?T,
    name?: string,
    onBlur?: () => void,
    onChange: (value: ?string, event: SyntheticEvent<HTMLInputElement>) => void,
    onClearClick?: () => void,
    onIconClick?: () => void,
    onKeyPress?: (key: ?string, event: SyntheticKeyboardEvent<HTMLInputElement>) => void,
    placeholder?: string,
    segmentDelimiter?: string,
    skin?: 'default' | 'dark',
    step?: ?T,
    type: string,
    valid: boolean,
    value: ?T,
|};
