// @flow
import React from 'react';
import type {Node} from 'react';
import Dropzone from 'react-dropzone';
import Button from '../Button';
import type {ButtonSkin} from '../Button';

type Props = {|
    children?: Node,
    disabled: boolean,
    icon: string | typeof undefined,
    onUpload: (file: File) => void,
    skin: ButtonSkin | typeof undefined,
|};

export default class FileUploadButton extends React.Component<Props> {
    static defaultProps = {
        disabled: false,
        icon: undefined,
        skin: undefined,
    };

    handleDrop = (files: Array<File>) => {
        const file = files[0];

        this.props.onUpload(file);
    };

    render() {
        const {children, disabled, icon, skin} = this.props;

        return (
            <Dropzone
                onDrop={this.handleDrop}
                style={{}}
            >
                {({getInputProps, getRootProps}) => (
                    <div {...getRootProps()}>
                        <Button disabled={disabled} icon={icon} skin={skin}>
                            {children}
                        </Button>
                        <input {...getInputProps()} />
                    </div>
                )}
            </Dropzone>
        );
    }
}
