<?php

namespace PHPCR\Util\CND\Scanner\TokenFilter;

use PHPCR\Util\CND\Scanner\Token;

/**
 * @license http://www.apache.org/licenses Apache License Version 2.0, January 2004
 * @license http://opensource.org/licenses/MIT MIT License
 * @author Daniel Barsotti <daniel.barsotti@liip.ch>
 */
class TokenTypeFilter implements TokenFilterInterface
{
    /**
     * The filtered out token type.
     *
     * @var int
     */
    protected $type;

    public function __construct($tokenType)
    {
        $this->type = $tokenType;
    }

    /**
     * @param Token $token
     *
     * @return Token | null
     */
    public function filter(Token $token)
    {
        if ($token->getType() === $this->type) {
            return;
        }

        return $token;
    }
}
