<?php

namespace Jackalope\Transport;

use PHPCR\PropertyType;
use PHPCR\Query\QOM\QueryObjectModelConstantsInterface as QOMConstantsInterface;
use PHPCR\Version\OnParentVersionAction;

/**
 * Utility class for transports that do not use jackrabbit to provide the
 * standard node type information.
 *
 * @license http://www.apache.org/licenses Apache License Version 2.0, January 2004
 * @license http://opensource.org/licenses/MIT MIT License
 *
 * @author Lukas Kahwe Smith <smith@pooteeweet.org>
 * @author Benjamin Eberlei <kontakt@beberlei.de>
 */
class StandardNodeTypes
{
    /**
     * Returns all the default nodes provided by the JCR 2.0 as well as the PHPCR
     * specification.
     *
     * Data is in array format according to TransportInterface::getNodeTypes()
     * so that transports that do not use jackrabbit can provide the standard
     * node types.
     *
     * @return array list of node type arrays to create node type objects from
     */
    public static function getNodeTypeData()
    {
        return [
            'mix:created' => [
                'name' => 'mix:created',
                'isAbstract' => false,
                'isMixin' => true,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'mix:created',
                        'name' => 'jcr:createdBy',
                        'isAutoCreated' => true,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'mix:created',
                        'name' => 'jcr:created',
                        'isAutoCreated' => true,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::DATE,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'mix:etag' => [
                'name' => 'mix:etag',
                'isAbstract' => false,
                'isMixin' => true,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'mix:etag',
                        'name' => 'jcr:etag',
                        'isAutoCreated' => true,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'mix:language' => [
                'name' => 'mix:language',
                'isAbstract' => false,
                'isMixin' => true,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'mix:language',
                        'name' => 'jcr:language',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'mix:lastModified' => [
                'name' => 'mix:lastModified',
                'isAbstract' => false,
                'isMixin' => true,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'mix:lastModified',
                        'name' => 'jcr:lastModifiedBy',
                        'isAutoCreated' => true,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'mix:lastModified',
                        'name' => 'jcr:lastModified',
                        'isAutoCreated' => true,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::DATE,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'mix:lifecycle' => [
                'name' => 'mix:lifecycle',
                'isAbstract' => false,
                'isMixin' => true,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'mix:lifecycle',
                        'name' => 'jcr:lifecyclePolicy',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::INITIALIZE,
                        'requiredType' => PropertyType::REFERENCE,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'mix:lifecycle',
                        'name' => 'jcr:currentLifecycleState',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::INITIALIZE,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'mix:lockable' => [
                'name' => 'mix:lockable',
                'isAbstract' => false,
                'isMixin' => true,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'mix:lockable',
                        'name' => 'jcr:lockIsDeep',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::IGNORE,
                        'requiredType' => PropertyType::BOOLEAN,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'mix:lockable',
                        'name' => 'jcr:lockOwner',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::IGNORE,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'mix:mimeType' => [
                'name' => 'mix:mimeType',
                'isAbstract' => false,
                'isMixin' => true,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'mix:mimeType',
                        'name' => 'jcr:encoding',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'mix:mimeType',
                        'name' => 'jcr:mimeType',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'mix:referenceable' => [
                'name' => 'mix:referenceable',
                'isAbstract' => false,
                'isMixin' => true,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'mix:referenceable',
                        'name' => 'jcr:uuid',
                        'isAutoCreated' => true,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::INITIALIZE,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ]
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'mix:shareable' => [
                'name' => 'mix:shareable',
                'isAbstract' => false,
                'isMixin' => true,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'mix:referenceable',
                ],
                'declaredPropertyDefinitions' => [],
                'declaredNodeDefinitions' => [],
            ],
            'mix:simpleVersionable' => [
                'name' => 'mix:simpleVersionable',
                'isAbstract' => false,
                'isMixin' => true,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'mix:simpleVersionable',
                        'name' => 'jcr:isCheckedOut',
                        'isAutoCreated' => true,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::IGNORE,
                        'requiredType' => PropertyType::BOOLEAN,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                        'defaultValues' => [
                            'true',
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'mix:title' => [
                'name' => 'mix:title',
                'isAbstract' => false,
                'isMixin' => true,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'mix:title',
                        'name' => 'jcr:description',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'mix:title',
                        'name' => 'jcr:title',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'mix:versionable' => [
                'name' => 'mix:versionable',
                'isAbstract' => false,
                'isMixin' => true,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'mix:referenceable',
                    'mix:simpleVersionable',
                ],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'mix:versionable',
                        'name' => 'jcr:predecessors',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::IGNORE,
                        'requiredType' => PropertyType::REFERENCE,
                        'multiple' => true,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'valueConstraints' => [
                            'nt:version',
                        ],
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'mix:versionable',
                        'name' => 'jcr:mergeFailed',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'requiredType' => PropertyType::REFERENCE,
                        'multiple' => true,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'valueConstraints' => [
                            'nt:version',
                        ],
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'mix:versionable',
                        'name' => 'jcr:activity',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::REFERENCE,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'valueConstraints' => [
                            'nt:activity',
                        ],
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'mix:versionable',
                        'name' => 'jcr:configuration',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::IGNORE,
                        'requiredType' => PropertyType::REFERENCE,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'valueConstraints' => [
                            'nt:configuration',
                        ],
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'mix:versionable',
                        'name' => 'jcr:versionHistory',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::IGNORE,
                        'requiredType' => PropertyType::REFERENCE,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'valueConstraints' => [
                            'nt:versionHistory',
                        ],
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'mix:versionable',
                        'name' => 'jcr:baseVersion',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::IGNORE,
                        'requiredType' => PropertyType::REFERENCE,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'valueConstraints' => [
                            'nt:version',
                        ],
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'nt:activity' => [
                'name' => 'nt:activity',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'mix:referenceable',
                    'nt:base',
                ],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'nt:activity',
                        'name' => 'jcr:activityTitle',
                        'isAutoCreated' => true,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'nt:address' => [
                'name' => 'nt:address',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'nt:base',
                ],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'nt:address',
                        'name' => 'jcr:workspace',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:address',
                        'name' => 'jcr:path',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::PATH,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:address',
                        'name' => 'jcr:host',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:address',
                        'name' => 'jcr:port',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:address',
                        'name' => 'jcr:protocol',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:address',
                        'name' => 'jcr:repository',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:address',
                        'name' => 'jcr:id',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::WEAKREFERENCE,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'nt:base' => [
                'name' => 'nt:base',
                'isAbstract' => true,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'nt:base',
                        'name' => 'jcr:mixinTypes',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COMPUTE,
                        'requiredType' => PropertyType::NAME,
                        'multiple' => true,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:base',
                        'name' => 'jcr:primaryType',
                        'isAutoCreated' => true,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COMPUTE,
                        'requiredType' => PropertyType::NAME,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'nt:childNodeDefinition' => [
                'name' => 'nt:childNodeDefinition',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'nt:base',
                ],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'nt:childNodeDefinition',
                        'name' => 'jcr:requiredPrimaryTypes',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::NAME,
                        'multiple' => true,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                        'defaultValues' => [
                            'nt:base',
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:childNodeDefinition',
                        'name' => 'jcr:autoCreated',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::BOOLEAN,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:childNodeDefinition',
                        'name' => 'jcr:defaultPrimaryType',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::NAME,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:childNodeDefinition',
                        'name' => 'jcr:protected',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::BOOLEAN,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:childNodeDefinition',
                        'name' => 'jcr:name',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::NAME,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:childNodeDefinition',
                        'name' => 'jcr:mandatory',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::BOOLEAN,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:childNodeDefinition',
                        'name' => 'jcr:sameNameSiblings',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::BOOLEAN,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:childNodeDefinition',
                        'name' => 'jcr:onParentVersion',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'valueConstraints' => [
                            OnParentVersionAction::ACTIONNAME_COPY,
                            OnParentVersionAction::ACTIONNAME_VERSION,
                            OnParentVersionAction::ACTIONNAME_INITIALIZE,
                            OnParentVersionAction::ACTIONNAME_COMPUTE,
                            OnParentVersionAction::ACTIONNAME_IGNORE,
                            OnParentVersionAction::ACTIONNAME_ABORT,
                        ],
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'nt:configuration' => [
                'name' => 'nt:configuration',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'mix:versionable',
                    'nt:base',
                ],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'nt:configuration',
                        'name' => 'jcr:root',
                        'isAutoCreated' => true,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::REFERENCE,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'nt:file' => [
                'name' => 'nt:file',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => 'jcr:content',
                'declaredSuperTypeNames' => [
                    'nt:hierarchyNode',
                ],
                'declaredPropertyDefinitions' => [],
                'declaredNodeDefinitions' => [
                    [
                        'declaringNodeType' => 'nt:file',
                        'name' => 'jcr:content',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => null,
                        'requiredPrimaryTypeNames' => [
                            'nt:base',
                        ],
                    ],
                ],
            ],
            'nt:folder' => [
                'name' => 'nt:folder',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'nt:hierarchyNode',
                ],
                'declaredPropertyDefinitions' => [],
                'declaredNodeDefinitions' => [
                    [
                        'declaringNodeType' => 'nt:folder',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::VERSION,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => null,
                        'requiredPrimaryTypeNames' => [
                            'nt:hierarchyNode',
                        ],
                    ],
                ],
            ],
            'nt:frozenNode' => [
                'name' => 'nt:frozenNode',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => true,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'mix:referenceable',
                    'nt:base',
                ],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'nt:frozenNode',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'requiredType' => PropertyType::UNDEFINED,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:frozenNode',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'requiredType' => PropertyType::UNDEFINED,
                        'multiple' => true,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:frozenNode',
                        'name' => 'jcr:frozenUuid',
                        'isAutoCreated' => true,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:frozenNode',
                        'name' => 'jcr:frozenPrimaryType',
                        'isAutoCreated' => true,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'requiredType' => PropertyType::NAME,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:frozenNode',
                        'name' => 'jcr:frozenMixinTypes',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'requiredType' => PropertyType::NAME,
                        'multiple' => true,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [
                    [
                        'declaringNodeType' => 'nt:frozenNode',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'allowsSameNameSiblings' => true,
                        'defaultPrimaryTypeName' => null,
                        'requiredPrimaryTypeNames' => [
                            'nt:base',
                        ],
                    ],
                ],
            ],
            'nt:hierarchyNode' => [
                'name' => 'nt:hierarchyNode',
                'isAbstract' => true,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'mix:created',
                    'nt:base',
                ],
                'declaredPropertyDefinitions' => [],
                'declaredNodeDefinitions' => [],
            ],
            'nt:linkedFile' => [
                'name' => 'nt:linkedFile',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => 'jcr:content',
                'declaredSuperTypeNames' => [
                    'nt:hierarchyNode',
                ],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'nt:linkedFile',
                        'name' => 'jcr:content',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::REFERENCE,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'nt:nodeType' => [
                'name' => 'nt:nodeType',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'nt:base',
                ],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'nt:nodeType',
                        'name' => 'jcr:hasOrderableChildNodes',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::BOOLEAN,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:nodeType',
                        'name' => 'jcr:isQueryable',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::BOOLEAN,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:nodeType',
                        'name' => 'jcr:isMixin',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::BOOLEAN,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:nodeType',
                        'name' => 'jcr:nodeTypeName',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::NAME,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:nodeType',
                        'name' => 'jcr:isAbstract',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::BOOLEAN,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:nodeType',
                        'name' => 'jcr:primaryItemName',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::NAME,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:nodeType',
                        'name' => 'jcr:supertypes',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::NAME,
                        'multiple' => true,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [
                    [
                        'declaringNodeType' => 'nt:nodeType',
                        'name' => 'jcr:childNodeDefinition',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'allowsSameNameSiblings' => true,
                        'defaultPrimaryTypeName' => 'nt:childNodeDefinition',
                        'requiredPrimaryTypeNames' => [
                            'nt:childNodeDefinition',
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:nodeType',
                        'name' => 'jcr:propertyDefinition',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'allowsSameNameSiblings' => true,
                        'defaultPrimaryTypeName' => 'nt:propertyDefinition',
                        'requiredPrimaryTypeNames' => [
                            'nt:propertyDefinition',
                        ],
                    ],
                ],
            ],
            'nt:propertyDefinition' => [
                'name' => 'nt:propertyDefinition',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'nt:base',
                ],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'nt:propertyDefinition',
                        'name' => 'jcr:autoCreated',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::BOOLEAN,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:propertyDefinition',
                        'name' => 'jcr:isQueryOrderable',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::BOOLEAN,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:propertyDefinition',
                        'name' => 'jcr:protected',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::BOOLEAN,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:propertyDefinition',
                        'name' => 'jcr:name',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::NAME,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:propertyDefinition',
                        'name' => 'jcr:valueConstraints',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => true,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:propertyDefinition',
                        'name' => 'jcr:isFullTextSearchable',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::BOOLEAN,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:propertyDefinition',
                        'name' => 'jcr:onParentVersion',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'valueConstraints' => [
                            OnParentVersionAction::ACTIONNAME_COPY,
                            OnParentVersionAction::ACTIONNAME_VERSION,
                            OnParentVersionAction::ACTIONNAME_INITIALIZE,
                            OnParentVersionAction::ACTIONNAME_COMPUTE,
                            OnParentVersionAction::ACTIONNAME_IGNORE,
                            OnParentVersionAction::ACTIONNAME_ABORT,
                        ],
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:propertyDefinition',
                        'name' => 'jcr:requiredType',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'valueConstraints' => [
                            'STRING',
                            'URI',
                            'BINARY',
                            'LONG',
                            'DOUBLE',
                            'DECIMAL',
                            'BOOLEAN',
                            'DATE',
                            'NAME',
                            'PATH',
                            'REFERENCE',
                            'WEAKREFERENCE',
                            'UNDEFINED',
                        ],
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:propertyDefinition',
                        'name' => 'jcr:multiple',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::BOOLEAN,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:propertyDefinition',
                        'name' => 'jcr:availableQueryOperators',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::NAME,
                        'multiple' => true,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:propertyDefinition',
                        'name' => 'jcr:defaultValues',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::UNDEFINED,
                        'multiple' => true,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:propertyDefinition',
                        'name' => 'jcr:mandatory',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::BOOLEAN,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'nt:query' => [
                'name' => 'nt:query',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'nt:base',
                ],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'nt:query',
                        'name' => 'jcr:statement',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:query',
                        'name' => 'jcr:language',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'nt:resource'=> [
                'name' => 'nt:resource',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => 'jcr:data',
                'declaredSuperTypeNames' => [
                    'mix:lastModified',
                    'mix:mimeType',
                    'mix:referenceable',
                    'nt:base',
                ],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'nt:resource',
                        'name' => 'jcr:data',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::BINARY,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'nt:unstructured' => [
                'name' => 'nt:unstructured',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => true,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'nt:base',
                ],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'nt:unstructured',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::UNDEFINED,
                        'multiple' => true,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:unstructured',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::UNDEFINED,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [
                    [
                        'declaringNodeType' => 'nt:unstructured',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::VERSION,
                        'allowsSameNameSiblings' => true,
                        'defaultPrimaryTypeName' => 'nt:unstructured',
                        'requiredPrimaryTypeNames' => [
                            'nt:base',
                        ],
                    ],
                ],
            ],
            'nt:version' => [
                'name' => 'nt:version',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'mix:referenceable',
                    'nt:base',
                ],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'nt:version',
                        'name' => 'jcr:predecessors',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'requiredType' => PropertyType::REFERENCE,
                        'multiple' => true,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'valueConstraints' => [
                            'nt:version',
                        ],
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:version',
                        'name' => 'jcr:activity',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'requiredType' => PropertyType::REFERENCE,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'valueConstraints' => [
                            'nt:activity',
                        ],
                        'availableQueryOperators' =>[
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:version',
                        'name' => 'jcr:created',
                        'isAutoCreated' => true,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'requiredType' => PropertyType::DATE,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:version',
                        'name' => 'jcr:successors',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'requiredType' => PropertyType::REFERENCE,
                        'multiple' => true,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'valueConstraints' => [
                            'nt:version',
                        ],
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [
                    [
                        'declaringNodeType' => 'nt:version',
                        'name' => 'jcr:frozenNode',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => null,
                        'requiredPrimaryTypeNames' => [
                            'nt:frozenNode',
                        ],
                    ],
                ],
            ],
            'nt:versionHistory' => [
                'name' => 'nt:versionHistory',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'mix:referenceable',
                    'nt:base',
                ],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'nt:versionHistory',
                        'name' => 'jcr:copiedFrom',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'requiredType' => PropertyType::WEAKREFERENCE,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'valueConstraints' => [
                            0 => 'nt:version',
                        ],
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:versionHistory',
                        'name' => 'jcr:versionableUuid',
                        'isAutoCreated' => true,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [
                    [
                        'declaringNodeType' => 'nt:versionHistory',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => 'nt:version',
                        'requiredPrimaryTypeNames' => [
                            'nt:version',
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:versionHistory',
                        'name' => 'jcr:versionLabels',
                        'isAutoCreated' => true,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => 'nt:versionLabels',
                        'requiredPrimaryTypeNames' => [
                            'nt:versionLabels',
                        ],
                    ],
                    [
                        'declaringNodeType' => 'nt:versionHistory',
                        'name' => 'jcr:rootVersion',
                        'isAutoCreated' => true,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => 'nt:version',
                        'requiredPrimaryTypeNames' => [
                            'nt:version',
                        ],
                    ],
                ],
            ],
            'nt:versionLabels' => [
                'name' => 'nt:versionLabels',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'nt:base',
                ],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'nt:versionLabels',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'requiredType' => PropertyType::REFERENCE,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'valueConstraints' => [
                            'nt:version',
                        ],
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'nt:versionedChild' => [
                'name' => 'nt:versionedChild',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'nt:base',
                ],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'nt:versionedChild',
                        'name' => 'jcr:childVersionHistory',
                        'isAutoCreated' => true,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'requiredType' => PropertyType::REFERENCE,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'valueConstraints' => [
                            'nt:versionHistory',
                        ],
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'rep:ACE' => [
                'name' => 'rep:ACE',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'nt:base',
                ],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'rep:ACE',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'requiredType' => PropertyType::UNDEFINED,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'rep:ACE',
                        'name' => 'rep:privileges',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::NAME,
                        'multiple' => true,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'rep:ACE',
                        'name' => 'rep:glob',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'rep:ACE',
                        'name' => 'rep:nodePath',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => PropertyType::STRING,
                        'requiredType' => PropertyType::PATH,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'rep:ACE',
                        'name' => 'rep:principalName',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'rep:ACL' => [
                'name' => 'rep:ACL',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => true,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'rep:Policy',
                ],
                'declaredPropertyDefinitions' => [],
                'declaredNodeDefinitions' => [
                    [
                        'declaringNodeType' => 'rep:ACL',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::IGNORE,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => 'rep:GrantACE',
                        'requiredPrimaryTypeNames' => [
                            'rep:ACE',
                        ],
                    ],
                ],
            ],
            'rep:AccessControl' => [
                'name' => 'rep:AccessControl',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'nt:base',
                ],
                'declaredPropertyDefinitions' => [],
                'declaredNodeDefinitions' => [
                    [
                        'declaringNodeType' => 'rep:AccessControl',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::IGNORE,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => null,
                        'requiredPrimaryTypeNames' => [
                            'rep:AccessControl',
                        ],
                    ],
                    [
                        'declaringNodeType' => 'rep:AccessControl',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::IGNORE,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => null,
                        'requiredPrimaryTypeNames' => [
                            'rep:PrincipalAccessControl',
                        ],
                    ],
                ],
            ],
            'rep:AccessControllable' => [
                'name' => 'rep:AccessControllable',
                'isAbstract' => false,
                'isMixin' => true,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [],
                'declaredPropertyDefinitions' => [],
                'declaredNodeDefinitions' => [
                    [
                        'declaringNodeType' => 'rep:AccessControllable',
                        'name' => 'rep:policy',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::IGNORE,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => null,
                        'requiredPrimaryTypeNames' => [
                            'rep:Policy',
                        ],
                    ],
                ],
            ],
            'rep:Activities' => [
                'name' => 'rep:Activities',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'nt:base',
                ],
                'declaredPropertyDefinitions' => [],
                'declaredNodeDefinitions' => [
                    [
                        'declaringNodeType' => 'rep:Activities',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => 'rep:Activities',
                        'requiredPrimaryTypeNames' => [
                            'rep:Activities',
                        ],
                    ],
                    [
                        'declaringNodeType' => 'rep:Activities',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => 'nt:activity',
                        'requiredPrimaryTypeNames' => [
                            'nt:activity',
                        ],
                    ],
                ],
            ],
            'rep:Authorizable' => [
                'name' => 'rep:Authorizable',
                'isAbstract' => true,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'mix:referenceable',
                    'nt:hierarchyNode',
                ],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'rep:Authorizable',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::UNDEFINED,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'rep:Authorizable',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::UNDEFINED,
                        'multiple' => true,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'rep:Authorizable',
                        'name' => 'rep:principalName',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [
                    [
                        'declaringNodeType' => 'rep:Authorizable',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::VERSION,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => 'nt:unstructured',
                        'requiredPrimaryTypeNames' => [
                            'nt:base',
                        ],
                    ],
                ],
            ],
            'rep:AuthorizableFolder' => [
                'name' => 'rep:AuthorizableFolder',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'nt:hierarchyNode',
                ],
                'declaredPropertyDefinitions' => [],
                'declaredNodeDefinitions' => [
                    [
                        'declaringNodeType' => 'rep:AuthorizableFolder',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::VERSION,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => 'rep:AuthorizableFolder',
                        'requiredPrimaryTypeNames' => [
                            'rep:AuthorizableFolder',
                        ],
                    ],
                    [
                        'declaringNodeType' => 'rep:AuthorizableFolder',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::VERSION,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => 'rep:User',
                        'requiredPrimaryTypeNames' => [
                            'rep:Authorizable',
                        ],
                    ],
                ],
            ],
            'rep:Configurations' => [
                'name' => 'rep:Configurations',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'nt:base',
                ],
                'declaredPropertyDefinitions' => [],
                'declaredNodeDefinitions' => [
                    [
                        'declaringNodeType' => 'rep:Configurations',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => 'rep:Configurations',
                        'requiredPrimaryTypeNames' => [
                            'rep:Configurations',
                        ],
                    ],
                    [
                        'declaringNodeType' => 'rep:Configurations',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => 'nt:configuration',
                        'requiredPrimaryTypeNames' => [
                            'nt:configuration',
                        ],
                    ],
                ],
            ],
            'rep:DenyACE' => [
                'name' => 'rep:DenyACE',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'rep:ACE',
                ],
                'declaredPropertyDefinitions' => [],
                'declaredNodeDefinitions' => [],
            ],
            'rep:GrantACE' => [
                'name' => 'rep:GrantACE',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'rep:ACE',
                ],
                'declaredPropertyDefinitions' => [],
                'declaredNodeDefinitions' => [],
            ],
            'rep:Group' => [
                'name' => 'rep:Group',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'rep:Authorizable',
                ],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'rep:Group',
                        'name' => 'rep:members',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::WEAKREFERENCE,
                        'multiple' => true,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'valueConstraints' => [
                            'rep:Authorizable',
                        ],
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [
                    [
                        'declaringNodeType' => 'rep:Group',
                        'name' => 'rep:members',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::VERSION,
                        'allowsSameNameSiblings' => true,
                        'defaultPrimaryTypeName' => 'rep:Members',
                        'requiredPrimaryTypeNames' => [
                            'rep:Members',
                        ],
                    ],
                ],
            ],
            'rep:Impersonatable' => [
                'name' => 'rep:Impersonatable',
                'isAbstract' => false,
                'isMixin' => true,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'rep:Impersonatable',
                        'name' => 'rep:impersonators',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => true,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'rep:Members' => [
                'name' => 'rep:Members',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => true,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'nt:base',
                ],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'rep:Members',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::WEAKREFERENCE,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'valueConstraints' => [
                            0 => 'rep:Authorizable',
                        ],
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [
                    [
                        'declaringNodeType' => 'rep:Members',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'allowsSameNameSiblings' => true,
                        'defaultPrimaryTypeName' => 'rep:Members',
                        'requiredPrimaryTypeNames' => [
                            'rep:Members',
                        ],
                    ],
                ],
            ],
            'rep:Policy' => [
                'name' => 'rep:Policy',
                'isAbstract' => true,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'nt:base',
                ],
                'declaredPropertyDefinitions' => [],
                'declaredNodeDefinitions' => [],
            ],
            'rep:PrincipalAccessControl' => [
                'name' => 'rep:PrincipalAccessControl',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'rep:AccessControl',
                ],
                'declaredPropertyDefinitions' => [],
                'declaredNodeDefinitions' => [
                    [
                        'declaringNodeType' => 'rep:PrincipalAccessControl',
                        'name' => 'rep:policy',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::IGNORE,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => null,
                        'requiredPrimaryTypeNames' => [
                            'rep:Policy',
                        ],
                    ],
                ],
            ],
            'rep:RepoAccessControllable' => [
                'name' => 'rep:RepoAccessControllable',
                'isAbstract' => false,
                'isMixin' => true,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [],
                'declaredPropertyDefinitions' => [],
                'declaredNodeDefinitions' => [
                    [
                        'declaringNodeType' => 'rep:RepoAccessControllable',
                        'name' => 'rep:repoPolicy',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::IGNORE,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => null,
                        'requiredPrimaryTypeNames' => [
                            'rep:Policy',
                        ],
                    ],
                ],
            ],
            'rep:RetentionManageable' => [
                'name' => 'rep:RetentionManageable',
                'isAbstract' => false,
                'isMixin' => true,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'rep:RetentionManageable',
                        'name' => 'rep:retentionPolicy',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::IGNORE,
                        'requiredType' => PropertyType::UNDEFINED,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'rep:RetentionManageable',
                        'name' => 'rep:hold',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::IGNORE,
                        'requiredType' => PropertyType::UNDEFINED,
                        'multiple' => true,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'rep:User' => [
                'name' => 'rep:User',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'rep:Authorizable',
                    'rep:Impersonatable',
                ],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'rep:User',
                        'name' => 'rep:password',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                    [
                        'declaringNodeType' => 'rep:User',
                        'name' => 'rep:disabled',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::STRING,
                        'multiple' => false,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'rep:VersionReference' => [
                'name' => 'rep:VersionReference',
                'isAbstract' => false,
                'isMixin' => true,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [],
                'declaredPropertyDefinitions' => [
                    [
                        'declaringNodeType' => 'rep:VersionReference',
                        'name' => 'rep:versions',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::COPY,
                        'requiredType' => PropertyType::REFERENCE,
                        'multiple' => true,
                        'fullTextSearchable' => true,
                        'queryOrderable' => true,
                        'availableQueryOperators' => [
                            QOMConstantsInterface::JCR_OPERATOR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_NOT_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_GREATER_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN,
                            QOMConstantsInterface::JCR_OPERATOR_LESS_THAN_OR_EQUAL_TO,
                            QOMConstantsInterface::JCR_OPERATOR_LIKE,
                        ],
                    ],
                ],
                'declaredNodeDefinitions' => [],
            ],
            'rep:nodeTypes' => [
                'name' => 'rep:nodeTypes',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'nt:base',
                ],
                'declaredPropertyDefinitions' => [],
                'declaredNodeDefinitions' => [
                    [
                        'declaringNodeType' => 'rep:nodeTypes',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => 'nt:nodeType',
                        'requiredPrimaryTypeNames' => [
                            'nt:nodeType',
                        ],
                    ],
                ],
            ],
            'rep:root' => [
                'name' => 'rep:root',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => true,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'nt:unstructured',
                ],
                'declaredPropertyDefinitions' => [],
                'declaredNodeDefinitions' => [
                    [
                        'declaringNodeType' => 'rep:root',
                        'name' => 'jcr:system',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::IGNORE,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => 'rep:system',
                        'requiredPrimaryTypeNames' => [
                            'rep:system',
                        ],
                    ],
                ],
            ],
            'rep:system' => [
                'name' => 'rep:system',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => true,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'nt:base',
                ],
                'declaredPropertyDefinitions' => [],
                'declaredNodeDefinitions' => [
                    [
                        'declaringNodeType' => 'rep:system',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => false,
                        'onParentVersion' => OnParentVersionAction::IGNORE,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => 'nt:base',
                        'requiredPrimaryTypeNames' => [
                            'nt:base',
                        ],
                    ],
                    [
                        'declaringNodeType' => 'rep:system',
                        'name' => 'jcr:versionStorage',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => 'rep:versionStorage',
                        'requiredPrimaryTypeNames' => [
                            'rep:versionStorage',
                        ],
                    ],
                    [
                        'declaringNodeType' => 'rep:system',
                        'name' => 'jcr:activities',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => 'rep:Activities',
                        'requiredPrimaryTypeNames' => [
                            'rep:Activities',
                        ],
                    ],
                    [
                        'declaringNodeType' => 'rep:system',
                        'name' => 'jcr:configurations',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => 'rep:Configurations',
                        'requiredPrimaryTypeNames' => [
                            'rep:Configurations',
                        ],
                    ],
                    [
                        'declaringNodeType' => 'rep:system',
                        'name' => 'jcr:nodeTypes',
                        'isAutoCreated' => false,
                        'isMandatory' => true,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => 'rep:nodeTypes',
                        'requiredPrimaryTypeNames' => [
                            'rep:nodeTypes',
                        ],
                    ],
                ],
            ],
            'rep:versionStorage' => [
                'name' => 'rep:versionStorage',
                'isAbstract' => false,
                'isMixin' => false,
                'isQueryable' => true,
                'hasOrderableChildNodes' => false,
                'primaryItemName' => null,
                'declaredSuperTypeNames' => [
                    'nt:base',
                ],
                'declaredPropertyDefinitions' => [],
                'declaredNodeDefinitions' => [
                    [
                        'declaringNodeType' => 'rep:versionStorage',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => 'nt:versionHistory',
                        'requiredPrimaryTypeNames' => [
                            'nt:versionHistory',
                        ],
                    ],
                    [
                        'declaringNodeType' => 'rep:versionStorage',
                        'name' => '*',
                        'isAutoCreated' => false,
                        'isMandatory' => false,
                        'isProtected' => true,
                        'onParentVersion' => OnParentVersionAction::ABORT,
                        'allowsSameNameSiblings' => false,
                        'defaultPrimaryTypeName' => 'rep:versionStorage',
                        'requiredPrimaryTypeNames' => [
                            'rep:versionStorage',
                        ],
                    ],
                ],
            ],
        ];
    }
}
