<?php

namespace Jackalope\Query\QOM;

use PHPCR\Query\QOM\LowerCaseInterface;
use PHPCR\Query\QOM\DynamicOperandInterface;

/**
 * {@inheritDoc}
 *
 * @license http://www.apache.org/licenses Apache License Version 2.0, January 2004
 * @license http://opensource.org/licenses/MIT MIT License
 *
 * @api
 */
class LowerCase implements LowerCaseInterface
{
    /**
     * @var DynamicOperandInterface
     */
    protected $operand;

    /**
     * Create a new lower case value
     *
     * @param DynamicOperandInterface $operand
     */
    public function __construct(DynamicOperandInterface $operand)
    {
        $this->operand = $operand;
    }

    /**
     * {@inheritDoc}
     *
     * @api
     */
    public function getOperand()
    {
        return $this->operand;
    }
}
