<?php

namespace Doctrine\Bundle\PHPCRBundle\EventListener;

use Doctrine\ORM\Tools\Event\GenerateSchemaEventArgs;
use Jackalope\Transport\DoctrineDBAL\RepositorySchema;

/**
 * Merges the Jackalope doctrine dbal schema into a schema generated by
 * Doctrine ORM.
 *
 * This is used to avoid clashes with the Doctrine ORM if both are used in
 * parallel.
 *
 * @author David Buchmann <mail@davidbu.ch>
 * @author Johannes M. Schmitt <schmittjoh@gmail.com>
 */
class JackalopeDoctrineDbalSchemaListener
{
    private $schema;

    public function __construct(RepositorySchema $schema)
    {
        $this->schema = $schema;
    }

    public function postGenerateSchema(GenerateSchemaEventArgs $args)
    {
        $schema = $args->getSchema();
        $this->schema->addToSchema($schema);
    }
}
