<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('bs', array (
  'validators' => 
  array (
    'This value should be false.' => 'Ova vrijednost bi trebalo da bude "netačno" (false).',
    'This value should be true.' => 'Ova vrijednost bi trebalo da bude "tačno" (true).',
    'This value should be of type {{ type }}.' => 'Ova vrijednost bi trebalo da bude tipa {{ type }}.',
    'This value should be blank.' => 'Ova vrijednost bi trebalo da bude prazna.',
    'The value you selected is not a valid choice.' => 'Odabrana vrijednost nije validan izbor.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'Morate odabrati barem {{ limit }} mogućnost.|Morate odabrati barem {{ limit }} mogućnosti.|Morate odabrati barem {{ limit }} mogućnosti.  ',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'Morate odabrati najviše {{ limit }} mogućnost.|Morate odabrati najviše {{ limit }} mogućnosti.|Morate odabrati najviše {{ limit }} mogućnosti.',
    'One or more of the given values is invalid.' => 'Jedna ili više datih vrijednosti nisu validne.',
    'This field was not expected.' => 'Ovo polje nije očekivano.',
    'This field is missing.' => 'Ovo polje nedostaje.',
    'This value is not a valid date.' => 'Ova vrijednost nije ispravan datum.',
    'This value is not a valid datetime.' => 'Ova vrijednost nije ispravnog datum-vrijeme (datetime) formata.',
    'This value is not a valid email address.' => 'Ova vrijednost nije ispravna e-mail adresa.',
    'The file could not be found.' => 'Ova datoteka ne može biti pronađena.',
    'The file is not readable.' => 'Ova datoteka nije čitljiva.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'Ova datoteka je prevelika ({{ size }} {{ suffix }}). Najveća dozvoljena veličina je {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'Mime tip datoteke nije ispravan ({{ type }}). Dozvoljeni mime tipovi su {{ types }}.',
    'This value should be {{ limit }} or less.' => 'Ova vrijednost bi trebalo da bude {{ limit }} ili manje.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'Ova vrijednost je predugačka. Trebalo bi da ima {{ limit }} karakter ili manje.|Ova vrijednost je predugačka. Trebalo bi da ima {{ limit }} karaktera ili manje.|Ova vrijednost je predugačka. Trebalo bi da ima {{ limit }} karaktera ili manje.',
    'This value should be {{ limit }} or more.' => 'Ova vrijednost bi trebalo da bude {{ limit }} ili više.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'Ova vrijednost je prekratka. Trebalo bi da ima {{ limit }} karakter ili više.|Ova vrijednost je prekratka. Trebalo bi da ima {{ limit }} karaktera ili više.|Ova vrijednost je prekratka. Trebalo bi da ima {{ limit }} karaktera ili više.',
    'This value should not be blank.' => 'Ova vrijednost ne bi trebalo da bude prazna.',
    'This value should not be null.' => 'Ova vrijednost ne bi trebalo da bude null.',
    'This value should be null.' => 'Ova vrijednost bi trebalo da bude null.',
    'This value is not valid.' => 'Ova vrijednost nije ispravna.',
    'This value is not a valid time.' => 'Ova vrijednost nije ispravno vrijeme.',
    'This value is not a valid URL.' => 'Ova vrijednost nije ispravan URL.',
    'The two values should be equal.' => 'Obje vrijednosti bi trebalo da budu jednake.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'Ova datoteka je prevelika. Najveća dozvoljena veličina je {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'Ova datoteka je prevelika.',
    'The file could not be uploaded.' => 'Ova datoteka ne može biti prenijeta (uploaded).',
    'This value should be a valid number.' => 'Ova vrijednost bi trebalo da bude ispravan broj.',
    'This file is not a valid image.' => 'Ova datoteka nije validna slika.',
    'This is not a valid IP address.' => 'Ovo nije ispravna IP adresa.',
    'This value is not a valid language.' => 'Ova vrijednost nije validan jezik.',
    'This value is not a valid locale.' => 'Ova vrijednost nije validna regionalna oznaka.',
    'This value is not a valid country.' => 'Ova vrijednost nije validna država.',
    'This value is already used.' => 'Ova vrijednost je već upotrebljena.',
    'The size of the image could not be detected.' => 'Nije moguće otkriti veličinu ove slike.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'Širina slike je prevelika ({{ width }}px). Najveća dozvoljena širina je {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'Širina slike je premala ({{ width }}px). Najmanja dozvoljena širina je {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'Dužina slike je prevelika ({{ height }}px). Najveća dozvoljena dužina je {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'Dužina slike je premala ({{ height }}px). Najmanja dozvoljena dužina je {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'Ova vrijednost bi trebalo da bude trenutna korisnička lozinka.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'Ova vrijednost bi trebalo da ima tačno {{ limit }} karakter.|Ova vrijednost bi trebalo da ima tačno {{ limit }} karaktera.',
    'The file was only partially uploaded.' => 'Datoteka je samo djelimično prenijeta (uploaded).',
    'No file was uploaded.' => 'Nijedna datoteka nije prenijeta (uploaded).',
    'No temporary folder was configured in php.ini.' => 'Privremeni direktorijum nije konfigurisan u datoteci php.ini.',
    'Cannot write temporary file to disk.' => 'Privremenu datoteku nije moguće upisati na disk.',
    'A PHP extension caused the upload to fail.' => 'Prenos datoteke nije uspio zbog PHP ekstenzije.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'Ova kolekcija bi trebalo da sadrži {{ limit }} ili više elemenata.|Ova kolekcija bi trebalo da sadrži {{ limit }} ili više elemenata.|Ova kolekcija bi trebalo da sadrži {{ limit }} ili više elemenata.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'Ova kolekcija bi trebalo da sadrži {{ limit }} ili manje elemenata.|Ova kolekcija bi trebalo da sadrži {{ limit }} ili manje elemenata.|Ova kolekcija bi trebalo da sadrži {{ limit }} ili manje elemenata.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'Ova kolekcija bi trebalo da sadrži tačno {{ limit }} element.|Ova kolekcija bi trebalo da sadrži tačno {{ limit }} elementa.|Ova kolekcija bi trebalo da sadrži tačno {{ limit }} elemenata.',
    'Invalid card number.' => 'Broj kartice je neispravan.',
    'Unsupported card type or invalid card number.' => 'Tip kartice nije podržan ili je broj kartice neispravan.',
    'This is not a valid International Bank Account Number (IBAN).' => 'Ova vrijednost nije ispravan međunarodni broj bankovnog računa (IBAN).',
    'This value is not a valid ISBN-10.' => 'Ova vrijednost nije ispravan ISBN-10.',
    'This value is not a valid ISBN-13.' => 'Ova vrijednost nije ispravan ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'Ova vrijednost nije ispravan ISBN-10 niti ISBN-13.',
    'This value is not a valid ISSN.' => 'Ova vrijednost nije ispravan ISSN.',
    'This value is not a valid currency.' => 'Ova vrijednost nije ispravna valuta.',
    'This value should be equal to {{ compared_value }}.' => 'Ova vrijednost bi trebalo da bude jednaka {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'Ova vrijednost bi trebalo da bude veća od {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'Ova vrijednost bi trebalo da bude jednaka ili veća od {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Ova vrijednost bi trebalo da bude identična {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'Ova vrijednost bi trebalo da bude manja od {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'Ova vrijednost bi trebalo da bude jednaka ili manja od {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'Ova vrijednost bi trebalo da bude različita od {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Ova vrijednost bi trebalo da bude identična sa {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'Razmjera ove slike je prevelika ({{ ratio }}). Maksimalna dozvoljena razmjera je {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'Razmjera ove slike je premala ({{ ratio }}). Minimalna očekivana razmjera je {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'Ova slika je kvadratnog oblika ({{ width }}x{{ height }}px). Kvadratne slike nisu dozvoljene.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'Ova slika je orijentisana horizontalno (landscape) ({{ width }}x{{ height }}px). Horizontalno orijentisane slike nisu dozvoljene.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'Ova slika je orijentisana vertikalno (portrait) ({{ width }}x{{ height }}px). Vertikalno orijentisane slike nisu dozvoljene.',
    'An empty file is not allowed.' => 'Prazna datoteka nije dozvoljena.',
    'The host could not be resolved.' => 'Nije moguće odrediti poslužitelja (host).',
    'This value does not match the expected {{ charset }} charset.' => 'Ova vrijednost ne odgovara očekivanom {{ charset }} setu karaktera (charset).',
    'This is not a valid Business Identifier Code (BIC).' => 'Ovo nije validan poslovni identifikacioni kod (BIC).',
    'Error' => 'Greška',
    'This is not a valid UUID.' => 'Ovo nije validan UUID.',
    'This value should be a multiple of {{ compared_value }}.' => 'Ova vrijednost bi trebalo da bude djeljiva sa {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'Ovaj poslovni identifikacioni kod (BIC) nije povezan sa IBAN-om {{ iban }}.',
    'This value should be valid JSON.' => 'Ova vrijednost bi trebalo da bude validan JSON.',
    'This collection should contain only unique elements.' => 'Ova kolekcija bi trebala da sadrži samo jedinstvene elemente.',
    'This value should be positive.' => 'Ova vrijednost bi trebalo da bude pozitivna.',
    'This value should be either positive or zero.' => 'Ova vrijednost bi trebalo da bude pozitivna ili jednaka nuli.',
    'This value should be negative.' => 'Ova vrijednost bi trebalo da bude negativna.',
    'This value should be either negative or zero.' => 'Ova vrijednost bi trebalo da bude negativna ili jednaka nuli.',
    'This value is not a valid timezone.' => 'Ova vrijednost nije validna vremenska zona.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'Ova lozinka je procurila u nekom od slučajeva kompromitovanja podataka, nemojte je koristiti. Koristite drugu lozinku.',
    'This value should be between {{ min }} and {{ max }}.' => 'Ova vrijednosti bi trebala biti između {{ min }} i {{ max }}.',
    'This value is not a valid hostname.' => 'Ova vrijednost nije ispravno ime poslužitelja (hostname).',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'Broj elemenata u ovoj kolekciji bi trebalo da bude djeljiv sa {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'Ova vrijednost bi trebalo da zadovoljava namjanje jedno od narednih ograničenja:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Svaki element ove kolekcije bi trebalo da zadovolji sopstveni skup ograničenja.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'Ova vrijednost nije ispravna međunarodna identifikaciona oznaka hartija od vrijednosti (ISIN).',
    'This form should not contain extra fields.' => 'Ovaj obrazac ne bi trebalo da sadrži dodatna polja.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'Prenijeta (uploaded) datoteka je prevelika. Molim pokušajte prenijeti manju datoteku.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'CSRF vrijednost nije ispravna. Molim pokušajte ponovo da pošaljete obrazac.',
    'This value is not a valid HTML5 color.' => 'Ova vrijednost nije ispravna HTML5 boja.',
    'Please enter a valid birthdate.' => 'Molim upišite ispravan datum rođenja.',
    'The selected choice is invalid.' => 'Odabrani izbor nije ispravan.',
    'The collection is invalid.' => 'Ova kolekcija nije ispravna.',
    'Please select a valid color.' => 'Molim izaberite ispravnu boju.',
    'Please select a valid country.' => 'Molim izaberite ispravnu državu.',
    'Please select a valid currency.' => 'Molim izaberite ispravnu valutu.',
    'Please choose a valid date interval.' => 'Molim izaberite ispravan datumski interval.',
    'Please enter a valid date and time.' => 'Molim upišite ispravan datum i vrijeme.',
    'Please enter a valid date.' => 'Molim upišite ispravan datum.',
    'Please select a valid file.' => 'Molim izaberite ispravnu datoteku.',
    'The hidden field is invalid.' => 'Skriveno polje nije ispravno.',
    'Please enter an integer.' => 'Molim upišite cijeli broj (integer).',
    'Please select a valid language.' => 'Molim izaberite ispravan jezik.',
    'Please select a valid locale.' => 'Molim izaberite ispravnu lokalizaciju.',
    'Please enter a valid money amount.' => 'Molim upišite ispravnu količinu novca.',
    'Please enter a number.' => 'Molim upišite broj.',
    'The password is invalid.' => 'Ova lozinka nije ispravna.',
    'Please enter a percentage value.' => 'Molim upišite procentualnu vrijednost.',
    'The values do not match.' => 'Date vrijednosti se ne poklapaju.',
    'Please enter a valid time.' => 'Molim upišite ispravno vrijeme.',
    'Please select a valid timezone.' => 'Molim izaberite ispravnu vremensku zonu.',
    'Please enter a valid URL.' => 'Molim upišite ispravan URL.',
    'Please enter a valid search term.' => 'Molim upišite ispravan termin za pretragu.',
    'Please provide a valid phone number.' => 'Molim navedite ispravan broj telefona.',
    'The checkbox has an invalid value.' => 'Polje za potvrdu sadrži neispravnu vrijednost.',
    'Please enter a valid email address.' => 'Molim upišite ispravnu email adresu.',
    'Please select a valid option.' => 'Molim izaberite ispravnu opciju.',
    'Please select a valid range.' => 'Molim izaberite ispravan opseg.',
    'Please enter a valid week.' => 'Molim upišite ispravnu sedmicu.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'Došlo je do autentifikacijskog izuzetka (exception).',
    'Authentication credentials could not be found.' => 'Autentifikacijski podaci nisu pronađeni.',
    'Authentication request could not be processed due to a system problem.' => 'Autentifikacijski zahtjev ne može biti obrađen zbog sistemskog problema.',
    'Invalid credentials.' => 'Autentifikacijski podaci su neispravni.',
    'Cookie has already been used by someone else.' => 'Neko drugi je već iskoristio ovaj kolačić (cookie).',
    'Not privileged to request the resource.' => 'Nemate privilegije potrebne za pristup ovom resursu.',
    'Invalid CSRF token.' => 'CSRF žeton (token) je neispravan.',
    'No authentication provider found to support the authentication token.' => 'Nije pronađen autentifikacijski provajder koji bi podržao dati autentifikacijski žeton (token).',
    'No session available, it either timed out or cookies are not enabled.' => 'Nema dostupnih sesija; ili je istekla ili su kolačići (cookies) iksljučeni.',
    'No token could be found.' => 'Nije pronađen nijedan žeton (token).',
    'Username could not be found.' => 'Korisničko ime nije pronađeno.',
    'Account has expired.' => 'Nalog je istekao.',
    'Credentials have expired.' => 'Autentifikacijski podaci su istekli.',
    'Account is disabled.' => 'Nalog je onemogućen.',
    'Account is locked.' => 'Nalog je zaključan.',
    'Too many failed login attempts, please try again later.' => 'Previše neuspješnih pokušaja prijavljivanja, molim pokušajte ponovo kasnije.',
    'Invalid or expired login link.' => 'Link za prijavljivanje je istekao ili je neispravan.',
  ),
));

$catalogueEn = new MessageCatalogue('en', array (
  'validators' => 
  array (
    'This value should be false.' => 'This value should be false.',
    'This value should be true.' => 'This value should be true.',
    'This value should be of type {{ type }}.' => 'This value should be of type {{ type }}.',
    'This value should be blank.' => 'This value should be blank.',
    'The value you selected is not a valid choice.' => 'The value you selected is not a valid choice.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.',
    'One or more of the given values is invalid.' => 'One or more of the given values is invalid.',
    'This field was not expected.' => 'This field was not expected.',
    'This field is missing.' => 'This field is missing.',
    'This value is not a valid date.' => 'This value is not a valid date.',
    'This value is not a valid datetime.' => 'This value is not a valid datetime.',
    'This value is not a valid email address.' => 'This value is not a valid email address.',
    'The file could not be found.' => 'The file could not be found.',
    'The file is not readable.' => 'The file is not readable.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.',
    'This value should be {{ limit }} or less.' => 'This value should be {{ limit }} or less.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.',
    'This value should be {{ limit }} or more.' => 'This value should be {{ limit }} or more.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.',
    'This value should not be blank.' => 'This value should not be blank.',
    'This value should not be null.' => 'This value should not be null.',
    'This value should be null.' => 'This value should be null.',
    'This value is not valid.' => 'This value is not valid.',
    'This value is not a valid time.' => 'This value is not a valid time.',
    'This value is not a valid URL.' => 'This value is not a valid URL.',
    'The two values should be equal.' => 'The two values should be equal.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'The file is too large.',
    'The file could not be uploaded.' => 'The file could not be uploaded.',
    'This value should be a valid number.' => 'This value should be a valid number.',
    'This file is not a valid image.' => 'This file is not a valid image.',
    'This is not a valid IP address.' => 'This is not a valid IP address.',
    'This value is not a valid language.' => 'This value is not a valid language.',
    'This value is not a valid locale.' => 'This value is not a valid locale.',
    'This value is not a valid country.' => 'This value is not a valid country.',
    'This value is already used.' => 'This value is already used.',
    'The size of the image could not be detected.' => 'The size of the image could not be detected.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'This value should be the user\'s current password.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.',
    'The file was only partially uploaded.' => 'The file was only partially uploaded.',
    'No file was uploaded.' => 'No file was uploaded.',
    'No temporary folder was configured in php.ini.' => 'No temporary folder was configured in php.ini, or the configured folder does not exist.',
    'Cannot write temporary file to disk.' => 'Cannot write temporary file to disk.',
    'A PHP extension caused the upload to fail.' => 'A PHP extension caused the upload to fail.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.',
    'Invalid card number.' => 'Invalid card number.',
    'Unsupported card type or invalid card number.' => 'Unsupported card type or invalid card number.',
    'This is not a valid International Bank Account Number (IBAN).' => 'This is not a valid International Bank Account Number (IBAN).',
    'This value is not a valid ISBN-10.' => 'This value is not a valid ISBN-10.',
    'This value is not a valid ISBN-13.' => 'This value is not a valid ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'This value is neither a valid ISBN-10 nor a valid ISBN-13.',
    'This value is not a valid ISSN.' => 'This value is not a valid ISSN.',
    'This value is not a valid currency.' => 'This value is not a valid currency.',
    'This value should be equal to {{ compared_value }}.' => 'This value should be equal to {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'This value should be greater than {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'This value should be greater than or equal to {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should be identical to {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'This value should be less than {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'This value should be less than or equal to {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'This value should not be equal to {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.',
    'An empty file is not allowed.' => 'An empty file is not allowed.',
    'The host could not be resolved.' => 'The host could not be resolved.',
    'This value does not match the expected {{ charset }} charset.' => 'This value does not match the expected {{ charset }} charset.',
    'This is not a valid Business Identifier Code (BIC).' => 'This is not a valid Business Identifier Code (BIC).',
    'Error' => 'Error',
    'This is not a valid UUID.' => 'This is not a valid UUID.',
    'This value should be a multiple of {{ compared_value }}.' => 'This value should be a multiple of {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'This value should be valid JSON.',
    'This collection should contain only unique elements.' => 'This collection should contain only unique elements.',
    'This value should be positive.' => 'This value should be positive.',
    'This value should be either positive or zero.' => 'This value should be either positive or zero.',
    'This value should be negative.' => 'This value should be negative.',
    'This value should be either negative or zero.' => 'This value should be either negative or zero.',
    'This value is not a valid timezone.' => 'This value is not a valid timezone.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'This password has been leaked in a data breach, it must not be used. Please use another password.',
    'This value should be between {{ min }} and {{ max }}.' => 'This value should be between {{ min }} and {{ max }}.',
    'This value is not a valid hostname.' => 'This value is not a valid hostname.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'The number of elements in this collection should be a multiple of {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'This value should satisfy at least one of the following constraints:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Each element of this collection should satisfy its own set of constraints.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'This value is not a valid International Securities Identification Number (ISIN).',
    'This form should not contain extra fields.' => 'This form should not contain extra fields.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'The uploaded file was too large. Please try to upload a smaller file.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'The CSRF token is invalid. Please try to resubmit the form.',
    'This value is not a valid HTML5 color.' => 'This value is not a valid HTML5 color.',
    'Please enter a valid birthdate.' => 'Please enter a valid birthdate.',
    'The selected choice is invalid.' => 'The selected choice is invalid.',
    'The collection is invalid.' => 'The collection is invalid.',
    'Please select a valid color.' => 'Please select a valid color.',
    'Please select a valid country.' => 'Please select a valid country.',
    'Please select a valid currency.' => 'Please select a valid currency.',
    'Please choose a valid date interval.' => 'Please choose a valid date interval.',
    'Please enter a valid date and time.' => 'Please enter a valid date and time.',
    'Please enter a valid date.' => 'Please enter a valid date.',
    'Please select a valid file.' => 'Please select a valid file.',
    'The hidden field is invalid.' => 'The hidden field is invalid.',
    'Please enter an integer.' => 'Please enter an integer.',
    'Please select a valid language.' => 'Please select a valid language.',
    'Please select a valid locale.' => 'Please select a valid locale.',
    'Please enter a valid money amount.' => 'Please enter a valid money amount.',
    'Please enter a number.' => 'Please enter a number.',
    'The password is invalid.' => 'The password is invalid.',
    'Please enter a percentage value.' => 'Please enter a percentage value.',
    'The values do not match.' => 'The values do not match.',
    'Please enter a valid time.' => 'Please enter a valid time.',
    'Please select a valid timezone.' => 'Please select a valid timezone.',
    'Please enter a valid URL.' => 'Please enter a valid URL.',
    'Please enter a valid search term.' => 'Please enter a valid search term.',
    'Please provide a valid phone number.' => 'Please provide a valid phone number.',
    'The checkbox has an invalid value.' => 'The checkbox has an invalid value.',
    'Please enter a valid email address.' => 'Please enter a valid email address.',
    'Please select a valid option.' => 'Please select a valid option.',
    'Please select a valid range.' => 'Please select a valid range.',
    'Please enter a valid week.' => 'Please enter a valid week.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'An authentication exception occurred.',
    'Authentication credentials could not be found.' => 'Authentication credentials could not be found.',
    'Authentication request could not be processed due to a system problem.' => 'Authentication request could not be processed due to a system problem.',
    'Invalid credentials.' => 'Invalid credentials.',
    'Cookie has already been used by someone else.' => 'Cookie has already been used by someone else.',
    'Not privileged to request the resource.' => 'Not privileged to request the resource.',
    'Invalid CSRF token.' => 'Invalid CSRF token.',
    'No authentication provider found to support the authentication token.' => 'No authentication provider found to support the authentication token.',
    'No session available, it either timed out or cookies are not enabled.' => 'No session available, it either timed out or cookies are not enabled.',
    'No token could be found.' => 'No token could be found.',
    'Username could not be found.' => 'Username could not be found.',
    'Account has expired.' => 'Account has expired.',
    'Credentials have expired.' => 'Credentials have expired.',
    'Account is disabled.' => 'Account is disabled.',
    'Account is locked.' => 'Account is locked.',
    'Too many failed login attempts, please try again later.' => 'Too many failed login attempts, please try again later.',
    'Invalid or expired login link.' => 'Invalid or expired login link.',
  ),
  'admin' => 
  array (
    'sulu_search.search' => 'Search',
    'sulu_search.everything' => 'Everything',
    'sulu_search.search_hint' => 'Use (*) in your query as a placeholder for parts of a word.',
    'sulu_search.nothing_found' => 'Nothing could be found for your search term.',
    'sulu_contact.contacts' => 'Contacts',
    'sulu_contact.organizations' => 'Organizations',
    'sulu_contact.organization' => 'Organization',
    'sulu_contact.people' => 'People',
    'sulu_contact.contact_selection_overlay_title' => 'Choose contacts',
    'sulu_contact.account_selection_overlay_title' => 'Choose accounts',
    'sulu_contact.contact_selection_label' => '{count} {count, plural, =1 {contact} other {contacts}} selected',
    'sulu_contact.account_selection_label' => '{count} {count, plural, =1 {account} other {accounts}} selected',
    'sulu_contact.contact_account_selection_label' => '{count} {count, plural, =1 {contact} other {contacts}} selected',
    'sulu_contact.avatar' => 'Avatar',
    'sulu_contact.logo' => 'Logo',
    'sulu_contact.name' => 'Name',
    'sulu_contact.first_name' => 'First Name',
    'sulu_contact.last_name' => 'Last Name',
    'sulu_contact.contact_details' => 'Contact details',
    'sulu_contact.addresses' => 'Addresses',
    'sulu_contact.bank_accounts' => 'Bank accounts',
    'sulu_contact.email' => 'Email',
    'sulu_contact.primary_address' => 'Primary address',
    'sulu_contact.delivery_address' => 'Delivery address',
    'sulu_contact.billing_address' => 'Billing address',
    'sulu_contact.city' => 'City',
    'sulu_contact.zip' => 'ZIP',
    'sulu_contact.street' => 'Street',
    'sulu_contact.number' => 'Number',
    'sulu_contact.address_line' => 'Addressline',
    'sulu_contact.state' => 'Region',
    'sulu_contact.country' => 'Country',
    'sulu_contact.postbox_number' => 'Postbox #',
    'sulu_contact.postbox_zip' => 'Postbox ZIP',
    'sulu_contact.postbox_city' => 'Postbox City',
    'sulu_contact.phone' => 'Phone',
    'sulu_contact.fax' => 'Fax',
    'sulu_contact.website' => 'Website',
    'sulu_contact.social_media' => 'Social Media',
    'sulu_contact.birthday' => 'Birthday',
    'sulu_contact.title' => 'Title',
    'sulu_contact.salutation' => 'Salutation',
    'sulu_contact.form_of_address' => 'Form of Address',
    'sulu_contact.male_form_of_address' => 'Mr.',
    'sulu_contact.female_form_of_address' => 'Ms.',
    'sulu_contact.position' => 'Position',
    'sulu_contact.corporation' => 'Corporation',
    'sulu_contact.main_contact' => 'Main Contact',
    'sulu_contact.uid' => 'UID',
    'sulu_contact.register_number' => 'Register Number',
    'sulu_contact.jurisdiction' => 'Jurisdiction',
    'sulu_contact.note' => 'Note',
    'sulu_contact.parent_company' => 'Parent Company',
    'sulu_contact.upload_avatar_info_text' => 'Drop image or click to change avatar',
    'sulu_contact.upload_logo_info_text' => 'Drop image or click to change logo',
    'sulu_contact.no_contact_selected' => 'No contact selected',
    'sulu_contact.single_contact_selection_overlay_title' => 'Choose contact',
    'sulu_contact.no_account_selected' => 'No account selected',
    'sulu_contact.single_account_selection_overlay_title' => 'Choose account',
    'sulu_contact.taxonomies' => 'Taxonomies',
    'sulu_contact.add_address' => 'Add address',
    'sulu_contact.edit_address' => 'Edit address',
    'sulu_contact.add_bank_account' => 'Add bank account',
    'sulu_contact.edit_bank_account' => 'Edit bank account',
    'sulu_contact.work' => 'Work',
    'sulu_contact.private' => 'Private',
    'sulu_contact.mobile' => 'Mobile',
    'sulu_contact.bank' => 'Bank',
    'sulu_contact.iban' => 'IBAN',
    'sulu_contact.bic' => 'BIC',
    'sulu_contact.edit_title_overlay_title' => 'Edit titles',
    'sulu_contact.edit_position_overlay_title' => 'Edit positions',
    'sulu_contact.documents' => 'Documents',
    'sulu_contact.delete_media_warning_title' => 'Remove document assignment?',
    'sulu_contact.delete_media_warning_text' => 'This operation removes the selected document assignments. The document itself will not be deleted. Do you really wish to proceed?',
    'sulu_contact.add_contact_to_organization' => 'Add contact to organization',
    'sulu_contact.latitude' => 'Latitude',
    'sulu_contact.longitude' => 'Longitude',
    'sulu_media.media' => 'Media',
    'sulu_media.all_media' => 'All media',
    'sulu_media.audio' => 'Audio',
    'sulu_media.document' => 'Document',
    'sulu_media.image' => 'Image',
    'sulu_media.video' => 'Video',
    'sulu_media.copy_url' => 'Copy URL',
    'sulu_media.download_masterfile' => 'Download master file',
    'sulu_media.select_media_singular' => 'Select media',
    'sulu_media.select_media_plural' => 'Select media',
    'sulu_media.reset_selection' => 'Reset selection',
    'sulu_media.copy_masterfile_url' => 'Copy master file URL',
    'sulu_media.copy_masterfile_url_website' => 'Copy master file URL (Website)',
    'sulu_media.information_taxonomy' => 'Information and Taxonomy',
    'sulu_media.upload' => 'Upload',
    'sulu_media.upload_new_version' => 'Upload new version',
    'sulu_media.media_selected_singular' => 'media element selected',
    'sulu_media.media_selected_plural' => 'media elements selected',
    'sulu_media.drop_files_to_upload' => 'Upload files per drag`n`drop',
    'sulu_media.click_here_to_upload' => 'or click here to upload files',
    'sulu_media.add_collection' => 'Add collection',
    'sulu_media.remove_collection' => 'Delete collection',
    'sulu_media.remove_collection_warning' => 'This operation deletes a collection and cannot be undone. Do you really wish to proceed?',
    'sulu_media.move_collection' => 'Move collection',
    'sulu_media.edit_collection' => 'Edit collection',
    'sulu_media.download_media' => 'Download media',
    'sulu_media.download_counter' => 'Download count',
    'sulu_media.delete_media' => 'Delete media',
    'sulu_media.delete_media_warning_title' => 'Delete media',
    'sulu_media.delete_media_warning_text' => 'This operation deletes a media and cannot be undone. Do you really wish to proceed?',
    'sulu_media.delete_preview_image_warning_title' => 'Delete preview image',
    'sulu_media.delete_preview_image_warning_text' => 'This operation deletes the preview image and cannot be undone. Do you really wish to proceed?',
    'sulu_media.thumbnail' => 'Thumbnail',
    'sulu_media.type' => 'Type',
    'sulu_media.version' => 'Version',
    'sulu_media.size' => 'Filesize',
    'sulu_media.mime_type' => 'MIME-Type',
    'sulu_media.license' => 'License',
    'sulu_media.copyright' => 'Copyright Information',
    'sulu_media.credits' => 'Credits',
    'sulu_media.taxonomies' => 'Taxonomies',
    'sulu_media.history' => 'History',
    'sulu_media.formats' => 'Formats',
    'sulu_media.all_collections' => 'All collections',
    'sulu_media.move_media' => 'Move media',
    'sulu_media.upload_server_error' => 'There was an error while uploading one or multiple files to the server.',
    'sulu_media.set_focus_point' => 'Set focus point',
    'sulu_media.define_crops' => 'Define crops',
    'sulu_media.upload_preview_image' => 'Upload preview image',
    'sulu_media.delete_preview_image' => 'Delete preview image',
    'sulu_media.cropped' => 'Cropped',
    'sulu_media.double_click_crop_and_maximize' => 'A double-click maximizes and centers the area',
    'sulu_media.min_size_notification' => 'Minimal size reached',
    'sulu_media.left_top' => 'Left top',
    'sulu_media.top' => 'Top',
    'sulu_media.right_top' => 'Right top',
    'sulu_media.left' => 'Left',
    'sulu_media.middle' => 'Middle',
    'sulu_media.right' => 'Right',
    'sulu_media.left_bottom' => 'Left bottom',
    'sulu_media.bottom' => 'Bottom',
    'sulu_media.right_bottom' => 'Right bottom',
    'sulu_media.hotspots' => 'Hotspots',
    'sulu_media.add_hotspot' => 'Add hotspot',
    'sulu_media.hotspot_type' => 'Hotspot type',
    'sulu_media.form_type' => 'Form type',
    'sulu_media.circle' => 'Circle',
    'sulu_media.point' => 'Point',
    'sulu_media.rectangle' => 'Rectangle',
    'sulu_security.roles' => 'User roles',
    'sulu_security.user_name' => 'Username',
    'sulu_security.enable_user' => 'Enable User',
    'sulu_security.user_locked' => 'User locked',
    'sulu_security.permissions' => 'Permissions',
    'sulu_security.password' => 'Password',
    'sulu_security.email' => 'Email',
    'sulu_security.system' => 'System',
    'sulu_security.system_language' => 'System language',
    'sulu_security.reset_mail_subject' => 'Reset your Sulu password',
    'sulu_security.reset_mail_message' => 'To reset your Sulu password please click on the following link or copy/paste it to your browser:',
    'sulu_security.view' => 'View',
    'sulu_security.add' => 'Add',
    'sulu_security.edit' => 'Edit',
    'sulu_security.delete' => 'Delete',
    'sulu_security.live' => 'Live',
    'sulu_security.security' => 'Security',
    'sulu_security.system_permission_heading' => 'Activate permissions for {system}',
    'sulu_security.inherit_permissions_title' => 'Inherit permissions?',
    'sulu_security.inherit_permissions_label' => 'Override permissions of sub elements',
    'sulu_security.move_permission_title' => 'Notice',
    'sulu_security.move_permission_warning' => 'Permissions from the parent element will not be transferred.',
    'sulu_category.categories' => 'Categories',
    'sulu_category.key' => 'Key',
    'sulu_category.name' => 'Name',
    'sulu_category.keywords' => 'Keywords',
    'sulu_category.keyword' => 'Keyword',
    'sulu_category.multiple_usage' => 'Multiple Usage',
    'sulu_category.all_categories' => 'All categories',
    'sulu_category.no_category_selected' => 'No category selected',
    'sulu_category.single_category_selection_overlay_title' => 'Choose category',
    'sulu_snippet.selection_overlay_title' => 'Choose snippets',
    'sulu_snippet.selection_label' => '{count} {count, plural, =1 {snippet} other {snippets}} selected',
    'sulu_snippet.no_snippet_selected' => 'No snippet selected',
    'sulu_snippet.single_snippet_selection_overlay_title' => 'Choose snippet',
    'sulu_snippet.snippets' => 'Snippets',
    'sulu_snippet.snippet' => 'Snippet',
    'sulu_snippet.default_snippets' => 'Default Snippets',
    'sulu_snippet.snippet_area' => 'Type or area',
    'sulu_snippet.taxonomies' => 'Taxonomies',
    'sulu_snippet.webspace_default_snippet' => '%webspaceKey% default snippet',
    'sulu_page.webspaces' => 'Webspaces',
    'sulu_page.selection_label' => '{count} {count, plural, =1 {page} other {pages}} selected',
    'sulu_page.selection_overlay_title' => 'Choose pages',
    'sulu_page.seo' => 'SEO',
    'sulu_page.excerpt' => 'Excerpt & Taxonomies',
    'sulu_page.title' => 'Title',
    'sulu_page.show_ghost_and_shadow' => 'Show ghost and shadow pages',
    'sulu_page.no_page_selected' => 'No page selected',
    'sulu_page.single_selection_overlay_title' => 'Choose page',
    'sulu_page.settings' => 'Settings',
    'sulu_page.show_page_in' => 'Show page in',
    'sulu_page.no_navigation' => 'no navigation',
    'sulu_page.all_navigations' => 'all navigations',
    'sulu_page.page_type' => 'Page Type',
    'sulu_page.content' => 'Content',
    'sulu_page.pages' => 'Pages',
    'sulu_page.page' => 'Page',
    'sulu_page.internal_link' => 'Internal Link',
    'sulu_page.external_link' => 'External Link',
    'sulu_page.link_title' => 'Link Title',
    'sulu_page.linked_content' => 'Linked Content',
    'sulu_page.url' => 'URL',
    'sulu_page.shadow_page' => 'Shadow Page',
    'sulu_page.enable_shadow_page' => 'Enable Shadow Page',
    'sulu_page.enable_shadow_page_info_text' => 'This function is disabled if the current locale is already used as shadow locale.',
    'sulu_page.shadow_locale' => 'Shadow Locale',
    'sulu_page.editing_information' => 'Editing Information',
    'sulu_page.authored_date' => 'Authored Date',
    'sulu_page.author' => 'Author',
    'sulu_page.changelog' => 'Changelog',
    'sulu_page.text_for_more_link' => 'Text for more link',
    'sulu_page.icons' => 'Icons',
    'sulu_page.images' => 'Images',
    'sulu_page.edited' => 'edited',
    'sulu_page.search_result' => 'Search Engine Result Pages Preview (SERP)',
    'sulu_page.meta_title' => 'Title (Meta title)',
    'sulu_page.meta_title_info_text' => 'The meta title is limited to 55 characters.',
    'sulu_page.meta_description' => 'Description (Meta description)',
    'sulu_page.meta_description_info_text' => 'The meta description is limited to 320 characters.',
    'sulu_page.meta_keywords' => 'Keywords (Meta keywords)',
    'sulu_page.meta_keywords_info_text' => 'Please use a maximum of 5 keywords, dependant from the content of the page, separated by commas.',
    'sulu_page.canonical_url' => 'Canonical URL  (Canonical tag)',
    'sulu_page.no_index' => 'no-index (page will not be indexed by search engines)',
    'sulu_page.no_follow' => 'no-follow (links on this page will not be followed by the search engine)',
    'sulu_page.hide_in_sitemap' => 'Hide in sitemap',
    'sulu_page.delete_draft' => 'Delete draft',
    'sulu_page.delete_draft_warning_title' => 'Delete Draft?',
    'sulu_page.delete_draft_warning_text' => 'Do you really want to delete the draft? All data will be lost. The published page will not be changed.',
    'sulu_page.unpublish_warning_title' => 'Set to unpublished?',
    'sulu_page.unpublish_warning_text' => 'Do you really want to unpublish the page? All website links will be lost. This setting can be changed at any time without data loss.',
    'sulu_page.unpublish' => 'Set to unpublished',
    'sulu_page.restore_version' => 'Restore version?',
    'sulu_page.restore_version_text' => 'A new draft will be created. An existing draft version will be overwritten',
    'sulu_page.hide_block_label' => 'Don\'t display on public website',
    'sulu_page.hide_block_description' => 'This block will not be published, but remains editable in the admin.',
    'sulu_page.segment_label' => 'Assign segment',
    'sulu_page.segment_description' => 'The block will be automatically filtered on the website by the chosen segment.',
    'sulu_page.target_groups_label' => 'Assign target groups',
    'sulu_page.target_groups_description' => 'The block will only be visible for the selected target groups.',
    'sulu_tag.tags' => 'Tags',
    'sulu_tag.tag' => 'Tag',
    'sulu_website.analytics' => 'Analytics',
    'sulu_website.all_domains' => 'All domains',
    'sulu_website.domains' => 'Domains',
    'sulu_website.google_analytics' => 'Google Analytics',
    'sulu_website.google_tag_manager' => 'Google Tag Manager',
    'sulu_website.matomo' => 'Matomo',
    'sulu_website.custom_analytics' => 'Custom',
    'sulu_website.script' => 'Script',
    'sulu_website.key' => 'Key',
    'sulu_website.matomo_url' => 'URL',
    'sulu_website.matomo_id' => 'Site-ID',
    'sulu_website.position' => 'Position',
    'sulu_website.head_open' => 'Head open',
    'sulu_website.head_close' => 'Head close',
    'sulu_website.body_open' => 'Body open',
    'sulu_website.body_close' => 'Body close',
    'sulu_website.cache_clear' => 'Clear website cache',
    'sulu_website.cache_clear_warning_title' => 'Clear website cache?',
    'sulu_website.cache_clear_warning_text' => 'This operation will clear the entire cache for all webspaces. Do you really wish to proceed?',
    'sulu_location.latitude' => 'Latitude',
    'sulu_location.longitude' => 'Longitude',
    'sulu_location.zoom' => 'Zoom',
    'sulu_location.select_location' => 'Select location',
    'sulu_location.additional_information' => 'Additional Information',
    'sulu_location.title' => 'Title',
    'sulu_location.street' => 'Street',
    'sulu_location.number' => 'Number',
    'sulu_location.code' => 'Code',
    'sulu_location.town' => 'Town',
    'sulu_location.country' => 'Country',
    'sulu_custom_url.custom_urls' => 'Custom URLs',
    'sulu_custom_url.custom_url' => 'Custom URL',
    'sulu_custom_url.published' => 'Published',
    'sulu_custom_url.base_domain' => 'Base domain',
    'sulu_custom_url.target_page' => 'Target page',
    'sulu_custom_url.target_locale' => 'Localization',
    'sulu_custom_url.redirect' => 'Redirect',
    'sulu_custom_url.redirect_info' => 'The custom URL will be redirected to URL of the linked page.',
    'sulu_custom_url.canonical' => 'Canonical URL',
    'sulu_custom_url.canonical_info' => 'When the Canonical URL has been activated only the linked page will be indexed by search engines',
    'sulu_custom_url.no_index' => 'No Index',
    'sulu_custom_url.no_index_info' => 'The page will not be indexed by search engines.',
    'sulu_custom_url.no_follow' => 'No Follow',
    'sulu_custom_url.no_follow_info' => 'The links on the page will not be followed by search engines.',
    'sulu_custom_url.target_title' => 'Target page',
  ),
));
$catalogue->addFallbackCatalogue($catalogueEn);

return $catalogue;
