<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('fa', array (
  'validators' => 
  array (
    'This value should be false.' => 'این مقدار باید نادرست(False) باشد.',
    'This value should be true.' => 'این مقدار باید درست(True) باشد.',
    'This value should be of type {{ type }}.' => 'این مقدار باید از نوع {{ type }} باشد.',
    'This value should be blank.' => 'این مقدار باید خالی باشد.',
    'The value you selected is not a valid choice.' => 'مقدار انتخاب شده شامل گزینه های معتبر نمی باشد.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'باید حداقل {{ limit }} گزینه انتخاب نمایید.|باید حداقل {{ limit }} گزینه انتخاب نمایید.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'حداکثر {{ limit }} گزینه می توانید انتخاب نمایید.|حداکثر {{ limit }} گزینه می توانید انتخاب نمایید.',
    'One or more of the given values is invalid.' => 'یک یا چند مقدار نامعتبر وجود دارد.',
    'The fields {{ fields }} were not expected.' => 'فیلدهای {{ fields }} شامل فیلدهای مورد انتظار نمی باشند.',
    'The fields {{ fields }} are missing.' => 'فیلدهای {{ fields }} کم هستند.',
    'This value is not a valid date.' => 'این مقدار یک تاریخ معتبر نمی باشد.',
    'This value is not a valid datetime.' => 'این مقدار یک تاریخ و زمان معتبر نمی باشد.',
    'This value is not a valid email address.' => 'این یک رایانامه معتبر نمی باشد.',
    'The file could not be found.' => 'فایل یافت نشد.',
    'The file is not readable.' => 'پرونده خواندنی نمی باشد.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'فایل بیش از اندازه بزرگ است({{ size }} {{ suffix }}). حداکثر اندازه مجاز برابر با {{ limit }} {{ suffix }} می باشد.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'این نوع فایل مجاز نمی باشد({{ type }}). نوع های مجاز شامل {{ types }} می باشند.',
    'This value should be {{ limit }} or less.' => 'این مقدار باید کوچکتر و یا مساوی {{ limit }} باشد.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'بسیار طولانی است.حداکثر تعداد حروف مجاز برابر {{ limit }} می باشد.|بسیار طولانی است.حداکثر تعداد حروف مجاز برابر {{ limit }} می باشد.',
    'This value should be {{ limit }} or more.' => 'این مقدار باید بزرگتر و یا مساوی {{ limit }} باشد.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'مقدار وارد شده بسیار کوتاه است.تعداد حروف وارد شده، باید حداقل شامل {{ limit }} کاراکتر باشد.|مقدار وارد شده بسیار کوتاه است.تعداد حروف وارد شده، باید حداقل شامل {{ limit }} کاراکتر باشد.',
    'This value should not be blank.' => 'این مقدار نباید خالی باشد.',
    'This value should not be null.' => 'این مقدار باید شامل چیزی باشد.',
    'This value should be null.' => 'این مقدار باید شامل چیزی نباشد.',
    'This value is not valid.' => 'این مقدار معتبر نمی باشد.',
    'This value is not a valid time.' => 'این مقدار یک زمان صحیح نمی باشد.',
    'This value is not a valid URL.' => 'این مقدار شامل یک URL معتبر نمی باشد.',
    'The two values should be equal.' => 'دو مقدار باید با یکدیگر برابر باشند.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'فایل بیش از اندازه بزرگ است. حداکثر اندازه مجاز برابر با {{ limit }} {{ suffix }} می باشد.',
    'The file is too large.' => 'فایل بیش از اندازه بزرگ می باشد.',
    'The file could not be uploaded.' => 'بارگذاری فایل با شکست مواجه گردید.',
    'This value should be a valid number.' => 'این مقدار باید یک عدد معتبر باشد.',
    'This file is not a valid image.' => 'این فایل یک تصویر نمی باشد.',
    'This is not a valid IP address.' => 'این مقدار یک IP معتبر نمی باشد.',
    'This value is not a valid language.' => 'این مقدار یک زبان صحیح نمی باشد.',
    'This value is not a valid locale.' => 'این مقدار یک محل صحیح نمی باشد.',
    'This value is not a valid country.' => 'این مقدار یک کشور صحیح نمی باشد.',
    'This value is already used.' => 'این مقدار قبلا مورد استفاده قرار گرفته است.',
    'The size of the image could not be detected.' => 'اندازه تصویر قابل شناسایی نمی باشد.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'طول تصویر بسیار بزرگ است({{ width }}px). بیشینه طول مجاز {{ max_width }}px می باشد.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'طول تصویر بسیار کوچک است({{ width }}px). کمینه طول موردنظر {{ min_width }}px می باشد.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'ارتفاع تصویر بسیار بزرگ است({{ height }}px). بیشینه ارتفاع مجاز {{ max_height }}px می باشد.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'ارتفاع تصویر بسیار کوچک است({{ height }}px). کمینه ارتفاع موردنظر {{ min_height }}px می باشد.',
    'This value should be the user\'s current password.' => 'این مقدار می بایست کلمه عبور کنونی کاربر باشد.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => ' این مقدار می بایست دقیقا {{ limit }} کاراکتر داشته باشد.| این مقدار می بایست دقیقا {{ limit }} کاراکتر داشته باشد.',
    'The file was only partially uploaded.' => 'پرونده به صورت جزیی بارگذاری گردیده است.',
    'No file was uploaded.' => 'هیچ پرونده ای بارگذاری نگردیده است.',
    'No temporary folder was configured in php.ini.' => 'پوشه موقتی در php.ini پیکربندی نگردیده است.',
    'Cannot write temporary file to disk.' => 'فایل موقتی را نمی توان در دیسک نوشت.',
    'A PHP extension caused the upload to fail.' => 'یک اکستنشن PHP موجب شد که بارگذاری فایل با شکست مواجه گردد.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'این مجموعه می بایست دارای حداقل {{ limit }} عنصر یا بیشتر باشد.|این مجموعه می بایست دارای حداقل {{ limit }} عنصر یا بیشتر باشد.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'این مجموعه می بایست دارای حداکثر {{ limit }} عنصر یا کمتر باشد.|این مجموعه می بایست دارای حداکثر {{ limit }} عنصر یا کمتر باشد.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'این مجموعه می بایست به طور دقیق دارای {{ limit }} عنصر باشد.|این مجموعه می بایست به طور دقیق دارای {{ limit }} عنصر باشد.',
    'Invalid card number.' => 'شماره کارت نامعتبر می باشد.',
    'Unsupported card type or invalid card number.' => 'نوع کارت پشتیبانی نمی شود و یا شماره کارت نامعتبر می باشد.',
    'This is not a valid International Bank Account Number (IBAN).' => 'این یک شماره حساب بانک بین المللی معتبر نمی باشد(IBAN).',
    'This value is not a valid ISBN-10.' => 'این مقدار یک ISBN-10 معتبر نمی باشد.',
    'This value is not a valid ISBN-13.' => 'این مقدار یک ISBN-13 معتبر نمی باشد.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'این مقدار یک ISBN-10 صحیح و یا ISBN-13 معتبر نمی باشد.',
    'This value is not a valid ISSN.' => 'این مقدار یک ISSN معتبر نمی باشد.',
    'This value is not a valid currency.' => 'این مقدار یک واحد پول معتبر نمی باشد.',
    'This value should be equal to {{ compared_value }}.' => 'این مقدار باید برابر با {{ compared_value }} باشد.',
    'This value should be greater than {{ compared_value }}.' => 'این مقدار باید از {{ compared_value }} بیشتر باشد.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'این مقدار باید بزرگتر و یا مساوی با {{ compared_value }} باشد.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'این مقدار باید با {{ compared_value_type }} {{ compared_value }} یکسان باشد.',
    'This value should be less than {{ compared_value }}.' => 'این مقدار باید کمتر از {{ compared_value }} باشد.',
    'This value should be less than or equal to {{ compared_value }}.' => 'این مقدار باید کمتر و یا مساوی با {{ compared_value }} باشد.',
    'This value should not be equal to {{ compared_value }}.' => 'این مقدار نباید با {{ compared_value }} برابر باشد.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'این مقدار نباید با {{ compared_value_type }} {{ compared_value }} یکسان باشد.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'ابعاد({{ ratio }}) عکس بیش از حد بزرگ است.حداکثر ابعاد مجاز {{ max_ratio }} می باشد.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'ابعاد({{ ratio }}) عکس بیش از حد کوچک است.حداقل ابعاد مجاز {{ min_ratio }} می باشد.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'این تصویر یک مربع({{ width }}x{{ height }}px) می باشد. تصویر مربع مجاز نمی باشد.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'این تصویر افقی({{ width }}x{{ height }}px) می باشد. تصویر افقی مجاز نمی باشد.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'این تصویر عمودی({{ width }}x{{ height }}px) می باشد. تصویر عمودی مجاز نمی باشد.',
    'An empty file is not allowed.' => 'پرونده خالی مجاز نمی باشد.',
    'The host could not be resolved.' => 'میزبان قابل حل نمی باشد.',
    'This value does not match the expected {{ charset }} charset.' => 'این مقدار مطابق با مقدار مورد انتظار {{ charset }} نمی باشد.',
    'This is not a valid Business Identifier Code (BIC).' => 'این مقدار یک(BIC) معتبر نمی باشد.',
    'Error' => 'خطا',
    'This is not a valid UUID.' => 'این مقدار یک UUID معتبر نمی باشد.',
    'This value should be a multiple of {{ compared_value }}.' => 'این مقدار باید چند برابر {{ compared_value }} باشد.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'این(BIC) با IBAN ارتباطی ندارد.',
    'This value should be valid JSON.' => 'این مقدار باید یک JSON معتبر باشد.',
    'This collection should contain only unique elements.' => 'این مجموعه باید تنها شامل عناصر یکتا باشد.',
    'This value should be positive.' => 'این مقدار باید مثبت باشد.',
    'This value should be either positive or zero.' => 'این مقدار باید مثبت یا صفر باشد.',
    'This value should be negative.' => 'این مقدار باید منفی باشد.',
    'This value should be either negative or zero.' => 'این مقدار باید منفی یا صفر باشد.',
    'This value is not a valid timezone.' => 'این مقدار یک منطقه‌زمانی (timezone) معتبر نیست.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'این رمزعبور در یک رخنه‌ی اطلاعاتی نشت کرده است. لطفاً از یک رمزعبور دیگر استفاده کنید.',
    'This value should be between {{ min }} and {{ max }}.' => 'این مقدار باید بین {{ min }} و {{ max }} باشد',
    'This value is not a valid hostname.' => 'این مقدار یک hostname معتبر نیست.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'تعداد عناصر این مجموعه باید ضریبی از {{ compared_value }} باشد.',
    'This value should satisfy at least one of the following constraints:' => 'این مقدار باید حداقل یکی از محدودیت‌های زیر را ارضا کند:',
    'Each element of this collection should satisfy its own set of constraints.' => 'هر یک از عناصر این مجموعه باید دسته محدودیت‌های خودش را ارضا کند.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'این مقدار یک شماره شناسایی بین‌المللی اوراق بهادار (ISIN) معتبر نیست.',
    'This form should not contain extra fields.' => 'این فرم نباید شامل فیلدهای اضافی باشد.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'فایل بارگذاری‌شده بسیار بزرگ است. لطفاً فایل کوچک‌تری را بارگذاری نمایید.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'توکن CSRF نامعتبر است. لطفاً فرم را مجدداً ارسال نمایید.',
    'This value is not a valid HTML5 color.' => 'این مقدار یک رنگ معتبر HTML5  نیست.',
    'Please enter a valid birthdate.' => 'لطفاً یک تاریخ تولد معتبر وارد نمایید.',
    'The selected choice is invalid.' => 'گزینه‌ی انتخاب‌شده نامعتبر است',
    'The collection is invalid.' => 'این مجموعه نامعتبر است.',
    'Please select a valid color.' => 'لطفاً یک رنگ معتبر انتخاب کنید.',
    'Please select a valid country.' => 'لطفاً یک کشور معتبر انتخاب کنید.',
    'Please select a valid currency.' => 'لطفاً یک واحد پولی معتبر انتخاب کنید.',
    'Please choose a valid date interval.' => 'لطفاً یک بازه‌ی زمانی معتبر انتخاب کنید.',
    'Please enter a valid date and time.' => 'لطفاً یک تاریخ و زمان معتبر وارد کنید.',
    'Please enter a valid date.' => 'لطفاً یک تاریخ معتبر وارد کنید.',
    'Please select a valid file.' => 'لطفاً یک فایل معتبر انتخاب کنید.',
    'The hidden field is invalid.' => 'فیلد مخفی نامعتبر است.',
    'Please enter an integer.' => 'لطفاً یک عدد صحیح وارد کنید.',
    'Please select a valid language.' => 'لطفاً یک زبان معتبر انتخاب کنید.',
    'Please select a valid locale.' => 'لطفاً یک جغرافیای (locale) معتبر انتخاب کنید.',
    'Please enter a valid money amount.' => 'لطفاً یک مقدار پول معتبر وارد کنید.',
    'Please enter a number.' => 'لطفاً یک عدد وارد کنید.',
    'The password is invalid.' => 'رمزعبور نامعتبر است.',
    'Please enter a percentage value.' => 'لطفاً یک درصد معتبر وارد کنید.',
    'The values do not match.' => 'مقادیر تطابق ندارند.',
    'Please enter a valid time.' => 'لطفاً یک زمان معتبر وارد کنید.',
    'Please select a valid timezone.' => 'لطفاً یک منطقه‌زمانی معتبر وارد کنید.',
    'Please enter a valid URL.' => 'لطفاً یک URL معتبر وارد کنید.',
    'Please enter a valid search term.' => 'لطفاً یک عبارت جستجوی معتبر وارد کنید.',
    'Please provide a valid phone number.' => 'لطفاً یک شماره تلفن معتبر وارد کنید.',
    'The checkbox has an invalid value.' => 'کادر انتخاب (checkbox)  دارای مقداری نامعتبر است.',
    'Please enter a valid email address.' => 'لطفاً یک آدرس رایانامه‌ی معتبر وارد کنید.',
    'Please select a valid option.' => 'لطفاً یک گزینه‌ی معتبر انتخاب کنید.',
    'Please select a valid range.' => 'لطفاً یک محدوده‌ی معتبر انتخاب کنید.',
    'Please enter a valid week.' => 'لطفاً یک هفته‌ی معتبر وارد کنید.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'خطایی هنگام احراز هویت رخ داده است.',
    'Authentication credentials could not be found.' => 'شرایط احراز هویت یافت نشد.',
    'Authentication request could not be processed due to a system problem.' => 'درخواست احراز هویت به دلیل  وجود مشکل در سیستم قابل پردازش نمی باشد.',
    'Invalid credentials.' => 'احراز هویت نامعتبر می باشد.',
    'Cookie has already been used by someone else.' => 'Cookie قبلا توسط شخص دیگری استفاده گردیده است.',
    'Not privileged to request the resource.' => 'دسترسی لازم برای درخواست از این منبع را دارا نمی باشید.',
    'Invalid CSRF token.' => 'توکن CSRF معتبر نمی باشد.',
    'No authentication provider found to support the authentication token.' => 'هیچ ارایه دهنده احراز هویتی برای پشتیبانی از توکن احراز هویت پیدا نشد.',
    'No session available, it either timed out or cookies are not enabled.' => 'هیچ جلسه‌ای در دسترس نمی باشد. این میتواند به دلیل پایان یافتن زمان و یا فعال نبودن کوکی ها باشد.',
    'No token could be found.' => 'هیچ توکنی پیدا نشد.',
    'Username could not be found.' => 'نام ‌کاربری پیدا نشد.',
    'Account has expired.' => 'حساب کاربری منقضی گردیده است.',
    'Credentials have expired.' => 'مجوزهای احراز هویت منقضی گردیده‌اند.',
    'Account is disabled.' => 'حساب کاربری غیرفعال می باشد.',
    'Account is locked.' => 'حساب کاربری قفل گردیده است.',
    'Too many failed login attempts, please try again later.' => 'تلاش‌های ناموفق زیادی برای ورود صورت گرفته است، لطفاً بعداً دوباره تلاش کنید.',
    'Invalid or expired login link.' => 'لینک ورود نامعتبر یا تاریخ‌گذشته است.',
  ),
));

$catalogueEn = new MessageCatalogue('en', array (
  'validators' => 
  array (
    'This value should be false.' => 'This value should be false.',
    'This value should be true.' => 'This value should be true.',
    'This value should be of type {{ type }}.' => 'This value should be of type {{ type }}.',
    'This value should be blank.' => 'This value should be blank.',
    'The value you selected is not a valid choice.' => 'The value you selected is not a valid choice.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.',
    'One or more of the given values is invalid.' => 'One or more of the given values is invalid.',
    'This field was not expected.' => 'This field was not expected.',
    'This field is missing.' => 'This field is missing.',
    'This value is not a valid date.' => 'This value is not a valid date.',
    'This value is not a valid datetime.' => 'This value is not a valid datetime.',
    'This value is not a valid email address.' => 'This value is not a valid email address.',
    'The file could not be found.' => 'The file could not be found.',
    'The file is not readable.' => 'The file is not readable.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.',
    'This value should be {{ limit }} or less.' => 'This value should be {{ limit }} or less.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.',
    'This value should be {{ limit }} or more.' => 'This value should be {{ limit }} or more.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.',
    'This value should not be blank.' => 'This value should not be blank.',
    'This value should not be null.' => 'This value should not be null.',
    'This value should be null.' => 'This value should be null.',
    'This value is not valid.' => 'This value is not valid.',
    'This value is not a valid time.' => 'This value is not a valid time.',
    'This value is not a valid URL.' => 'This value is not a valid URL.',
    'The two values should be equal.' => 'The two values should be equal.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'The file is too large.',
    'The file could not be uploaded.' => 'The file could not be uploaded.',
    'This value should be a valid number.' => 'This value should be a valid number.',
    'This file is not a valid image.' => 'This file is not a valid image.',
    'This is not a valid IP address.' => 'This is not a valid IP address.',
    'This value is not a valid language.' => 'This value is not a valid language.',
    'This value is not a valid locale.' => 'This value is not a valid locale.',
    'This value is not a valid country.' => 'This value is not a valid country.',
    'This value is already used.' => 'This value is already used.',
    'The size of the image could not be detected.' => 'The size of the image could not be detected.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'This value should be the user\'s current password.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.',
    'The file was only partially uploaded.' => 'The file was only partially uploaded.',
    'No file was uploaded.' => 'No file was uploaded.',
    'No temporary folder was configured in php.ini.' => 'No temporary folder was configured in php.ini, or the configured folder does not exist.',
    'Cannot write temporary file to disk.' => 'Cannot write temporary file to disk.',
    'A PHP extension caused the upload to fail.' => 'A PHP extension caused the upload to fail.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.',
    'Invalid card number.' => 'Invalid card number.',
    'Unsupported card type or invalid card number.' => 'Unsupported card type or invalid card number.',
    'This is not a valid International Bank Account Number (IBAN).' => 'This is not a valid International Bank Account Number (IBAN).',
    'This value is not a valid ISBN-10.' => 'This value is not a valid ISBN-10.',
    'This value is not a valid ISBN-13.' => 'This value is not a valid ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'This value is neither a valid ISBN-10 nor a valid ISBN-13.',
    'This value is not a valid ISSN.' => 'This value is not a valid ISSN.',
    'This value is not a valid currency.' => 'This value is not a valid currency.',
    'This value should be equal to {{ compared_value }}.' => 'This value should be equal to {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'This value should be greater than {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'This value should be greater than or equal to {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should be identical to {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'This value should be less than {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'This value should be less than or equal to {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'This value should not be equal to {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.',
    'An empty file is not allowed.' => 'An empty file is not allowed.',
    'The host could not be resolved.' => 'The host could not be resolved.',
    'This value does not match the expected {{ charset }} charset.' => 'This value does not match the expected {{ charset }} charset.',
    'This is not a valid Business Identifier Code (BIC).' => 'This is not a valid Business Identifier Code (BIC).',
    'Error' => 'Error',
    'This is not a valid UUID.' => 'This is not a valid UUID.',
    'This value should be a multiple of {{ compared_value }}.' => 'This value should be a multiple of {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'This value should be valid JSON.',
    'This collection should contain only unique elements.' => 'This collection should contain only unique elements.',
    'This value should be positive.' => 'This value should be positive.',
    'This value should be either positive or zero.' => 'This value should be either positive or zero.',
    'This value should be negative.' => 'This value should be negative.',
    'This value should be either negative or zero.' => 'This value should be either negative or zero.',
    'This value is not a valid timezone.' => 'This value is not a valid timezone.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'This password has been leaked in a data breach, it must not be used. Please use another password.',
    'This value should be between {{ min }} and {{ max }}.' => 'This value should be between {{ min }} and {{ max }}.',
    'This value is not a valid hostname.' => 'This value is not a valid hostname.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'The number of elements in this collection should be a multiple of {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'This value should satisfy at least one of the following constraints:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Each element of this collection should satisfy its own set of constraints.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'This value is not a valid International Securities Identification Number (ISIN).',
    'This form should not contain extra fields.' => 'This form should not contain extra fields.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'The uploaded file was too large. Please try to upload a smaller file.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'The CSRF token is invalid. Please try to resubmit the form.',
    'This value is not a valid HTML5 color.' => 'This value is not a valid HTML5 color.',
    'Please enter a valid birthdate.' => 'Please enter a valid birthdate.',
    'The selected choice is invalid.' => 'The selected choice is invalid.',
    'The collection is invalid.' => 'The collection is invalid.',
    'Please select a valid color.' => 'Please select a valid color.',
    'Please select a valid country.' => 'Please select a valid country.',
    'Please select a valid currency.' => 'Please select a valid currency.',
    'Please choose a valid date interval.' => 'Please choose a valid date interval.',
    'Please enter a valid date and time.' => 'Please enter a valid date and time.',
    'Please enter a valid date.' => 'Please enter a valid date.',
    'Please select a valid file.' => 'Please select a valid file.',
    'The hidden field is invalid.' => 'The hidden field is invalid.',
    'Please enter an integer.' => 'Please enter an integer.',
    'Please select a valid language.' => 'Please select a valid language.',
    'Please select a valid locale.' => 'Please select a valid locale.',
    'Please enter a valid money amount.' => 'Please enter a valid money amount.',
    'Please enter a number.' => 'Please enter a number.',
    'The password is invalid.' => 'The password is invalid.',
    'Please enter a percentage value.' => 'Please enter a percentage value.',
    'The values do not match.' => 'The values do not match.',
    'Please enter a valid time.' => 'Please enter a valid time.',
    'Please select a valid timezone.' => 'Please select a valid timezone.',
    'Please enter a valid URL.' => 'Please enter a valid URL.',
    'Please enter a valid search term.' => 'Please enter a valid search term.',
    'Please provide a valid phone number.' => 'Please provide a valid phone number.',
    'The checkbox has an invalid value.' => 'The checkbox has an invalid value.',
    'Please enter a valid email address.' => 'Please enter a valid email address.',
    'Please select a valid option.' => 'Please select a valid option.',
    'Please select a valid range.' => 'Please select a valid range.',
    'Please enter a valid week.' => 'Please enter a valid week.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'An authentication exception occurred.',
    'Authentication credentials could not be found.' => 'Authentication credentials could not be found.',
    'Authentication request could not be processed due to a system problem.' => 'Authentication request could not be processed due to a system problem.',
    'Invalid credentials.' => 'Invalid credentials.',
    'Cookie has already been used by someone else.' => 'Cookie has already been used by someone else.',
    'Not privileged to request the resource.' => 'Not privileged to request the resource.',
    'Invalid CSRF token.' => 'Invalid CSRF token.',
    'No authentication provider found to support the authentication token.' => 'No authentication provider found to support the authentication token.',
    'No session available, it either timed out or cookies are not enabled.' => 'No session available, it either timed out or cookies are not enabled.',
    'No token could be found.' => 'No token could be found.',
    'Username could not be found.' => 'Username could not be found.',
    'Account has expired.' => 'Account has expired.',
    'Credentials have expired.' => 'Credentials have expired.',
    'Account is disabled.' => 'Account is disabled.',
    'Account is locked.' => 'Account is locked.',
    'Too many failed login attempts, please try again later.' => 'Too many failed login attempts, please try again later.',
    'Invalid or expired login link.' => 'Invalid or expired login link.',
  ),
  'admin' => 
  array (
    'sulu_search.search' => 'Search',
    'sulu_search.everything' => 'Everything',
    'sulu_search.search_hint' => 'Use (*) in your query as a placeholder for parts of a word.',
    'sulu_search.nothing_found' => 'Nothing could be found for your search term.',
    'sulu_contact.contacts' => 'Contacts',
    'sulu_contact.organizations' => 'Organizations',
    'sulu_contact.organization' => 'Organization',
    'sulu_contact.people' => 'People',
    'sulu_contact.contact_selection_overlay_title' => 'Choose contacts',
    'sulu_contact.account_selection_overlay_title' => 'Choose accounts',
    'sulu_contact.contact_selection_label' => '{count} {count, plural, =1 {contact} other {contacts}} selected',
    'sulu_contact.account_selection_label' => '{count} {count, plural, =1 {account} other {accounts}} selected',
    'sulu_contact.contact_account_selection_label' => '{count} {count, plural, =1 {contact} other {contacts}} selected',
    'sulu_contact.avatar' => 'Avatar',
    'sulu_contact.logo' => 'Logo',
    'sulu_contact.name' => 'Name',
    'sulu_contact.first_name' => 'First Name',
    'sulu_contact.last_name' => 'Last Name',
    'sulu_contact.contact_details' => 'Contact details',
    'sulu_contact.addresses' => 'Addresses',
    'sulu_contact.bank_accounts' => 'Bank accounts',
    'sulu_contact.email' => 'Email',
    'sulu_contact.primary_address' => 'Primary address',
    'sulu_contact.delivery_address' => 'Delivery address',
    'sulu_contact.billing_address' => 'Billing address',
    'sulu_contact.city' => 'City',
    'sulu_contact.zip' => 'ZIP',
    'sulu_contact.street' => 'Street',
    'sulu_contact.number' => 'Number',
    'sulu_contact.address_line' => 'Addressline',
    'sulu_contact.state' => 'Region',
    'sulu_contact.country' => 'Country',
    'sulu_contact.postbox_number' => 'Postbox #',
    'sulu_contact.postbox_zip' => 'Postbox ZIP',
    'sulu_contact.postbox_city' => 'Postbox City',
    'sulu_contact.phone' => 'Phone',
    'sulu_contact.fax' => 'Fax',
    'sulu_contact.website' => 'Website',
    'sulu_contact.social_media' => 'Social Media',
    'sulu_contact.birthday' => 'Birthday',
    'sulu_contact.title' => 'Title',
    'sulu_contact.salutation' => 'Salutation',
    'sulu_contact.form_of_address' => 'Form of Address',
    'sulu_contact.male_form_of_address' => 'Mr.',
    'sulu_contact.female_form_of_address' => 'Ms.',
    'sulu_contact.position' => 'Position',
    'sulu_contact.corporation' => 'Corporation',
    'sulu_contact.main_contact' => 'Main Contact',
    'sulu_contact.uid' => 'UID',
    'sulu_contact.register_number' => 'Register Number',
    'sulu_contact.jurisdiction' => 'Jurisdiction',
    'sulu_contact.note' => 'Note',
    'sulu_contact.parent_company' => 'Parent Company',
    'sulu_contact.upload_avatar_info_text' => 'Drop image or click to change avatar',
    'sulu_contact.upload_logo_info_text' => 'Drop image or click to change logo',
    'sulu_contact.no_contact_selected' => 'No contact selected',
    'sulu_contact.single_contact_selection_overlay_title' => 'Choose contact',
    'sulu_contact.no_account_selected' => 'No account selected',
    'sulu_contact.single_account_selection_overlay_title' => 'Choose account',
    'sulu_contact.taxonomies' => 'Taxonomies',
    'sulu_contact.add_address' => 'Add address',
    'sulu_contact.edit_address' => 'Edit address',
    'sulu_contact.add_bank_account' => 'Add bank account',
    'sulu_contact.edit_bank_account' => 'Edit bank account',
    'sulu_contact.work' => 'Work',
    'sulu_contact.private' => 'Private',
    'sulu_contact.mobile' => 'Mobile',
    'sulu_contact.bank' => 'Bank',
    'sulu_contact.iban' => 'IBAN',
    'sulu_contact.bic' => 'BIC',
    'sulu_contact.edit_title_overlay_title' => 'Edit titles',
    'sulu_contact.edit_position_overlay_title' => 'Edit positions',
    'sulu_contact.documents' => 'Documents',
    'sulu_contact.delete_media_warning_title' => 'Remove document assignment?',
    'sulu_contact.delete_media_warning_text' => 'This operation removes the selected document assignments. The document itself will not be deleted. Do you really wish to proceed?',
    'sulu_contact.add_contact_to_organization' => 'Add contact to organization',
    'sulu_contact.latitude' => 'Latitude',
    'sulu_contact.longitude' => 'Longitude',
    'sulu_media.media' => 'Media',
    'sulu_media.all_media' => 'All media',
    'sulu_media.audio' => 'Audio',
    'sulu_media.document' => 'Document',
    'sulu_media.image' => 'Image',
    'sulu_media.video' => 'Video',
    'sulu_media.copy_url' => 'Copy URL',
    'sulu_media.download_masterfile' => 'Download master file',
    'sulu_media.select_media_singular' => 'Select media',
    'sulu_media.select_media_plural' => 'Select media',
    'sulu_media.reset_selection' => 'Reset selection',
    'sulu_media.copy_masterfile_url' => 'Copy master file URL',
    'sulu_media.copy_masterfile_url_website' => 'Copy master file URL (Website)',
    'sulu_media.information_taxonomy' => 'Information and Taxonomy',
    'sulu_media.upload' => 'Upload',
    'sulu_media.upload_new_version' => 'Upload new version',
    'sulu_media.media_selected_singular' => 'media element selected',
    'sulu_media.media_selected_plural' => 'media elements selected',
    'sulu_media.drop_files_to_upload' => 'Upload files per drag`n`drop',
    'sulu_media.click_here_to_upload' => 'or click here to upload files',
    'sulu_media.add_collection' => 'Add collection',
    'sulu_media.remove_collection' => 'Delete collection',
    'sulu_media.remove_collection_warning' => 'This operation deletes a collection and cannot be undone. Do you really wish to proceed?',
    'sulu_media.move_collection' => 'Move collection',
    'sulu_media.edit_collection' => 'Edit collection',
    'sulu_media.download_media' => 'Download media',
    'sulu_media.download_counter' => 'Download count',
    'sulu_media.delete_media' => 'Delete media',
    'sulu_media.delete_media_warning_title' => 'Delete media',
    'sulu_media.delete_media_warning_text' => 'This operation deletes a media and cannot be undone. Do you really wish to proceed?',
    'sulu_media.delete_preview_image_warning_title' => 'Delete preview image',
    'sulu_media.delete_preview_image_warning_text' => 'This operation deletes the preview image and cannot be undone. Do you really wish to proceed?',
    'sulu_media.thumbnail' => 'Thumbnail',
    'sulu_media.type' => 'Type',
    'sulu_media.version' => 'Version',
    'sulu_media.size' => 'Filesize',
    'sulu_media.mime_type' => 'MIME-Type',
    'sulu_media.license' => 'License',
    'sulu_media.copyright' => 'Copyright Information',
    'sulu_media.credits' => 'Credits',
    'sulu_media.taxonomies' => 'Taxonomies',
    'sulu_media.history' => 'History',
    'sulu_media.formats' => 'Formats',
    'sulu_media.all_collections' => 'All collections',
    'sulu_media.move_media' => 'Move media',
    'sulu_media.upload_server_error' => 'There was an error while uploading one or multiple files to the server.',
    'sulu_media.set_focus_point' => 'Set focus point',
    'sulu_media.define_crops' => 'Define crops',
    'sulu_media.upload_preview_image' => 'Upload preview image',
    'sulu_media.delete_preview_image' => 'Delete preview image',
    'sulu_media.cropped' => 'Cropped',
    'sulu_media.double_click_crop_and_maximize' => 'A double-click maximizes and centers the area',
    'sulu_media.min_size_notification' => 'Minimal size reached',
    'sulu_media.left_top' => 'Left top',
    'sulu_media.top' => 'Top',
    'sulu_media.right_top' => 'Right top',
    'sulu_media.left' => 'Left',
    'sulu_media.middle' => 'Middle',
    'sulu_media.right' => 'Right',
    'sulu_media.left_bottom' => 'Left bottom',
    'sulu_media.bottom' => 'Bottom',
    'sulu_media.right_bottom' => 'Right bottom',
    'sulu_media.hotspots' => 'Hotspots',
    'sulu_media.add_hotspot' => 'Add hotspot',
    'sulu_media.hotspot_type' => 'Hotspot type',
    'sulu_media.form_type' => 'Form type',
    'sulu_media.circle' => 'Circle',
    'sulu_media.point' => 'Point',
    'sulu_media.rectangle' => 'Rectangle',
    'sulu_security.roles' => 'User roles',
    'sulu_security.user_name' => 'Username',
    'sulu_security.enable_user' => 'Enable User',
    'sulu_security.user_locked' => 'User locked',
    'sulu_security.permissions' => 'Permissions',
    'sulu_security.password' => 'Password',
    'sulu_security.email' => 'Email',
    'sulu_security.system' => 'System',
    'sulu_security.system_language' => 'System language',
    'sulu_security.reset_mail_subject' => 'Reset your Sulu password',
    'sulu_security.reset_mail_message' => 'To reset your Sulu password please click on the following link or copy/paste it to your browser:',
    'sulu_security.view' => 'View',
    'sulu_security.add' => 'Add',
    'sulu_security.edit' => 'Edit',
    'sulu_security.delete' => 'Delete',
    'sulu_security.live' => 'Live',
    'sulu_security.security' => 'Security',
    'sulu_security.system_permission_heading' => 'Activate permissions for {system}',
    'sulu_security.inherit_permissions_title' => 'Inherit permissions?',
    'sulu_security.inherit_permissions_label' => 'Override permissions of sub elements',
    'sulu_security.move_permission_title' => 'Notice',
    'sulu_security.move_permission_warning' => 'Permissions from the parent element will not be transferred.',
    'sulu_category.categories' => 'Categories',
    'sulu_category.key' => 'Key',
    'sulu_category.name' => 'Name',
    'sulu_category.keywords' => 'Keywords',
    'sulu_category.keyword' => 'Keyword',
    'sulu_category.multiple_usage' => 'Multiple Usage',
    'sulu_category.all_categories' => 'All categories',
    'sulu_category.no_category_selected' => 'No category selected',
    'sulu_category.single_category_selection_overlay_title' => 'Choose category',
    'sulu_snippet.selection_overlay_title' => 'Choose snippets',
    'sulu_snippet.selection_label' => '{count} {count, plural, =1 {snippet} other {snippets}} selected',
    'sulu_snippet.no_snippet_selected' => 'No snippet selected',
    'sulu_snippet.single_snippet_selection_overlay_title' => 'Choose snippet',
    'sulu_snippet.snippets' => 'Snippets',
    'sulu_snippet.snippet' => 'Snippet',
    'sulu_snippet.default_snippets' => 'Default Snippets',
    'sulu_snippet.snippet_area' => 'Type or area',
    'sulu_snippet.taxonomies' => 'Taxonomies',
    'sulu_snippet.webspace_default_snippet' => '%webspaceKey% default snippet',
    'sulu_page.webspaces' => 'Webspaces',
    'sulu_page.selection_label' => '{count} {count, plural, =1 {page} other {pages}} selected',
    'sulu_page.selection_overlay_title' => 'Choose pages',
    'sulu_page.seo' => 'SEO',
    'sulu_page.excerpt' => 'Excerpt & Taxonomies',
    'sulu_page.title' => 'Title',
    'sulu_page.show_ghost_and_shadow' => 'Show ghost and shadow pages',
    'sulu_page.no_page_selected' => 'No page selected',
    'sulu_page.single_selection_overlay_title' => 'Choose page',
    'sulu_page.settings' => 'Settings',
    'sulu_page.show_page_in' => 'Show page in',
    'sulu_page.no_navigation' => 'no navigation',
    'sulu_page.all_navigations' => 'all navigations',
    'sulu_page.page_type' => 'Page Type',
    'sulu_page.content' => 'Content',
    'sulu_page.pages' => 'Pages',
    'sulu_page.page' => 'Page',
    'sulu_page.internal_link' => 'Internal Link',
    'sulu_page.external_link' => 'External Link',
    'sulu_page.link_title' => 'Link Title',
    'sulu_page.linked_content' => 'Linked Content',
    'sulu_page.url' => 'URL',
    'sulu_page.shadow_page' => 'Shadow Page',
    'sulu_page.enable_shadow_page' => 'Enable Shadow Page',
    'sulu_page.enable_shadow_page_info_text' => 'This function is disabled if the current locale is already used as shadow locale.',
    'sulu_page.shadow_locale' => 'Shadow Locale',
    'sulu_page.editing_information' => 'Editing Information',
    'sulu_page.authored_date' => 'Authored Date',
    'sulu_page.author' => 'Author',
    'sulu_page.changelog' => 'Changelog',
    'sulu_page.text_for_more_link' => 'Text for more link',
    'sulu_page.icons' => 'Icons',
    'sulu_page.images' => 'Images',
    'sulu_page.edited' => 'edited',
    'sulu_page.search_result' => 'Search Engine Result Pages Preview (SERP)',
    'sulu_page.meta_title' => 'Title (Meta title)',
    'sulu_page.meta_title_info_text' => 'The meta title is limited to 55 characters.',
    'sulu_page.meta_description' => 'Description (Meta description)',
    'sulu_page.meta_description_info_text' => 'The meta description is limited to 320 characters.',
    'sulu_page.meta_keywords' => 'Keywords (Meta keywords)',
    'sulu_page.meta_keywords_info_text' => 'Please use a maximum of 5 keywords, dependant from the content of the page, separated by commas.',
    'sulu_page.canonical_url' => 'Canonical URL  (Canonical tag)',
    'sulu_page.no_index' => 'no-index (page will not be indexed by search engines)',
    'sulu_page.no_follow' => 'no-follow (links on this page will not be followed by the search engine)',
    'sulu_page.hide_in_sitemap' => 'Hide in sitemap',
    'sulu_page.delete_draft' => 'Delete draft',
    'sulu_page.delete_draft_warning_title' => 'Delete Draft?',
    'sulu_page.delete_draft_warning_text' => 'Do you really want to delete the draft? All data will be lost. The published page will not be changed.',
    'sulu_page.unpublish_warning_title' => 'Set to unpublished?',
    'sulu_page.unpublish_warning_text' => 'Do you really want to unpublish the page? All website links will be lost. This setting can be changed at any time without data loss.',
    'sulu_page.unpublish' => 'Set to unpublished',
    'sulu_page.restore_version' => 'Restore version?',
    'sulu_page.restore_version_text' => 'A new draft will be created. An existing draft version will be overwritten',
    'sulu_page.hide_block_label' => 'Don\'t display on public website',
    'sulu_page.hide_block_description' => 'This block will not be published, but remains editable in the admin.',
    'sulu_page.segment_label' => 'Assign segment',
    'sulu_page.segment_description' => 'The block will be automatically filtered on the website by the chosen segment.',
    'sulu_page.target_groups_label' => 'Assign target groups',
    'sulu_page.target_groups_description' => 'The block will only be visible for the selected target groups.',
    'sulu_tag.tags' => 'Tags',
    'sulu_tag.tag' => 'Tag',
    'sulu_website.analytics' => 'Analytics',
    'sulu_website.all_domains' => 'All domains',
    'sulu_website.domains' => 'Domains',
    'sulu_website.google_analytics' => 'Google Analytics',
    'sulu_website.google_tag_manager' => 'Google Tag Manager',
    'sulu_website.matomo' => 'Matomo',
    'sulu_website.custom_analytics' => 'Custom',
    'sulu_website.script' => 'Script',
    'sulu_website.key' => 'Key',
    'sulu_website.matomo_url' => 'URL',
    'sulu_website.matomo_id' => 'Site-ID',
    'sulu_website.position' => 'Position',
    'sulu_website.head_open' => 'Head open',
    'sulu_website.head_close' => 'Head close',
    'sulu_website.body_open' => 'Body open',
    'sulu_website.body_close' => 'Body close',
    'sulu_website.cache_clear' => 'Clear website cache',
    'sulu_website.cache_clear_warning_title' => 'Clear website cache?',
    'sulu_website.cache_clear_warning_text' => 'This operation will clear the entire cache for all webspaces. Do you really wish to proceed?',
    'sulu_location.latitude' => 'Latitude',
    'sulu_location.longitude' => 'Longitude',
    'sulu_location.zoom' => 'Zoom',
    'sulu_location.select_location' => 'Select location',
    'sulu_location.additional_information' => 'Additional Information',
    'sulu_location.title' => 'Title',
    'sulu_location.street' => 'Street',
    'sulu_location.number' => 'Number',
    'sulu_location.code' => 'Code',
    'sulu_location.town' => 'Town',
    'sulu_location.country' => 'Country',
    'sulu_custom_url.custom_urls' => 'Custom URLs',
    'sulu_custom_url.custom_url' => 'Custom URL',
    'sulu_custom_url.published' => 'Published',
    'sulu_custom_url.base_domain' => 'Base domain',
    'sulu_custom_url.target_page' => 'Target page',
    'sulu_custom_url.target_locale' => 'Localization',
    'sulu_custom_url.redirect' => 'Redirect',
    'sulu_custom_url.redirect_info' => 'The custom URL will be redirected to URL of the linked page.',
    'sulu_custom_url.canonical' => 'Canonical URL',
    'sulu_custom_url.canonical_info' => 'When the Canonical URL has been activated only the linked page will be indexed by search engines',
    'sulu_custom_url.no_index' => 'No Index',
    'sulu_custom_url.no_index_info' => 'The page will not be indexed by search engines.',
    'sulu_custom_url.no_follow' => 'No Follow',
    'sulu_custom_url.no_follow_info' => 'The links on the page will not be followed by search engines.',
    'sulu_custom_url.target_title' => 'Target page',
  ),
));
$catalogue->addFallbackCatalogue($catalogueEn);

return $catalogue;
