<?php

namespace ContainerFeOmBal;

use Symfony\Component\DependencyInjection\Argument\RewindableGenerator;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\Exception\InvalidArgumentException;
use Symfony\Component\DependencyInjection\Exception\LogicException;
use Symfony\Component\DependencyInjection\Exception\RuntimeException;
use Symfony\Component\DependencyInjection\ParameterBag\FrozenParameterBag;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

/**
 * @internal This class has been auto-generated by the Symfony Dependency Injection Component.
 */
class App_KernelDevDebugContainer extends Container
{
    protected $containerDir;
    protected $targetDir;
    protected $parameters = [];
    private $buildParameters;
    protected $getService;

    public function __construct(array $buildParameters = [], $containerDir = __DIR__)
    {
        $this->getService = \Closure::fromCallable([$this, 'getService']);
        $this->buildParameters = $buildParameters;
        $this->containerDir = $containerDir;
        $this->targetDir = \dirname($containerDir);
        $this->parameters = $this->getDefaultParameters();

        $this->services = $this->privates = [];
        $this->syntheticIds = [
            'kernel' => true,
        ];
        $this->methodMap = [
            '.container.private.filesystem' => 'get_Container_Private_FilesystemService',
            '.container.private.form.factory' => 'get_Container_Private_Form_FactoryService',
            '.container.private.twig' => 'get_Container_Private_TwigService',
            'cmf_routing.route_provider' => 'getCmfRouting_RouteProviderService',
            'doctrine' => 'getDoctrineService',
            'doctrine.dbal.default_connection' => 'getDoctrine_Dbal_DefaultConnectionService',
            'doctrine.orm.default_entity_manager' => 'getDoctrine_Orm_DefaultEntityManagerService',
            'doctrine_phpcr.session' => 'getDoctrinePhpcr_SessionService',
            'event_dispatcher' => 'getEventDispatcherService',
            'fos_http_cache.cache_manager' => 'getFosHttpCache_CacheManagerService',
            'fos_http_cache.event_listener.cache_control' => 'getFosHttpCache_EventListener_CacheControlService',
            'fos_http_cache.http.symfony_response_tagger' => 'getFosHttpCache_Http_SymfonyResponseTaggerService',
            'fos_http_cache.proxy_client.symfony' => 'getFosHttpCache_ProxyClient_SymfonyService',
            'http_kernel' => 'getHttpKernelService',
            'jms_serializer' => 'getJmsSerializerService',
            'jms_serializer.deserialization_context_factory' => 'getJmsSerializer_DeserializationContextFactoryService',
            'jms_serializer.serialization_context_factory' => 'getJmsSerializer_SerializationContextFactoryService',
            'request_stack' => 'getRequestStackService',
            'router' => 'getRouterService',
            'sulu.content.localization_finder' => 'getSulu_Content_LocalizationFinderService',
            'sulu.content.mapper' => 'getSulu_Content_MapperService',
            'sulu.content.path_cleaner' => 'getSulu_Content_PathCleanerService',
            'sulu.content.structure_manager' => 'getSulu_Content_StructureManagerService',
            'sulu.content.type_manager' => 'getSulu_Content_TypeManagerService',
            'sulu.phpcr.session' => 'getSulu_Phpcr_SessionService',
            'sulu.repository.access_control' => 'getSulu_Repository_AccessControlService',
            'sulu.repository.account' => 'getSulu_Repository_AccountService',
            'sulu.repository.category' => 'getSulu_Repository_CategoryService',
            'sulu.repository.category_meta' => 'getSulu_Repository_CategoryMetaService',
            'sulu.repository.category_translation' => 'getSulu_Repository_CategoryTranslationService',
            'sulu.repository.contact' => 'getSulu_Repository_ContactService',
            'sulu.repository.keyword' => 'getSulu_Repository_KeywordService',
            'sulu.repository.media' => 'getSulu_Repository_MediaService',
            'sulu.repository.role' => 'getSulu_Repository_RoleService',
            'sulu.repository.route' => 'getSulu_Repository_RouteService',
            'sulu.repository.tag' => 'getSulu_Repository_TagService',
            'sulu.repository.user' => 'getSulu_Repository_UserService',
            'sulu.util.node_helper' => 'getSulu_Util_NodeHelperService',
            'sulu_category.category_manager' => 'getSuluCategory_CategoryManagerService',
            'sulu_category.keyword_manager' => 'getSuluCategory_KeywordManagerService',
            'sulu_contact.contact_manager' => 'getSuluContact_ContactManagerService',
            'sulu_core.array_serializer' => 'getSuluCore_ArraySerializerService',
            'sulu_core.webspace.request_analyzer' => 'getSuluCore_Webspace_RequestAnalyzerService',
            'sulu_core.webspace.webspace_manager' => 'getSuluCore_Webspace_WebspaceManagerService',
            'sulu_custom_urls.manager' => 'getSuluCustomUrls_ManagerService',
            'sulu_document_manager.document_inspector' => 'getSuluDocumentManager_DocumentInspectorService',
            'sulu_document_manager.document_manager' => 'getSuluDocumentManager_DocumentManagerService',
            'sulu_document_manager.live_session' => 'getSuluDocumentManager_LiveSessionService',
            'sulu_document_manager.metadata_factory.base' => 'getSuluDocumentManager_MetadataFactory_BaseService',
            'sulu_document_manager.property_encoder' => 'getSuluDocumentManager_PropertyEncoderService',
            'sulu_markup.parser.html_extractor' => 'getSuluMarkup_Parser_HtmlExtractorService',
            'sulu_media.collection_repository' => 'getSuluMedia_CollectionRepositoryService',
            'sulu_media.format_cache' => 'getSuluMedia_FormatCacheService',
            'sulu_media.format_manager' => 'getSuluMedia_FormatManagerService',
            'sulu_media.image.transformation.blur' => 'getSuluMedia_Image_Transformation_BlurService',
            'sulu_media.image.transformation.crop' => 'getSuluMedia_Image_Transformation_CropService',
            'sulu_media.image.transformation.gamma' => 'getSuluMedia_Image_Transformation_GammaService',
            'sulu_media.image.transformation.grayscale' => 'getSuluMedia_Image_Transformation_GrayscaleService',
            'sulu_media.image.transformation.negative' => 'getSuluMedia_Image_Transformation_NegativeService',
            'sulu_media.image.transformation.paste' => 'getSuluMedia_Image_Transformation_PasteService',
            'sulu_media.image.transformation.sharpen' => 'getSuluMedia_Image_Transformation_SharpenService',
            'sulu_media.media_manager' => 'getSuluMedia_MediaManagerService',
            'sulu_media.storage' => 'getSuluMedia_StorageService',
            'sulu_page.compat.structure.legacy_property_factory' => 'getSuluPage_Compat_Structure_LegacyPropertyFactoryService',
            'sulu_page.content_repository' => 'getSuluPage_ContentRepositoryService',
            'sulu_page.extension.manager' => 'getSuluPage_Extension_ManagerService',
            'sulu_page.structure.factory' => 'getSuluPage_Structure_FactoryService',
            'sulu_security.mask_converter' => 'getSuluSecurity_MaskConverterService',
            'sulu_security.salt_generator' => 'getSuluSecurity_SaltGeneratorService',
            'sulu_security.user_manager' => 'getSuluSecurity_UserManagerService',
            'sulu_snippet.default_snippet.manager' => 'getSuluSnippet_DefaultSnippet_ManagerService',
            'sulu_snippet.resolver' => 'getSuluSnippet_ResolverService',
            'sulu_tag.tag_manager' => 'getSuluTag_TagManagerService',
            'sulu_website.resolver.structure' => 'getSuluWebsite_Resolver_StructureService',
            'translator' => 'getTranslatorService',
            'var_dumper.cloner' => 'getVarDumper_ClonerService',
            'cache_clearer' => 'getCacheClearerService',
            'filesystem' => 'getFilesystemService',
            'security.csrf.token_manager' => 'getSecurity_Csrf_TokenManagerService',
            'form.factory' => 'getForm_FactoryService',
            'form.type.file' => 'getForm_Type_FileService',
            'validator' => 'getValidatorService',
            'serializer' => 'getSerializerService',
            'twig' => 'getTwigService',
        ];
        $this->fileMap = [
            '.container.private.cache_clearer' => 'get_Container_Private_CacheClearerService',
            '.container.private.form.type.file' => 'get_Container_Private_Form_Type_FileService',
            '.container.private.security.csrf.token_manager' => 'get_Container_Private_Security_Csrf_TokenManagerService',
            '.container.private.serializer' => 'get_Container_Private_SerializerService',
            '.container.private.validator' => 'get_Container_Private_ValidatorService',
            'Symfony\\Bundle\\FrameworkBundle\\Controller\\RedirectController' => 'getRedirectControllerService',
            'Symfony\\Bundle\\FrameworkBundle\\Controller\\TemplateController' => 'getTemplateControllerService',
            'cache.app' => 'getCache_AppService',
            'cache.app_clearer' => 'getCache_AppClearerService',
            'cache.global_clearer' => 'getCache_GlobalClearerService',
            'cache.system' => 'getCache_SystemService',
            'cache.system_clearer' => 'getCache_SystemClearerService',
            'cache_warmer' => 'getCacheWarmerService',
            'cmf_routing.redirect_controller' => 'getCmfRouting_RedirectControllerService',
            'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\LoadFixtureCommand' => 'getLoadFixtureCommandService',
            'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\MigratorMigrateCommand' => 'getMigratorMigrateCommandService',
            'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\NodeDumpCommand' => 'getNodeDumpCommandService',
            'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\NodeMoveCommand' => 'getNodeMoveCommandService',
            'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\NodeRemoveCommand' => 'getNodeRemoveCommandService',
            'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\NodeTouchCommand' => 'getNodeTouchCommandService',
            'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\NodeTypeListCommand' => 'getNodeTypeListCommandService',
            'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\NodeTypeRegisterCommand' => 'getNodeTypeRegisterCommandService',
            'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\NodesUpdateCommand' => 'getNodesUpdateCommandService',
            'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\PhpcrShellCommand' => 'getPhpcrShellCommandService',
            'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\RepositoryInitCommand' => 'getRepositoryInitCommandService',
            'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\WorkspaceCreateCommand' => 'getWorkspaceCreateCommandService',
            'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\WorkspaceDeleteCommand' => 'getWorkspaceDeleteCommandService',
            'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\WorkspaceExportCommand' => 'getWorkspaceExportCommandService',
            'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\WorkspaceImportCommand' => 'getWorkspaceImportCommandService',
            'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\WorkspaceListCommand' => 'getWorkspaceListCommandService',
            'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\WorkspacePurgeCommand' => 'getWorkspacePurgeCommandService',
            'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\WorkspaceQueryCommand' => 'getWorkspaceQueryCommandService',
            'console.command.public_alias.massive_build.command.build' => 'getConsole_Command_PublicAlias_MassiveBuild_Command_BuildService',
            'console.command.public_alias.sulu_page.command.workspace_import' => 'getConsole_Command_PublicAlias_SuluPage_Command_WorkspaceImportService',
            'console.command.public_alias.sulu_route.move_page_tree_command' => 'getConsole_Command_PublicAlias_SuluRoute_MovePageTreeCommandService',
            'console.command_loader' => 'getConsole_CommandLoaderService',
            'container.env_var_processors_locator' => 'getContainer_EnvVarProcessorsLocatorService',
            'data_collector.dump' => 'getDataCollector_DumpService',
            'doctrine_phpcr' => 'getDoctrinePhpcrService',
            'doctrine_phpcr.admin.default_session' => 'getDoctrinePhpcr_Admin_DefaultSessionService',
            'doctrine_phpcr.admin.live_session' => 'getDoctrinePhpcr_Admin_LiveSessionService',
            'doctrine_phpcr.initializer_manager' => 'getDoctrinePhpcr_InitializerManagerService',
            'error_controller' => 'getErrorControllerService',
            'fos_rest.serializer.jms_handler_registry' => 'getFosRest_Serializer_JmsHandlerRegistryService',
            'fos_rest.view_handler' => 'getFosRest_ViewHandlerService',
            'jms_serializer.handler_registry' => 'getJmsSerializer_HandlerRegistryService',
            'jms_serializer.metadata_driver' => 'getJmsSerializer_MetadataDriverService',
            'jms_serializer.twig_extension.serializer_runtime_helper' => 'getJmsSerializer_TwigExtension_SerializerRuntimeHelperService',
            'massive_search.adapter.test' => 'getMassiveSearch_Adapter_TestService',
            'massive_search.adapter.zend_lucene' => 'getMassiveSearch_Adapter_ZendLuceneService',
            'massive_search.search_manager' => 'getMassiveSearch_SearchManagerService',
            'phpcr_migrations.command.initialize' => 'getPhpcrMigrations_Command_InitializeService',
            'phpcr_migrations.command.migrate' => 'getPhpcrMigrations_Command_MigrateService',
            'phpcr_migrations.command.status' => 'getPhpcrMigrations_Command_StatusService',
            'routing.loader' => 'getRouting_LoaderService',
            'services_resetter' => 'getServicesResetterService',
            'session' => 'getSessionService',
            'sulu.content.path_cleaner.replacer_loader' => 'getSulu_Content_PathCleaner_ReplacerLoaderService',
            'sulu.content.path_cleaner.replacer_loader.file_locator' => 'getSulu_Content_PathCleaner_ReplacerLoader_FileLocatorService',
            'sulu.content.type.block' => 'getSulu_Content_Type_BlockService',
            'sulu.content.type.checkbox' => 'getSulu_Content_Type_CheckboxService',
            'sulu.content.type.color' => 'getSulu_Content_Type_ColorService',
            'sulu.content.type.date' => 'getSulu_Content_Type_DateService',
            'sulu.content.type.datetime' => 'getSulu_Content_Type_DatetimeService',
            'sulu.content.type.email' => 'getSulu_Content_Type_EmailService',
            'sulu.content.type.number' => 'getSulu_Content_Type_NumberService',
            'sulu.content.type.page_selection' => 'getSulu_Content_Type_PageSelectionService',
            'sulu.content.type.password' => 'getSulu_Content_Type_PasswordService',
            'sulu.content.type.phone' => 'getSulu_Content_Type_PhoneService',
            'sulu.content.type.resource_locator' => 'getSulu_Content_Type_ResourceLocatorService',
            'sulu.content.type.segment_select' => 'getSulu_Content_Type_SegmentSelectService',
            'sulu.content.type.select' => 'getSulu_Content_Type_SelectService',
            'sulu.content.type.single_page_selection' => 'getSulu_Content_Type_SinglePageSelectionService',
            'sulu.content.type.single_select' => 'getSulu_Content_Type_SingleSelectService',
            'sulu.content.type.text_area' => 'getSulu_Content_Type_TextAreaService',
            'sulu.content.type.text_editor' => 'getSulu_Content_Type_TextEditorService',
            'sulu.content.type.text_line' => 'getSulu_Content_Type_TextLineService',
            'sulu.content.type.time' => 'getSulu_Content_Type_TimeService',
            'sulu.content.type.url' => 'getSulu_Content_Type_UrlService',
            'sulu.content.webspace_structure_provider' => 'getSulu_Content_WebspaceStructureProviderService',
            'sulu.core.localization_manager' => 'getSulu_Core_LocalizationManagerService',
            'sulu.repository.role_setting' => 'getSulu_Repository_RoleSettingService',
            'sulu_category.content.type.category_selection' => 'getSuluCategory_Content_Type_CategorySelectionService',
            'sulu_category.content.type.single_category_selection' => 'getSuluCategory_Content_Type_SingleCategorySelectionService',
            'sulu_contact.account_factory' => 'getSuluContact_AccountFactoryService',
            'sulu_contact.account_manager' => 'getSuluContact_AccountManagerService',
            'sulu_contact.content.account_selection' => 'getSuluContact_Content_AccountSelectionService',
            'sulu_contact.content.contact_account_selection' => 'getSuluContact_Content_ContactAccountSelectionService',
            'sulu_contact.content.contact_selection' => 'getSuluContact_Content_ContactSelectionService',
            'sulu_contact.content.single_account_selection' => 'getSuluContact_Content_SingleAccountSelectionService',
            'sulu_contact.content.single_contact_selection' => 'getSuluContact_Content_SingleContactSelectionService',
            'sulu_contact.util.index_comparator' => 'getSuluContact_Util_IndexComparatorService',
            'sulu_core.doctrine_list_builder_factory' => 'getSuluCore_DoctrineListBuilderFactoryService',
            'sulu_core.doctrine_rest_helper' => 'getSuluCore_DoctrineRestHelperService',
            'sulu_core.list_rest_helper' => 'getSuluCore_ListRestHelperService',
            'sulu_core.webspace.document_manager.webspace_initializer' => 'getSuluCore_Webspace_DocumentManager_WebspaceInitializerService',
            'sulu_custom_urls.initializer' => 'getSuluCustomUrls_InitializerService',
            'sulu_document_manager.initializer' => 'getSuluDocumentManager_InitializerService',
            'sulu_document_manager.initializer.root_path_purge_initializer' => 'getSuluDocumentManager_Initializer_RootPathPurgeInitializerService',
            'sulu_document_manager.initializer.workspace' => 'getSuluDocumentManager_Initializer_WorkspaceService',
            'sulu_document_manager.serializer.subscriber.proxy' => 'getSuluDocumentManager_Serializer_Subscriber_ProxyService',
            'sulu_hash.request_hash_checker' => 'getSuluHash_RequestHashCheckerService',
            'sulu_location.content.type.location' => 'getSuluLocation_Content_Type_LocationService',
            'sulu_location.controller.geolocator' => 'getSuluLocation_Controller_GeolocatorService',
            'sulu_media.collection_manager' => 'getSuluMedia_CollectionManagerService',
            'sulu_media.disposition_type.resolver' => 'getSuluMedia_DispositionType_ResolverService',
            'sulu_media.format_options_manager' => 'getSuluMedia_FormatOptionsManagerService',
            'sulu_media.media_stream_controller' => 'getSuluMedia_MediaStreamControllerService',
            'sulu_media.system_collections.manager' => 'getSuluMedia_SystemCollections_ManagerService',
            'sulu_media.type.image_map' => 'getSuluMedia_Type_ImageMapService',
            'sulu_media.type.media_selection' => 'getSuluMedia_Type_MediaSelectionService',
            'sulu_media.type.single_media_selection' => 'getSuluMedia_Type_SingleMediaSelectionService',
            'sulu_page.document_manager.content_initializer' => 'getSuluPage_DocumentManager_ContentInitializerService',
            'sulu_page.export.webspace' => 'getSuluPage_Export_WebspaceService',
            'sulu_page.import.webspace' => 'getSuluPage_Import_WebspaceService',
            'sulu_page.node_repository' => 'getSuluPage_NodeRepositoryService',
            'sulu_page.rl_repository' => 'getSuluPage_RlRepositoryService',
            'sulu_page.smart_content.content_type' => 'getSuluPage_SmartContent_ContentTypeService',
            'sulu_page.smart_content.data_provider_pool' => 'getSuluPage_SmartContent_DataProviderPoolService',
            'sulu_page.teaser.content_type' => 'getSuluPage_Teaser_ContentTypeService',
            'sulu_route.content_type' => 'getSuluRoute_ContentTypeService',
            'sulu_route.content_type.page_tree_route' => 'getSuluRoute_ContentType_PageTreeRouteService',
            'sulu_search.controller.website_search' => 'getSuluSearch_Controller_WebsiteSearchService',
            'sulu_security.token_generator' => 'getSuluSecurity_TokenGeneratorService',
            'sulu_security.user_repository' => 'getSuluSecurity_UserRepositoryService',
            'sulu_security.user_setting_repository' => 'getSuluSecurity_UserSettingRepositoryService',
            'sulu_snippet.content.single_snippet_selection' => 'getSuluSnippet_Content_SingleSnippetSelectionService',
            'sulu_snippet.content.snippet' => 'getSuluSnippet_Content_SnippetService',
            'sulu_snippet.document.snippet_initializer' => 'getSuluSnippet_Document_SnippetInitializerService',
            'sulu_snippet.export.snippet' => 'getSuluSnippet_Export_SnippetService',
            'sulu_snippet.import.snippet' => 'getSuluSnippet_Import_SnippetService',
            'sulu_snippet.reference_store.snippet' => 'getSuluSnippet_ReferenceStore_SnippetService',
            'sulu_snippet.repository' => 'getSuluSnippet_RepositoryService',
            'sulu_tag.content.type.tag_selection' => 'getSuluTag_Content_Type_TagSelectionService',
            'sulu_website.analytics.manager' => 'getSuluWebsite_Analytics_ManagerService',
            'sulu_website.default_controller' => 'getSuluWebsite_DefaultControllerService',
            'sulu_website.http_cache.clearer' => 'getSuluWebsite_HttpCache_ClearerService',
            'sulu_website.redirect_controller' => 'getSuluWebsite_RedirectControllerService',
            'sulu_website.resolver.parameter' => 'getSuluWebsite_Resolver_ParameterService',
            'sulu_website.resolver.template_attribute' => 'getSuluWebsite_Resolver_TemplateAttributeService',
            'sulu_website.segment_controller' => 'getSuluWebsite_SegmentControllerService',
            'sulu_website.sitemap_controller' => 'getSuluWebsite_SitemapControllerService',
            'sulu_website.url_select_helper' => 'getSuluWebsite_UrlSelectHelperService',
            'swiftmailer.mailer.default' => 'getSwiftmailer_Mailer_DefaultService',
            'swiftmailer.mailer.default.plugin.messagelogger' => 'getSwiftmailer_Mailer_Default_Plugin_MessageloggerService',
            'swiftmailer.mailer.default.transport.real' => 'getSwiftmailer_Mailer_Default_Transport_RealService',
            'swiftmailer.transport' => 'getSwiftmailer_TransportService',
            'web_profiler.controller.exception_panel' => 'getWebProfiler_Controller_ExceptionPanelService',
            'web_profiler.controller.profiler' => 'getWebProfiler_Controller_ProfilerService',
            'web_profiler.controller.router' => 'getWebProfiler_Controller_RouterService',
        ];
        $this->aliases = [
            'Doctrine\\Bundle\\PHPCRBundle\\ManagerRegistry' => 'doctrine_phpcr',
            'FOS\\HttpCacheBundle\\CacheManager' => 'fos_http_cache.cache_manager',
            'FOS\\HttpCacheBundle\\EventListener\\CacheControlListener' => 'fos_http_cache.event_listener.cache_control',
            'FOS\\HttpCacheBundle\\Http\\SymfonyResponseTagger' => 'fos_http_cache.http.symfony_response_tagger',
            'FOS\\HttpCache\\ResponseTagger' => 'fos_http_cache.http.symfony_response_tagger',
            'PHPCR\\SessionInterface' => 'doctrine_phpcr.session',
            'Sulu\\Bundle\\MediaBundle\\Media\\Storage\\StorageInterface' => 'sulu_media.storage',
            'Sulu\\Bundle\\WebsiteBundle\\Controller\\DefaultController' => 'sulu_website.default_controller',
            'database_connection' => 'doctrine.dbal.default_connection',
            'doctrine.orm.entity_manager' => 'doctrine.orm.default_entity_manager',
            'doctrine_phpcr.admin.jackalope_doctrine_dbal.default_connection' => 'doctrine.dbal.default_connection',
            'doctrine_phpcr.admin.jackalope_doctrine_dbal.live_connection' => 'doctrine.dbal.default_connection',
            'doctrine_phpcr.default_session' => 'doctrine_phpcr.session',
            'doctrine_phpcr.jackalope_doctrine_dbal.default_connection' => 'doctrine.dbal.default_connection',
            'doctrine_phpcr.jackalope_doctrine_dbal.live_connection' => 'doctrine.dbal.default_connection',
            'doctrine_phpcr.live_session' => 'sulu_document_manager.live_session',
            'mailer' => 'swiftmailer.mailer.default',
            'sulu_document_manager.default_session' => 'doctrine_phpcr.session',
        ];

        $this->privates['service_container'] = function () {
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/HttpKernelInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/KernelInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/RebootableInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/TerminableInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/Kernel.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/framework-bundle/Kernel/MicroKernelTrait.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/HttpKernel/SuluKernel.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache/src/SymfonyCache/HttpCacheProvider.php';
            include_once \dirname(__DIR__, 5).'/src/Kernel.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/PreviewBundle/Preview/Renderer/PreviewKernel.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/Controller/ControllerResolverInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/Controller/ControllerResolver.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/Controller/ContainerControllerResolver.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/framework-bundle/Controller/ControllerResolver.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/event-dispatcher/EventSubscriberInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/EventListener/ResponseListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/EventListener/StreamedResponseListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/EventListener/LocaleListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/EventListener/ValidateRequestListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/EventListener/DisallowRobotsIndexingListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/EventListener/ErrorListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/dependency-injection/ParameterBag/ParameterBagInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/dependency-injection/ParameterBag/ParameterBag.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/dependency-injection/ParameterBag/FrozenParameterBag.php';
            include_once \dirname(__DIR__, 5).'/vendor/psr/container/src/ContainerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/dependency-injection/ParameterBag/ContainerBagInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/dependency-injection/ParameterBag/ContainerBag.php';
            include_once \dirname(__DIR__, 5).'/vendor/psr/event-dispatcher/src/EventDispatcherInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/event-dispatcher-contracts/EventDispatcherInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/event-dispatcher/EventDispatcherInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/event-dispatcher/EventDispatcher.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/HttpKernel.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/Controller/ArgumentResolverInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/Controller/ArgumentResolver.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactoryInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactory.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-foundation/RequestStack.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/config/FileLocatorInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/config/FileLocator.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/Config/FileLocator.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/config/ConfigCacheFactoryInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/config/ResourceCheckerConfigCacheFactory.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/EventListener/LocaleAwareListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/EventListener/AbstractSessionListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/EventListener/SessionListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/service-contracts/ServiceProviderInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/service-contracts/ServiceLocatorTrait.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/dependency-injection/ServiceLocator.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/form/FormRegistryInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/form/FormRegistry.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/form/FormExtensionInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/form/Extension/DependencyInjection/DependencyInjectionExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/form/ResolvedFormTypeFactoryInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/form/ResolvedFormTypeFactory.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/EventListener/DebugHandlersListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/psr/log/Psr/Log/LoggerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/monolog/monolog/src/Monolog/ResettableInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/monolog/monolog/src/Monolog/Logger.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/Log/DebugLoggerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/service-contracts/ResetInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/monolog-bridge/Logger.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/Debug/FileLinkFormatter.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/routing/RequestContext.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/expression-language/ExpressionFunctionProviderInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/routing/Matcher/ExpressionLanguageProvider.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/Reader.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/AnnotationReader.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/AnnotationRegistry.php';
            include_once \dirname(__DIR__, 5).'/vendor/twig/twig/src/Loader/LoaderInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/twig/twig/src/Loader/FilesystemLoader.php';
            include_once \dirname(__DIR__, 5).'/vendor/monolog/monolog/src/Monolog/Handler/HandlerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/monolog/monolog/src/Monolog/Handler/Handler.php';
            include_once \dirname(__DIR__, 5).'/vendor/monolog/monolog/src/Monolog/Handler/AbstractHandler.php';
            include_once \dirname(__DIR__, 5).'/vendor/monolog/monolog/src/Monolog/Handler/ProcessableHandlerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/monolog/monolog/src/Monolog/Handler/FormattableHandlerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/monolog/monolog/src/Monolog/Handler/ProcessableHandlerTrait.php';
            include_once \dirname(__DIR__, 5).'/vendor/monolog/monolog/src/Monolog/Handler/FormattableHandlerTrait.php';
            include_once \dirname(__DIR__, 5).'/vendor/monolog/monolog/src/Monolog/Handler/AbstractProcessingHandler.php';
            include_once \dirname(__DIR__, 5).'/vendor/monolog/monolog/src/Monolog/Handler/StreamHandler.php';
            include_once \dirname(__DIR__, 5).'/vendor/monolog/monolog/src/Monolog/Processor/ProcessorInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/monolog/monolog/src/Monolog/Processor/PsrLogMessageProcessor.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/monolog-bridge/Handler/ConsoleHandler.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/PHPCR/PathCleanupInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/PHPCR/PathCleanup.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/string/Slugger/SluggerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/translation-contracts/LocaleAwareInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/string/Slugger/AsciiSlugger.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Mapper/ContentMapperInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Mapper/ContentMapper.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/ContentTypeManagerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/dependency-injection/ContainerAwareTrait.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/ContentTypeManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/dependency-injection/ContainerAwareInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Compat/StructureManagerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Compat/StructureManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Types/ResourceLocator/Mapper/ResourceLocatorMapperInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Types/ResourceLocator/Mapper/PhpcrMapper.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Types/ResourceLocator/Strategy/ResourceLocatorStrategyPoolInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Types/ResourceLocator/Strategy/ResourceLocatorStrategyPool.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Types/ResourceLocator/Strategy/ResourceLocatorStrategyInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Types/ResourceLocator/Strategy/ResourceLocatorStrategy.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Types/ResourceLocator/Strategy/TreeFullEditStrategy.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Types/ResourceLocator/Strategy/ResourceLocatorGeneratorInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Types/ResourceLocator/Strategy/TreeGenerator.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Types/ResourceLocator/Strategy/TreeLeafEditStrategy.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Query/ContentQueryExecutorInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Query/ContentQueryExecutor.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Util/SuluNodeHelper.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Compat/LocalizationFinderInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Compat/LocalizationFinder.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/config/Loader/LoaderInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/config/Loader/Loader.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/config/Loader/DelegatingLoader.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/config/Loader/LoaderResolverInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/config/Loader/LoaderResolver.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/config/Loader/FileLoader.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Webspace/Loader/BaseXmlFileLoader.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Webspace/Loader/XmlFileLoader10.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Webspace/Loader/XmlFileLoader11.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Webspace/Url/ReplacerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Webspace/Url/Replacer.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Localization/Provider/LocalizationProviderInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Webspace/Manager/WebspaceManagerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Webspace/Manager/WebspaceManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/ocramius/proxy-manager/src/ProxyManager/Configuration.php';
            include_once \dirname(__DIR__, 5).'/vendor/ocramius/proxy-manager/src/ProxyManager/GeneratorStrategy/GeneratorStrategyInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/ocramius/proxy-manager/src/ProxyManager/GeneratorStrategy/FileWriterGeneratorStrategy.php';
            include_once \dirname(__DIR__, 5).'/vendor/ocramius/proxy-manager/src/ProxyManager/FileLocator/FileLocatorInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/ocramius/proxy-manager/src/ProxyManager/FileLocator/FileLocator.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/PHPCR/SessionManager/SessionManagerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/PHPCR/SessionManager/SessionManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Serializer/ArraySerializerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Serializer/ArraySerializer.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Webspace/Analyzer/RequestAnalyzerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Webspace/Analyzer/RequestAnalyzer.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Webspace/Analyzer/Attributes/RequestProcessorInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Webspace/Analyzer/Attributes/ParameterRequestProcessor.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Webspace/Analyzer/Attributes/UrlRequestProcessor.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Webspace/Analyzer/Attributes/WebsiteRequestProcessor.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Webspace/Analyzer/Attributes/SegmentRequestProcessor.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Webspace/Analyzer/Attributes/PortalInformationRequestProcessor.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/persistence/lib/Doctrine/Persistence/ConnectionRegistry.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/persistence/lib/Doctrine/Persistence/ManagerRegistry.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/persistence/lib/Doctrine/Persistence/AbstractManagerRegistry.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/doctrine-bridge/ManagerRegistry.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/doctrine-bundle/Registry.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/dbal/lib/Doctrine/DBAL/Driver/Connection.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/dbal/lib/Doctrine/DBAL/Connection.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/doctrine-bundle/ConnectionFactory.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/dbal/lib/Doctrine/DBAL/Configuration.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/dbal/lib/Doctrine/DBAL/Logging/SQLLogger.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/dbal/lib/Doctrine/DBAL/Logging/LoggerChain.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/doctrine-bridge/Logger/DbalLogger.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/dbal/lib/Doctrine/DBAL/Logging/DebugStack.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/event-manager/lib/Doctrine/Common/EventManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/doctrine-bridge/ContainerAwareEventManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/event-manager/lib/Doctrine/Common/EventSubscriber.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/EventSubscriber/ORM/MetadataSubscriber.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Doctrine/ReferencesOption.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Tools/ResolveTargetEntityListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/doctrine-bridge/SchemaListener/PdoCacheAdapterDoctrineSchemaSubscriber.php';
            include_once \dirname(__DIR__, 5).'/vendor/massive/search-bundle/Search/EventSubscriber/DoctrineOrmSubscriber.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/EventSubscriber/ORM/TimestampableSubscriber.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/EventSubscriber/ORM/UserBlameSubscriber.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SecurityBundle/EventListener/PermissionInheritanceSubscriber.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony-cmf/routing-bundle/src/Doctrine/RouteConditionMetadataListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/gedmo/doctrine-extensions/lib/Gedmo/Mapping/MappedEventSubscriber.php';
            include_once \dirname(__DIR__, 5).'/vendor/gedmo/doctrine-extensions/lib/Gedmo/Tree/TreeListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/psr/cache/src/CacheItemPoolInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/cache/Adapter/AdapterInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/cache-contracts/CacheInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/psr/log/Psr/Log/LoggerAwareInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/cache/ResettableInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/psr/log/Psr/Log/LoggerAwareTrait.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/cache/Adapter/ArrayAdapter.php';
            include_once \dirname(__DIR__, 5).'/vendor/phpcr/phpcr/src/PHPCR/RepositoryFactoryInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/jackalope/jackalope-doctrine-dbal/src/Jackalope/RepositoryFactoryDoctrineDBAL.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/rest-bundle/Util/ExceptionValueMap.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/rest-bundle/EventListener/ResponseStatusCodeListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/rest-bundle/EventListener/BodyListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/rest-bundle/Decoder/DecoderProviderInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/rest-bundle/Decoder/ContainerDecoderProvider.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/rest-bundle/EventListener/ZoneMatcherListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-foundation/RequestMatcherInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-foundation/RequestMatcher.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/Type/ParserInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/Type/Parser.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache-bundle/src/Http/RuleMatcherInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache-bundle/src/Http/RuleMatcher.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache-bundle/src/Http/RequestMatcher/UnsafeRequestMatcher.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache-bundle/src/Http/ResponseMatcher/ResponseMatcherInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache-bundle/src/Http/ResponseMatcher/NonErrorResponseMatcher.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache-bundle/src/EventListener/CacheControlListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache/src/ProxyClient/ProxyClient.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache/src/ProxyClient/HttpProxyClient.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache/src/ProxyClient/Invalidation/PurgeCapable.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache/src/ProxyClient/Invalidation/RefreshCapable.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache/src/ProxyClient/Invalidation/TagCapable.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache/src/ProxyClient/Invalidation/ClearCapable.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache/src/ProxyClient/Symfony.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache/src/ProxyClient/Dispatcher.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache/src/SymfonyCache/KernelDispatcher.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache/src/CacheInvalidator.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache-bundle/src/CacheManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache/src/ResponseTagger.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache-bundle/src/Http/SymfonyResponseTagger.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache/src/TagHeaderFormatter/TagHeaderFormatter.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache/src/TagHeaderFormatter/CommaSeparatedTagHeaderFormatter.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache-bundle/src/EventListener/AbstractRuleListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache-bundle/src/EventListener/TagListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache-bundle/src/Http/RequestMatcher/CacheableRequestMatcher.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache-bundle/src/Http/ResponseMatcher/CacheableResponseMatcher.php';
            include_once \dirname(__DIR__, 5).'/vendor/massive/search-bundle/Search/Factory.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SearchBundle/Search/Factory.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/ContactBundle/Contact/ContactManagerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/RelationTrait.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/ContactBundle/Contact/AbstractContactManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/SmartContent/Orm/DataProviderRepositoryInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/ContactBundle/Contact/ContactManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/persistence/lib/Doctrine/Persistence/ObjectRepository.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/collections/lib/Doctrine/Common/Collections/Selectable.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/EntityRepository.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/ContactBundle/Entity/ContactTitleRepository.php';
            include_once \dirname(__DIR__, 5).'/vendor/gedmo/doctrine-extensions/lib/Gedmo/Tree/RepositoryUtilsInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/gedmo/doctrine-extensions/lib/Gedmo/Tree/RepositoryInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/gedmo/doctrine-extensions/lib/Gedmo/Tree/Entity/Repository/AbstractTreeRepository.php';
            include_once \dirname(__DIR__, 5).'/vendor/gedmo/doctrine-extensions/lib/Gedmo/Tree/Entity/Repository/NestedTreeRepository.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Entity/CollectionRepositoryInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Security/Authorization/AccessControl/DescendantProviderInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Security/Authorization/AccessControl/SecuredEntityRepositoryTrait.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Entity/CollectionRepository.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/FormatCache/FormatCacheInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/FormatCache/LocalFormatCache.php';
            include_once \dirname(__DIR__, 5).'/vendor/imagine/imagine/src/Factory/ClassFactoryAwareInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/imagine/imagine/src/Image/ImagineInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/imagine/imagine/src/Image/AbstractImagine.php';
            include_once \dirname(__DIR__, 5).'/vendor/imagine/imagine/src/Imagick/Imagine.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/ImageConverter/Transformation/TransformationInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/ImageConverter/Transformation/CropTransformation.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/ImageConverter/Transformation/PasteTransformation.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/ImageConverter/Transformation/BlurTransformation.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/ImageConverter/Transformation/GammaTransformation.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/ImageConverter/Transformation/GrayscaleTransformation.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/ImageConverter/Transformation/NegativeTransformation.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/ImageConverter/Transformation/SharpenTransformation.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/Manager/MediaManagerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/Manager/MediaManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/FileValidator/FileValidatorInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/FileValidator/FileValidator.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/TypeManager/TypeManagerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/TypeManager/TypeManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/FormatManager/FormatManagerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/FormatManager/FormatManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/ImageConverter/ImageConverterInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/ImageConverter/ImagineImageConverter.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/ImageConverter/MediaImageExtractorInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/ImageConverter/MediaImageExtractor.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/Video/VideoThumbnailServiceInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/Video/VideoThumbnailService.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/ImageConverter/TransformationPoolInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/ImageConverter/TransformationPool.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/ImageConverter/Focus/FocusInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/ImageConverter/Focus/Focus.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/ImageConverter/Scaler/ScalerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/ImageConverter/Scaler/Scaler.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/ImageConverter/Cropper/CropperInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/ImageConverter/Cropper/Cropper.php';
            include_once \dirname(__DIR__, 5).'/vendor/contao/imagine-svg/src/Imagine.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Security/Authorization/MaskConverterInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Security/Authorization/MaskConverter.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Security/Authentication/SaltGenerator.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Security/Authorization/AccessControl/AccessControlManagerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Security/Authorization/AccessControl/AccessControlManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Security/Authorization/AccessControl/AccessControlProviderInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Security/Authorization/AccessControl/PhpcrAccessControlProvider.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Security/Authorization/AccessControl/DoctrineAccessControlProvider.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SecurityBundle/System/SystemStoreInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SecurityBundle/System/SystemStore.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SecurityBundle/EventListener/SystemListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SecurityBundle/AccessControl/AccessControlQueryEnhancer.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CategoryBundle/Category/CategoryManagerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CategoryBundle/Category/CategoryManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Category/Request/CategoryRequestHandlerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Category/Request/CategoryRequestHandler.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CategoryBundle/Category/KeywordManagerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CategoryBundle/Category/KeywordManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SnippetBundle/Snippet/DefaultSnippetManagerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SnippetBundle/Snippet/DefaultSnippetManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Webspace/Settings/SettingsManagerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Webspace/Settings/SettingsManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/DocumentManagerBundle/Session/SessionManagerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/DocumentManagerBundle/Session/SessionManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SnippetBundle/Snippet/SnippetResolverInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SnippetBundle/Snippet/SnippetResolver.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Repository/ContentRepositoryInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Repository/ContentRepository.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Metadata/Factory/StructureMetadataFactoryInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Metadata/Factory/StructureMetadataFactory.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Metadata/XmlParserTrait.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Metadata/Loader/AbstractLoader.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Metadata/Loader/StructureXmlLoader.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/HttpCacheBundle/CacheLifetime/CacheLifetimeResolverInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/HttpCacheBundle/CacheLifetime/CacheLifetimeResolver.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Metadata/Parser/PropertiesXmlParser.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Metadata/Parser/SchemaXmlParser.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Extension/ExtensionManagerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Extension/ExtensionManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Extension/ExtensionInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Extension/AbstractExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Extension/ExportExtensionInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/PageBundle/Content/Structure/SeoStructureExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/PageBundle/Content/Structure/ExcerptStructureExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Compat/Structure/LegacyPropertyFactory.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Export/Manager/ExportManagerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Export/Manager/ExportManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Import/Manager/ImportManagerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Import/Manager/ImportManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/TagBundle/Tag/TagManagerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/TagBundle/Tag/TagManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Tag/Request/TagRequestHandlerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Tag/Request/TagRequestHandler.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Resolver/StructureResolverInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Resolver/StructureResolver.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Routing/RequestListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/EventListener/RouterListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/EventListener/RouterListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/EventListener/TranslatorListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Entity/AnalyticsRepository.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/EventListener/AppendAnalyticsListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/EventSubscriber/GeneratorEventSubscriber.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/EventListener/SegmentSubscriber.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/DocumentManager/DocumentManagerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/DocumentManager/DocumentManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/DocumentManager/DocumentRegistry.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/DocumentManager/NodeManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/DocumentManager/MetadataFactoryInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/DocumentManager/Metadata/BaseMetadataFactory.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/DocumentManager/Metadata/MetadataFactory.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/DocumentManager/NamespaceRegistry.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/DocumentManager/PropertyEncoder.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/DocumentManagerBundle/Bridge/PropertyEncoder.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/DocumentManager/PathSegmentRegistry.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/DocumentManager/PathBuilder.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/DocumentManager/DocumentInspector.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/DocumentManagerBundle/Bridge/DocumentInspector.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/DocumentManager/ProxyFactory.php';
            include_once \dirname(__DIR__, 5).'/vendor/ocramius/proxy-manager/src/ProxyManager/Factory/AbstractBaseFactory.php';
            include_once \dirname(__DIR__, 5).'/vendor/ocramius/proxy-manager/src/ProxyManager/Factory/LazyLoadingGhostFactory.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/CustomUrl/Manager/CustomUrlManagerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/CustomUrl/Manager/CustomUrlManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/CustomUrl/Repository/CustomUrlRepository.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/CustomUrl/Generator/GeneratorInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/CustomUrl/Generator/Generator.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MarkupBundle/Markup/TagExtractorInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MarkupBundle/Markup/HtmlTagExtractor.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MarkupBundle/Markup/MarkupParserInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MarkupBundle/Markup/HtmlMarkupParser.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MarkupBundle/Tag/TagRegistryInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MarkupBundle/Tag/TagRegistry.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MarkupBundle/Tag/TagInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MarkupBundle/Markup/LinkTag.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MarkupBundle/Markup/Link/LinkProviderPoolInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MarkupBundle/Markup/Link/LinkProviderPool.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MarkupBundle/Markup/Link/LinkProviderInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Markup/Link/MediaLinkProvider.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/PageBundle/Markup/Link/PageLinkProvider.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MarkupBundle/Markup/DelegatingTagExtractor.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MarkupBundle/Listener/MarkupListener.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/var-dumper/Cloner/ClonerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/var-dumper/Cloner/AbstractCloner.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/var-dumper/Cloner/VarCloner.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/var-dumper/Dumper/DataDumperInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/var-dumper/Cloner/DumperInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/var-dumper/Dumper/AbstractDumper.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/var-dumper/Dumper/CliDumper.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/var-dumper/Dumper/HtmlDumper.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/AdminBundle/UserManager/UserManagerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SecurityBundle/UserManager/UserManager.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SecurityBundle/Entity/GroupRepository.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/translation-contracts/TranslatorInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/translation/TranslatorBagInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/translation/Translator.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-kernel/CacheWarmer/WarmableInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/framework-bundle/Translation/Translator.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/translation/Formatter/MessageFormatterInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/translation/Formatter/IntlFormatterInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/translation/Formatter/MessageFormatter.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/translation-contracts/TranslatorTrait.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/translation/IdentityTranslator.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/routing/RequestContextAwareInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/routing/Matcher/UrlMatcherInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/routing/Generator/UrlGeneratorInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/routing/RouterInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/routing/Matcher/RequestMatcherInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony-cmf/routing/src/ChainRouterInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony-cmf/routing/src/ChainRouter.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/routing/Router.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/service-contracts/ServiceSubscriberInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/framework-bundle/Routing/Router.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony-cmf/routing/src/VersatileGeneratorInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony-cmf/routing/src/ChainedRouterInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony-cmf/routing/src/Enhancer/RouteEnhancerTrait.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony-cmf/routing/src/DynamicRouter.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony-cmf/routing-bundle/src/Routing/DynamicRouter.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony-cmf/routing/src/NestedMatcher/NestedMatcher.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/routing/Matcher/UrlMatcher.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony-cmf/routing/src/NestedMatcher/FinalMatcherInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony-cmf/routing/src/NestedMatcher/UrlMatcher.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/routing/RouteCollection.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/routing/Generator/ConfigurableRequirementsInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/routing/Generator/UrlGenerator.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony-cmf/routing/src/ProviderBasedGenerator.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony-cmf/routing/src/ContentAwareGenerator.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony-cmf/routing/src/Enhancer/RouteEnhancerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony-cmf/routing/src/Enhancer/RouteContentEnhancer.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony-cmf/routing/src/RouteProviderInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/CustomUrl/Routing/CustomUrlRouteProvider.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/CustomUrl/Routing/Enhancers/AbstractEnhancer.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/CustomUrl/Routing/Enhancers/TrailingSlashEnhancer.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/CustomUrl/Routing/Enhancers/TrailingHTMLEnhancer.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/CustomUrl/Routing/Enhancers/RedirectEnhancer.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/CustomUrl/Routing/Enhancers/SeoEnhancer.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/CustomUrl/Routing/Enhancers/ContentEnhancer.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/CustomUrl/Routing/Enhancers/InternalLinkEnhancer.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/CustomUrl/Routing/Enhancers/StructureEnhancer.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/CustomUrl/Routing/Enhancers/ExternalLinkEnhancer.php';
            include_once \dirname(__DIR__, 5).'/vendor/phpcr/phpcr/src/PHPCR/SessionInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/DocumentManagerBundle/Session/Session.php';
            include_once \dirname(__DIR__, 5).'/vendor/jackalope/jackalope/src/Jackalope/Session.php';
            include_once \dirname(__DIR__, 5).'/vendor/phpcr/phpcr/src/PHPCR/RepositoryInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/jackalope/jackalope/src/Jackalope/Repository.php';
            include_once \dirname(__DIR__, 5).'/vendor/phpcr/phpcr/src/PHPCR/CredentialsInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/phpcr/phpcr/src/PHPCR/SimpleCredentials.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/ContextFactory/SerializationContextFactoryInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/ContextFactory/DeserializationContextFactoryInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer-bundle/ContextFactory/ConfiguredContextFactory.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/SerializerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/ArrayTransformerInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/Serializer.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/metadata/src/MetadataFactoryInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/metadata/src/AdvancedMetadataFactoryInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/metadata/src/MetadataFactory.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/metadata/src/Driver/DriverInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/metadata/src/Driver/LazyLoadingDriver.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/metadata/src/Cache/CacheInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/metadata/src/Cache/FileCache.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/GraphNavigator/Factory/GraphNavigatorFactoryInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/GraphNavigator/Factory/DeserializationGraphNavigatorFactory.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/Construction/ObjectConstructorInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/Construction/UnserializeObjectConstructor.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/Accessor/AccessorStrategyInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/Accessor/DefaultAccessorStrategy.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/Expression/CompilableExpressionEvaluatorInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/Expression/ExpressionEvaluatorInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/Expression/ExpressionEvaluator.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/expression-language/ExpressionLanguage.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer-bundle/ExpressionLanguage/BasicSerializerFunctionsProvider.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/EventDispatcher/EventDispatcherInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/EventDispatcher/EventDispatcher.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/EventDispatcher/LazyEventDispatcher.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/GraphNavigator/Factory/SerializationGraphNavigatorFactory.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/Visitor/Factory/SerializationVisitorFactory.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/Visitor/Factory/JsonSerializationVisitorFactory.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/Visitor/Factory/XmlSerializationVisitorFactory.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/Visitor/Factory/DeserializationVisitorFactory.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/Visitor/Factory/JsonDeserializationVisitorFactory.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/Visitor/Factory/XmlDeserializationVisitorFactory.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/Storage/StorageInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Media/Storage/LocalStorage.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/filesystem/Filesystem.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Routing/ContentRouteProvider.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/form/FormFactoryInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/form/FormFactory.php';
            include_once \dirname(__DIR__, 5).'/vendor/twig/twig/src/Cache/CacheInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/twig/twig/src/Cache/FilesystemCache.php';
            include_once \dirname(__DIR__, 5).'/vendor/twig/twig/src/Extension/ExtensionInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/twig/twig/src/Extension/AbstractExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/twig/twig/src/Extension/CoreExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/twig/twig/src/Extension/EscaperExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/twig/twig/src/Extension/OptimizerExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/twig/twig/src/Extension/StagingExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/twig/twig/src/ExtensionSet.php';
            include_once \dirname(__DIR__, 5).'/vendor/twig/twig/src/Template.php';
            include_once \dirname(__DIR__, 5).'/vendor/twig/twig/src/TemplateWrapper.php';
            include_once \dirname(__DIR__, 5).'/vendor/twig/twig/src/Environment.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/twig-bridge/Extension/CsrfExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/twig/twig/src/Extension/ProfilerExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/twig-bridge/Extension/ProfilerExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/twig/twig/src/Profiler/Profile.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/twig-bridge/Extension/TranslationExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/twig-bridge/Extension/AssetExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/asset/Packages.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/asset/PackageInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/asset/Package.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/asset/PathPackage.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/asset/VersionStrategy/VersionStrategyInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/asset/VersionStrategy/EmptyVersionStrategy.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/asset/Context/ContextInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/asset/Context/RequestStackContext.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/twig-bridge/Extension/CodeExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/twig-bridge/Extension/RoutingExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/twig-bridge/Extension/YamlExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/twig-bridge/Extension/ExpressionExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/twig-bridge/Extension/HttpKernelExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/twig-bridge/Extension/HttpFoundationExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/http-foundation/UrlHelper.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/twig-bridge/Extension/FormExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/twig-bridge/Extension/DumpExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/doctrine-bundle/Twig/DoctrineExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/Twig/SerializerRuntimeExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache-bundle/src/Twig/CacheTagExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/ContactBundle/Twig/ContactTwigExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/cache/lib/Doctrine/Common/Cache/Cache.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/cache/lib/Doctrine/Common/Cache/FlushableCache.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/cache/lib/Doctrine/Common/Cache/ClearableCache.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/cache/lib/Doctrine/Common/Cache/MultiGetCache.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/cache/lib/Doctrine/Common/Cache/MultiDeleteCache.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/cache/lib/Doctrine/Common/Cache/MultiPutCache.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/cache/lib/Doctrine/Common/Cache/MultiOperationCache.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/cache/lib/Doctrine/Common/Cache/CacheProvider.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/cache/lib/Doctrine/Common/Cache/ArrayCache.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Twig/DispositionTypeTwigExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Twig/MediaTwigExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SecurityBundle/Twig/UserTwigExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CategoryBundle/Twig/CategoryTwigExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Cache/MemoizeInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Cache/Memoize.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Cache/MemoizeTwigExtensionTrait.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SnippetBundle/Twig/MemoizedSnippetTwigExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SnippetBundle/Twig/SnippetTwigExtensionInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SnippetBundle/Twig/SnippetTwigExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SnippetBundle/Twig/DefaultSnippetTwigExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SnippetBundle/Twig/SnippetAreaTwigExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/PageBundle/Twig/ExportTwigExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/TagBundle/Twig/TagTwigExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Twig/Content/ContentPathInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Twig/Content/ContentPathTwigExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Twig/Navigation/MemoizedNavigationTwigExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Twig/Navigation/NavigationTwigExtensionInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Twig/Navigation/NavigationTwigExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Navigation/NavigationMapperInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Navigation/NavigationMapper.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Query/ContentQueryBuilderInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Content/Query/ContentQueryBuilder.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Navigation/NavigationQueryBuilder.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Twig/Sitemap/MemoizedSitemapTwigExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Twig/Sitemap/SitemapTwigExtensionInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Twig/Sitemap/SitemapTwigExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Sitemap/SitemapGeneratorInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Sitemap/SitemapGenerator.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Sitemap/SitemapContentQueryBuilder.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Twig/Content/MemoizedContentTwigExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Twig/Content/ContentTwigExtensionInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Twig/Content/ContentTwigExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Twig/Meta/MetaTwigExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Twig/Seo/SeoTwigExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Twig/Core/UtilTwigExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/web-profiler-bundle/Twig/WebProfilerExtension.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/twig-bridge/AppVariable.php';
            include_once \dirname(__DIR__, 5).'/vendor/twig/twig/src/RuntimeLoader/RuntimeLoaderInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/twig/twig/src/RuntimeLoader/ContainerRuntimeLoader.php';
            include_once \dirname(__DIR__, 5).'/vendor/symfony/twig-bundle/DependencyInjection/Configurator/EnvironmentConfigurator.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/Handler/HandlerRegistryInterface.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/Handler/HandlerRegistry.php';
            include_once \dirname(__DIR__, 5).'/vendor/jms/serializer/src/Handler/LazyHandlerRegistry.php';
            include_once \dirname(__DIR__, 5).'/vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/CachedReader.php';
        };
    }

    public function compile(): void
    {
        throw new LogicException('You cannot compile a dumped container that was already compiled.');
    }

    public function isCompiled(): bool
    {
        return true;
    }

    public function getRemovedIds(): array
    {
        return require $this->containerDir.\DIRECTORY_SEPARATOR.'removed-ids.php';
    }

    protected function load($file, $lazyLoad = true)
    {
        if (class_exists($class = __NAMESPACE__.'\\'.$file, false)) {
            return $class::do($this, $lazyLoad);
        }

        if ('.' === $file[-4]) {
            $class = substr($class, 0, -4);
        } else {
            $file .= '.php';
        }

        $service = require $this->containerDir.\DIRECTORY_SEPARATOR.$file;

        return class_exists($class, false) ? $class::do($this, $lazyLoad) : $service;
    }

    protected function createProxy($class, \Closure $factory)
    {
        class_exists($class, false) || require __DIR__.'/'.$class.'.php';

        return $factory();
    }

    /**
     * Gets the public '.container.private.filesystem' shared service.
     *
     * @return \Symfony\Component\Filesystem\Filesystem
     */
    protected function get_Container_Private_FilesystemService()
    {
        return $this->services['.container.private.filesystem'] = new \Symfony\Component\Filesystem\Filesystem();
    }

    /**
     * Gets the public '.container.private.form.factory' shared service.
     *
     * @return \Symfony\Component\Form\FormFactory
     */
    protected function get_Container_Private_Form_FactoryService()
    {
        return $this->services['.container.private.form.factory'] = new \Symfony\Component\Form\FormFactory(($this->privates['form.registry'] ?? $this->getForm_RegistryService()));
    }

    /**
     * Gets the public '.container.private.twig' shared service.
     *
     * @return \Twig\Environment
     */
    protected function get_Container_Private_TwigService()
    {
        $this->services['.container.private.twig'] = $instance = new \Twig\Environment(($this->privates['twig.loader.native_filesystem'] ?? $this->getTwig_Loader_NativeFilesystemService()), ['autoescape' => 'name', 'cache' => ($this->targetDir.''.'/twig'), 'charset' => 'UTF-8', 'debug' => true, 'strict_variables' => true]);

        $a = ($this->services['translator'] ?? $this->getTranslatorService());
        $b = ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack()));
        $c = ($this->privates['router.request_context'] ?? $this->getRouter_RequestContextService());
        $d = ($this->privates['debug.file_link_formatter'] ?? $this->getDebug_FileLinkFormatterService());
        $e = ($this->services['sulu_core.array_serializer'] ?? $this->getSuluCore_ArraySerializerService());
        $f = new \Sulu\Component\Cache\Memoize(new \Doctrine\Common\Cache\ArrayCache(), 1);
        $g = ($this->services['sulu.content.mapper'] ?? $this->getSulu_Content_MapperService());
        $h = ($this->services['sulu_core.webspace.request_analyzer'] ?? $this->getSuluCore_Webspace_RequestAnalyzerService());
        $i = ($this->services['sulu_website.resolver.structure'] ?? $this->getSuluWebsite_Resolver_StructureService());
        $j = ($this->services['sulu_snippet.default_snippet.manager'] ?? $this->getSuluSnippet_DefaultSnippet_ManagerService());
        $k = ($this->services['sulu_snippet.resolver'] ?? $this->getSuluSnippet_ResolverService());
        $l = ($this->services['sulu_core.webspace.webspace_manager'] ?? $this->getSuluCore_Webspace_WebspaceManagerService());

        $m = new \Sulu\Bundle\WebsiteBundle\Twig\Content\ContentPathTwigExtension($l, 'dev', $h);
        $n = ($this->privates['sulu.content.query_executor'] ?? $this->getSulu_Content_QueryExecutorService());
        $o = ($this->services['sulu.content.structure_manager'] ?? $this->getSulu_Content_StructureManagerService());
        $p = ($this->services['sulu_page.extension.manager'] ?? $this->getSuluPage_Extension_ManagerService());
        $q = ($this->services['sulu.phpcr.session'] ?? $this->getSulu_Phpcr_SessionService());
        $r = new \Symfony\Component\VarDumper\Dumper\HtmlDumper(NULL, 'UTF-8', 1);
        $r->setDisplayOptions(['maxStringLength' => 4096, 'fileLinkFormat' => $d]);
        $s = new \Symfony\Bridge\Twig\AppVariable();
        $s->setEnvironment('dev');
        $s->setDebug(true);
        if ($this->has('request_stack')) {
            $s->setRequestStack($b);
        }

        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\CsrfExtension());
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\ProfilerExtension(new \Twig\Profiler\Profile(), NULL));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\TranslationExtension($a));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\AssetExtension(new \Symfony\Component\Asset\Packages(new \Symfony\Component\Asset\PathPackage('', new \Symfony\Component\Asset\VersionStrategy\EmptyVersionStrategy(), new \Symfony\Component\Asset\Context\RequestStackContext($b, $c->getBaseUrl(), $c->isSecure())), [])));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\CodeExtension($d, \dirname(__DIR__, 5), 'UTF-8'));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\RoutingExtension(($this->services['router'] ?? $this->getRouterService())));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\YamlExtension());
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\ExpressionExtension());
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\HttpKernelExtension());
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\HttpFoundationExtension(new \Symfony\Component\HttpFoundation\UrlHelper($b, $c)));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\FormExtension($a));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\DumpExtension(($this->services['var_dumper.cloner'] ?? $this->getVarDumper_ClonerService()), ($this->privates['var_dumper.html_dumper'] ?? $this->getVarDumper_HtmlDumperService())));
        $instance->addExtension(new \Doctrine\Bundle\DoctrineBundle\Twig\DoctrineExtension());
        $instance->addExtension(new \JMS\Serializer\Twig\SerializerRuntimeExtension());
        $instance->addExtension(new \FOS\HttpCacheBundle\Twig\CacheTagExtension(($this->services['fos_http_cache.http.symfony_response_tagger'] ?? $this->getFosHttpCache_Http_SymfonyResponseTaggerService())));
        $instance->addExtension(new \Sulu\Bundle\ContactBundle\Twig\ContactTwigExtension(new \Doctrine\Common\Cache\ArrayCache(), ($this->services['sulu.repository.contact'] ?? $this->getSulu_Repository_ContactService())));
        $instance->addExtension(new \Sulu\Bundle\MediaBundle\Twig\DispositionTypeTwigExtension());
        $instance->addExtension(new \Sulu\Bundle\MediaBundle\Twig\MediaTwigExtension(($this->services['sulu_media.media_manager'] ?? $this->getSuluMedia_MediaManagerService())));
        $instance->addExtension(new \Sulu\Bundle\SecurityBundle\Twig\UserTwigExtension(new \Doctrine\Common\Cache\ArrayCache(), ($this->services['sulu.repository.user'] ?? $this->getSulu_Repository_UserService())));
        $instance->addExtension(new \Sulu\Bundle\CategoryBundle\Twig\CategoryTwigExtension(($this->services['sulu_category.category_manager'] ?? $this->getSuluCategory_CategoryManagerService()), ($this->privates['sulu_category.category_request_handler'] ?? $this->getSuluCategory_CategoryRequestHandlerService()), $e, $f));
        $instance->addExtension(new \Sulu\Bundle\SnippetBundle\Twig\MemoizedSnippetTwigExtension(new \Sulu\Bundle\SnippetBundle\Twig\SnippetTwigExtension($g, $h, $i), $f, 1));
        $instance->addExtension(new \Sulu\Bundle\SnippetBundle\Twig\DefaultSnippetTwigExtension($j, $h, $k));
        $instance->addExtension(new \Sulu\Bundle\SnippetBundle\Twig\SnippetAreaTwigExtension($j, $h, $k));
        $instance->addExtension(new \Sulu\Bundle\PageBundle\Twig\ExportTwigExtension(($this->privates['sulu_page.export.manager'] ?? $this->getSuluPage_Export_ManagerService())));
        $instance->addExtension(new \Sulu\Bundle\TagBundle\Twig\TagTwigExtension(($this->services['sulu_tag.tag_manager'] ?? $this->getSuluTag_TagManagerService()), ($this->privates['sulu_tag.tag_request_handler'] ?? $this->getSuluTag_TagRequestHandlerService()), $e, $f));
        $instance->addExtension($m);
        $instance->addExtension(new \Sulu\Bundle\WebsiteBundle\Twig\Navigation\MemoizedNavigationTwigExtension(new \Sulu\Bundle\WebsiteBundle\Twig\Navigation\NavigationTwigExtension($g, new \Sulu\Bundle\WebsiteBundle\Navigation\NavigationMapper($g, $n, new \Sulu\Bundle\WebsiteBundle\Navigation\NavigationQueryBuilder($o, $p, 'i18n'), $q, NULL, $this->parameters['sulu_security.permissions']), $h), $f, 1));
        $instance->addExtension(new \Sulu\Bundle\WebsiteBundle\Twig\Sitemap\MemoizedSitemapTwigExtension(new \Sulu\Bundle\WebsiteBundle\Twig\Sitemap\SitemapTwigExtension(new \Sulu\Bundle\WebsiteBundle\Sitemap\SitemapGenerator($n, $l, new \Sulu\Bundle\WebsiteBundle\Sitemap\SitemapContentQueryBuilder($o, $p, 'i18n'), 'dev'), $l, 'dev', $h), $f, 1));
        $instance->addExtension(new \Sulu\Bundle\WebsiteBundle\Twig\Content\MemoizedContentTwigExtension(new \Sulu\Bundle\WebsiteBundle\Twig\Content\ContentTwigExtension($g, $i, $q, $h, ($this->privates['monolog.logger'] ?? $this->getMonolog_LoggerService()), NULL, $l), $f, 1));
        $instance->addExtension(new \Sulu\Bundle\WebsiteBundle\Twig\Meta\MetaTwigExtension($h, $m));
        $instance->addExtension(new \Sulu\Bundle\WebsiteBundle\Twig\Seo\SeoTwigExtension($h, $m, $b));
        $instance->addExtension(new \Sulu\Bundle\WebsiteBundle\Twig\Core\UtilTwigExtension());
        $instance->addExtension(new \Symfony\Bundle\WebProfilerBundle\Twig\WebProfilerExtension($r));
        $instance->addGlobal('app', $s);
        $instance->addRuntimeLoader(new \Twig\RuntimeLoader\ContainerRuntimeLoader(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'JMS\\Serializer\\Twig\\SerializerRuntimeHelper' => ['services', 'jms_serializer.twig_extension.serializer_runtime_helper', 'getJmsSerializer_TwigExtension_SerializerRuntimeHelperService', true],
            'Symfony\\Bridge\\Twig\\Extension\\CsrfRuntime' => ['privates', 'twig.runtime.security_csrf', 'getTwig_Runtime_SecurityCsrfService', true],
            'Symfony\\Bridge\\Twig\\Extension\\HttpKernelRuntime' => ['privates', 'twig.runtime.httpkernel', 'getTwig_Runtime_HttpkernelService', true],
            'Symfony\\Component\\Form\\FormRenderer' => ['privates', 'twig.form.renderer', 'getTwig_Form_RendererService', true],
        ], [
            'JMS\\Serializer\\Twig\\SerializerRuntimeHelper' => '?',
            'Symfony\\Bridge\\Twig\\Extension\\CsrfRuntime' => '?',
            'Symfony\\Bridge\\Twig\\Extension\\HttpKernelRuntime' => '?',
            'Symfony\\Component\\Form\\FormRenderer' => '?',
        ])));
        (new \Symfony\Bundle\TwigBundle\DependencyInjection\Configurator\EnvironmentConfigurator('F j, Y H:i', '%d days', NULL, 0, '.', ','))->configure($instance);

        return $instance;
    }

    /**
     * Gets the public 'cmf_routing.route_provider' shared service.
     *
     * @return \Sulu\Bundle\WebsiteBundle\Routing\ContentRouteProvider
     */
    protected function getCmfRouting_RouteProviderService()
    {
        return $this->services['cmf_routing.route_provider'] = new \Sulu\Bundle\WebsiteBundle\Routing\ContentRouteProvider(($this->services['sulu_document_manager.document_manager'] ?? $this->getSuluDocumentManager_DocumentManagerService()), ($this->services['sulu_document_manager.document_inspector'] ?? $this->getSuluDocumentManager_DocumentInspectorService()), ($this->privates['sulu.content.resource_locator.strategy_pool'] ?? $this->getSulu_Content_ResourceLocator_StrategyPoolService()), ($this->services['sulu.content.structure_manager'] ?? $this->getSulu_Content_StructureManagerService()), ($this->services['sulu_core.webspace.webspace_manager'] ?? $this->getSuluCore_Webspace_WebspaceManagerService()), ($this->services['sulu_core.webspace.request_analyzer'] ?? $this->getSuluCore_Webspace_RequestAnalyzerService()), NULL, ['utf8' => true]);
    }

    /**
     * Gets the public 'doctrine' shared service.
     *
     * @return \Doctrine\Bundle\DoctrineBundle\Registry
     */
    protected function getDoctrineService()
    {
        return $this->services['doctrine'] = new \Doctrine\Bundle\DoctrineBundle\Registry($this, $this->parameters['doctrine.connections'], $this->parameters['doctrine.entity_managers'], 'default', 'default');
    }

    /**
     * Gets the public 'doctrine.dbal.default_connection' shared service.
     *
     * @return \Doctrine\DBAL\Connection
     */
    protected function getDoctrine_Dbal_DefaultConnectionService()
    {
        $a = ($this->privates['sulu_security.access_control_manager'] ?? $this->getSuluSecurity_AccessControlManagerService());

        if (isset($this->services['doctrine.dbal.default_connection'])) {
            return $this->services['doctrine.dbal.default_connection'];
        }
        $b = new \Doctrine\DBAL\Configuration();

        $c = new \Symfony\Bridge\Monolog\Logger('doctrine');
        $c->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));

        $b->setSQLLogger(new \Doctrine\DBAL\Logging\LoggerChain([0 => new \Symfony\Bridge\Doctrine\Logger\DbalLogger($c, NULL), 1 => new \Doctrine\DBAL\Logging\DebugStack()]));
        $d = new \Symfony\Bridge\Doctrine\ContainerAwareEventManager(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'doctrine.orm.default_listeners.attach_entity_listeners' => ['privates', 'doctrine.orm.default_listeners.attach_entity_listeners', 'getDoctrine_Orm_DefaultListeners_AttachEntityListenersService', true],
            'doctrine_phpcr.jackalope_doctrine_dbal.schema_listener' => ['privates', 'doctrine_phpcr.jackalope_doctrine_dbal.schema_listener', 'getDoctrinePhpcr_JackalopeDoctrineDbal_SchemaListenerService', true],
            'sulu_contact.account_listener' => ['privates', 'sulu_contact.account_listener', 'getSuluContact_AccountListenerService', true],
            'sulu_contact.doctrine.invalidation_listener' => ['privates', 'sulu_contact.doctrine.invalidation_listener', 'getSuluContact_Doctrine_InvalidationListenerService', true],
            'sulu_media.doctrine.invalidation_listener' => ['privates', 'sulu_media.doctrine.invalidation_listener', 'getSuluMedia_Doctrine_InvalidationListenerService', true],
        ], [
            'doctrine.orm.default_listeners.attach_entity_listeners' => '?',
            'doctrine_phpcr.jackalope_doctrine_dbal.schema_listener' => '?',
            'sulu_contact.account_listener' => '?',
            'sulu_contact.doctrine.invalidation_listener' => '?',
            'sulu_media.doctrine.invalidation_listener' => '?',
        ]));

        $e = new \Doctrine\ORM\Tools\ResolveTargetEntityListener();
        $e->addResolveTargetEntity('Sulu\\Bundle\\MediaBundle\\Entity\\CollectionInterface', 'Sulu\\Bundle\\MediaBundle\\Entity\\Collection', []);
        $e->addResolveTargetEntity('Sulu\\Bundle\\ContactBundle\\Entity\\AccountInterface', 'Sulu\\Bundle\\ContactBundle\\Entity\\Account', []);
        $e->addResolveTargetEntity('Sulu\\Bundle\\ContactBundle\\Entity\\ContactInterface', 'Sulu\\Bundle\\ContactBundle\\Entity\\Contact', []);
        $e->addResolveTargetEntity('Sulu\\Bundle\\ContactBundle\\Entity\\AccountInterface', 'Sulu\\Bundle\\ContactBundle\\Entity\\Account', []);
        $e->addResolveTargetEntity('Sulu\\Bundle\\MediaBundle\\Entity\\MediaInterface', 'Sulu\\Bundle\\MediaBundle\\Entity\\Media', []);
        $e->addResolveTargetEntity('Sulu\\Component\\Security\\Authentication\\UserInterface', 'Sulu\\Bundle\\SecurityBundle\\Entity\\User', []);
        $e->addResolveTargetEntity('Sulu\\Component\\Security\\Authentication\\RoleInterface', 'Sulu\\Bundle\\SecurityBundle\\Entity\\Role', []);
        $e->addResolveTargetEntity('Sulu\\Component\\Security\\Authentication\\RoleSettingInterface', 'Sulu\\Bundle\\SecurityBundle\\Entity\\RoleSetting', []);
        $e->addResolveTargetEntity('Sulu\\Component\\Security\\Authorization\\AccessControl\\AccessControlInterface', 'Sulu\\Bundle\\SecurityBundle\\Entity\\AccessControl', []);
        $e->addResolveTargetEntity('Sulu\\Bundle\\CategoryBundle\\Entity\\CategoryInterface', 'Sulu\\Bundle\\CategoryBundle\\Entity\\Category', []);
        $e->addResolveTargetEntity('Sulu\\Bundle\\CategoryBundle\\Entity\\CategoryMetaInterface', 'Sulu\\Bundle\\CategoryBundle\\Entity\\CategoryMeta', []);
        $e->addResolveTargetEntity('Sulu\\Bundle\\CategoryBundle\\Entity\\CategoryTranslationInterface', 'Sulu\\Bundle\\CategoryBundle\\Entity\\CategoryTranslation', []);
        $e->addResolveTargetEntity('Sulu\\Bundle\\CategoryBundle\\Entity\\KeywordInterface', 'Sulu\\Bundle\\CategoryBundle\\Entity\\Keyword', []);
        $e->addResolveTargetEntity('Sulu\\Bundle\\TagBundle\\Tag\\TagInterface', 'Sulu\\Bundle\\TagBundle\\Entity\\Tag', []);
        $e->addResolveTargetEntity('Sulu\\Bundle\\RouteBundle\\Model\\RouteInterface', 'Sulu\\Bundle\\RouteBundle\\Entity\\Route', []);
        $f = new \Gedmo\Tree\TreeListener();
        $f->setAnnotationReader(($this->privates['annotations.cached_reader'] ?? $this->getAnnotations_CachedReaderService()));

        $d->addEventSubscriber(new \Sulu\Component\Persistence\EventSubscriber\ORM\MetadataSubscriber($this->parameters['sulu.persistence.objects']));
        $d->addEventSubscriber(new \Sulu\Component\Doctrine\ReferencesOption(($this->services['doctrine'] ?? $this->getDoctrineService()), ['Sulu\\Bundle\\ContactBundle\\Entity\\ContactInterface' => 'Sulu\\Bundle\\ContactBundle\\Entity\\Contact', 'Sulu\\Bundle\\ContactBundle\\Entity\\AccountInterface' => 'Sulu\\Bundle\\ContactBundle\\Entity\\Account', 'Sulu\\Bundle\\MediaBundle\\Entity\\MediaInterface' => 'Sulu\\Bundle\\MediaBundle\\Entity\\Media', 'Sulu\\Component\\Security\\Authentication\\UserInterface' => 'Sulu\\Bundle\\SecurityBundle\\Entity\\User', 'Sulu\\Component\\Security\\Authentication\\RoleInterface' => 'Sulu\\Bundle\\SecurityBundle\\Entity\\Role', 'Sulu\\Component\\Security\\Authentication\\RoleSettingInterface' => 'Sulu\\Bundle\\SecurityBundle\\Entity\\RoleSetting', 'Sulu\\Component\\Security\\Authorization\\AccessControl\\AccessControlInterface' => 'Sulu\\Bundle\\SecurityBundle\\Entity\\AccessControl', 'Sulu\\Bundle\\CategoryBundle\\Entity\\CategoryInterface' => 'Sulu\\Bundle\\CategoryBundle\\Entity\\Category', 'Sulu\\Bundle\\CategoryBundle\\Entity\\CategoryMetaInterface' => 'Sulu\\Bundle\\CategoryBundle\\Entity\\CategoryMeta', 'Sulu\\Bundle\\CategoryBundle\\Entity\\CategoryTranslationInterface' => 'Sulu\\Bundle\\CategoryBundle\\Entity\\CategoryTranslation', 'Sulu\\Bundle\\CategoryBundle\\Entity\\KeywordInterface' => 'Sulu\\Bundle\\CategoryBundle\\Entity\\Keyword', 'Sulu\\Bundle\\TagBundle\\Tag\\TagInterface' => 'Sulu\\Bundle\\TagBundle\\Entity\\Tag', 'Sulu\\Bundle\\RouteBundle\\Model\\RouteInterface' => 'Sulu\\Bundle\\RouteBundle\\Entity\\Route']));
        $d->addEventSubscriber($e);
        $d->addEventSubscriber(new \Symfony\Bridge\Doctrine\SchemaListener\PdoCacheAdapterDoctrineSchemaSubscriber([]));
        $d->addEventSubscriber(new \Massive\Bundle\SearchBundle\Search\EventSubscriber\DoctrineOrmSubscriber(($this->services['event_dispatcher'] ?? $this->getEventDispatcherService())));
        $d->addEventSubscriber(new \Sulu\Component\Persistence\EventSubscriber\ORM\TimestampableSubscriber());
        $d->addEventSubscriber(new \Sulu\Component\Persistence\EventSubscriber\ORM\UserBlameSubscriber(NULL, 'Sulu\\Bundle\\SecurityBundle\\Entity\\User'));
        $d->addEventSubscriber(new \Sulu\Bundle\SecurityBundle\EventListener\PermissionInheritanceSubscriber($a));
        $d->addEventSubscriber(new \Symfony\Cmf\Bundle\RoutingBundle\Doctrine\RouteConditionMetadataListener());
        $d->addEventSubscriber($f);
        $d->addEventListener([0 => 'loadClassMetadata'], 'doctrine.orm.default_listeners.attach_entity_listeners');
        $d->addEventListener([0 => 'postGenerateSchema'], 'doctrine_phpcr.jackalope_doctrine_dbal.schema_listener');
        $d->addEventListener([0 => 'postPersist'], 'sulu_contact.account_listener');
        $d->addEventListener([0 => 'postPersist'], 'sulu_contact.doctrine.invalidation_listener');
        $d->addEventListener([0 => 'postUpdate'], 'sulu_contact.doctrine.invalidation_listener');
        $d->addEventListener([0 => 'preRemove'], 'sulu_contact.doctrine.invalidation_listener');
        $d->addEventListener([0 => 'postPersist'], 'sulu_media.doctrine.invalidation_listener');
        $d->addEventListener([0 => 'postUpdate'], 'sulu_media.doctrine.invalidation_listener');
        $d->addEventListener([0 => 'preRemove'], 'sulu_media.doctrine.invalidation_listener');

        return $this->services['doctrine.dbal.default_connection'] = (new \Doctrine\Bundle\DoctrineBundle\ConnectionFactory([]))->createConnection(['url' => $this->getEnv('resolve:DATABASE_URL'), 'host' => 'localhost', 'port' => NULL, 'user' => 'root', 'password' => NULL, 'driver' => 'pdo_mysql', 'driverOptions' => [], 'defaultTableOptions' => []], $b, $d, []);
    }

    /**
     * Gets the public 'doctrine.orm.default_entity_manager' shared service.
     *
     * @return \Doctrine\ORM\EntityManager
     */
    protected function getDoctrine_Orm_DefaultEntityManagerService($lazyLoad = true)
    {
        if ($lazyLoad) {
            return $this->services['doctrine.orm.default_entity_manager'] = $this->createProxy('EntityManager_9a5be93', function () {
                return \EntityManager_9a5be93::staticProxyConstructor(function (&$wrappedInstance, \ProxyManager\Proxy\LazyLoadingInterface $proxy) {
                    $wrappedInstance = $this->getDoctrine_Orm_DefaultEntityManagerService(false);

                    $proxy->setProxyInitializer(null);

                    return true;
                });
            });
        }

        include_once \dirname(__DIR__, 5).'/vendor/doctrine/common/lib/Doctrine/Common/Proxy/Autoloader.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Proxy/Autoloader.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/persistence/lib/Doctrine/Persistence/ObjectManager.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/EntityManagerInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/EntityManager.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Configuration.php';
        include_once \dirname(__DIR__, 5).'/vendor/symfony/cache/PruneableInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/symfony/cache/DoctrineProvider.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/persistence/lib/Doctrine/Persistence/Mapping/Driver/MappingDriver.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/persistence/lib/Doctrine/Persistence/Mapping/Driver/MappingDriverChain.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/persistence/lib/Doctrine/Persistence/Mapping/Driver/FileDriver.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/Driver/XmlDriver.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/Driver/SimplifiedXmlDriver.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/persistence/lib/Doctrine/Persistence/Mapping/Driver/AnnotationDriver.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/Driver/AnnotationDriver.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/NamingStrategy.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/UnderscoreNamingStrategy.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/QuoteStrategy.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/DefaultQuoteStrategy.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/EntityListenerResolver.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/doctrine-bundle/Mapping/EntityListenerServiceResolver.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/doctrine-bundle/Mapping/ContainerEntityListenerResolver.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Repository/RepositoryFactory.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/doctrine-bundle/Repository/ContainerRepositoryFactory.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/doctrine-bundle/ManagerConfigurator.php';

        $a = new \Doctrine\ORM\Configuration();

        $b = new \Doctrine\Persistence\Mapping\Driver\MappingDriverChain();

        $c = new \Doctrine\ORM\Mapping\Driver\SimplifiedXmlDriver([(\dirname(__DIR__, 5).'/vendor/gedmo/doctrine-extensions/lib/Gedmo/Tree/Entity') => 'Gedmo\\Tree\\Entity', (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/ContactBundle/Resources/config/doctrine') => 'Sulu\\Bundle\\ContactBundle\\Entity', (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Resources/config/doctrine') => 'Sulu\\Bundle\\MediaBundle\\Entity', (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SecurityBundle/Resources/config/doctrine') => 'Sulu\\Bundle\\SecurityBundle\\Entity', (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CategoryBundle/Resources/config/doctrine') => 'Sulu\\Bundle\\CategoryBundle\\Entity', (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/TagBundle/Resources/config/doctrine') => 'Sulu\\Bundle\\TagBundle\\Entity', (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Resources/config/doctrine') => 'Sulu\\Bundle\\WebsiteBundle\\Entity', (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/RouteBundle/Resources/config/doctrine') => 'Sulu\\Bundle\\RouteBundle\\Entity']);
        $c->setGlobalBasename('mapping');
        $d = new \Doctrine\ORM\Mapping\Driver\AnnotationDriver(($this->privates['annotations.cached_reader'] ?? $this->getAnnotations_CachedReaderService()), [0 => (\dirname(__DIR__, 5).'/src/Entity'), 1 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CoreBundle/Entity')]);

        $b->addDriver($c, 'Gedmo\\Tree\\Entity');
        $b->addDriver($c, 'Sulu\\Bundle\\ContactBundle\\Entity');
        $b->addDriver($c, 'Sulu\\Bundle\\MediaBundle\\Entity');
        $b->addDriver($c, 'Sulu\\Bundle\\SecurityBundle\\Entity');
        $b->addDriver($c, 'Sulu\\Bundle\\CategoryBundle\\Entity');
        $b->addDriver($c, 'Sulu\\Bundle\\TagBundle\\Entity');
        $b->addDriver($c, 'Sulu\\Bundle\\WebsiteBundle\\Entity');
        $b->addDriver($c, 'Sulu\\Bundle\\RouteBundle\\Entity');
        $b->addDriver($d, 'App\\Entity');
        $b->addDriver($d, 'Sulu\\Bundle\\CoreBundle\\Entity');

        $a->setEntityNamespaces(['GedmoTree' => 'Gedmo\\Tree\\Entity', 'App' => 'App\\Entity', 'SuluCoreBundle' => 'Sulu\\Bundle\\CoreBundle\\Entity', 'SuluContactBundle' => 'Sulu\\Bundle\\ContactBundle\\Entity', 'SuluMediaBundle' => 'Sulu\\Bundle\\MediaBundle\\Entity', 'SuluSecurityBundle' => 'Sulu\\Bundle\\SecurityBundle\\Entity', 'SuluCategoryBundle' => 'Sulu\\Bundle\\CategoryBundle\\Entity', 'SuluTagBundle' => 'Sulu\\Bundle\\TagBundle\\Entity', 'SuluWebsiteBundle' => 'Sulu\\Bundle\\WebsiteBundle\\Entity', 'SuluRouteBundle' => 'Sulu\\Bundle\\RouteBundle\\Entity']);
        $a->setMetadataCacheImpl(new \Symfony\Component\Cache\DoctrineProvider(($this->privates['cache.doctrine.orm.default.metadata'] ?? ($this->privates['cache.doctrine.orm.default.metadata'] = new \Symfony\Component\Cache\Adapter\ArrayAdapter()))));
        $a->setQueryCacheImpl(new \Symfony\Component\Cache\DoctrineProvider(($this->privates['cache.doctrine.orm.default.query'] ?? ($this->privates['cache.doctrine.orm.default.query'] = new \Symfony\Component\Cache\Adapter\ArrayAdapter()))));
        $a->setResultCacheImpl(new \Symfony\Component\Cache\DoctrineProvider(($this->privates['cache.doctrine.orm.default.result'] ?? ($this->privates['cache.doctrine.orm.default.result'] = new \Symfony\Component\Cache\Adapter\ArrayAdapter()))));
        $a->setMetadataDriverImpl($b);
        $a->setProxyDir(($this->targetDir.''.'/doctrine/orm/Proxies'));
        $a->setProxyNamespace('Proxies');
        $a->setAutoGenerateProxyClasses(true);
        $a->setClassMetadataFactoryName('Doctrine\\ORM\\Mapping\\ClassMetadataFactory');
        $a->setDefaultRepositoryClassName('Doctrine\\ORM\\EntityRepository');
        $a->setNamingStrategy(new \Doctrine\ORM\Mapping\UnderscoreNamingStrategy(0, true));
        $a->setQuoteStrategy(new \Doctrine\ORM\Mapping\DefaultQuoteStrategy());
        $a->setEntityListenerResolver(new \Doctrine\Bundle\DoctrineBundle\Mapping\ContainerEntityListenerResolver($this));
        $a->setRepositoryFactory(new \Doctrine\Bundle\DoctrineBundle\Repository\ContainerRepositoryFactory(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [], [])));
        $a->addCustomStringFunction('group_concat', 'Oro\\ORM\\Query\\AST\\Functions\\String\\GroupConcat');
        $a->addCustomStringFunction('CAST', 'Sulu\\Component\\Rest\\DQL\\Cast');

        $instance = \Doctrine\ORM\EntityManager::create(($this->services['doctrine.dbal.default_connection'] ?? $this->getDoctrine_Dbal_DefaultConnectionService()), $a);

        (new \Doctrine\Bundle\DoctrineBundle\ManagerConfigurator([], []))->configure($instance);

        return $instance;
    }

    /**
     * Gets the public 'doctrine_phpcr.session' shared service.
     *
     * @return \Sulu\Bundle\DocumentManagerBundle\Session\Session
     */
    protected function getDoctrinePhpcr_SessionService()
    {
        $a = ($this->services['doctrine.dbal.default_connection'] ?? $this->getDoctrine_Dbal_DefaultConnectionService());

        if (isset($this->services['doctrine_phpcr.session'])) {
            return $this->services['doctrine_phpcr.session'];
        }

        return $this->services['doctrine_phpcr.session'] = new \Sulu\Bundle\DocumentManagerBundle\Session\Session([($this->privates['doctrine_phpcr.jackalope.repository.factory.service.doctrinedbal'] ?? ($this->privates['doctrine_phpcr.jackalope.repository.factory.service.doctrinedbal'] = new \Jackalope\RepositoryFactoryDoctrineDBAL()))->getRepository(['jackalope.doctrine_dbal_connection' => $a, 'jackalope.check_login_on_server' => false]), 'login'](new \PHPCR\SimpleCredentials('admin', 'admin'), $this->getEnv('PHPCR_WORKSPACE')));
    }

    /**
     * Gets the public 'event_dispatcher' shared service.
     *
     * @return \Symfony\Component\EventDispatcher\EventDispatcher
     */
    protected function getEventDispatcherService()
    {
        $this->services['event_dispatcher'] = $instance = new \Symfony\Component\EventDispatcher\EventDispatcher();

        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['fos_rest.body_listener'] ?? $this->getFosRest_BodyListenerService());
        }, 1 => 'onKernelRequest'], 10);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['fos_rest.zone_matcher_listener'] ?? $this->getFosRest_ZoneMatcherListenerService());
        }, 1 => 'onKernelRequest'], 248);
        $instance->addListener('massive_search.index', [0 => function () {
            return ($this->privates['massive_search.events.index_listener'] ?? $this->load('getMassiveSearch_Events_IndexListenerService'));
        }, 1 => 'onIndex'], 0);
        $instance->addListener('massive_search.deindex', [0 => function () {
            return ($this->privates['massive_search.events.deindex_listener'] ?? $this->load('getMassiveSearch_Events_DeindexListenerService'));
        }, 1 => 'onDeindex'], 0);
        $instance->addListener('massive_search.index_rebuild', [0 => function () {
            return ($this->privates['massive_search.events.zend_rebuild'] ?? $this->load('getMassiveSearch_Events_ZendRebuildService'));
        }, 1 => 'onIndexRebuild'], -999);
        $instance->addListener('sulu_security.permission_update', [0 => function () {
            return ($this->privates['sulu_media.permission_listener'] ?? $this->load('getSuluMedia_PermissionListenerService'));
        }, 1 => 'onPermissionUpdate'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['sulu_security.system_listener'] ?? $this->getSuluSecurity_SystemListenerService());
        }, 1 => 'onKernelRequest'], 24);
        $instance->addListener('massive_search.hit', [0 => function () {
            return ($this->privates['sulu_search.event_listener.hit'] ?? $this->load('getSuluSearch_EventListener_HitService'));
        }, 1 => 'onHit'], 0);
        $instance->addListener('sulu_security.permission_update', [0 => function () {
            return ($this->privates['sulu_page.permission_listener'] ?? $this->load('getSuluPage_PermissionListenerService'));
        }, 1 => 'onPermissionUpdate'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['sulu_website.routing.request_listener'] ?? $this->getSuluWebsite_Routing_RequestListenerService());
        }, 1 => 'onRequest'], 31);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['sulu_website.analytics.response_listener'] ?? $this->getSuluWebsite_Analytics_ResponseListenerService());
        }, 1 => 'onResponse'], -5);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['sulu_markup.response_listener'] ?? $this->getSuluMarkup_ResponseListenerService());
        }, 1 => 'replaceMarkup'], -10);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['response_listener'] ?? ($this->privates['response_listener'] = new \Symfony\Component\HttpKernel\EventListener\ResponseListener('UTF-8')));
        }, 1 => 'onKernelResponse'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['streamed_response_listener'] ?? ($this->privates['streamed_response_listener'] = new \Symfony\Component\HttpKernel\EventListener\StreamedResponseListener()));
        }, 1 => 'onKernelResponse'], -1024);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['locale_listener'] ?? $this->getLocaleListenerService());
        }, 1 => 'setDefaultLocale'], 100);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['locale_listener'] ?? $this->getLocaleListenerService());
        }, 1 => 'onKernelRequest'], 16);
        $instance->addListener('kernel.finish_request', [0 => function () {
            return ($this->privates['locale_listener'] ?? $this->getLocaleListenerService());
        }, 1 => 'onKernelFinishRequest'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['validate_request_listener'] ?? ($this->privates['validate_request_listener'] = new \Symfony\Component\HttpKernel\EventListener\ValidateRequestListener()));
        }, 1 => 'onKernelRequest'], 256);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['disallow_search_engine_index_response_listener'] ?? ($this->privates['disallow_search_engine_index_response_listener'] = new \Symfony\Component\HttpKernel\EventListener\DisallowRobotsIndexingListener()));
        }, 1 => 'onResponse'], -255);
        $instance->addListener('kernel.controller_arguments', [0 => function () {
            return ($this->privates['exception_listener'] ?? $this->getExceptionListenerService());
        }, 1 => 'onControllerArguments'], 0);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['exception_listener'] ?? $this->getExceptionListenerService());
        }, 1 => 'logKernelException'], 0);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['exception_listener'] ?? $this->getExceptionListenerService());
        }, 1 => 'onKernelException'], -128);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['exception_listener'] ?? $this->getExceptionListenerService());
        }, 1 => 'removeCspHeader'], -128);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['locale_aware_listener'] ?? $this->getLocaleAwareListenerService());
        }, 1 => 'onKernelRequest'], 15);
        $instance->addListener('kernel.finish_request', [0 => function () {
            return ($this->privates['locale_aware_listener'] ?? $this->getLocaleAwareListenerService());
        }, 1 => 'onKernelFinishRequest'], -15);
        $instance->addListener('console.error', [0 => function () {
            return ($this->privates['console.error_listener'] ?? $this->load('getConsole_ErrorListenerService'));
        }, 1 => 'onConsoleError'], -128);
        $instance->addListener('console.terminate', [0 => function () {
            return ($this->privates['console.error_listener'] ?? $this->load('getConsole_ErrorListenerService'));
        }, 1 => 'onConsoleTerminate'], -128);
        $instance->addListener('console.error', [0 => function () {
            return ($this->privates['console.suggest_missing_package_subscriber'] ?? ($this->privates['console.suggest_missing_package_subscriber'] = new \Symfony\Bundle\FrameworkBundle\EventListener\SuggestMissingPackageSubscriber()));
        }, 1 => 'onConsoleError'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['session_listener'] ?? $this->getSessionListenerService());
        }, 1 => 'onKernelRequest'], 128);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['session_listener'] ?? $this->getSessionListenerService());
        }, 1 => 'onKernelResponse'], -1000);
        $instance->addListener('kernel.finish_request', [0 => function () {
            return ($this->privates['session_listener'] ?? $this->getSessionListenerService());
        }, 1 => 'onFinishRequest'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['debug.debug_handlers_listener'] ?? $this->getDebug_DebugHandlersListenerService());
        }, 1 => 'configure'], 2048);
        $instance->addListener('console.command', [0 => function () {
            return ($this->privates['debug.debug_handlers_listener'] ?? $this->getDebug_DebugHandlersListenerService());
        }, 1 => 'configure'], 2048);
        $instance->addListener('console.command', [0 => function () {
            return ($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService());
        }, 1 => 'onCommand'], 255);
        $instance->addListener('console.terminate', [0 => function () {
            return ($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService());
        }, 1 => 'onTerminate'], -255);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['swiftmailer.email_sender.listener'] ?? $this->load('getSwiftmailer_EmailSender_ListenerService'));
        }, 1 => 'onException'], 0);
        $instance->addListener('kernel.terminate', [0 => function () {
            return ($this->privates['swiftmailer.email_sender.listener'] ?? $this->load('getSwiftmailer_EmailSender_ListenerService'));
        }, 1 => 'onTerminate'], 0);
        $instance->addListener('console.error', [0 => function () {
            return ($this->privates['swiftmailer.email_sender.listener'] ?? $this->load('getSwiftmailer_EmailSender_ListenerService'));
        }, 1 => 'onException'], 0);
        $instance->addListener('console.terminate', [0 => function () {
            return ($this->privates['swiftmailer.email_sender.listener'] ?? $this->load('getSwiftmailer_EmailSender_ListenerService'));
        }, 1 => 'onTerminate'], 0);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['fos_rest.exception.response_status_code_listener'] ?? $this->getFosRest_Exception_ResponseStatusCodeListenerService());
        }, 1 => 'getResponseStatusCodeFromThrowable'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['fos_rest.exception.response_status_code_listener'] ?? $this->getFosRest_Exception_ResponseStatusCodeListenerService());
        }, 1 => 'setResponseStatusCode'], 0);
        $instance->addListener('massive_search.index_rebuild', [0 => function () {
            return ($this->privates['massive_search.search.event_subscriber.purge_subscriber'] ?? $this->load('getMassiveSearch_Search_EventSubscriber_PurgeSubscriberService'));
        }, 1 => 'purgeIndexes'], 500);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->services['fos_http_cache.event_listener.cache_control'] ?? ($this->services['fos_http_cache.event_listener.cache_control'] = new \FOS\HttpCacheBundle\EventListener\CacheControlListener('X-Cache-Debug')));
        }, 1 => 'onKernelResponse'], 10);
        $instance->addListener('fos_http_cache.error.proxy_unreachable', [0 => function () {
            return ($this->privates['fos_http_cache.event_listener.log'] ?? $this->load('getFosHttpCache_EventListener_LogService'));
        }, 1 => 'onProxyUnreachableError'], 0);
        $instance->addListener('fos_http_cache.error.response', [0 => function () {
            return ($this->privates['fos_http_cache.event_listener.log'] ?? $this->load('getFosHttpCache_EventListener_LogService'));
        }, 1 => 'onProxyResponseError'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['fos_http_cache.event_listener.tag'] ?? $this->getFosHttpCache_EventListener_TagService());
        }, 1 => 'onKernelResponse'], 0);
        $instance->addListener('kernel.terminate', [0 => function () {
            return ($this->privates['fos_http_cache.event_listener.invalidation'] ?? $this->load('getFosHttpCache_EventListener_InvalidationService'));
        }, 1 => 'onKernelTerminate'], 0);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['fos_http_cache.event_listener.invalidation'] ?? $this->load('getFosHttpCache_EventListener_InvalidationService'));
        }, 1 => 'onKernelException'], 0);
        $instance->addListener('console.terminate', [0 => function () {
            return ($this->privates['fos_http_cache.event_listener.invalidation'] ?? $this->load('getFosHttpCache_EventListener_InvalidationService'));
        }, 1 => 'onConsoleTerminate'], 0);
        $instance->addListener('massive_search.pre_index', [0 => function () {
            return ($this->privates['sulu_media.search.subscriber.structure_media'] ?? $this->load('getSuluMedia_Search_Subscriber_StructureMediaService'));
        }, 1 => 'handlePreIndex'], 0);
        $instance->addListener('massive_search.pre_index', [0 => function () {
            return ($this->privates['sulu_media.search.subscriber.media'] ?? $this->load('getSuluMedia_Search_Subscriber_MediaService'));
        }, 1 => 'handlePreIndex'], 0);
        $instance->addListener('massive_search.pre_index', [0 => function () {
            return ($this->privates['sulu_page.search.event_subscriber.blame_timestamp'] ?? $this->load('getSuluPage_Search_EventSubscriber_BlameTimestampService'));
        }, 1 => 'handleBlameTimestamp'], 0);
        $instance->addListener('massive_search.hit', [0 => function () {
            return ($this->privates['sulu_page.search.event_subscriber.blame_timestamp'] ?? $this->load('getSuluPage_Search_EventSubscriber_BlameTimestampService'));
        }, 1 => 'handleBlameTimestampHitMapping'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['sulu_website.router_listener'] ?? $this->getSuluWebsite_RouterListenerService());
        }, 1 => 'onKernelRequest'], 32);
        $instance->addListener('kernel.finish_request', [0 => function () {
            return ($this->privates['sulu_website.router_listener'] ?? $this->getSuluWebsite_RouterListenerService());
        }, 1 => 'onKernelFinishRequest'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['sulu_website.event_listener.translator'] ?? $this->getSuluWebsite_EventListener_TranslatorService());
        }, 1 => 'onKernelRequest'], 14);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['sulu_website.redirect_exception_listener'] ?? $this->load('getSuluWebsite_RedirectExceptionListenerService'));
        }, 1 => 'redirectPartialMatch'], 0);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['sulu_website.redirect_exception_listener'] ?? $this->load('getSuluWebsite_RedirectExceptionListenerService'));
        }, 1 => 'redirectTrailingSlashOrHtml'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['sulu_website.event_subscriber.generator'] ?? ($this->privates['sulu_website.event_subscriber.generator'] = new \Sulu\Bundle\WebsiteBundle\EventSubscriber\GeneratorEventSubscriber('2.2.3')));
        }, 1 => 'onResponse'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['sulu_website.segment_subscriber'] ?? $this->getSuluWebsite_SegmentSubscriberService());
        }, 1 => 'addVaryHeader'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['sulu_website.segment_subscriber'] ?? $this->getSuluWebsite_SegmentSubscriberService());
        }, 1 => 'addCookieHeader'], 0);
        $instance->addListener('console.command', [0 => function () {
            return ($this->privates['debug.dump_listener'] ?? $this->load('getDebug_DumpListenerService'));
        }, 1 => 'configure'], 1024);

        return $instance;
    }

    /**
     * Gets the public 'fos_http_cache.cache_manager' shared service.
     *
     * @return \FOS\HttpCacheBundle\CacheManager
     */
    protected function getFosHttpCache_CacheManagerService()
    {
        $this->services['fos_http_cache.cache_manager'] = $instance = new \FOS\HttpCacheBundle\CacheManager(($this->services['fos_http_cache.proxy_client.symfony'] ?? $this->getFosHttpCache_ProxyClient_SymfonyService()), ($this->services['router'] ?? $this->getRouterService()));

        if ($this->has('event_dispatcher')) {
            $instance->setEventDispatcher(($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()));
        }
        $instance->setGenerateUrlType(0);

        return $instance;
    }

    /**
     * Gets the public 'fos_http_cache.event_listener.cache_control' shared service.
     *
     * @return \FOS\HttpCacheBundle\EventListener\CacheControlListener
     */
    protected function getFosHttpCache_EventListener_CacheControlService()
    {
        return $this->services['fos_http_cache.event_listener.cache_control'] = new \FOS\HttpCacheBundle\EventListener\CacheControlListener('X-Cache-Debug');
    }

    /**
     * Gets the public 'fos_http_cache.http.symfony_response_tagger' shared service.
     *
     * @return \FOS\HttpCacheBundle\Http\SymfonyResponseTagger
     */
    protected function getFosHttpCache_Http_SymfonyResponseTaggerService()
    {
        return $this->services['fos_http_cache.http.symfony_response_tagger'] = new \FOS\HttpCacheBundle\Http\SymfonyResponseTagger(['header_formatter' => new \FOS\HttpCache\TagHeaderFormatter\CommaSeparatedTagHeaderFormatter('X-Cache-Tags', ','), 'strict' => false]);
    }

    /**
     * Gets the public 'fos_http_cache.proxy_client.symfony' shared service.
     *
     * @return \FOS\HttpCache\ProxyClient\Symfony
     */
    protected function getFosHttpCache_ProxyClient_SymfonyService()
    {
        return $this->services['fos_http_cache.proxy_client.symfony'] = new \FOS\HttpCache\ProxyClient\Symfony(new \FOS\HttpCache\SymfonyCache\KernelDispatcher(($this->services['kernel'] ?? $this->get('kernel', 1))), $this->parameters['fos_http_cache.proxy_client.symfony.options']);
    }

    /**
     * Gets the public 'http_kernel' shared service.
     *
     * @return \Symfony\Component\HttpKernel\HttpKernel
     */
    protected function getHttpKernelService()
    {
        return $this->services['http_kernel'] = new \Symfony\Component\HttpKernel\HttpKernel(($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->privates['controller_resolver'] ?? $this->getControllerResolverService()), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), new \Symfony\Component\HttpKernel\Controller\ArgumentResolver(new \Symfony\Component\HttpKernel\ControllerMetadata\ArgumentMetadataFactory(), new RewindableGenerator(function () {
            yield 0 => ($this->privates['argument_resolver.request_attribute'] ?? ($this->privates['argument_resolver.request_attribute'] = new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\RequestAttributeValueResolver()));
            yield 1 => ($this->privates['argument_resolver.request'] ?? ($this->privates['argument_resolver.request'] = new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\RequestValueResolver()));
            yield 2 => ($this->privates['argument_resolver.session'] ?? ($this->privates['argument_resolver.session'] = new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\SessionValueResolver()));
            yield 3 => ($this->privates['argument_resolver.service'] ?? $this->load('getArgumentResolver_ServiceService'));
            yield 4 => ($this->privates['argument_resolver.default'] ?? ($this->privates['argument_resolver.default'] = new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\DefaultValueResolver()));
            yield 5 => ($this->privates['argument_resolver.variadic'] ?? ($this->privates['argument_resolver.variadic'] = new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\VariadicValueResolver()));
        }, 6)));
    }

    /**
     * Gets the public 'jms_serializer' shared service.
     *
     * @return \JMS\Serializer\Serializer
     */
    protected function getJmsSerializerService()
    {
        $a = new \Metadata\MetadataFactory(new \Metadata\Driver\LazyLoadingDriver(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'metadata_driver' => ['services', 'jms_serializer.metadata_driver', 'getJmsSerializer_MetadataDriverService', true],
        ], [
            'metadata_driver' => '?',
        ]), 'metadata_driver'), 'Metadata\\ClassHierarchyMetadata', true);
        $a->setCache(new \Metadata\Cache\FileCache(($this->targetDir.''.'/jms_serializer')));
        $b = ($this->services['fos_rest.serializer.jms_handler_registry'] ?? $this->load('getFosRest_Serializer_JmsHandlerRegistryService'));
        $c = new \Symfony\Component\ExpressionLanguage\ExpressionLanguage();
        $c->registerProvider(new \JMS\SerializerBundle\ExpressionLanguage\BasicSerializerFunctionsProvider());

        $d = new \JMS\Serializer\Expression\ExpressionEvaluator($c, ['container' => $this]);

        $e = new \JMS\Serializer\Accessor\DefaultAccessorStrategy($d);
        $f = new \JMS\Serializer\EventDispatcher\LazyEventDispatcher(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'jms_serializer.doctrine_proxy_subscriber' => ['privates', 'jms_serializer.doctrine_proxy_subscriber', 'getJmsSerializer_DoctrineProxySubscriberService', true],
            'sulu_core.representation_handler' => ['privates', 'sulu_core.representation_handler', 'getSuluCore_RepresentationHandlerService', true],
            'sulu_document_manager.serializer.subscriber.children_behavior' => ['privates', 'sulu_document_manager.serializer.subscriber.children_behavior', 'getSuluDocumentManager_Serializer_Subscriber_ChildrenBehaviorService', true],
            'sulu_document_manager.serializer.subscriber.document' => ['privates', 'sulu_document_manager.serializer.subscriber.document', 'getSuluDocumentManager_Serializer_Subscriber_DocumentService', true],
            'sulu_document_manager.serializer.subscriber.proxy' => ['services', 'sulu_document_manager.serializer.subscriber.proxy', 'getSuluDocumentManager_Serializer_Subscriber_ProxyService', true],
            'sulu_hash.event_subscriber.serializer' => ['privates', 'sulu_hash.event_subscriber.serializer', 'getSuluHash_EventSubscriber_SerializerService', true],
            'sulu_page.compat.serializer.subscriber.page_bridge' => ['privates', 'sulu_page.compat.serializer.subscriber.page_bridge', 'getSuluPage_Compat_Serializer_Subscriber_PageBridgeService', true],
            'sulu_page.document.serializer.subscriber.extension_container' => ['privates', 'sulu_page.document.serializer.subscriber.extension_container', 'getSuluPage_Document_Serializer_Subscriber_ExtensionContainerService', true],
            'sulu_page.document.serializer.subscriber.locale' => ['privates', 'sulu_page.document.serializer.subscriber.locale', 'getSuluPage_Document_Serializer_Subscriber_LocaleService', true],
            'sulu_page.document.serializer.subscriber.parent_behavior' => ['privates', 'sulu_page.document.serializer.subscriber.parent_behavior', 'getSuluPage_Document_Serializer_Subscriber_ParentBehaviorService', true],
            'sulu_page.document.serializer.subscriber.path_behavior' => ['privates', 'sulu_page.document.serializer.subscriber.path_behavior', 'getSuluPage_Document_Serializer_Subscriber_PathBehaviorService', true],
            'sulu_page.document.serializer.subscriber.redirect_type_behavior' => ['privates', 'sulu_page.document.serializer.subscriber.redirect_type_behavior', 'getSuluPage_Document_Serializer_Subscriber_RedirectTypeBehaviorService', true],
            'sulu_page.document.serializer.subscriber.shadow_locale_behavior' => ['privates', 'sulu_page.document.serializer.subscriber.shadow_locale_behavior', 'getSuluPage_Document_Serializer_Subscriber_ShadowLocaleBehaviorService', true],
            'sulu_page.document.serializer.subscriber.structure_behavior' => ['privates', 'sulu_page.document.serializer.subscriber.structure_behavior', 'getSuluPage_Document_Serializer_Subscriber_StructureBehaviorService', true],
            'sulu_page.document.serializer.subscriber.workflow_stage_behavior' => ['privates', 'sulu_page.document.serializer.subscriber.workflow_stage_behavior', 'getSuluPage_Document_Serializer_Subscriber_WorkflowStageBehaviorService', true],
            'sulu_security.document.serializer.subscriber.security' => ['privates', 'sulu_security.document.serializer.subscriber.security', 'getSuluSecurity_Document_Serializer_Subscriber_SecurityService', true],
        ], [
            'jms_serializer.doctrine_proxy_subscriber' => '?',
            'sulu_core.representation_handler' => '?',
            'sulu_document_manager.serializer.subscriber.children_behavior' => '?',
            'sulu_document_manager.serializer.subscriber.document' => '?',
            'sulu_document_manager.serializer.subscriber.proxy' => '?',
            'sulu_hash.event_subscriber.serializer' => '?',
            'sulu_page.compat.serializer.subscriber.page_bridge' => '?',
            'sulu_page.document.serializer.subscriber.extension_container' => '?',
            'sulu_page.document.serializer.subscriber.locale' => '?',
            'sulu_page.document.serializer.subscriber.parent_behavior' => '?',
            'sulu_page.document.serializer.subscriber.path_behavior' => '?',
            'sulu_page.document.serializer.subscriber.redirect_type_behavior' => '?',
            'sulu_page.document.serializer.subscriber.shadow_locale_behavior' => '?',
            'sulu_page.document.serializer.subscriber.structure_behavior' => '?',
            'sulu_page.document.serializer.subscriber.workflow_stage_behavior' => '?',
            'sulu_security.document.serializer.subscriber.security' => '?',
        ]));
        $f->setListeners(['serializer.post_serialize' => [0 => [0 => [0 => 'sulu_core.representation_handler', 1 => 'onPostSerialize'], 1 => NULL, 2 => 'json', 3 => NULL], 1 => [0 => [0 => 'sulu_security.document.serializer.subscriber.security', 1 => 'onPostSerialize'], 1 => NULL, 2 => 'json', 3 => NULL], 2 => [0 => [0 => 'sulu_page.document.serializer.subscriber.structure_behavior', 1 => 'onPostSerialize'], 1 => NULL, 2 => 'json', 3 => NULL], 3 => [0 => [0 => 'sulu_page.document.serializer.subscriber.path_behavior', 1 => 'onPostSerialize'], 1 => NULL, 2 => 'json', 3 => NULL], 4 => [0 => [0 => 'sulu_page.document.serializer.subscriber.parent_behavior', 1 => 'onPostSerialize'], 1 => NULL, 2 => 'json', 3 => NULL], 5 => [0 => [0 => 'sulu_page.document.serializer.subscriber.locale', 1 => 'onPostSerialize'], 1 => NULL, 2 => 'json', 3 => NULL], 6 => [0 => [0 => 'sulu_page.document.serializer.subscriber.shadow_locale_behavior', 1 => 'onPostSerialize'], 1 => NULL, 2 => 'json', 3 => NULL], 7 => [0 => [0 => 'sulu_page.document.serializer.subscriber.redirect_type_behavior', 1 => 'onPostSerialize'], 1 => NULL, 2 => 'json', 3 => NULL], 8 => [0 => [0 => 'sulu_page.document.serializer.subscriber.workflow_stage_behavior', 1 => 'onPostSerialize'], 1 => NULL, 2 => 'json', 3 => NULL], 9 => [0 => [0 => 'sulu_page.compat.serializer.subscriber.page_bridge', 1 => 'onPostSerialize'], 1 => NULL, 2 => 'json', 3 => NULL], 10 => [0 => [0 => 'sulu_document_manager.serializer.subscriber.children_behavior', 1 => 'onPostSerialize'], 1 => NULL, 2 => 'json', 3 => NULL], 11 => [0 => [0 => 'sulu_hash.event_subscriber.serializer', 1 => 'onPostSerialize'], 1 => NULL, 2 => NULL, 3 => NULL]], 'serializer.pre_serialize' => [0 => [0 => [0 => 'jms_serializer.doctrine_proxy_subscriber', 1 => 'onPreSerializeTypedProxy'], 1 => NULL, 2 => NULL, 3 => 'Doctrine\\Persistence\\Proxy'], 1 => [0 => [0 => 'jms_serializer.doctrine_proxy_subscriber', 1 => 'onPreSerializeTypedProxy'], 1 => NULL, 2 => NULL, 3 => 'Doctrine\\Common\\Persistence\\Proxy'], 2 => [0 => [0 => 'jms_serializer.doctrine_proxy_subscriber', 1 => 'onPreSerialize'], 1 => NULL, 2 => NULL, 3 => 'Doctrine\\ORM\\PersistentCollection'], 3 => [0 => [0 => 'jms_serializer.doctrine_proxy_subscriber', 1 => 'onPreSerialize'], 1 => NULL, 2 => NULL, 3 => 'Doctrine\\ODM\\MongoDB\\PersistentCollection'], 4 => [0 => [0 => 'jms_serializer.doctrine_proxy_subscriber', 1 => 'onPreSerialize'], 1 => NULL, 2 => NULL, 3 => 'Doctrine\\ODM\\PHPCR\\PersistentCollection'], 5 => [0 => [0 => 'jms_serializer.doctrine_proxy_subscriber', 1 => 'onPreSerialize'], 1 => NULL, 2 => NULL, 3 => 'Doctrine\\Persistence\\Proxy'], 6 => [0 => [0 => 'jms_serializer.doctrine_proxy_subscriber', 1 => 'onPreSerialize'], 1 => NULL, 2 => NULL, 3 => 'Doctrine\\Common\\Persistence\\Proxy'], 7 => [0 => [0 => 'jms_serializer.doctrine_proxy_subscriber', 1 => 'onPreSerialize'], 1 => NULL, 2 => NULL, 3 => 'ProxyManager\\Proxy\\LazyLoadingInterface'], 8 => [0 => [0 => 'sulu_page.document.serializer.subscriber.structure_behavior', 1 => 'onPreSerialize'], 1 => NULL, 2 => NULL, 3 => NULL], 9 => [0 => [0 => 'sulu_page.document.serializer.subscriber.extension_container', 1 => 'onPreSerialize'], 1 => NULL, 2 => NULL, 3 => NULL], 10 => [0 => [0 => 'sulu_document_manager.serializer.subscriber.proxy', 1 => 'onPreSerialize'], 1 => NULL, 2 => NULL, 3 => NULL]], 'serializer.post_deserialize' => [0 => [0 => [0 => 'sulu_document_manager.serializer.subscriber.document', 1 => 'onPostDeserialize'], 1 => NULL, 2 => NULL, 3 => NULL]]]);
        $g = new \JMS\Serializer\Visitor\Factory\JsonSerializationVisitorFactory();
        $g->setOptions(1216);
        $h = new \JMS\Serializer\Visitor\Factory\XmlSerializationVisitorFactory();
        $h->setFormatOutput(true);
        $i = new \JMS\Serializer\Visitor\Factory\JsonDeserializationVisitorFactory();
        $i->setOptions(0);

        return $this->services['jms_serializer'] = new \JMS\Serializer\Serializer($a, [2 => new \JMS\Serializer\GraphNavigator\Factory\DeserializationGraphNavigatorFactory($a, $b, new \JMS\Serializer\Construction\UnserializeObjectConstructor(), $e, $f, $d), 1 => new \JMS\Serializer\GraphNavigator\Factory\SerializationGraphNavigatorFactory($a, $b, $e, $f, $d)], ['json' => $g, 'xml' => $h], ['json' => $i, 'xml' => new \JMS\Serializer\Visitor\Factory\XmlDeserializationVisitorFactory()], ($this->services['jms_serializer.serialization_context_factory'] ?? ($this->services['jms_serializer.serialization_context_factory'] = new \JMS\SerializerBundle\ContextFactory\ConfiguredContextFactory())), ($this->services['jms_serializer.deserialization_context_factory'] ?? ($this->services['jms_serializer.deserialization_context_factory'] = new \JMS\SerializerBundle\ContextFactory\ConfiguredContextFactory())), ($this->privates['jms_serializer.type_parser'] ?? ($this->privates['jms_serializer.type_parser'] = new \JMS\Serializer\Type\Parser())));
    }

    /**
     * Gets the public 'jms_serializer.deserialization_context_factory' shared service.
     *
     * @return \JMS\SerializerBundle\ContextFactory\ConfiguredContextFactory
     */
    protected function getJmsSerializer_DeserializationContextFactoryService()
    {
        return $this->services['jms_serializer.deserialization_context_factory'] = new \JMS\SerializerBundle\ContextFactory\ConfiguredContextFactory();
    }

    /**
     * Gets the public 'jms_serializer.serialization_context_factory' shared service.
     *
     * @return \JMS\SerializerBundle\ContextFactory\ConfiguredContextFactory
     */
    protected function getJmsSerializer_SerializationContextFactoryService()
    {
        return $this->services['jms_serializer.serialization_context_factory'] = new \JMS\SerializerBundle\ContextFactory\ConfiguredContextFactory();
    }

    /**
     * Gets the public 'request_stack' shared service.
     *
     * @return \Symfony\Component\HttpFoundation\RequestStack
     */
    protected function getRequestStackService()
    {
        return $this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack();
    }

    /**
     * Gets the public 'router' shared service.
     *
     * @return \Symfony\Cmf\Component\Routing\ChainRouter
     */
    protected function getRouterService()
    {
        $a = ($this->privates['monolog.logger'] ?? $this->getMonolog_LoggerService());

        $this->services['router'] = $instance = new \Symfony\Cmf\Component\Routing\ChainRouter($a);

        $b = ($this->privates['router.request_context'] ?? $this->getRouter_RequestContextService());
        $c = new \Symfony\Bridge\Monolog\Logger('router');
        $c->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $c->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));

        $d = new \Symfony\Bundle\FrameworkBundle\Routing\Router((new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'routing.loader' => ['services', 'routing.loader', 'getRouting_LoaderService', true],
        ], [
            'routing.loader' => 'Symfony\\Component\\Config\\Loader\\LoaderInterface',
        ]))->withContext('router.default', $this), 'kernel::loadRoutes', ['cache_dir' => $this->targetDir.'', 'debug' => true, 'generator_class' => 'Symfony\\Component\\Routing\\Generator\\CompiledUrlGenerator', 'generator_dumper_class' => 'Symfony\\Component\\Routing\\Generator\\Dumper\\CompiledUrlGeneratorDumper', 'matcher_class' => 'Symfony\\Bundle\\FrameworkBundle\\Routing\\RedirectableCompiledUrlMatcher', 'matcher_dumper_class' => 'Symfony\\Component\\Routing\\Matcher\\Dumper\\CompiledUrlMatcherDumper', 'strict_requirements' => true, 'resource_type' => 'service'], $b, ($this->privates['parameter_bag'] ?? ($this->privates['parameter_bag'] = new \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag($this))), $c, 'en');
        $d->setConfigCacheFactory(($this->privates['config_cache_factory'] ?? $this->getConfigCacheFactoryService()));
        $d->addExpressionLanguageProvider(($this->privates['router.expression_language_provider'] ?? $this->getRouter_ExpressionLanguageProviderService()));
        $e = ($this->services['cmf_routing.route_provider'] ?? $this->getCmfRouting_RouteProviderService());
        $f = new \Symfony\Component\Routing\RouteCollection();
        $g = new \Symfony\Component\Routing\RequestContext();
        $h = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        $i = new \Symfony\Cmf\Bundle\RoutingBundle\Routing\DynamicRouter($b, new \Symfony\Cmf\Component\Routing\NestedMatcher\NestedMatcher($e, new \Symfony\Cmf\Component\Routing\NestedMatcher\UrlMatcher($f, $g)), new \Symfony\Cmf\Component\Routing\ContentAwareGenerator($e, $a), '', $h, $e);
        $i->setRequestStack(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())));
        $i->addRouteEnhancer(new \Symfony\Cmf\Component\Routing\Enhancer\RouteContentEnhancer('_route_object', '_content'), 100);
        $j = new \Sulu\Component\CustomUrl\Routing\CustomUrlRouteProvider(($this->services['sulu_core.webspace.request_analyzer'] ?? $this->getSuluCore_Webspace_RequestAnalyzerService()), ($this->privates['sulu_document_manager.path_builder'] ?? $this->getSuluDocumentManager_PathBuilderService()), 'dev', ['utf8' => true]);

        $k = new \Symfony\Cmf\Bundle\RoutingBundle\Routing\DynamicRouter($b, new \Symfony\Cmf\Component\Routing\NestedMatcher\NestedMatcher($j, new \Symfony\Cmf\Component\Routing\NestedMatcher\UrlMatcher($f, $g)), new \Symfony\Cmf\Component\Routing\ProviderBasedGenerator($j), NULL, $h, $j);

        $l = ($this->services['sulu_core.webspace.webspace_manager'] ?? $this->getSuluCore_Webspace_WebspaceManagerService());

        $k->addRouteEnhancer(new \Sulu\Component\CustomUrl\Routing\Enhancers\TrailingSlashEnhancer(), 100);
        $k->addRouteEnhancer(new \Sulu\Component\CustomUrl\Routing\Enhancers\TrailingHTMLEnhancer(), 90);
        $k->addRouteEnhancer(new \Sulu\Component\CustomUrl\Routing\Enhancers\RedirectEnhancer($l), 80);
        $k->addRouteEnhancer(new \Sulu\Component\CustomUrl\Routing\Enhancers\SeoEnhancer($l), 70);
        $k->addRouteEnhancer(new \Sulu\Component\CustomUrl\Routing\Enhancers\ContentEnhancer(($this->services['sulu_document_manager.document_inspector'] ?? $this->getSuluDocumentManager_DocumentInspectorService()), ($this->services['sulu.content.structure_manager'] ?? $this->getSulu_Content_StructureManagerService())), 60);
        $k->addRouteEnhancer(new \Sulu\Component\CustomUrl\Routing\Enhancers\InternalLinkEnhancer(), 50);
        $k->addRouteEnhancer(new \Sulu\Component\CustomUrl\Routing\Enhancers\StructureEnhancer(), 40);
        $k->addRouteEnhancer(new \Sulu\Component\CustomUrl\Routing\Enhancers\ExternalLinkEnhancer(), 30);
        $m = ($this->privates['sulu_route.routing.provider'] ?? $this->getSuluRoute_Routing_ProviderService());

        $instance->setContext($b);
        $instance->add($d, '100');
        $instance->add($i, '20');
        $instance->add($k, 30);
        $instance->add(new \Symfony\Cmf\Bundle\RoutingBundle\Routing\DynamicRouter($b, new \Symfony\Cmf\Component\Routing\NestedMatcher\NestedMatcher($m, new \Symfony\Cmf\Component\Routing\NestedMatcher\UrlMatcher($f, $g)), new \Symfony\Cmf\Component\Routing\ProviderBasedGenerator($m), NULL, $h, $m), 20);

        return $instance;
    }

    /**
     * Gets the public 'sulu.content.localization_finder' shared service.
     *
     * @return \Sulu\Component\Content\Compat\LocalizationFinder
     */
    protected function getSulu_Content_LocalizationFinderService()
    {
        return $this->services['sulu.content.localization_finder'] = new \Sulu\Component\Content\Compat\LocalizationFinder(($this->services['sulu_core.webspace.webspace_manager'] ?? $this->getSuluCore_Webspace_WebspaceManagerService()));
    }

    /**
     * Gets the public 'sulu.content.mapper' shared service.
     *
     * @return \Sulu\Component\Content\Mapper\ContentMapper
     */
    protected function getSulu_Content_MapperService()
    {
        return $this->services['sulu.content.mapper'] = new \Sulu\Component\Content\Mapper\ContentMapper(($this->services['sulu_document_manager.document_manager'] ?? $this->getSuluDocumentManager_DocumentManagerService()), ($this->services['sulu_core.webspace.webspace_manager'] ?? $this->getSuluCore_Webspace_WebspaceManagerService()), ($this->services['.container.private.form.factory'] ?? $this->get_Container_Private_Form_FactoryService()), ($this->services['sulu_document_manager.document_inspector'] ?? $this->getSuluDocumentManager_DocumentInspectorService()), ($this->services['sulu_document_manager.property_encoder'] ?? $this->getSuluDocumentManager_PropertyEncoderService()), ($this->services['sulu.content.structure_manager'] ?? $this->getSulu_Content_StructureManagerService()), ($this->services['sulu_page.extension.manager'] ?? $this->getSuluPage_Extension_ManagerService()), ($this->services['sulu.content.type_manager'] ?? $this->getSulu_Content_TypeManagerService()), ($this->services['sulu.phpcr.session'] ?? $this->getSulu_Phpcr_SessionService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->privates['sulu.content.resource_locator.strategy_pool'] ?? $this->getSulu_Content_ResourceLocator_StrategyPoolService()), ($this->privates['sulu_document_manager.namespace_registry'] ?? $this->getSuluDocumentManager_NamespaceRegistryService()), ($this->privates['sulu_security.access_control_manager'] ?? $this->getSuluSecurity_AccessControlManagerService()), $this->parameters['sulu_security.permissions'], NULL);
    }

    /**
     * Gets the public 'sulu.content.path_cleaner' shared service.
     *
     * @return \Sulu\Component\PHPCR\PathCleanup
     */
    protected function getSulu_Content_PathCleanerService()
    {
        return $this->services['sulu.content.path_cleaner'] = new \Sulu\Component\PHPCR\PathCleanup(['default' => [' ' => '-', '+' => '-', '.' => '-', '^' => '-', '~' => '-', '[' => '-', ']' => '-', '(' => '-', ')' => '-', '{' => '-', '}' => '-', 'Á' => 'A', 'á' => 'a', 'Ć' => 'C', 'ć' => 'c', 'É' => 'E', 'é' => 'e', 'Í' => 'I', 'í' => 'i', 'Ĺ' => 'L', 'ĺ' => 'l', 'Ń' => 'N', 'ń' => 'n', 'Ó' => 'O', 'ó' => 'o', 'Ő' => 'O', 'ő' => 'o', 'Ŕ' => 'R', 'ŕ' => 'r', 'Ś' => 'S', 'ś' => 's', 'Ú' => 'U', 'ú' => 'u', 'Ű' => 'U', 'ű' => 'u', 'Ý' => 'Y', 'ý' => 'y', 'Ź' => 'Z', 'ź' => 'z', 'Ă' => 'A', 'ă' => 'a', 'Ĕ' => 'E', 'ĕ' => 'e', 'Ğ' => 'G', 'ğ' => 'g', 'Ĭ' => 'I', 'ĭ' => 'i', 'Ŏ' => 'o', 'ŏ' => 'o', 'Ŭ' => 'U', 'ŭ' => 'u', 'Č' => 'C', 'č' => 'c', 'Ď' => 'D', 'Ě' => 'E', 'ě' => 'e', 'Ň' => 'N', 'ň' => 'n', 'Ř' => 'R', 'ř' => 'r', 'Š' => 'S', 'š' => 's', 'Ť' => 'T', 'Ž' => 'Z', 'ž' => 'z', 'Ç' => 'C', 'ç' => 'c', 'Ģ' => 'G', 'ģ' => 'g', 'Ķ' => 'K', 'ķ' => 'k', 'Ļ' => 'L', 'ļ' => 'l', 'Ņ' => 'N', 'ņ' => 'n', 'Ŗ' => 'R', 'ŗ' => 'r', 'Ş' => 'S', 'ş' => 's', 'Ţ' => 'T', 'ţ' => 't', 'Ä' => 'Ae', 'ä' => 'ae', 'Ë' => 'E', 'ë' => 'e', 'Ï' => 'I', 'ï' => 'i', 'Ö' => 'Oe', 'ö' => 'oe', 'Ü' => 'Ue', 'ü' => 'ue', 'Ÿ' => 'Y', 'ÿ' => 'y', 'À' => 'A', 'à' => 'a', 'È' => 'E', 'è' => 'e', 'Ì' => 'I', 'ì' => 'i', 'Ò' => 'O', 'ò' => 'o', 'Ù' => 'U', 'ù' => 'u', 'Ā' => 'A', 'ā' => 'a', 'Ē' => 'E', 'ē' => 'e', 'Ī' => 'I', 'ī' => 'i', 'Ō' => 'O', 'ō' => 'o', 'Ū' => 'U', 'ū' => 'u', 'Ą' => 'A', 'ą' => 'a', 'Ę' => 'E', 'ę' => 'e', 'Į' => 'I', 'į' => 'i', 'Ų' => 'U', 'ų' => 'u', 'Ḃ' => 'B', 'ḃ' => 'b', 'Ċ' => 'C', 'ċ' => 'c', 'Ḋ' => 'D', 'ḋ' => 'd', 'Ė' => 'E', 'ė' => 'e', 'Ḟ' => 'F', 'Ġ' => 'G', 'ġ' => 'g', 'Ḣ' => 'H', 'ḣ' => 'h', 'İ' => 'I', 'Ṁ' => 'M', 'ṁ' => 'm', 'Ṅ' => 'N', 'ṅ' => 'n', 'Ṗ' => 'P', 'ṗ' => 'p', 'Ṙ' => 'R', 'ṙ' => 'r', 'Ṡ' => 'S', 'ṡ' => 's', 'Ṫ' => 'T', 'ṫ' => 't', 'Ż' => 'Z', 'ż' => 'z', 'Ḍ' => 'D', 'ḍ' => 'd', 'Ḥ' => 'H', 'ḥ' => 'h', 'Ḳ' => 'K', 'ḳ' => 'k', 'Ḷ' => 'L', 'ḷ' => 'l', 'Ṃ' => 'M', 'ṃ' => 'm', 'Ṛ' => 'R', 'ṛ' => 'r', 'Ṣ' => 'S', 'ṣ' => 's', 'Ṭ' => 'T', 'ṭ' => 't', 'Ṿ' => 'V', 'ṿ' => 'v', 'Đ' => 'D', 'đ' => 'd', 'Ħ' => 'H', 'ħ' => 'h', 'Ŧ' => 'T', 'ŧ' => 't', 'Å' => 'A', 'å' => 'a', 'Ů' => 'U', 'ů' => 'u', 'Ł' => 'L', 'ł' => 'l', 'Ø' => 'O', 'ø' => 'o', 'Ã' => 'A', 'ã' => 'a', 'Ĩ' => 'I', 'ĩ' => 'i', 'Ñ' => 'N', 'ñ' => 'n', 'Õ' => 'O', 'õ' => 'o', 'Ũ' => 'U', 'ũ' => 'u', 'Â' => 'A', 'â' => 'a', 'Ĉ' => 'C', 'ĉ' => 'c', 'Ê' => 'E', 'ê' => 'e', 'Ĝ' => 'G', 'ĝ' => 'g', 'Ĥ' => 'H', 'ĥ' => 'h', 'Î' => 'I', 'î' => 'i', 'Ĵ' => 'J', 'ĵ' => 'j', 'Ô' => 'O', 'ô' => 'o', 'Ŝ' => 'S', 'ŝ' => 's', 'Û' => 'U', 'û' => 'u', 'Ŵ' => 'W', 'ŵ' => 'w', 'Ŷ' => 'Y', 'ŷ' => 'y', 'Æ' => 'AE', 'æ' => 'ae', 'ß' => 'ss', 'Œ' => 'OE', 'œ' => 'oe', 'Ĳ' => 'IJ', 'ª' => 'a', 'º' => 'o'], 'de' => ['&' => 'und'], 'en' => ['&' => 'and'], 'fr' => ['&' => 'et'], 'it' => ['&' => 'e'], 'nl' => ['&' => 'en'], 'es' => ['&' => 'y'], 'bg' => ['&' => 'и']], new \Symfony\Component\String\Slugger\AsciiSlugger());
    }

    /**
     * Gets the public 'sulu.content.structure_manager' shared service.
     *
     * @return \Sulu\Component\Content\Compat\StructureManager
     */
    protected function getSulu_Content_StructureManagerService()
    {
        return $this->services['sulu.content.structure_manager'] = new \Sulu\Component\Content\Compat\StructureManager(($this->services['sulu_page.structure.factory'] ?? $this->getSuluPage_Structure_FactoryService()), ($this->services['sulu_document_manager.document_inspector'] ?? $this->getSuluDocumentManager_DocumentInspectorService()), ($this->services['sulu_page.compat.structure.legacy_property_factory'] ?? $this->getSuluPage_Compat_Structure_LegacyPropertyFactoryService()), $this->parameters['sulu.content.structure.type_map']);
    }

    /**
     * Gets the public 'sulu.content.type_manager' shared service.
     *
     * @return \Sulu\Component\Content\ContentTypeManager
     */
    protected function getSulu_Content_TypeManagerService()
    {
        $this->services['sulu.content.type_manager'] = $instance = new \Sulu\Component\Content\ContentTypeManager($this);

        $instance->mapAliasToServiceId('number', 'sulu.content.type.number');
        $instance->mapAliasToServiceId('text_line', 'sulu.content.type.text_line');
        $instance->mapAliasToServiceId('text_area', 'sulu.content.type.text_area');
        $instance->mapAliasToServiceId('text_editor', 'sulu.content.type.text_editor');
        $instance->mapAliasToServiceId('resource_locator', 'sulu.content.type.resource_locator');
        $instance->mapAliasToServiceId('block', 'sulu.content.type.block');
        $instance->mapAliasToServiceId('contact_account_selection', 'sulu_contact.content.contact_account_selection');
        $instance->mapAliasToServiceId('single_contact_selection', 'sulu_contact.content.single_contact_selection');
        $instance->mapAliasToServiceId('contact_selection', 'sulu_contact.content.contact_selection');
        $instance->mapAliasToServiceId('single_account_selection', 'sulu_contact.content.single_account_selection');
        $instance->mapAliasToServiceId('account_selection', 'sulu_contact.content.account_selection');
        $instance->mapAliasToServiceId('media_selection', 'sulu_media.type.media_selection');
        $instance->mapAliasToServiceId('single_media_selection', 'sulu_media.type.single_media_selection');
        $instance->mapAliasToServiceId('image_map', 'sulu_media.type.image_map');
        $instance->mapAliasToServiceId('category_selection', 'sulu_category.content.type.category_selection');
        $instance->mapAliasToServiceId('single_category_selection', 'sulu_category.content.type.single_category_selection');
        $instance->mapAliasToServiceId('single_snippet_selection', 'sulu_snippet.content.single_snippet_selection');
        $instance->mapAliasToServiceId('snippet_selection', 'sulu_snippet.content.snippet');
        $instance->mapAliasToServiceId('smart_content', 'sulu_page.smart_content.content_type');
        $instance->mapAliasToServiceId('teaser_selection', 'sulu_page.teaser.content_type');
        $instance->mapAliasToServiceId('page_selection', 'sulu.content.type.page_selection');
        $instance->mapAliasToServiceId('single_page_selection', 'sulu.content.type.single_page_selection');
        $instance->mapAliasToServiceId('phone', 'sulu.content.type.phone');
        $instance->mapAliasToServiceId('segment_select', 'sulu.content.type.segment_select');
        $instance->mapAliasToServiceId('password', 'sulu.content.type.password');
        $instance->mapAliasToServiceId('url', 'sulu.content.type.url');
        $instance->mapAliasToServiceId('email', 'sulu.content.type.email');
        $instance->mapAliasToServiceId('date', 'sulu.content.type.date');
        $instance->mapAliasToServiceId('datetime', 'sulu.content.type.datetime');
        $instance->mapAliasToServiceId('time', 'sulu.content.type.time');
        $instance->mapAliasToServiceId('color', 'sulu.content.type.color');
        $instance->mapAliasToServiceId('checkbox', 'sulu.content.type.checkbox');
        $instance->mapAliasToServiceId('select', 'sulu.content.type.select');
        $instance->mapAliasToServiceId('single_select', 'sulu.content.type.single_select');
        $instance->mapAliasToServiceId('tag_selection', 'sulu_tag.content.type.tag_selection');
        $instance->mapAliasToServiceId('location', 'sulu_location.content.type.location');
        $instance->mapAliasToServiceId('route', 'sulu_route.content_type');
        $instance->mapAliasToServiceId('page_tree_route', 'sulu_route.content_type.page_tree_route');

        return $instance;
    }

    /**
     * Gets the public 'sulu.phpcr.session' shared service.
     *
     * @return \Sulu\Component\PHPCR\SessionManager\SessionManager
     */
    protected function getSulu_Phpcr_SessionService()
    {
        return $this->services['sulu.phpcr.session'] = new \Sulu\Component\PHPCR\SessionManager\SessionManager(($this->services['doctrine_phpcr.session'] ?? $this->getDoctrinePhpcr_SessionService()), ['base' => 'cmf', 'content' => 'contents', 'route' => 'routes', 'snippet' => 'snippets']);
    }

    /**
     * Gets the public 'sulu.repository.access_control' shared service.
     *
     * @return \Sulu\Bundle\SecurityBundle\Entity\AccessControlRepository
     */
    protected function getSulu_Repository_AccessControlService($lazyLoad = true)
    {
        if ($lazyLoad) {
            return $this->services['sulu.repository.access_control'] = $this->createProxy('AccessControlRepository_b331497', function () {
                return \AccessControlRepository_b331497::staticProxyConstructor(function (&$wrappedInstance, \ProxyManager\Proxy\LazyLoadingInterface $proxy) {
                    $wrappedInstance = $this->getSulu_Repository_AccessControlService(false);

                    $proxy->setProxyInitializer(null);

                    return true;
                });
            });
        }

        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/Repository/RepositoryInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/Repository/ORM/EntityRepository.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Security/Authorization/AccessControl/AccessControlRepositoryInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SecurityBundle/Entity/AccessControlRepository.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/persistence/lib/Doctrine/Persistence/Mapping/ClassMetadata.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/ClassMetadataInfo.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/ClassMetadata.php';

        $a = ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService());

        return new \Sulu\Bundle\SecurityBundle\Entity\AccessControlRepository($a, $a->getClassMetadata('Sulu\\Bundle\\SecurityBundle\\Entity\\AccessControl'));
    }

    /**
     * Gets the public 'sulu.repository.account' shared service.
     *
     * @return \Sulu\Bundle\ContactBundle\Entity\AccountRepository
     */
    protected function getSulu_Repository_AccountService($lazyLoad = true)
    {
        if ($lazyLoad) {
            return $this->services['sulu.repository.account'] = $this->createProxy('AccountRepository_21f7ad1', function () {
                return \AccountRepository_21f7ad1::staticProxyConstructor(function (&$wrappedInstance, \ProxyManager\Proxy\LazyLoadingInterface $proxy) {
                    $wrappedInstance = $this->getSulu_Repository_AccountService(false);

                    $proxy->setProxyInitializer(null);

                    return true;
                });
            });
        }

        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/Repository/RepositoryInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/ContactBundle/Entity/AccountRepositoryInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/SmartContent/Orm/DataProviderRepositoryTrait.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/ContactBundle/Entity/AccountRepository.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/persistence/lib/Doctrine/Persistence/Mapping/ClassMetadata.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/ClassMetadataInfo.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/ClassMetadata.php';

        $a = ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService());

        return new \Sulu\Bundle\ContactBundle\Entity\AccountRepository($a, $a->getClassMetadata('Sulu\\Bundle\\ContactBundle\\Entity\\Account'));
    }

    /**
     * Gets the public 'sulu.repository.category' shared service.
     *
     * @return \Sulu\Bundle\CategoryBundle\Entity\CategoryRepository
     */
    protected function getSulu_Repository_CategoryService($lazyLoad = true)
    {
        if ($lazyLoad) {
            return $this->services['sulu.repository.category'] = $this->createProxy('CategoryRepository_9c346ab', function () {
                return \CategoryRepository_9c346ab::staticProxyConstructor(function (&$wrappedInstance, \ProxyManager\Proxy\LazyLoadingInterface $proxy) {
                    $wrappedInstance = $this->getSulu_Repository_CategoryService(false);

                    $proxy->setProxyInitializer(null);

                    return true;
                });
            });
        }

        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/Repository/RepositoryInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CategoryBundle/Entity/CategoryRepositoryInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CategoryBundle/Entity/CategoryRepository.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/persistence/lib/Doctrine/Persistence/Mapping/ClassMetadata.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/ClassMetadataInfo.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/ClassMetadata.php';

        $a = ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService());

        return new \Sulu\Bundle\CategoryBundle\Entity\CategoryRepository($a, $a->getClassMetadata('Sulu\\Bundle\\CategoryBundle\\Entity\\Category'));
    }

    /**
     * Gets the public 'sulu.repository.category_meta' shared service.
     *
     * @return \Sulu\Bundle\CategoryBundle\Entity\CategoryMetaRepository
     */
    protected function getSulu_Repository_CategoryMetaService($lazyLoad = true)
    {
        if ($lazyLoad) {
            return $this->services['sulu.repository.category_meta'] = $this->createProxy('CategoryMetaRepository_d16c689', function () {
                return \CategoryMetaRepository_d16c689::staticProxyConstructor(function (&$wrappedInstance, \ProxyManager\Proxy\LazyLoadingInterface $proxy) {
                    $wrappedInstance = $this->getSulu_Repository_CategoryMetaService(false);

                    $proxy->setProxyInitializer(null);

                    return true;
                });
            });
        }

        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/Repository/RepositoryInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/Repository/ORM/EntityRepository.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CategoryBundle/Entity/CategoryMetaRepositoryInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CategoryBundle/Entity/CategoryMetaRepository.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/persistence/lib/Doctrine/Persistence/Mapping/ClassMetadata.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/ClassMetadataInfo.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/ClassMetadata.php';

        $a = ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService());

        return new \Sulu\Bundle\CategoryBundle\Entity\CategoryMetaRepository($a, $a->getClassMetadata('Sulu\\Bundle\\CategoryBundle\\Entity\\CategoryMeta'));
    }

    /**
     * Gets the public 'sulu.repository.category_translation' shared service.
     *
     * @return \Sulu\Bundle\CategoryBundle\Entity\CategoryTranslationRepository
     */
    protected function getSulu_Repository_CategoryTranslationService($lazyLoad = true)
    {
        if ($lazyLoad) {
            return $this->services['sulu.repository.category_translation'] = $this->createProxy('CategoryTranslationRepository_5ea8703', function () {
                return \CategoryTranslationRepository_5ea8703::staticProxyConstructor(function (&$wrappedInstance, \ProxyManager\Proxy\LazyLoadingInterface $proxy) {
                    $wrappedInstance = $this->getSulu_Repository_CategoryTranslationService(false);

                    $proxy->setProxyInitializer(null);

                    return true;
                });
            });
        }

        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/Repository/RepositoryInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/Repository/ORM/EntityRepository.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CategoryBundle/Entity/CategoryTranslationRepositoryInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CategoryBundle/Entity/CategoryTranslationRepository.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/persistence/lib/Doctrine/Persistence/Mapping/ClassMetadata.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/ClassMetadataInfo.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/ClassMetadata.php';

        $a = ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService());

        return new \Sulu\Bundle\CategoryBundle\Entity\CategoryTranslationRepository($a, $a->getClassMetadata('Sulu\\Bundle\\CategoryBundle\\Entity\\CategoryTranslation'));
    }

    /**
     * Gets the public 'sulu.repository.contact' shared service.
     *
     * @return \Sulu\Bundle\ContactBundle\Entity\ContactRepository
     */
    protected function getSulu_Repository_ContactService($lazyLoad = true)
    {
        if ($lazyLoad) {
            return $this->services['sulu.repository.contact'] = $this->createProxy('ContactRepository_74094bd', function () {
                return \ContactRepository_74094bd::staticProxyConstructor(function (&$wrappedInstance, \ProxyManager\Proxy\LazyLoadingInterface $proxy) {
                    $wrappedInstance = $this->getSulu_Repository_ContactService(false);

                    $proxy->setProxyInitializer(null);

                    return true;
                });
            });
        }

        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/Repository/RepositoryInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/Repository/ORM/EntityRepository.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/ContactBundle/Entity/ContactRepositoryInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/SmartContent/Orm/DataProviderRepositoryTrait.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/ContactBundle/Entity/ContactRepository.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/persistence/lib/Doctrine/Persistence/Mapping/ClassMetadata.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/ClassMetadataInfo.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/ClassMetadata.php';

        $a = ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService());

        return new \Sulu\Bundle\ContactBundle\Entity\ContactRepository($a, $a->getClassMetadata('Sulu\\Bundle\\ContactBundle\\Entity\\Contact'));
    }

    /**
     * Gets the public 'sulu.repository.keyword' shared service.
     *
     * @return \Sulu\Bundle\CategoryBundle\Entity\KeywordRepository
     */
    protected function getSulu_Repository_KeywordService($lazyLoad = true)
    {
        if ($lazyLoad) {
            return $this->services['sulu.repository.keyword'] = $this->createProxy('KeywordRepository_4891058', function () {
                return \KeywordRepository_4891058::staticProxyConstructor(function (&$wrappedInstance, \ProxyManager\Proxy\LazyLoadingInterface $proxy) {
                    $wrappedInstance = $this->getSulu_Repository_KeywordService(false);

                    $proxy->setProxyInitializer(null);

                    return true;
                });
            });
        }

        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/Repository/RepositoryInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/Repository/ORM/EntityRepository.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CategoryBundle/Entity/KeywordRepositoryInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CategoryBundle/Entity/KeywordRepository.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/persistence/lib/Doctrine/Persistence/Mapping/ClassMetadata.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/ClassMetadataInfo.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/ClassMetadata.php';

        $a = ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService());

        return new \Sulu\Bundle\CategoryBundle\Entity\KeywordRepository($a, $a->getClassMetadata('Sulu\\Bundle\\CategoryBundle\\Entity\\Keyword'));
    }

    /**
     * Gets the public 'sulu.repository.media' shared service.
     *
     * @return \Sulu\Bundle\MediaBundle\Entity\MediaRepository
     */
    protected function getSulu_Repository_MediaService($lazyLoad = true)
    {
        if ($lazyLoad) {
            return $this->services['sulu.repository.media'] = $this->createProxy('MediaRepository_283a6d2', function () {
                return \MediaRepository_283a6d2::staticProxyConstructor(function (&$wrappedInstance, \ProxyManager\Proxy\LazyLoadingInterface $proxy) {
                    $wrappedInstance = $this->getSulu_Repository_MediaService(false);

                    $proxy->setProxyInitializer(null);

                    return true;
                });
            });
        }

        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/Repository/RepositoryInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/Repository/ORM/EntityRepository.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Entity/MediaRepositoryInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Entity/MediaRepository.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/persistence/lib/Doctrine/Persistence/Mapping/ClassMetadata.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/ClassMetadataInfo.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/ClassMetadata.php';

        $a = ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService());

        $instance = new \Sulu\Bundle\MediaBundle\Entity\MediaRepository($a, $a->getClassMetadata('Sulu\\Bundle\\MediaBundle\\Entity\\Media'));

        $instance->setAccessControlQueryEnhancer(($this->privates['sulu_security.access_control_query_enhancer'] ?? $this->getSuluSecurity_AccessControlQueryEnhancerService()));

        return $instance;
    }

    /**
     * Gets the public 'sulu.repository.role' shared service.
     *
     * @return \Sulu\Bundle\SecurityBundle\Entity\RoleRepository
     */
    protected function getSulu_Repository_RoleService($lazyLoad = true)
    {
        if ($lazyLoad) {
            return $this->services['sulu.repository.role'] = $this->createProxy('RoleRepository_c7c4870', function () {
                return \RoleRepository_c7c4870::staticProxyConstructor(function (&$wrappedInstance, \ProxyManager\Proxy\LazyLoadingInterface $proxy) {
                    $wrappedInstance = $this->getSulu_Repository_RoleService(false);

                    $proxy->setProxyInitializer(null);

                    return true;
                });
            });
        }

        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/Repository/RepositoryInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/Repository/ORM/EntityRepository.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Security/Authentication/RoleRepositoryInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SecurityBundle/Entity/RoleRepository.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/persistence/lib/Doctrine/Persistence/Mapping/ClassMetadata.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/ClassMetadataInfo.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/ClassMetadata.php';

        $a = ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService());

        return new \Sulu\Bundle\SecurityBundle\Entity\RoleRepository($a, $a->getClassMetadata('Sulu\\Bundle\\SecurityBundle\\Entity\\Role'));
    }

    /**
     * Gets the public 'sulu.repository.route' shared service.
     *
     * @return \Sulu\Bundle\RouteBundle\Entity\RouteRepository
     */
    protected function getSulu_Repository_RouteService($lazyLoad = true)
    {
        if ($lazyLoad) {
            return $this->services['sulu.repository.route'] = $this->createProxy('RouteRepository_ee5eed9', function () {
                return \RouteRepository_ee5eed9::staticProxyConstructor(function (&$wrappedInstance, \ProxyManager\Proxy\LazyLoadingInterface $proxy) {
                    $wrappedInstance = $this->getSulu_Repository_RouteService(false);

                    $proxy->setProxyInitializer(null);

                    return true;
                });
            });
        }

        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/Repository/RepositoryInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/Repository/ORM/EntityRepository.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/RouteBundle/Entity/RouteRepositoryInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/RouteBundle/Entity/RouteRepository.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/persistence/lib/Doctrine/Persistence/Mapping/ClassMetadata.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/ClassMetadataInfo.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/ClassMetadata.php';

        $a = ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService());

        return new \Sulu\Bundle\RouteBundle\Entity\RouteRepository($a, $a->getClassMetadata('Sulu\\Bundle\\RouteBundle\\Entity\\Route'));
    }

    /**
     * Gets the public 'sulu.repository.tag' shared service.
     *
     * @return \Sulu\Bundle\TagBundle\Entity\TagRepository
     */
    protected function getSulu_Repository_TagService($lazyLoad = true)
    {
        if ($lazyLoad) {
            return $this->services['sulu.repository.tag'] = $this->createProxy('TagRepository_4e72930', function () {
                return \TagRepository_4e72930::staticProxyConstructor(function (&$wrappedInstance, \ProxyManager\Proxy\LazyLoadingInterface $proxy) {
                    $wrappedInstance = $this->getSulu_Repository_TagService(false);

                    $proxy->setProxyInitializer(null);

                    return true;
                });
            });
        }

        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/Repository/RepositoryInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/Repository/ORM/EntityRepository.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/TagBundle/Tag/TagRepositoryInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/TagBundle/Entity/TagRepository.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/persistence/lib/Doctrine/Persistence/Mapping/ClassMetadata.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/ClassMetadataInfo.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/ClassMetadata.php';

        $a = ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService());

        return new \Sulu\Bundle\TagBundle\Entity\TagRepository($a, $a->getClassMetadata('Sulu\\Bundle\\TagBundle\\Entity\\Tag'));
    }

    /**
     * Gets the public 'sulu.repository.user' shared service.
     *
     * @return \Sulu\Bundle\SecurityBundle\Entity\UserRepository
     */
    protected function getSulu_Repository_UserService($lazyLoad = true)
    {
        if ($lazyLoad) {
            return $this->services['sulu.repository.user'] = $this->createProxy('UserRepository_28384ec', function () {
                return \UserRepository_28384ec::staticProxyConstructor(function (&$wrappedInstance, \ProxyManager\Proxy\LazyLoadingInterface $proxy) {
                    $wrappedInstance = $this->getSulu_Repository_UserService(false);

                    $proxy->setProxyInitializer(null);

                    return true;
                });
            });
        }

        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/Repository/RepositoryInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/Repository/ORM/EntityRepository.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Security/Authentication/UserRepositoryInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Component/Persistence/Repository/ORM/OrderByTrait.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SecurityBundle/Entity/UserRepository.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/persistence/lib/Doctrine/Persistence/Mapping/ClassMetadata.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/ClassMetadataInfo.php';
        include_once \dirname(__DIR__, 5).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/ClassMetadata.php';

        $a = ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService());

        return new \Sulu\Bundle\SecurityBundle\Entity\UserRepository($a, $a->getClassMetadata('Sulu\\Bundle\\SecurityBundle\\Entity\\User'));
    }

    /**
     * Gets the public 'sulu.util.node_helper' shared service.
     *
     * @return \Sulu\Component\Util\SuluNodeHelper
     */
    protected function getSulu_Util_NodeHelperService()
    {
        return $this->services['sulu.util.node_helper'] = new \Sulu\Component\Util\SuluNodeHelper(($this->services['doctrine_phpcr.session'] ?? $this->getDoctrinePhpcr_SessionService()), 'i18n', ['base' => 'cmf', 'content' => 'contents', 'route' => 'routes', 'snippet' => 'snippets'], ($this->services['sulu_page.structure.factory'] ?? $this->getSuluPage_Structure_FactoryService()));
    }

    /**
     * Gets the public 'sulu_category.category_manager' shared service.
     *
     * @return \Sulu\Bundle\CategoryBundle\Category\CategoryManager
     */
    protected function getSuluCategory_CategoryManagerService()
    {
        return $this->services['sulu_category.category_manager'] = new \Sulu\Bundle\CategoryBundle\Category\CategoryManager(($this->services['sulu.repository.category'] ?? $this->getSulu_Repository_CategoryService()), ($this->services['sulu.repository.category_meta'] ?? $this->getSulu_Repository_CategoryMetaService()), ($this->services['sulu.repository.category_translation'] ?? $this->getSulu_Repository_CategoryTranslationService()), ($this->services['sulu.repository.user'] ?? $this->getSulu_Repository_UserService()), ($this->services['sulu_category.keyword_manager'] ?? $this->getSuluCategory_KeywordManagerService()), ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()));
    }

    /**
     * Gets the public 'sulu_category.keyword_manager' shared service.
     *
     * @return \Sulu\Bundle\CategoryBundle\Category\KeywordManager
     */
    protected function getSuluCategory_KeywordManagerService()
    {
        return $this->services['sulu_category.keyword_manager'] = new \Sulu\Bundle\CategoryBundle\Category\KeywordManager(($this->services['sulu.repository.keyword'] ?? $this->getSulu_Repository_KeywordService()), ($this->services['sulu.repository.category_translation'] ?? $this->getSulu_Repository_CategoryTranslationService()), ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService()));
    }

    /**
     * Gets the public 'sulu_contact.contact_manager' shared service.
     *
     * @return \Sulu\Bundle\ContactBundle\Contact\ContactManager
     */
    protected function getSuluContact_ContactManagerService()
    {
        return $this->services['sulu_contact.contact_manager'] = new \Sulu\Bundle\ContactBundle\Contact\ContactManager(($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService()), ($this->services['sulu_tag.tag_manager'] ?? $this->getSuluTag_TagManagerService()), ($this->services['sulu_media.media_manager'] ?? $this->getSuluMedia_MediaManagerService()), ($this->services['sulu.repository.account'] ?? $this->getSulu_Repository_AccountService()), ($this->services['doctrine'] ?? $this->getDoctrineService())->getRepository('SuluContactBundle:ContactTitle'), ($this->services['sulu.repository.contact'] ?? $this->getSulu_Repository_ContactService()), ($this->services['sulu.repository.media'] ?? $this->getSulu_Repository_MediaService()), 'Sulu\\Bundle\\ContactBundle\\Entity\\Account');
    }

    /**
     * Gets the public 'sulu_core.array_serializer' shared service.
     *
     * @return \Sulu\Component\Serializer\ArraySerializer
     */
    protected function getSuluCore_ArraySerializerService()
    {
        return $this->services['sulu_core.array_serializer'] = new \Sulu\Component\Serializer\ArraySerializer(($this->services['jms_serializer'] ?? $this->getJmsSerializerService()));
    }

    /**
     * Gets the public 'sulu_core.webspace.request_analyzer' shared service.
     *
     * @return \Sulu\Component\Webspace\Analyzer\RequestAnalyzer
     */
    protected function getSuluCore_Webspace_RequestAnalyzerService()
    {
        $a = ($this->services['sulu_core.webspace.webspace_manager'] ?? $this->getSuluCore_Webspace_WebspaceManagerService());

        return $this->services['sulu_core.webspace.request_analyzer'] = new \Sulu\Component\Webspace\Analyzer\RequestAnalyzer(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), [0 => new \Sulu\Component\Webspace\Analyzer\Attributes\ParameterRequestProcessor($a, 'dev'), 1 => new \Sulu\Component\Webspace\Analyzer\Attributes\UrlRequestProcessor(), 2 => ($this->privates['sulu_custom_urls.request_processor'] ?? $this->getSuluCustomUrls_RequestProcessorService()), 3 => new \Sulu\Component\Webspace\Analyzer\Attributes\WebsiteRequestProcessor($a, ($this->services['sulu.content.mapper'] ?? $this->getSulu_Content_MapperService()), 'dev'), 4 => new \Sulu\Component\Webspace\Analyzer\Attributes\SegmentRequestProcessor('_ss'), 5 => new \Sulu\Component\Webspace\Analyzer\Attributes\PortalInformationRequestProcessor()]);
    }

    /**
     * Gets the public 'sulu_core.webspace.webspace_manager' shared service.
     *
     * @return \Sulu\Component\Webspace\Manager\WebspaceManager
     */
    protected function getSuluCore_Webspace_WebspaceManagerService()
    {
        return $this->services['sulu_core.webspace.webspace_manager'] = new \Sulu\Component\Webspace\Manager\WebspaceManager(($this->privates['sulu_core.webspace.loader.delegator'] ?? $this->getSuluCore_Webspace_Loader_DelegatorService()), ($this->privates['sulu_core.webspace.webspace_manager.url_replacer'] ?? ($this->privates['sulu_core.webspace.webspace_manager.url_replacer'] = new \Sulu\Component\Webspace\Url\Replacer())), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ['config_dir' => (\dirname(__DIR__, 5).'/config/webspaces'), 'cache_dir' => ($this->targetDir.''.'/sulu'), 'debug' => true, 'cache_class' => 'websiteWebspaceCollectionCache', 'base_class' => 'WebspaceCollection'], 'dev', 'localhost', 'http', ($this->services['sulu_page.structure.factory'] ?? $this->getSuluPage_Structure_FactoryService()));
    }

    /**
     * Gets the public 'sulu_custom_urls.manager' shared service.
     *
     * @return \Sulu\Component\CustomUrl\Manager\CustomUrlManager
     */
    protected function getSuluCustomUrls_ManagerService()
    {
        return $this->services['sulu_custom_urls.manager'] = new \Sulu\Component\CustomUrl\Manager\CustomUrlManager(($this->services['sulu_document_manager.document_manager'] ?? $this->getSuluDocumentManager_DocumentManagerService()), ($this->services['sulu_document_manager.document_inspector'] ?? $this->getSuluDocumentManager_DocumentInspectorService()), new \Sulu\Component\CustomUrl\Repository\CustomUrlRepository(($this->services['sulu.phpcr.session'] ?? $this->getSulu_Phpcr_SessionService()), ($this->services['sulu_page.content_repository'] ?? $this->getSuluPage_ContentRepositoryService()), ($this->privates['sulu_custom_urls.domain_generator'] ?? $this->getSuluCustomUrls_DomainGeneratorService()), ($this->services['sulu_security.user_manager'] ?? $this->getSuluSecurity_UserManagerService())), ($this->privates['sulu_document_manager.metadata_factory'] ?? $this->getSuluDocumentManager_MetadataFactoryService()), ($this->privates['sulu_document_manager.path_builder'] ?? $this->getSuluDocumentManager_PathBuilderService()), ($this->services['sulu_core.webspace.webspace_manager'] ?? $this->getSuluCore_Webspace_WebspaceManagerService()), 'dev');
    }

    /**
     * Gets the public 'sulu_document_manager.document_inspector' shared service.
     *
     * @return \Sulu\Bundle\DocumentManagerBundle\Bridge\DocumentInspector
     */
    protected function getSuluDocumentManager_DocumentInspectorService()
    {
        return $this->services['sulu_document_manager.document_inspector'] = new \Sulu\Bundle\DocumentManagerBundle\Bridge\DocumentInspector(($this->privates['sulu_document_manager.document_registry'] ?? ($this->privates['sulu_document_manager.document_registry'] = new \Sulu\Component\DocumentManager\DocumentRegistry('en'))), ($this->privates['sulu_document_manager.path_segment_registry'] ?? $this->getSuluDocumentManager_PathSegmentRegistryService()), ($this->privates['sulu_document_manager.namespace_registry'] ?? $this->getSuluDocumentManager_NamespaceRegistryService()), ($this->privates['sulu_document_manager.proxy_factory'] ?? $this->getSuluDocumentManager_ProxyFactoryService()), ($this->privates['sulu_document_manager.metadata_factory'] ?? $this->getSuluDocumentManager_MetadataFactoryService()), ($this->services['sulu_page.structure.factory'] ?? $this->getSuluPage_Structure_FactoryService()), ($this->services['sulu_document_manager.property_encoder'] ?? $this->getSuluDocumentManager_PropertyEncoderService()), ($this->services['sulu_core.webspace.webspace_manager'] ?? $this->getSuluCore_Webspace_WebspaceManagerService()));
    }

    /**
     * Gets the public 'sulu_document_manager.document_manager' shared service.
     *
     * @return \Sulu\Component\DocumentManager\DocumentManager
     */
    protected function getSuluDocumentManager_DocumentManagerService()
    {
        $a = ($this->privates['sulu_document_manager.node_manager'] ?? $this->getSuluDocumentManager_NodeManagerService());

        if (isset($this->services['sulu_document_manager.document_manager'])) {
            return $this->services['sulu_document_manager.document_manager'];
        }

        return $this->services['sulu_document_manager.document_manager'] = new \Sulu\Component\DocumentManager\DocumentManager(($this->privates['sulu_document_manager.event_dispatcher.standard'] ?? $this->getSuluDocumentManager_EventDispatcher_StandardService()), $a);
    }

    /**
     * Gets the public 'sulu_document_manager.live_session' shared service.
     *
     * @return \Sulu\Bundle\DocumentManagerBundle\Session\Session
     */
    protected function getSuluDocumentManager_LiveSessionService()
    {
        return $this->services['sulu_document_manager.live_session'] = new \Sulu\Bundle\DocumentManagerBundle\Session\Session([($this->privates['doctrine_phpcr.jackalope.repository.factory.service.doctrinedbal'] ?? ($this->privates['doctrine_phpcr.jackalope.repository.factory.service.doctrinedbal'] = new \Jackalope\RepositoryFactoryDoctrineDBAL()))->getRepository(['jackalope.doctrine_dbal_connection' => ($this->services['doctrine.dbal.default_connection'] ?? $this->getDoctrine_Dbal_DefaultConnectionService()), 'jackalope.check_login_on_server' => false]), 'login'](new \PHPCR\SimpleCredentials('admin', 'admin'), $this->getEnv('string:PHPCR_WORKSPACE').'_live'));
    }

    /**
     * Gets the public 'sulu_document_manager.metadata_factory.base' shared service.
     *
     * @return \Sulu\Component\DocumentManager\Metadata\BaseMetadataFactory
     */
    protected function getSuluDocumentManager_MetadataFactory_BaseService()
    {
        return $this->services['sulu_document_manager.metadata_factory.base'] = new \Sulu\Component\DocumentManager\Metadata\BaseMetadataFactory(($this->privates['sulu_document_manager.event_dispatcher.standard'] ?? $this->getSuluDocumentManager_EventDispatcher_StandardService()), $this->parameters['sulu_document_manager.mapping']);
    }

    /**
     * Gets the public 'sulu_document_manager.property_encoder' shared service.
     *
     * @return \Sulu\Bundle\DocumentManagerBundle\Bridge\PropertyEncoder
     */
    protected function getSuluDocumentManager_PropertyEncoderService()
    {
        return $this->services['sulu_document_manager.property_encoder'] = new \Sulu\Bundle\DocumentManagerBundle\Bridge\PropertyEncoder(($this->privates['sulu_document_manager.namespace_registry'] ?? $this->getSuluDocumentManager_NamespaceRegistryService()));
    }

    /**
     * Gets the public 'sulu_markup.parser.html_extractor' shared service.
     *
     * @return \Sulu\Bundle\MarkupBundle\Markup\HtmlTagExtractor
     */
    protected function getSuluMarkup_Parser_HtmlExtractorService()
    {
        return $this->services['sulu_markup.parser.html_extractor'] = new \Sulu\Bundle\MarkupBundle\Markup\HtmlTagExtractor('sulu');
    }

    /**
     * Gets the public 'sulu_media.collection_repository' shared service.
     *
     * @return \Sulu\Bundle\MediaBundle\Entity\CollectionRepository
     */
    protected function getSuluMedia_CollectionRepositoryService()
    {
        $this->services['sulu_media.collection_repository'] = $instance = ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService())->getRepository('SuluMediaBundle:Collection');

        $instance->setAccessControlQueryEnhancer(($this->privates['sulu_security.access_control_query_enhancer'] ?? $this->getSuluSecurity_AccessControlQueryEnhancerService()));

        return $instance;
    }

    /**
     * Gets the public 'sulu_media.format_cache' shared service.
     *
     * @return \Sulu\Bundle\MediaBundle\Media\FormatCache\LocalFormatCache
     */
    protected function getSuluMedia_FormatCacheService()
    {
        return $this->services['sulu_media.format_cache'] = new \Sulu\Bundle\MediaBundle\Media\FormatCache\LocalFormatCache(($this->services['.container.private.filesystem'] ?? ($this->services['.container.private.filesystem'] = new \Symfony\Component\Filesystem\Filesystem())), (\dirname(__DIR__, 5).'/public/uploads/media'), '/uploads/media/{slug}', 10);
    }

    /**
     * Gets the public 'sulu_media.format_manager' shared service.
     *
     * @return \Sulu\Bundle\MediaBundle\Media\FormatManager\FormatManager
     */
    protected function getSuluMedia_FormatManagerService()
    {
        $a = ($this->privates['sulu_media.adapter.imagick'] ?? ($this->privates['sulu_media.adapter.imagick'] = new \Imagine\Imagick\Imagine()));
        $b = new \Sulu\Bundle\MediaBundle\Media\ImageConverter\TransformationPool();
        $b->add(($this->services['sulu_media.image.transformation.crop'] ?? ($this->services['sulu_media.image.transformation.crop'] = new \Sulu\Bundle\MediaBundle\Media\ImageConverter\Transformation\CropTransformation())), 'crop');
        $b->add(($this->services['sulu_media.image.transformation.paste'] ?? $this->getSuluMedia_Image_Transformation_PasteService()), 'paste');
        $b->add(($this->services['sulu_media.image.transformation.blur'] ?? ($this->services['sulu_media.image.transformation.blur'] = new \Sulu\Bundle\MediaBundle\Media\ImageConverter\Transformation\BlurTransformation())), 'blur');
        $b->add(($this->services['sulu_media.image.transformation.gamma'] ?? ($this->services['sulu_media.image.transformation.gamma'] = new \Sulu\Bundle\MediaBundle\Media\ImageConverter\Transformation\GammaTransformation())), 'gamma');
        $b->add(($this->services['sulu_media.image.transformation.grayscale'] ?? ($this->services['sulu_media.image.transformation.grayscale'] = new \Sulu\Bundle\MediaBundle\Media\ImageConverter\Transformation\GrayscaleTransformation())), 'grayscale');
        $b->add(($this->services['sulu_media.image.transformation.negative'] ?? ($this->services['sulu_media.image.transformation.negative'] = new \Sulu\Bundle\MediaBundle\Media\ImageConverter\Transformation\NegativeTransformation())), 'negative');
        $b->add(($this->services['sulu_media.image.transformation.sharpen'] ?? ($this->services['sulu_media.image.transformation.sharpen'] = new \Sulu\Bundle\MediaBundle\Media\ImageConverter\Transformation\SharpenTransformation())), 'sharpen');

        return $this->services['sulu_media.format_manager'] = new \Sulu\Bundle\MediaBundle\Media\FormatManager\FormatManager(($this->services['sulu.repository.media'] ?? $this->getSulu_Repository_MediaService()), ($this->services['sulu_media.format_cache'] ?? $this->getSuluMedia_FormatCacheService()), new \Sulu\Bundle\MediaBundle\Media\ImageConverter\ImagineImageConverter($a, ($this->services['sulu_media.storage'] ?? $this->getSuluMedia_StorageService()), new \Sulu\Bundle\MediaBundle\Media\ImageConverter\MediaImageExtractor($a, new \Sulu\Bundle\MediaBundle\Media\Video\VideoThumbnailService(NULL), 'gs'), $b, new \Sulu\Bundle\MediaBundle\Media\ImageConverter\Focus\Focus(), new \Sulu\Bundle\MediaBundle\Media\ImageConverter\Scaler\Scaler(), new \Sulu\Bundle\MediaBundle\Media\ImageConverter\Cropper\Cropper(), $this->parameters['sulu_media.image.formats'], $this->parameters['sulu_media.format_manager.mime_types'], new \Contao\ImagineSvg\Imagine()), true, $this->parameters['sulu_media.format_manager.response_headers'], $this->parameters['sulu_media.image.formats'], ($this->privates['monolog.logger'] ?? $this->getMonolog_LoggerService()));
    }

    /**
     * Gets the public 'sulu_media.image.transformation.blur' shared service.
     *
     * @return \Sulu\Bundle\MediaBundle\Media\ImageConverter\Transformation\BlurTransformation
     */
    protected function getSuluMedia_Image_Transformation_BlurService()
    {
        return $this->services['sulu_media.image.transformation.blur'] = new \Sulu\Bundle\MediaBundle\Media\ImageConverter\Transformation\BlurTransformation();
    }

    /**
     * Gets the public 'sulu_media.image.transformation.crop' shared service.
     *
     * @return \Sulu\Bundle\MediaBundle\Media\ImageConverter\Transformation\CropTransformation
     */
    protected function getSuluMedia_Image_Transformation_CropService()
    {
        return $this->services['sulu_media.image.transformation.crop'] = new \Sulu\Bundle\MediaBundle\Media\ImageConverter\Transformation\CropTransformation();
    }

    /**
     * Gets the public 'sulu_media.image.transformation.gamma' shared service.
     *
     * @return \Sulu\Bundle\MediaBundle\Media\ImageConverter\Transformation\GammaTransformation
     */
    protected function getSuluMedia_Image_Transformation_GammaService()
    {
        return $this->services['sulu_media.image.transformation.gamma'] = new \Sulu\Bundle\MediaBundle\Media\ImageConverter\Transformation\GammaTransformation();
    }

    /**
     * Gets the public 'sulu_media.image.transformation.grayscale' shared service.
     *
     * @return \Sulu\Bundle\MediaBundle\Media\ImageConverter\Transformation\GrayscaleTransformation
     */
    protected function getSuluMedia_Image_Transformation_GrayscaleService()
    {
        return $this->services['sulu_media.image.transformation.grayscale'] = new \Sulu\Bundle\MediaBundle\Media\ImageConverter\Transformation\GrayscaleTransformation();
    }

    /**
     * Gets the public 'sulu_media.image.transformation.negative' shared service.
     *
     * @return \Sulu\Bundle\MediaBundle\Media\ImageConverter\Transformation\NegativeTransformation
     */
    protected function getSuluMedia_Image_Transformation_NegativeService()
    {
        return $this->services['sulu_media.image.transformation.negative'] = new \Sulu\Bundle\MediaBundle\Media\ImageConverter\Transformation\NegativeTransformation();
    }

    /**
     * Gets the public 'sulu_media.image.transformation.paste' shared service.
     *
     * @return \Sulu\Bundle\MediaBundle\Media\ImageConverter\Transformation\PasteTransformation
     */
    protected function getSuluMedia_Image_Transformation_PasteService()
    {
        return $this->services['sulu_media.image.transformation.paste'] = new \Sulu\Bundle\MediaBundle\Media\ImageConverter\Transformation\PasteTransformation(($this->privates['sulu_media.adapter.imagick'] ?? ($this->privates['sulu_media.adapter.imagick'] = new \Imagine\Imagick\Imagine())), ($this->privates['file_locator'] ?? ($this->privates['file_locator'] = new \Symfony\Component\HttpKernel\Config\FileLocator(($this->services['kernel'] ?? $this->get('kernel', 1))))));
    }

    /**
     * Gets the public 'sulu_media.image.transformation.sharpen' shared service.
     *
     * @return \Sulu\Bundle\MediaBundle\Media\ImageConverter\Transformation\SharpenTransformation
     */
    protected function getSuluMedia_Image_Transformation_SharpenService()
    {
        return $this->services['sulu_media.image.transformation.sharpen'] = new \Sulu\Bundle\MediaBundle\Media\ImageConverter\Transformation\SharpenTransformation();
    }

    /**
     * Gets the public 'sulu_media.media_manager' shared service.
     *
     * @return \Sulu\Bundle\MediaBundle\Media\Manager\MediaManager
     */
    protected function getSuluMedia_MediaManagerService()
    {
        $a = new \Sulu\Bundle\MediaBundle\Media\FileValidator\FileValidator();
        $a->setMaxFileSize('256MB');
        $a->setBlockedMimeTypes([]);

        return $this->services['sulu_media.media_manager'] = new \Sulu\Bundle\MediaBundle\Media\Manager\MediaManager(($this->services['sulu.repository.media'] ?? $this->getSulu_Repository_MediaService()), ($this->services['sulu_media.collection_repository'] ?? $this->getSuluMedia_CollectionRepositoryService()), ($this->services['sulu.repository.user'] ?? $this->getSulu_Repository_UserService()), ($this->services['sulu.repository.category'] ?? $this->getSulu_Repository_CategoryService()), ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService()), ($this->services['sulu_media.storage'] ?? $this->getSuluMedia_StorageService()), $a, ($this->services['sulu_media.format_manager'] ?? $this->getSuluMedia_FormatManagerService()), ($this->services['sulu_tag.tag_manager'] ?? $this->getSuluTag_TagManagerService()), ($this->privates['sulu_media.type_manager'] ?? $this->getSuluMedia_TypeManagerService()), ($this->services['sulu.content.path_cleaner'] ?? $this->getSulu_Content_PathCleanerService()), NULL, NULL, NULL, $this->parameters['sulu_security.permissions'], '/media/{id}/download/{slug}', '256MB', NULL, '/admin/media/{id}/download/{slug}');
    }

    /**
     * Gets the public 'sulu_media.storage' shared service.
     *
     * @return \Sulu\Bundle\MediaBundle\Media\Storage\LocalStorage
     */
    protected function getSuluMedia_StorageService()
    {
        return $this->services['sulu_media.storage'] = new \Sulu\Bundle\MediaBundle\Media\Storage\LocalStorage((\dirname(__DIR__, 4).'/uploads/media'), 10, new \Symfony\Component\Filesystem\Filesystem(), ($this->privates['monolog.logger'] ?? $this->getMonolog_LoggerService()));
    }

    /**
     * Gets the public 'sulu_page.compat.structure.legacy_property_factory' shared service.
     *
     * @return \Sulu\Component\Content\Compat\Structure\LegacyPropertyFactory
     */
    protected function getSuluPage_Compat_Structure_LegacyPropertyFactoryService()
    {
        return $this->services['sulu_page.compat.structure.legacy_property_factory'] = new \Sulu\Component\Content\Compat\Structure\LegacyPropertyFactory(($this->privates['sulu_document_manager.namespace_registry'] ?? $this->getSuluDocumentManager_NamespaceRegistryService()));
    }

    /**
     * Gets the public 'sulu_page.content_repository' shared service.
     *
     * @return \Sulu\Component\Content\Repository\ContentRepository
     */
    protected function getSuluPage_ContentRepositoryService()
    {
        return $this->services['sulu_page.content_repository'] = new \Sulu\Component\Content\Repository\ContentRepository(($this->services['sulu.phpcr.session'] ?? $this->getSulu_Phpcr_SessionService()), ($this->services['sulu_document_manager.property_encoder'] ?? $this->getSuluDocumentManager_PropertyEncoderService()), ($this->services['sulu_core.webspace.webspace_manager'] ?? $this->getSuluCore_Webspace_WebspaceManagerService()), ($this->services['sulu.content.localization_finder'] ?? $this->getSulu_Content_LocalizationFinderService()), ($this->services['sulu.content.structure_manager'] ?? $this->getSulu_Content_StructureManagerService()), ($this->services['sulu.util.node_helper'] ?? $this->getSulu_Util_NodeHelperService()), ($this->privates['sulu_security.system_store'] ?? $this->getSuluSecurity_SystemStoreService()), $this->parameters['sulu_security.permissions']);
    }

    /**
     * Gets the public 'sulu_page.extension.manager' shared service.
     *
     * @return \Sulu\Component\Content\Extension\ExtensionManager
     */
    protected function getSuluPage_Extension_ManagerService()
    {
        $this->services['sulu_page.extension.manager'] = $instance = new \Sulu\Component\Content\Extension\ExtensionManager();

        $instance->addExtension(new \Sulu\Bundle\PageBundle\Content\Structure\SeoStructureExtension());
        $instance->addExtension(new \Sulu\Bundle\PageBundle\Content\Structure\ExcerptStructureExtension(($this->services['sulu.content.structure_manager'] ?? $this->getSulu_Content_StructureManagerService()), ($this->services['sulu.content.type_manager'] ?? $this->getSulu_Content_TypeManagerService()), ($this->privates['sulu_page.export.manager'] ?? $this->getSuluPage_Export_ManagerService()), ($this->privates['sulu_page.import.manager'] ?? $this->getSuluPage_Import_ManagerService()), ($this->privates['sulu_search.search.factory'] ?? ($this->privates['sulu_search.search.factory'] = new \Sulu\Bundle\SearchBundle\Search\Factory()))));

        return $instance;
    }

    /**
     * Gets the public 'sulu_page.structure.factory' shared service.
     *
     * @return \Sulu\Component\Content\Metadata\Factory\StructureMetadataFactory
     */
    protected function getSuluPage_Structure_FactoryService()
    {
        return $this->services['sulu_page.structure.factory'] = new \Sulu\Component\Content\Metadata\Factory\StructureMetadataFactory(new \Sulu\Component\Content\Metadata\Loader\StructureXmlLoader(new \Sulu\Bundle\HttpCacheBundle\CacheLifetime\CacheLifetimeResolver(), new \Sulu\Component\Content\Metadata\Parser\PropertiesXmlParser(($this->services['translator'] ?? $this->getTranslatorService()), $this->parameters['sulu_core.translated_locales']), new \Sulu\Component\Content\Metadata\Parser\SchemaXmlParser(), ($this->services['sulu.content.type_manager'] ?? $this->getSulu_Content_TypeManagerService()), $this->parameters['sulu.content.structure.required_properties'], $this->parameters['sulu.content.structure.required_tags']), $this->parameters['sulu.content.structure.paths'], $this->parameters['sulu.content.structure.default_types'], ($this->targetDir.''.'/sulu/structures'), true);
    }

    /**
     * Gets the public 'sulu_security.mask_converter' shared service.
     *
     * @return \Sulu\Component\Security\Authorization\MaskConverter
     */
    protected function getSuluSecurity_MaskConverterService()
    {
        return $this->services['sulu_security.mask_converter'] = new \Sulu\Component\Security\Authorization\MaskConverter($this->parameters['permissions']);
    }

    /**
     * Gets the public 'sulu_security.salt_generator' shared service.
     *
     * @return \Sulu\Component\Security\Authentication\SaltGenerator
     */
    protected function getSuluSecurity_SaltGeneratorService()
    {
        return $this->services['sulu_security.salt_generator'] = new \Sulu\Component\Security\Authentication\SaltGenerator();
    }

    /**
     * Gets the public 'sulu_security.user_manager' shared service.
     *
     * @return \Sulu\Bundle\SecurityBundle\UserManager\UserManager
     */
    protected function getSuluSecurity_UserManagerService()
    {
        $a = ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService());

        return $this->services['sulu_security.user_manager'] = new \Sulu\Bundle\SecurityBundle\UserManager\UserManager($a, NULL, ($this->services['sulu.repository.role'] ?? $this->getSulu_Repository_RoleService()), $a->getRepository('SuluSecurityBundle:Group'), ($this->services['sulu_contact.contact_manager'] ?? $this->getSuluContact_ContactManagerService()), ($this->services['sulu_security.salt_generator'] ?? ($this->services['sulu_security.salt_generator'] = new \Sulu\Component\Security\Authentication\SaltGenerator())), ($this->services['sulu.repository.user'] ?? $this->getSulu_Repository_UserService()));
    }

    /**
     * Gets the public 'sulu_snippet.default_snippet.manager' shared service.
     *
     * @return \Sulu\Bundle\SnippetBundle\Snippet\DefaultSnippetManager
     */
    protected function getSuluSnippet_DefaultSnippet_ManagerService()
    {
        return $this->services['sulu_snippet.default_snippet.manager'] = new \Sulu\Bundle\SnippetBundle\Snippet\DefaultSnippetManager(new \Sulu\Component\Webspace\Settings\SettingsManager(new \Sulu\Bundle\DocumentManagerBundle\Session\SessionManager(($this->services['doctrine_phpcr.session'] ?? $this->getDoctrinePhpcr_SessionService()), ($this->services['sulu_document_manager.live_session'] ?? $this->getSuluDocumentManager_LiveSessionService())), ($this->services['sulu.phpcr.session'] ?? $this->getSulu_Phpcr_SessionService())), ($this->services['sulu_document_manager.document_manager'] ?? $this->getSuluDocumentManager_DocumentManagerService()), ($this->services['sulu_core.webspace.webspace_manager'] ?? $this->getSuluCore_Webspace_WebspaceManagerService()), ($this->privates['sulu_document_manager.document_registry'] ?? ($this->privates['sulu_document_manager.document_registry'] = new \Sulu\Component\DocumentManager\DocumentRegistry('en'))), $this->parameters['sulu_snippet.areas']);
    }

    /**
     * Gets the public 'sulu_snippet.resolver' shared service.
     *
     * @return \Sulu\Bundle\SnippetBundle\Snippet\SnippetResolver
     */
    protected function getSuluSnippet_ResolverService()
    {
        return $this->services['sulu_snippet.resolver'] = new \Sulu\Bundle\SnippetBundle\Snippet\SnippetResolver(($this->services['sulu.content.mapper'] ?? $this->getSulu_Content_MapperService()), ($this->services['sulu_website.resolver.structure'] ?? $this->getSuluWebsite_Resolver_StructureService()));
    }

    /**
     * Gets the public 'sulu_tag.tag_manager' shared service.
     *
     * @return \Sulu\Bundle\TagBundle\Tag\TagManager
     */
    protected function getSuluTag_TagManagerService()
    {
        return $this->services['sulu_tag.tag_manager'] = new \Sulu\Bundle\TagBundle\Tag\TagManager(($this->services['sulu.repository.tag'] ?? $this->getSulu_Repository_TagService()), ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()));
    }

    /**
     * Gets the public 'sulu_website.resolver.structure' shared service.
     *
     * @return \Sulu\Bundle\WebsiteBundle\Resolver\StructureResolver
     */
    protected function getSuluWebsite_Resolver_StructureService()
    {
        return $this->services['sulu_website.resolver.structure'] = new \Sulu\Bundle\WebsiteBundle\Resolver\StructureResolver(($this->services['sulu.content.type_manager'] ?? $this->getSulu_Content_TypeManagerService()), ($this->services['sulu_page.extension.manager'] ?? $this->getSuluPage_Extension_ManagerService()));
    }

    /**
     * Gets the public 'translator' shared service.
     *
     * @return \Symfony\Bundle\FrameworkBundle\Translation\Translator
     */
    protected function getTranslatorService()
    {
        $this->services['translator'] = $instance = new \Symfony\Bundle\FrameworkBundle\Translation\Translator(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'translation.loader.csv' => ['privates', 'translation.loader.csv', 'getTranslation_Loader_CsvService', true],
            'translation.loader.dat' => ['privates', 'translation.loader.dat', 'getTranslation_Loader_DatService', true],
            'translation.loader.ini' => ['privates', 'translation.loader.ini', 'getTranslation_Loader_IniService', true],
            'translation.loader.json' => ['privates', 'translation.loader.json', 'getTranslation_Loader_JsonService', true],
            'translation.loader.mo' => ['privates', 'translation.loader.mo', 'getTranslation_Loader_MoService', true],
            'translation.loader.php' => ['privates', 'translation.loader.php', 'getTranslation_Loader_PhpService', true],
            'translation.loader.po' => ['privates', 'translation.loader.po', 'getTranslation_Loader_PoService', true],
            'translation.loader.qt' => ['privates', 'translation.loader.qt', 'getTranslation_Loader_QtService', true],
            'translation.loader.res' => ['privates', 'translation.loader.res', 'getTranslation_Loader_ResService', true],
            'translation.loader.xliff' => ['privates', 'translation.loader.xliff', 'getTranslation_Loader_XliffService', true],
            'translation.loader.yml' => ['privates', 'translation.loader.yml', 'getTranslation_Loader_YmlService', true],
        ], [
            'translation.loader.csv' => '?',
            'translation.loader.dat' => '?',
            'translation.loader.ini' => '?',
            'translation.loader.json' => '?',
            'translation.loader.mo' => '?',
            'translation.loader.php' => '?',
            'translation.loader.po' => '?',
            'translation.loader.qt' => '?',
            'translation.loader.res' => '?',
            'translation.loader.xliff' => '?',
            'translation.loader.yml' => '?',
        ]), new \Symfony\Component\Translation\Formatter\MessageFormatter(new \Symfony\Component\Translation\IdentityTranslator()), 'en', ['translation.loader.php' => [0 => 'php'], 'translation.loader.yml' => [0 => 'yaml', 1 => 'yml'], 'translation.loader.xliff' => [0 => 'xlf', 1 => 'xliff'], 'translation.loader.po' => [0 => 'po'], 'translation.loader.mo' => [0 => 'mo'], 'translation.loader.qt' => [0 => 'ts'], 'translation.loader.csv' => [0 => 'csv'], 'translation.loader.res' => [0 => 'res'], 'translation.loader.dat' => [0 => 'dat'], 'translation.loader.ini' => [0 => 'ini'], 'translation.loader.json' => [0 => 'json']], ['cache_dir' => ($this->targetDir.''.'/translations'), 'debug' => true, 'resource_files' => ['af' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.af.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.af.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.af.xlf')], 'ar' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.ar.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.ar.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.ar.xlf')], 'az' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.az.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.az.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.az.xlf')], 'be' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.be.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.be.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.be.xlf')], 'bg' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.bg.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.bg.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.bg.xlf')], 'bs' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.bs.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.bs.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.bs.xlf')], 'ca' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.ca.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.ca.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.ca.xlf')], 'cs' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.cs.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.cs.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.cs.xlf')], 'cy' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.cy.xlf')], 'da' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.da.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.da.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.da.xlf')], 'de' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.de.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.de.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.de.xlf'), 3 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SearchBundle/Resources/translations/admin.de.json'), 4 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/ContactBundle/Resources/translations/admin.de.json'), 5 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Resources/translations/admin.de.json'), 6 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SecurityBundle/Resources/translations/admin.de.json'), 7 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CategoryBundle/Resources/translations/admin.de.json'), 8 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SnippetBundle/Resources/translations/admin.de.json'), 9 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/PageBundle/Resources/translations/admin.de.json'), 10 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/TagBundle/Resources/translations/admin.de.json'), 11 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Resources/translations/admin.de.json'), 12 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/LocationBundle/Resources/translations/admin.de.json'), 13 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CustomUrlBundle/Resources/translations/admin.de.json')], 'el' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.el.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.el.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.el.xlf')], 'en' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.en.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.en.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.en.xlf'), 3 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SearchBundle/Resources/translations/admin.en.json'), 4 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/ContactBundle/Resources/translations/admin.en.json'), 5 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Resources/translations/admin.en.json'), 6 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SecurityBundle/Resources/translations/admin.en.json'), 7 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CategoryBundle/Resources/translations/admin.en.json'), 8 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SnippetBundle/Resources/translations/admin.en.json'), 9 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/PageBundle/Resources/translations/admin.en.json'), 10 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/TagBundle/Resources/translations/admin.en.json'), 11 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Resources/translations/admin.en.json'), 12 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/LocationBundle/Resources/translations/admin.en.json'), 13 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CustomUrlBundle/Resources/translations/admin.en.json')], 'es' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.es.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.es.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.es.xlf')], 'et' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.et.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.et.xlf')], 'eu' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.eu.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.eu.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.eu.xlf')], 'fa' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.fa.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.fa.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.fa.xlf')], 'fi' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.fi.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.fi.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.fi.xlf')], 'fr' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.fr.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.fr.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.fr.xlf')], 'gl' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.gl.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.gl.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.gl.xlf')], 'he' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.he.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.he.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.he.xlf')], 'hr' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.hr.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.hr.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.hr.xlf')], 'hu' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.hu.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.hu.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.hu.xlf')], 'hy' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.hy.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.hy.xlf')], 'id' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.id.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.id.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.id.xlf')], 'it' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.it.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.it.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.it.xlf')], 'ja' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.ja.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.ja.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.ja.xlf')], 'lb' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.lb.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.lb.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.lb.xlf')], 'lt' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.lt.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.lt.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.lt.xlf')], 'lv' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.lv.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.lv.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.lv.xlf')], 'mn' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.mn.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.mn.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.mn.xlf')], 'nb' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.nb.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.nb.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.nb.xlf')], 'nl' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.nl.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.nl.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.nl.xlf')], 'nn' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.nn.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.nn.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.nn.xlf')], 'no' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.no.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.no.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.no.xlf')], 'pl' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.pl.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.pl.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.pl.xlf')], 'pt' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.pt.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.pt.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.pt.xlf')], 'pt_BR' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.pt_BR.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.pt_BR.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.pt_BR.xlf')], 'ro' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.ro.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.ro.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.ro.xlf')], 'ru' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.ru.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.ru.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.ru.xlf')], 'sk' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.sk.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.sk.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.sk.xlf')], 'sl' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.sl.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.sl.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.sl.xlf')], 'sq' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.sq.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.sq.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.sq.xlf')], 'sr_Cyrl' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.sr_Cyrl.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.sr_Cyrl.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.sr_Cyrl.xlf')], 'sr_Latn' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.sr_Latn.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.sr_Latn.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.sr_Latn.xlf')], 'sv' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.sv.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.sv.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.sv.xlf')], 'th' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.th.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.th.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.th.xlf')], 'tl' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.tl.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.tl.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.tl.xlf')], 'tr' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.tr.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.tr.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.tr.xlf')], 'uk' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.uk.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.uk.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.uk.xlf')], 'vi' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.vi.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.vi.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.vi.xlf')], 'zh_CN' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.zh_CN.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.zh_CN.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.zh_CN.xlf')], 'zh_TW' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations/validators.zh_TW.xlf'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations/validators.zh_TW.xlf'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations/security.zh_TW.xlf')]], 'scanned_directories' => [0 => (\dirname(__DIR__, 5).'/vendor/symfony/validator/Resources/translations'), 1 => (\dirname(__DIR__, 5).'/vendor/symfony/form/Resources/translations'), 2 => (\dirname(__DIR__, 5).'/vendor/symfony/security-core/Resources/translations'), 3 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SearchBundle/Resources/translations'), 4 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/ContactBundle/Resources/translations'), 5 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Resources/translations'), 6 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SecurityBundle/Resources/translations'), 7 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CategoryBundle/Resources/translations'), 8 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SnippetBundle/Resources/translations'), 9 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/PageBundle/Resources/translations'), 10 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/TagBundle/Resources/translations'), 11 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Resources/translations'), 12 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/LocationBundle/Resources/translations'), 13 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CustomUrlBundle/Resources/translations'), 14 => (\dirname(__DIR__, 5).'/translations'), 15 => (\dirname(__DIR__, 5).'/vendor/symfony/framework-bundle/translations'), 16 => (\dirname(__DIR__, 5).'/vendor/symfony/twig-bundle/translations'), 17 => (\dirname(__DIR__, 5).'/vendor/symfony/monolog-bundle/translations'), 18 => (\dirname(__DIR__, 5).'/vendor/symfony/swiftmailer-bundle/translations'), 19 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CoreBundle/translations'), 20 => (\dirname(__DIR__, 5).'/vendor/doctrine/doctrine-bundle/translations'), 21 => (\dirname(__DIR__, 5).'/vendor/doctrine/doctrine-fixtures-bundle/translations'), 22 => (\dirname(__DIR__, 5).'/vendor/doctrine/phpcr-bundle/src/translations'), 23 => (\dirname(__DIR__, 5).'/vendor/friendsofsymfony/rest-bundle/translations'), 24 => (\dirname(__DIR__, 5).'/vendor/handcraftedinthealps/rest-routing-bundle/translations'), 25 => (\dirname(__DIR__, 5).'/vendor/jms/serializer-bundle/translations'), 26 => (\dirname(__DIR__, 5).'/vendor/massive/search-bundle/translations'), 27 => (\dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache-bundle/src/translations'), 28 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/PersistenceBundle/translations'), 29 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/HttpCacheBundle/translations'), 30 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/DocumentManagerBundle/translations'), 31 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/HashBundle/translations'), 32 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/RouteBundle/translations'), 33 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MarkupBundle/translations'), 34 => (\dirname(__DIR__, 5).'/vendor/dantleech/phpcr-migrations-bundle/translations'), 35 => (\dirname(__DIR__, 5).'/vendor/massive/build-bundle/translations'), 36 => (\dirname(__DIR__, 5).'/vendor/symfony/web-profiler-bundle/translations'), 37 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/TestBundle/translations'), 38 => (\dirname(__DIR__, 5).'/vendor/symfony/debug-bundle/translations'), 39 => (\dirname(__DIR__, 5).'/vendor/symfony-cmf/routing-bundle/src/translations'), 40 => (\dirname(__DIR__, 5).'/vendor/stof/doctrine-extensions-bundle/translations')], 'cache_vary' => ['scanned_directories' => [0 => 'vendor/symfony/validator/Resources/translations', 1 => 'vendor/symfony/form/Resources/translations', 2 => 'vendor/symfony/security-core/Resources/translations', 3 => 'vendor/sulu/sulu/src/Sulu/Bundle/SearchBundle/Resources/translations', 4 => 'vendor/sulu/sulu/src/Sulu/Bundle/ContactBundle/Resources/translations', 5 => 'vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/Resources/translations', 6 => 'vendor/sulu/sulu/src/Sulu/Bundle/SecurityBundle/Resources/translations', 7 => 'vendor/sulu/sulu/src/Sulu/Bundle/CategoryBundle/Resources/translations', 8 => 'vendor/sulu/sulu/src/Sulu/Bundle/SnippetBundle/Resources/translations', 9 => 'vendor/sulu/sulu/src/Sulu/Bundle/PageBundle/Resources/translations', 10 => 'vendor/sulu/sulu/src/Sulu/Bundle/TagBundle/Resources/translations', 11 => 'vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Resources/translations', 12 => 'vendor/sulu/sulu/src/Sulu/Bundle/LocationBundle/Resources/translations', 13 => 'vendor/sulu/sulu/src/Sulu/Bundle/CustomUrlBundle/Resources/translations', 14 => 'translations', 15 => 'vendor/symfony/framework-bundle/translations', 16 => 'vendor/symfony/twig-bundle/translations', 17 => 'vendor/symfony/monolog-bundle/translations', 18 => 'vendor/symfony/swiftmailer-bundle/translations', 19 => 'vendor/sulu/sulu/src/Sulu/Bundle/CoreBundle/translations', 20 => 'vendor/doctrine/doctrine-bundle/translations', 21 => 'vendor/doctrine/doctrine-fixtures-bundle/translations', 22 => 'vendor/doctrine/phpcr-bundle/src/translations', 23 => 'vendor/friendsofsymfony/rest-bundle/translations', 24 => 'vendor/handcraftedinthealps/rest-routing-bundle/translations', 25 => 'vendor/jms/serializer-bundle/translations', 26 => 'vendor/massive/search-bundle/translations', 27 => 'vendor/friendsofsymfony/http-cache-bundle/src/translations', 28 => 'vendor/sulu/sulu/src/Sulu/Bundle/PersistenceBundle/translations', 29 => 'vendor/sulu/sulu/src/Sulu/Bundle/HttpCacheBundle/translations', 30 => 'vendor/sulu/sulu/src/Sulu/Bundle/DocumentManagerBundle/translations', 31 => 'vendor/sulu/sulu/src/Sulu/Bundle/HashBundle/translations', 32 => 'vendor/sulu/sulu/src/Sulu/Bundle/RouteBundle/translations', 33 => 'vendor/sulu/sulu/src/Sulu/Bundle/MarkupBundle/translations', 34 => 'vendor/dantleech/phpcr-migrations-bundle/translations', 35 => 'vendor/massive/build-bundle/translations', 36 => 'vendor/symfony/web-profiler-bundle/translations', 37 => 'vendor/sulu/sulu/src/Sulu/Bundle/TestBundle/translations', 38 => 'vendor/symfony/debug-bundle/translations', 39 => 'vendor/symfony-cmf/routing-bundle/src/translations', 40 => 'vendor/stof/doctrine-extensions-bundle/translations']]], []);

        $instance->setConfigCacheFactory(($this->privates['config_cache_factory'] ?? $this->getConfigCacheFactoryService()));
        $instance->setFallbackLocales([0 => 'en']);

        return $instance;
    }

    /**
     * Gets the public 'var_dumper.cloner' shared service.
     *
     * @return \Symfony\Component\VarDumper\Cloner\VarCloner
     */
    protected function getVarDumper_ClonerService()
    {
        $this->services['var_dumper.cloner'] = $instance = new \Symfony\Component\VarDumper\Cloner\VarCloner();

        $instance->setMaxItems(2500);
        $instance->setMinDepth(1);
        $instance->setMaxString(-1);
        $instance->addCasters(['Closure' => 'Symfony\\Component\\VarDumper\\Caster\\ReflectionCaster::unsetClosureFileInfo']);

        return $instance;
    }

    /**
     * Gets the private 'annotations.cached_reader' shared service.
     *
     * @return \Doctrine\Common\Annotations\CachedReader
     */
    protected function getAnnotations_CachedReaderService()
    {
        return $this->privates['annotations.cached_reader'] = new \Doctrine\Common\Annotations\CachedReader(($this->privates['annotations.reader'] ?? $this->getAnnotations_ReaderService()), $this->load('getAnnotations_CacheService'), true);
    }

    /**
     * Gets the private 'annotations.reader' shared service.
     *
     * @return \Doctrine\Common\Annotations\AnnotationReader
     */
    protected function getAnnotations_ReaderService()
    {
        $this->privates['annotations.reader'] = $instance = new \Doctrine\Common\Annotations\AnnotationReader();

        $a = new \Doctrine\Common\Annotations\AnnotationRegistry();
        $a->registerUniqueLoader('class_exists');

        $instance->addGlobalIgnoredName('required', $a);

        return $instance;
    }

    /**
     * Gets the private 'config_cache_factory' shared service.
     *
     * @return \Symfony\Component\Config\ResourceCheckerConfigCacheFactory
     */
    protected function getConfigCacheFactoryService()
    {
        return $this->privates['config_cache_factory'] = new \Symfony\Component\Config\ResourceCheckerConfigCacheFactory(new RewindableGenerator(function () {
            yield 0 => ($this->privates['dependency_injection.config.container_parameters_resource_checker'] ?? ($this->privates['dependency_injection.config.container_parameters_resource_checker'] = new \Symfony\Component\DependencyInjection\Config\ContainerParametersResourceChecker($this)));
            yield 1 => ($this->privates['config.resource.self_checking_resource_checker'] ?? ($this->privates['config.resource.self_checking_resource_checker'] = new \Symfony\Component\Config\Resource\SelfCheckingResourceChecker()));
        }, 2));
    }

    /**
     * Gets the private 'controller_resolver' shared service.
     *
     * @return \Symfony\Bundle\FrameworkBundle\Controller\ControllerResolver
     */
    protected function getControllerResolverService()
    {
        return $this->privates['controller_resolver'] = new \Symfony\Bundle\FrameworkBundle\Controller\ControllerResolver($this, ($this->privates['monolog.logger.request'] ?? $this->getMonolog_Logger_RequestService()));
    }

    /**
     * Gets the private 'debug.debug_handlers_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\DebugHandlersListener
     */
    protected function getDebug_DebugHandlersListenerService()
    {
        $a = new \Symfony\Bridge\Monolog\Logger('php');
        $a->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $a->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));

        return $this->privates['debug.debug_handlers_listener'] = new \Symfony\Component\HttpKernel\EventListener\DebugHandlersListener(NULL, $a, NULL, -1, true, ($this->privates['debug.file_link_formatter'] ?? $this->getDebug_FileLinkFormatterService()), true, NULL);
    }

    /**
     * Gets the private 'debug.file_link_formatter' shared service.
     *
     * @return \Symfony\Component\HttpKernel\Debug\FileLinkFormatter
     */
    protected function getDebug_FileLinkFormatterService()
    {
        return $this->privates['debug.file_link_formatter'] = new \Symfony\Component\HttpKernel\Debug\FileLinkFormatter(NULL, ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), \dirname(__DIR__, 5), function () {
            return ($this->privates['debug.file_link_formatter.url_format'] ?? $this->load('getDebug_FileLinkFormatter_UrlFormatService'));
        });
    }

    /**
     * Gets the private 'exception_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\ErrorListener
     */
    protected function getExceptionListenerService()
    {
        return $this->privates['exception_listener'] = new \Symfony\Component\HttpKernel\EventListener\ErrorListener('error_controller', ($this->privates['monolog.logger.request'] ?? $this->getMonolog_Logger_RequestService()), true);
    }

    /**
     * Gets the private 'form.registry' shared service.
     *
     * @return \Symfony\Component\Form\FormRegistry
     */
    protected function getForm_RegistryService()
    {
        return $this->privates['form.registry'] = new \Symfony\Component\Form\FormRegistry([0 => new \Symfony\Component\Form\Extension\DependencyInjection\DependencyInjectionExtension(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'Doctrine\\Bundle\\PHPCRBundle\\Form\\Type\\PHPCRReferenceType' => ['privates', 'form.type.phpcr.reference', 'getForm_Type_Phpcr_ReferenceService', true],
            'Sulu\\Bundle\\PageBundle\\Form\\Type\\HomeDocumentType' => ['privates', 'dtl_content.form.type.home', 'getDtlContent_Form_Type_HomeService', true],
            'Sulu\\Bundle\\PageBundle\\Form\\Type\\PageDocumentType' => ['privates', 'dtl_content.form.type.page', 'getDtlContent_Form_Type_PageService', true],
            'Sulu\\Bundle\\SnippetBundle\\Form\\SnippetType' => ['privates', 'sulu_snippet.form.snippet', 'getSuluSnippet_Form_SnippetService', true],
            'Sulu\\Component\\Content\\Form\\Type\\DocumentObjectType' => ['privates', 'dtl_content.form.factory.document_type', 'getDtlContent_Form_Factory_DocumentTypeService', true],
            'Symfony\\Bridge\\Doctrine\\Form\\Type\\EntityType' => ['privates', 'form.type.entity', 'getForm_Type_EntityService', true],
            'Symfony\\Cmf\\Bundle\\RoutingBundle\\Form\\Type\\RouteTypeType' => ['privates', 'cmf_routing.route_type_form_type', 'getCmfRouting_RouteTypeFormTypeService', true],
            'Symfony\\Component\\Form\\Extension\\Core\\Type\\ChoiceType' => ['privates', 'form.type.choice', 'getForm_Type_ChoiceService', true],
            'Symfony\\Component\\Form\\Extension\\Core\\Type\\ColorType' => ['privates', 'form.type.color', 'getForm_Type_ColorService', true],
            'Symfony\\Component\\Form\\Extension\\Core\\Type\\FileType' => ['services', '.container.private.form.type.file', 'get_Container_Private_Form_Type_FileService', true],
            'Symfony\\Component\\Form\\Extension\\Core\\Type\\FormType' => ['privates', 'form.type.form', 'getForm_Type_FormService', true],
        ], [
            'Doctrine\\Bundle\\PHPCRBundle\\Form\\Type\\PHPCRReferenceType' => '?',
            'Sulu\\Bundle\\PageBundle\\Form\\Type\\HomeDocumentType' => '?',
            'Sulu\\Bundle\\PageBundle\\Form\\Type\\PageDocumentType' => '?',
            'Sulu\\Bundle\\SnippetBundle\\Form\\SnippetType' => '?',
            'Sulu\\Component\\Content\\Form\\Type\\DocumentObjectType' => '?',
            'Symfony\\Bridge\\Doctrine\\Form\\Type\\EntityType' => '?',
            'Symfony\\Cmf\\Bundle\\RoutingBundle\\Form\\Type\\RouteTypeType' => '?',
            'Symfony\\Component\\Form\\Extension\\Core\\Type\\ChoiceType' => '?',
            'Symfony\\Component\\Form\\Extension\\Core\\Type\\ColorType' => '?',
            'Symfony\\Component\\Form\\Extension\\Core\\Type\\FileType' => '?',
            'Symfony\\Component\\Form\\Extension\\Core\\Type\\FormType' => '?',
        ]), ['Symfony\\Component\\Form\\Extension\\Core\\Type\\FormType' => new RewindableGenerator(function () {
            yield 0 => ($this->privates['form.type_extension.form.transformation_failure_handling'] ?? $this->load('getForm_TypeExtension_Form_TransformationFailureHandlingService'));
            yield 1 => ($this->privates['form.type_extension.form.http_foundation'] ?? $this->load('getForm_TypeExtension_Form_HttpFoundationService'));
            yield 2 => ($this->privates['form.type_extension.form.validator'] ?? $this->load('getForm_TypeExtension_Form_ValidatorService'));
            yield 3 => ($this->privates['form.type_extension.upload.validator'] ?? $this->load('getForm_TypeExtension_Upload_ValidatorService'));
            yield 4 => ($this->privates['form.type_extension.csrf'] ?? $this->load('getForm_TypeExtension_CsrfService'));
        }, 5), 'Symfony\\Component\\Form\\Extension\\Core\\Type\\RepeatedType' => new RewindableGenerator(function () {
            yield 0 => ($this->privates['form.type_extension.repeated.validator'] ?? ($this->privates['form.type_extension.repeated.validator'] = new \Symfony\Component\Form\Extension\Validator\Type\RepeatedTypeValidatorExtension()));
        }, 1), 'Symfony\\Component\\Form\\Extension\\Core\\Type\\SubmitType' => new RewindableGenerator(function () {
            yield 0 => ($this->privates['form.type_extension.submit.validator'] ?? ($this->privates['form.type_extension.submit.validator'] = new \Symfony\Component\Form\Extension\Validator\Type\SubmitTypeValidatorExtension()));
        }, 1)], new RewindableGenerator(function () {
            yield 0 => ($this->privates['form.type_guesser.validator'] ?? $this->load('getForm_TypeGuesser_ValidatorService'));
            yield 1 => ($this->privates['form.type_guesser.doctrine'] ?? $this->load('getForm_TypeGuesser_DoctrineService'));
        }, 2))], new \Symfony\Component\Form\ResolvedFormTypeFactory());
    }

    /**
     * Gets the private 'fos_http_cache.event_listener.tag' shared service.
     *
     * @return \FOS\HttpCacheBundle\EventListener\TagListener
     */
    protected function getFosHttpCache_EventListener_TagService()
    {
        return $this->privates['fos_http_cache.event_listener.tag'] = new \FOS\HttpCacheBundle\EventListener\TagListener(($this->services['fos_http_cache.cache_manager'] ?? $this->getFosHttpCache_CacheManagerService()), ($this->services['fos_http_cache.http.symfony_response_tagger'] ?? $this->getFosHttpCache_Http_SymfonyResponseTaggerService()), new \FOS\HttpCacheBundle\Http\RuleMatcher(new \FOS\HttpCacheBundle\Http\RequestMatcher\CacheableRequestMatcher(), new \FOS\HttpCacheBundle\Http\ResponseMatcher\CacheableResponseMatcher([])), ($this->privates['fos_http_cache.rule_matcher.must_invalidate'] ?? $this->getFosHttpCache_RuleMatcher_MustInvalidateService()), NULL);
    }

    /**
     * Gets the private 'fos_http_cache.rule_matcher.must_invalidate' shared service.
     *
     * @return \FOS\HttpCacheBundle\Http\RuleMatcher
     */
    protected function getFosHttpCache_RuleMatcher_MustInvalidateService()
    {
        return $this->privates['fos_http_cache.rule_matcher.must_invalidate'] = new \FOS\HttpCacheBundle\Http\RuleMatcher(new \FOS\HttpCacheBundle\Http\RequestMatcher\UnsafeRequestMatcher(), new \FOS\HttpCacheBundle\Http\ResponseMatcher\NonErrorResponseMatcher());
    }

    /**
     * Gets the private 'fos_rest.body_listener' shared service.
     *
     * @return \FOS\RestBundle\EventListener\BodyListener
     */
    protected function getFosRest_BodyListenerService()
    {
        $this->privates['fos_rest.body_listener'] = $instance = new \FOS\RestBundle\EventListener\BodyListener(new \FOS\RestBundle\Decoder\ContainerDecoderProvider(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'fos_rest.decoder.json' => ['privates', 'fos_rest.decoder.json', 'getFosRest_Decoder_JsonService', true],
            'fos_rest.decoder.xml' => ['privates', 'fos_rest.decoder.xml', 'getFosRest_Decoder_XmlService', true],
        ], [
            'fos_rest.decoder.json' => '?',
            'fos_rest.decoder.xml' => '?',
        ]), ['json' => 'fos_rest.decoder.json', 'xml' => 'fos_rest.decoder.xml']), false);

        $instance->setDefaultFormat(NULL);

        return $instance;
    }

    /**
     * Gets the private 'fos_rest.exception.codes_map' shared service.
     *
     * @return \FOS\RestBundle\Util\ExceptionValueMap
     */
    protected function getFosRest_Exception_CodesMapService()
    {
        return $this->privates['fos_rest.exception.codes_map'] = new \FOS\RestBundle\Util\ExceptionValueMap(['Sulu\\Component\\DocumentManager\\Exception\\DocumentNotFoundException' => 404, 'Sulu\\Component\\CustomUrl\\Manager\\TitleAlreadyExistsException' => 400, 'Sulu\\Component\\CustomUrl\\Generator\\MissingDomainPartException' => 400, 'Sulu\\Component\\CustomUrl\\Manager\\RouteNotRemovableException' => 420, 'Sulu\\Component\\DocumentManager\\Exception\\VersionNotFoundException' => 404, 'Sulu\\Component\\Content\\Exception\\MandatoryPropertyException' => 400, 'Sulu\\Component\\Content\\Exception\\ResourceLocatorAlreadyExistsException' => 409, 'Sulu\\Bundle\\CategoryBundle\\Exception\\CategoryIdNotFoundException' => 404, 'Sulu\\Bundle\\CategoryBundle\\Exception\\CategoryKeyNotFoundException' => 404, 'Sulu\\Bundle\\CategoryBundle\\Exception\\CategoryKeyNotUniqueException' => 409, 'Sulu\\Bundle\\CategoryBundle\\Exception\\CategoryNameMissingException' => 400, 'Sulu\\Bundle\\CategoryBundle\\Exception\\KeywordIsMultipleReferencedException' => 409, 'Sulu\\Bundle\\CategoryBundle\\Exception\\KeywordNotUniqueException' => 409, 'Sulu\\Bundle\\SecurityBundle\\Exception\\RoleNameAlreadyExistsException' => 409, 'Sulu\\Bundle\\SecurityBundle\\Exception\\RoleKeyAlreadyExistsException' => 409, 'Sulu\\Bundle\\SecurityBundle\\Security\\Exception\\UsernameNotUniqueException' => 409, 'Sulu\\Bundle\\SecurityBundle\\Security\\Exception\\EmailNotUniqueException' => 409, 'Sulu\\Bundle\\MediaBundle\\Media\\Exception\\MediaNotFoundException' => 404, 'Sulu\\Bundle\\MediaBundle\\Media\\Exception\\FileVersionNotFoundException' => 404, 'Sulu\\Bundle\\MediaBundle\\Media\\Exception\\FormatNotFoundException' => 404, 'Sulu\\Bundle\\MediaBundle\\Media\\Exception\\FormatOptionsMissingParameterException' => 400, 'Sulu\\Component\\Rest\\Exception\\MissingParameterException' => 400, 'Sulu\\Component\\Rest\\Exception\\InvalidHashException' => 409, 'Sulu\\Component\\Rest\\Csv\\ObjectNotSupportedException' => 406, 'Sulu\\Component\\Rest\\ListBuilder\\Filter\\InvalidFilterTypeOptionsException' => 400]);
    }

    /**
     * Gets the private 'fos_rest.exception.response_status_code_listener' shared service.
     *
     * @return \FOS\RestBundle\EventListener\ResponseStatusCodeListener
     */
    protected function getFosRest_Exception_ResponseStatusCodeListenerService()
    {
        return $this->privates['fos_rest.exception.response_status_code_listener'] = new \FOS\RestBundle\EventListener\ResponseStatusCodeListener(($this->privates['fos_rest.exception.codes_map'] ?? $this->getFosRest_Exception_CodesMapService()));
    }

    /**
     * Gets the private 'fos_rest.serializer.jms_handler_registry.inner' shared service.
     *
     * @return \JMS\Serializer\Handler\LazyHandlerRegistry
     */
    protected function getFosRest_Serializer_JmsHandlerRegistry_InnerService()
    {
        return $this->privates['fos_rest.serializer.jms_handler_registry.inner'] = new \JMS\Serializer\Handler\LazyHandlerRegistry(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'fos_rest.serializer.flatten_exception_handler' => ['privates', 'fos_rest.serializer.flatten_exception_handler', 'getFosRest_Serializer_FlattenExceptionHandlerService', true],
            'fos_rest.serializer.form_error_handler' => ['privates', 'fos_rest.serializer.form_error_handler', 'getFosRest_Serializer_FormErrorHandlerService', true],
            'jms_serializer.array_collection_handler' => ['privates', 'jms_serializer.array_collection_handler', 'getJmsSerializer_ArrayCollectionHandlerService', true],
            'jms_serializer.constraint_violation_handler' => ['privates', 'jms_serializer.constraint_violation_handler', 'getJmsSerializer_ConstraintViolationHandlerService', true],
            'jms_serializer.datetime_handler' => ['privates', 'jms_serializer.datetime_handler', 'getJmsSerializer_DatetimeHandlerService', true],
            'jms_serializer.iterator_handler' => ['privates', 'jms_serializer.iterator_handler', 'getJmsSerializer_IteratorHandlerService', true],
            'sulu_core.rest.datetime_handler' => ['privates', 'sulu_core.rest.datetime_handler', 'getSuluCore_Rest_DatetimeHandlerService', true],
            'sulu_document_manager.serializer.handler.children_collection' => ['privates', 'sulu_document_manager.serializer.handler.children_collection', 'getSuluDocumentManager_Serializer_Handler_ChildrenCollectionService', true],
            'sulu_page.compat.serializer.handler.page_bridge' => ['privates', 'sulu_page.compat.serializer.handler.page_bridge', 'getSuluPage_Compat_Serializer_Handler_PageBridgeService', true],
            'sulu_page.document.serializer.handler.extension_container' => ['privates', 'sulu_page.document.serializer.handler.extension_container', 'getSuluPage_Document_Serializer_Handler_ExtensionContainerService', true],
            'sulu_page.document.serializer.handler.structure' => ['privates', 'sulu_page.document.serializer.handler.structure', 'getSuluPage_Document_Serializer_Handler_StructureService', true],
        ], [
            'fos_rest.serializer.flatten_exception_handler' => '?',
            'fos_rest.serializer.form_error_handler' => '?',
            'jms_serializer.array_collection_handler' => '?',
            'jms_serializer.constraint_violation_handler' => '?',
            'jms_serializer.datetime_handler' => '?',
            'jms_serializer.iterator_handler' => '?',
            'sulu_core.rest.datetime_handler' => '?',
            'sulu_document_manager.serializer.handler.children_collection' => '?',
            'sulu_page.compat.serializer.handler.page_bridge' => '?',
            'sulu_page.document.serializer.handler.extension_container' => '?',
            'sulu_page.document.serializer.handler.structure' => '?',
        ]), [2 => ['DateTime' => ['array' => [0 => 'sulu_core.rest.datetime_handler', 1 => 'deserialize'], 'json' => [0 => 'jms_serializer.datetime_handler', 1 => 'deserializeDateTimeFromjson'], 'xml' => [0 => 'jms_serializer.datetime_handler', 1 => 'deserializeDateTimeFromxml']], 'DateTimeImmutable' => ['array' => [0 => 'sulu_core.rest.datetime_handler', 1 => 'deserialize'], 'json' => [0 => 'jms_serializer.datetime_handler', 1 => 'deserializeDateTimeImmutableFromjson'], 'xml' => [0 => 'jms_serializer.datetime_handler', 1 => 'deserializeDateTimeImmutableFromxml']], 'ArrayCollection' => ['json' => [0 => 'jms_serializer.array_collection_handler', 1 => 'deserializeCollection'], 'xml' => [0 => 'jms_serializer.array_collection_handler', 1 => 'deserializeCollection'], 'yml' => [0 => 'jms_serializer.array_collection_handler', 1 => 'deserializeCollection']], 'Doctrine\\Common\\Collections\\ArrayCollection' => ['json' => [0 => 'jms_serializer.array_collection_handler', 1 => 'deserializeCollection'], 'xml' => [0 => 'jms_serializer.array_collection_handler', 1 => 'deserializeCollection'], 'yml' => [0 => 'jms_serializer.array_collection_handler', 1 => 'deserializeCollection']], 'Doctrine\\ORM\\PersistentCollection' => ['json' => [0 => 'jms_serializer.array_collection_handler', 1 => 'deserializeCollection'], 'xml' => [0 => 'jms_serializer.array_collection_handler', 1 => 'deserializeCollection'], 'yml' => [0 => 'jms_serializer.array_collection_handler', 1 => 'deserializeCollection']], 'Doctrine\\ODM\\MongoDB\\PersistentCollection' => ['json' => [0 => 'jms_serializer.array_collection_handler', 1 => 'deserializeCollection'], 'xml' => [0 => 'jms_serializer.array_collection_handler', 1 => 'deserializeCollection'], 'yml' => [0 => 'jms_serializer.array_collection_handler', 1 => 'deserializeCollection']], 'Doctrine\\ODM\\PHPCR\\PersistentCollection' => ['json' => [0 => 'jms_serializer.array_collection_handler', 1 => 'deserializeCollection'], 'xml' => [0 => 'jms_serializer.array_collection_handler', 1 => 'deserializeCollection'], 'yml' => [0 => 'jms_serializer.array_collection_handler', 1 => 'deserializeCollection']], 'DateInterval' => ['json' => [0 => 'jms_serializer.datetime_handler', 1 => 'deserializeDateIntervalFromjson'], 'xml' => [0 => 'jms_serializer.datetime_handler', 1 => 'deserializeDateIntervalFromxml']], 'DateTimeInterface' => ['json' => [0 => 'jms_serializer.datetime_handler', 1 => 'deserializeDateTimeFromJson'], 'xml' => [0 => 'jms_serializer.datetime_handler', 1 => 'deserializeDateTimeFromXml']], 'JMS\\Serializer\\Handler\\iterable' => ['json' => [0 => 'jms_serializer.iterator_handler', 1 => 'deserializeIterable'], 'xml' => [0 => 'jms_serializer.iterator_handler', 1 => 'deserializeIterable']], 'Iterator' => ['json' => [0 => 'jms_serializer.iterator_handler', 1 => 'deserializeIterator'], 'xml' => [0 => 'jms_serializer.iterator_handler', 1 => 'deserializeIterator']], 'ArrayIterator' => ['json' => [0 => 'jms_serializer.iterator_handler', 1 => 'deserializeIterator'], 'xml' => [0 => 'jms_serializer.iterator_handler', 1 => 'deserializeIterator']], 'Generator' => ['json' => [0 => 'jms_serializer.iterator_handler', 1 => 'deserializeGenerator'], 'xml' => [0 => 'jms_serializer.iterator_handler', 1 => 'deserializeGenerator']], 'Sulu\\Component\\Content\\Document\\Structure\\Structure' => ['json' => [0 => 'sulu_page.document.serializer.handler.structure', 1 => 'doDeserialize']], 'Sulu\\Component\\Content\\Document\\Extension\\ExtensionContainer' => ['json' => [0 => 'sulu_page.document.serializer.handler.extension_container', 1 => 'doDeserialize']], 'Sulu\\Component\\Content\\Compat\\Structure\\PageBridge' => ['json' => [0 => 'sulu_page.compat.serializer.handler.page_bridge', 1 => 'doDeserialize']]], 1 => ['DateTime' => ['array' => [0 => 'sulu_core.rest.datetime_handler', 1 => 'serialize'], 'json' => [0 => 'jms_serializer.datetime_handler', 1 => 'serializeDateTime'], 'xml' => [0 => 'jms_serializer.datetime_handler', 1 => 'serializeDateTime']], 'DateTimeImmutable' => ['array' => [0 => 'sulu_core.rest.datetime_handler', 1 => 'serialize'], 'json' => [0 => 'jms_serializer.datetime_handler', 1 => 'serializeDateTimeImmutable'], 'xml' => [0 => 'jms_serializer.datetime_handler', 1 => 'serializeDateTimeImmutable']], 'Symfony\\Component\\ErrorHandler\\Exception\\FlattenException' => ['json' => [0 => 'fos_rest.serializer.flatten_exception_handler', 1 => 'serializeToJson'], 'xml' => [0 => 'fos_rest.serializer.flatten_exception_handler', 1 => 'serializeToXml']], 'ArrayCollection' => ['json' => [0 => 'jms_serializer.array_collection_handler', 1 => 'serializeCollection'], 'xml' => [0 => 'jms_serializer.array_collection_handler', 1 => 'serializeCollection'], 'yml' => [0 => 'jms_serializer.array_collection_handler', 1 => 'serializeCollection']], 'Doctrine\\Common\\Collections\\ArrayCollection' => ['json' => [0 => 'jms_serializer.array_collection_handler', 1 => 'serializeCollection'], 'xml' => [0 => 'jms_serializer.array_collection_handler', 1 => 'serializeCollection'], 'yml' => [0 => 'jms_serializer.array_collection_handler', 1 => 'serializeCollection']], 'Doctrine\\ORM\\PersistentCollection' => ['json' => [0 => 'jms_serializer.array_collection_handler', 1 => 'serializeCollection'], 'xml' => [0 => 'jms_serializer.array_collection_handler', 1 => 'serializeCollection'], 'yml' => [0 => 'jms_serializer.array_collection_handler', 1 => 'serializeCollection']], 'Doctrine\\ODM\\MongoDB\\PersistentCollection' => ['json' => [0 => 'jms_serializer.array_collection_handler', 1 => 'serializeCollection'], 'xml' => [0 => 'jms_serializer.array_collection_handler', 1 => 'serializeCollection'], 'yml' => [0 => 'jms_serializer.array_collection_handler', 1 => 'serializeCollection']], 'Doctrine\\ODM\\PHPCR\\PersistentCollection' => ['json' => [0 => 'jms_serializer.array_collection_handler', 1 => 'serializeCollection'], 'xml' => [0 => 'jms_serializer.array_collection_handler', 1 => 'serializeCollection'], 'yml' => [0 => 'jms_serializer.array_collection_handler', 1 => 'serializeCollection']], 'Symfony\\Component\\Validator\\ConstraintViolationList' => ['xml' => [0 => 'jms_serializer.constraint_violation_handler', 1 => 'serializeListToxml'], 'json' => [0 => 'jms_serializer.constraint_violation_handler', 1 => 'serializeListTojson']], 'Symfony\\Component\\Validator\\ConstraintViolation' => ['xml' => [0 => 'jms_serializer.constraint_violation_handler', 1 => 'serializeViolationToxml'], 'json' => [0 => 'jms_serializer.constraint_violation_handler', 1 => 'serializeViolationTojson']], 'DateInterval' => ['json' => [0 => 'jms_serializer.datetime_handler', 1 => 'serializeDateInterval'], 'xml' => [0 => 'jms_serializer.datetime_handler', 1 => 'serializeDateInterval']], 'JMS\\Serializer\\Handler\\iterable' => ['json' => [0 => 'jms_serializer.iterator_handler', 1 => 'serializeIterable'], 'xml' => [0 => 'jms_serializer.iterator_handler', 1 => 'serializeIterable']], 'Iterator' => ['json' => [0 => 'jms_serializer.iterator_handler', 1 => 'serializeIterable'], 'xml' => [0 => 'jms_serializer.iterator_handler', 1 => 'serializeIterable']], 'ArrayIterator' => ['json' => [0 => 'jms_serializer.iterator_handler', 1 => 'serializeIterable'], 'xml' => [0 => 'jms_serializer.iterator_handler', 1 => 'serializeIterable']], 'Generator' => ['json' => [0 => 'jms_serializer.iterator_handler', 1 => 'serializeIterable'], 'xml' => [0 => 'jms_serializer.iterator_handler', 1 => 'serializeIterable']], 'Sulu\\Component\\Content\\Document\\Structure\\Structure' => ['json' => [0 => 'sulu_page.document.serializer.handler.structure', 1 => 'doSerialize']], 'Sulu\\Component\\Content\\Document\\Extension\\ExtensionContainer' => ['json' => [0 => 'sulu_page.document.serializer.handler.extension_container', 1 => 'doSerialize']], 'Sulu\\Component\\DocumentManager\\Collection\\ChildrenCollection' => ['json' => [0 => 'sulu_document_manager.serializer.handler.children_collection', 1 => 'doSerialize']], 'Symfony\\Component\\Form\\Form' => ['xml' => [0 => 'fos_rest.serializer.form_error_handler', 1 => 'serializeFormToxml'], 'json' => [0 => 'fos_rest.serializer.form_error_handler', 1 => 'serializeFormTojson']], 'Symfony\\Component\\Form\\FormError' => ['xml' => [0 => 'fos_rest.serializer.form_error_handler', 1 => 'serializeFormErrorToxml'], 'json' => [0 => 'fos_rest.serializer.form_error_handler', 1 => 'serializeFormErrorTojson']]]]);
    }

    /**
     * Gets the private 'fos_rest.zone_matcher_listener' shared service.
     *
     * @return \FOS\RestBundle\EventListener\ZoneMatcherListener
     */
    protected function getFosRest_ZoneMatcherListenerService()
    {
        $this->privates['fos_rest.zone_matcher_listener'] = $instance = new \FOS\RestBundle\EventListener\ZoneMatcherListener();

        $instance->addRequestMatcher(new \Symfony\Component\HttpFoundation\RequestMatcher('^/admin/*'));

        return $instance;
    }

    /**
     * Gets the private 'locale_aware_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\LocaleAwareListener
     */
    protected function getLocaleAwareListenerService()
    {
        return $this->privates['locale_aware_listener'] = new \Symfony\Component\HttpKernel\EventListener\LocaleAwareListener(new RewindableGenerator(function () {
            yield 0 => ($this->privates['slugger'] ?? ($this->privates['slugger'] = new \Symfony\Component\String\Slugger\AsciiSlugger('en')));
            yield 1 => ($this->services['translator'] ?? $this->getTranslatorService());
        }, 2), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())));
    }

    /**
     * Gets the private 'locale_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\LocaleListener
     */
    protected function getLocaleListenerService()
    {
        return $this->privates['locale_listener'] = new \Symfony\Component\HttpKernel\EventListener\LocaleListener(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), 'en', ($this->services['router'] ?? $this->getRouterService()));
    }

    /**
     * Gets the private 'monolog.handler.console' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Handler\ConsoleHandler
     */
    protected function getMonolog_Handler_ConsoleService()
    {
        return $this->privates['monolog.handler.console'] = new \Symfony\Bridge\Monolog\Handler\ConsoleHandler(NULL, true, [], []);
    }

    /**
     * Gets the private 'monolog.handler.main' shared service.
     *
     * @return \Monolog\Handler\StreamHandler
     */
    protected function getMonolog_Handler_MainService()
    {
        $this->privates['monolog.handler.main'] = $instance = new \Monolog\Handler\StreamHandler((\dirname(__DIR__, 4).'/log/preview/dev.log'), 100, true, NULL, false);

        $instance->pushProcessor(new \Monolog\Processor\PsrLogMessageProcessor());

        return $instance;
    }

    /**
     * Gets the private 'monolog.logger' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Logger
     */
    protected function getMonolog_LoggerService()
    {
        $this->privates['monolog.logger'] = $instance = new \Symfony\Bridge\Monolog\Logger('app');

        $instance->useMicrosecondTimestamps(true);
        $instance->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $instance->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));

        return $instance;
    }

    /**
     * Gets the private 'monolog.logger.request' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Logger
     */
    protected function getMonolog_Logger_RequestService()
    {
        $this->privates['monolog.logger.request'] = $instance = new \Symfony\Bridge\Monolog\Logger('request');

        $instance->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $instance->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));

        return $instance;
    }

    /**
     * Gets the private 'parameter_bag' shared service.
     *
     * @return \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag
     */
    protected function getParameterBagService()
    {
        return $this->privates['parameter_bag'] = new \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag($this);
    }

    /**
     * Gets the private 'router.expression_language_provider' shared service.
     *
     * @return \Symfony\Component\Routing\Matcher\ExpressionLanguageProvider
     */
    protected function getRouter_ExpressionLanguageProviderService()
    {
        return $this->privates['router.expression_language_provider'] = new \Symfony\Component\Routing\Matcher\ExpressionLanguageProvider(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'env' => ['privates', 'container.getenv', 'getContainer_GetenvService', true],
        ], [
            'env' => 'Closure',
        ]));
    }

    /**
     * Gets the private 'router.request_context' shared service.
     *
     * @return \Symfony\Component\Routing\RequestContext
     */
    protected function getRouter_RequestContextService()
    {
        $this->privates['router.request_context'] = $instance = \Symfony\Component\Routing\RequestContext::fromUri('', 'localhost', 'http', 80, 443);

        $instance->setParameter('_functions', ($this->privates['router.expression_language_provider'] ?? $this->getRouter_ExpressionLanguageProviderService()));

        return $instance;
    }

    /**
     * Gets the private 'session_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\SessionListener
     */
    protected function getSessionListenerService()
    {
        return $this->privates['session_listener'] = new \Symfony\Component\HttpKernel\EventListener\SessionListener(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'initialized_session' => ['services', 'session', NULL, true],
            'logger' => ['privates', 'monolog.logger', 'getMonolog_LoggerService', false],
            'request_stack' => ['services', 'request_stack', 'getRequestStackService', false],
            'session' => ['services', 'session', 'getSessionService', true],
            'session_storage' => ['privates', 'session.storage.mock_file', 'getSession_Storage_MockFileService', true],
        ], [
            'initialized_session' => '?',
            'logger' => '?',
            'request_stack' => '?',
            'session' => '?',
            'session_storage' => '?',
        ]), true);
    }

    /**
     * Gets the private 'sulu.content.query_executor' shared service.
     *
     * @return \Sulu\Component\Content\Query\ContentQueryExecutor
     */
    protected function getSulu_Content_QueryExecutorService()
    {
        return $this->privates['sulu.content.query_executor'] = new \Sulu\Component\Content\Query\ContentQueryExecutor(($this->services['sulu.phpcr.session'] ?? $this->getSulu_Phpcr_SessionService()), ($this->services['sulu.content.mapper'] ?? $this->getSulu_Content_MapperService()), NULL);
    }

    /**
     * Gets the private 'sulu.content.resource_locator.mapper.phpcr' shared service.
     *
     * @return \Sulu\Component\Content\Types\ResourceLocator\Mapper\PhpcrMapper
     */
    protected function getSulu_Content_ResourceLocator_Mapper_PhpcrService()
    {
        return $this->privates['sulu.content.resource_locator.mapper.phpcr'] = new \Sulu\Component\Content\Types\ResourceLocator\Mapper\PhpcrMapper(($this->services['sulu.phpcr.session'] ?? $this->getSulu_Phpcr_SessionService()), ($this->services['sulu_document_manager.document_manager'] ?? $this->getSuluDocumentManager_DocumentManagerService()), ($this->services['sulu_document_manager.document_inspector'] ?? $this->getSuluDocumentManager_DocumentInspectorService()));
    }

    /**
     * Gets the private 'sulu.content.resource_locator.strategy.tree_leaf_edit' shared service.
     *
     * @return \Sulu\Component\Content\Types\ResourceLocator\Strategy\TreeLeafEditStrategy
     */
    protected function getSulu_Content_ResourceLocator_Strategy_TreeLeafEditService()
    {
        return $this->privates['sulu.content.resource_locator.strategy.tree_leaf_edit'] = new \Sulu\Component\Content\Types\ResourceLocator\Strategy\TreeLeafEditStrategy(($this->privates['sulu.content.resource_locator.mapper.phpcr'] ?? $this->getSulu_Content_ResourceLocator_Mapper_PhpcrService()), ($this->services['sulu.content.path_cleaner'] ?? $this->getSulu_Content_PathCleanerService()), ($this->services['sulu.content.structure_manager'] ?? $this->getSulu_Content_StructureManagerService()), ($this->services['sulu.content.type_manager'] ?? $this->getSulu_Content_TypeManagerService()), ($this->services['sulu.util.node_helper'] ?? $this->getSulu_Util_NodeHelperService()), ($this->services['sulu_document_manager.document_inspector'] ?? $this->getSuluDocumentManager_DocumentInspectorService()), ($this->services['sulu_document_manager.document_manager'] ?? $this->getSuluDocumentManager_DocumentManagerService()), ($this->privates['sulu.content.resource_locator.strategy.tree_generator'] ?? ($this->privates['sulu.content.resource_locator.strategy.tree_generator'] = new \Sulu\Component\Content\Types\ResourceLocator\Strategy\TreeGenerator())));
    }

    /**
     * Gets the private 'sulu.content.resource_locator.strategy_pool' shared service.
     *
     * @return \Sulu\Component\Content\Types\ResourceLocator\Strategy\ResourceLocatorStrategyPool
     */
    protected function getSulu_Content_ResourceLocator_StrategyPoolService()
    {
        return $this->privates['sulu.content.resource_locator.strategy_pool'] = new \Sulu\Component\Content\Types\ResourceLocator\Strategy\ResourceLocatorStrategyPool(['tree_leaf_edit' => ($this->privates['sulu.content.resource_locator.strategy.tree_leaf_edit'] ?? $this->getSulu_Content_ResourceLocator_Strategy_TreeLeafEditService()), 'tree_full_edit' => new \Sulu\Component\Content\Types\ResourceLocator\Strategy\TreeFullEditStrategy(($this->privates['sulu.content.resource_locator.mapper.phpcr'] ?? $this->getSulu_Content_ResourceLocator_Mapper_PhpcrService()), ($this->services['sulu.content.path_cleaner'] ?? $this->getSulu_Content_PathCleanerService()), ($this->services['sulu.content.structure_manager'] ?? $this->getSulu_Content_StructureManagerService()), ($this->services['sulu.content.type_manager'] ?? $this->getSulu_Content_TypeManagerService()), ($this->services['sulu.util.node_helper'] ?? $this->getSulu_Util_NodeHelperService()), ($this->services['sulu_document_manager.document_inspector'] ?? $this->getSuluDocumentManager_DocumentInspectorService()), ($this->services['sulu_document_manager.document_manager'] ?? $this->getSuluDocumentManager_DocumentManagerService()), ($this->privates['sulu.content.resource_locator.strategy.tree_generator'] ?? ($this->privates['sulu.content.resource_locator.strategy.tree_generator'] = new \Sulu\Component\Content\Types\ResourceLocator\Strategy\TreeGenerator())))], ($this->services['sulu_core.webspace.webspace_manager'] ?? $this->getSuluCore_Webspace_WebspaceManagerService()));
    }

    /**
     * Gets the private 'sulu_category.category_request_handler' shared service.
     *
     * @return \Sulu\Component\Category\Request\CategoryRequestHandler
     */
    protected function getSuluCategory_CategoryRequestHandlerService()
    {
        return $this->privates['sulu_category.category_request_handler'] = new \Sulu\Component\Category\Request\CategoryRequestHandler(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())));
    }

    /**
     * Gets the private 'sulu_core.proxy_manager.configuration' shared service.
     *
     * @return \ProxyManager\Configuration
     */
    protected function getSuluCore_ProxyManager_ConfigurationService()
    {
        $this->privates['sulu_core.proxy_manager.configuration'] = $instance = new \ProxyManager\Configuration();

        $instance->setProxiesTargetDir(($this->targetDir.''.'/sulu/proxies'));
        $instance->setGeneratorStrategy(new \ProxyManager\GeneratorStrategy\FileWriterGeneratorStrategy(new \ProxyManager\FileLocator\FileLocator(($this->privates['sulu_core.proxy_manager.configuration'] ?? $this->getSuluCore_ProxyManager_ConfigurationService())->getProxiesTargetDir())));

        return $instance;
    }

    /**
     * Gets the private 'sulu_core.webspace.loader.delegator' shared service.
     *
     * @return \Symfony\Component\Config\Loader\DelegatingLoader
     */
    protected function getSuluCore_Webspace_Loader_DelegatorService()
    {
        $a = ($this->privates['file_locator'] ?? ($this->privates['file_locator'] = new \Symfony\Component\HttpKernel\Config\FileLocator(($this->services['kernel'] ?? $this->get('kernel', 1)))));

        return $this->privates['sulu_core.webspace.loader.delegator'] = new \Symfony\Component\Config\Loader\DelegatingLoader(new \Symfony\Component\Config\Loader\LoaderResolver([0 => new \Sulu\Component\Webspace\Loader\XmlFileLoader11($a), 1 => new \Sulu\Component\Webspace\Loader\XmlFileLoader10($a)]));
    }

    /**
     * Gets the private 'sulu_custom_urls.domain_generator' shared service.
     *
     * @return \Sulu\Component\CustomUrl\Generator\Generator
     */
    protected function getSuluCustomUrls_DomainGeneratorService()
    {
        return $this->privates['sulu_custom_urls.domain_generator'] = new \Sulu\Component\CustomUrl\Generator\Generator(($this->privates['sulu_core.webspace.webspace_manager.url_replacer'] ?? ($this->privates['sulu_core.webspace.webspace_manager.url_replacer'] = new \Sulu\Component\Webspace\Url\Replacer())));
    }

    /**
     * Gets the private 'sulu_custom_urls.request_processor' shared service.
     *
     * @return \Sulu\Bundle\CustomUrlBundle\Request\CustomUrlRequestProcessor
     */
    protected function getSuluCustomUrls_RequestProcessorService($lazyLoad = true)
    {
        if ($lazyLoad) {
            return $this->privates['sulu_custom_urls.request_processor'] = $this->createProxy('CustomUrlRequestProcessor_292b929', function () {
                return \CustomUrlRequestProcessor_292b929::staticProxyConstructor(function (&$wrappedInstance, \ProxyManager\Proxy\LazyLoadingInterface $proxy) {
                    $wrappedInstance = $this->getSuluCustomUrls_RequestProcessorService(false);

                    $proxy->setProxyInitializer(null);

                    return true;
                });
            });
        }

        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CustomUrlBundle/Request/CustomUrlRequestProcessor.php';

        return new \Sulu\Bundle\CustomUrlBundle\Request\CustomUrlRequestProcessor(($this->services['sulu_custom_urls.manager'] ?? $this->getSuluCustomUrls_ManagerService()), ($this->privates['sulu_custom_urls.domain_generator'] ?? $this->getSuluCustomUrls_DomainGeneratorService()), ($this->services['sulu_core.webspace.webspace_manager'] ?? $this->getSuluCore_Webspace_WebspaceManagerService()), 'dev');
    }

    /**
     * Gets the private 'sulu_document_manager.event_dispatcher.standard' shared service.
     *
     * @return \Symfony\Component\EventDispatcher\EventDispatcher
     */
    protected function getSuluDocumentManager_EventDispatcher_StandardService()
    {
        $this->privates['sulu_document_manager.event_dispatcher.standard'] = $instance = new \Symfony\Component\EventDispatcher\EventDispatcher();

        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_page.search.event_subscriber.structure'] ?? $this->load('getSuluPage_Search_EventSubscriber_StructureService'));
        }, 1 => 'indexPersistedDocument'], -10);
        $instance->addListener('sulu_document_manager.publish', [0 => function () {
            return ($this->privates['sulu_page.search.event_subscriber.structure'] ?? $this->load('getSuluPage_Search_EventSubscriber_StructureService'));
        }, 1 => 'indexPublishedDocument'], -256);
        $instance->addListener('sulu_document_manager.remove', [0 => function () {
            return ($this->privates['sulu_page.search.event_subscriber.structure'] ?? $this->load('getSuluPage_Search_EventSubscriber_StructureService'));
        }, 1 => 'deindexRemovedDocument'], 600);
        $instance->addListener('sulu_document_manager.unpublish', [0 => function () {
            return ($this->privates['sulu_page.search.event_subscriber.structure'] ?? $this->load('getSuluPage_Search_EventSubscriber_StructureService'));
        }, 1 => 'deindexUnpublishedDocument'], -1024);
        $instance->addListener('sulu_document_manager.remove_draft', [0 => function () {
            return ($this->privates['sulu_page.search.event_subscriber.structure'] ?? $this->load('getSuluPage_Search_EventSubscriber_StructureService'));
        }, 1 => 'indexDocumentAfterRemoveDraft'], -1024);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_page.document.subscriber.content'] ?? $this->load('getSuluPage_Document_Subscriber_ContentService'));
        }, 1 => 'saveStructureData'], 0);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_page.document.subscriber.content'] ?? $this->load('getSuluPage_Document_Subscriber_ContentService'));
        }, 1 => 'handlePersistStagedProperties'], 50);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_page.document.subscriber.content'] ?? $this->load('getSuluPage_Document_Subscriber_ContentService'));
        }, 1 => 'handlePersistStructureType'], 100);
        $instance->addListener('sulu_document_manager.publish', [0 => function () {
            return ($this->privates['sulu_page.document.subscriber.content'] ?? $this->load('getSuluPage_Document_Subscriber_ContentService'));
        }, 1 => 'saveStructureData'], 0);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_page.document.subscriber.content'] ?? $this->load('getSuluPage_Document_Subscriber_ContentService'));
        }, 1 => 'handleHydrate'], 0);
        $instance->addListener('sulu_document_manager.configure_options', [0 => function () {
            return ($this->privates['sulu_page.document.subscriber.content'] ?? $this->load('getSuluPage_Document_Subscriber_ContentService'));
        }, 1 => 'configureOptions'], 0);
        $instance->addListener('sulu_document_manager.metadata_load', [0 => function () {
            return ($this->privates['sulu_navigationContext.document.subscriber.navigation_context'] ?? ($this->privates['sulu_navigationContext.document.subscriber.navigation_context'] = new \Sulu\Component\Content\Document\Subscriber\NavigationContextSubscriber()));
        }, 1 => 'handleMetadataLoad'], 0);
        $instance->addListener('sulu_document_manager.metadata_load', [0 => function () {
            return ($this->privates['sulu_redirect_type.document.subscriber.redirect_type'] ?? ($this->privates['sulu_redirect_type.document.subscriber.redirect_type'] = new \Sulu\Component\Content\Document\Subscriber\RedirectTypeSubscriber()));
        }, 1 => 'handleMetadataLoad'], 0);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_redirect_type.document.subscriber.redirect_type'] ?? ($this->privates['sulu_redirect_type.document.subscriber.redirect_type'] = new \Sulu\Component\Content\Document\Subscriber\RedirectTypeSubscriber()));
        }, 1 => 'handlePersist'], 15);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_resource_segment.document.subscriber.resource_segment'] ?? $this->load('getSuluResourceSegment_Document_Subscriber_ResourceSegmentService'));
        }, 1 => 'handlePersistDocument'], 10);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_resource_segment.document.subscriber.resource_segment'] ?? $this->load('getSuluResourceSegment_Document_Subscriber_ResourceSegmentService'));
        }, 1 => 'handleHydrate'], -200);
        $instance->addListener('sulu_document_manager.move', [0 => function () {
            return ($this->privates['sulu_resource_segment.document.subscriber.resource_segment'] ?? $this->load('getSuluResourceSegment_Document_Subscriber_ResourceSegmentService'));
        }, 1 => 'updateMovedDocument'], -128);
        $instance->addListener('sulu_document_manager.copy', [0 => function () {
            return ($this->privates['sulu_resource_segment.document.subscriber.resource_segment'] ?? $this->load('getSuluResourceSegment_Document_Subscriber_ResourceSegmentService'));
        }, 1 => 'updateCopiedDocument'], -128);
        $instance->addListener('sulu_document_manager.publish', [0 => function () {
            return ($this->privates['sulu_resource_segment.document.subscriber.resource_segment'] ?? $this->load('getSuluResourceSegment_Document_Subscriber_ResourceSegmentService'));
        }, 1 => 'handlePersistRoute'], -128);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.workflow_stage'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_WorkflowStageService'));
        }, 1 => 'setWorkflowStageOnDocument'], 0);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.workflow_stage'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_WorkflowStageService'));
        }, 1 => 'setWorkflowStageToTest'], 0);
        $instance->addListener('sulu_document_manager.publish', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.workflow_stage'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_WorkflowStageService'));
        }, 1 => 'setWorkflowStageToPublished'], 0);
        $instance->addListener('sulu_document_manager.unpublish', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.workflow_stage'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_WorkflowStageService'));
        }, 1 => 'setWorkflowStageToTestAndResetPublishedDate'], 0);
        $instance->addListener('sulu_document_manager.copy', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.workflow_stage'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_WorkflowStageService'));
        }, 1 => 'setWorkflowStageToTestForCopy'], 0);
        $instance->addListener('sulu_document_manager.restore', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.workflow_stage'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_WorkflowStageService'));
        }, 1 => 'setWorkflowStageToTestForRestore'], -32);
        $instance->addListener('sulu_document_manager.metadata_load', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.shadow_locale'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_ShadowLocaleService'));
        }, 1 => 'handleMetadataLoad'], 0);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.shadow_locale'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_ShadowLocaleService'));
        }, 1 => 'handlePersistUpdateUrl'], 20);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.shadow_locale'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_ShadowLocaleService'));
        }, 1 => 'saveShadowProperties'], 15);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.shadow_locale'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_ShadowLocaleService'));
        }, 1 => 'handleHydrate'], 390);
        $instance->addListener('sulu_document_manager.publish', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.shadow_locale'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_ShadowLocaleService'));
        }, 1 => 'saveShadowProperties'], 15);
        $instance->addListener('sulu_document_manager.configure_options', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.shadow_locale'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_ShadowLocaleService'));
        }, 1 => 'handleConfigureOptions'], 0);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.shadow_copy_properties'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_ShadowCopyPropertiesService'));
        }, 1 => 'copyShadowProperties'], -256);
        $instance->addListener('sulu_document_manager.publish', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.shadow_copy_properties'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_ShadowCopyPropertiesService'));
        }, 1 => 'copyShadowProperties'], 0);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.title'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_TitleService'));
        }, 1 => 'setTitleOnDocument'], -10);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.title'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_TitleService'));
        }, 1 => 'setTitleOnNode'], 10);
        $instance->addListener('sulu_document_manager.publish', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.title'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_TitleService'));
        }, 1 => 'setTitleOnNode'], 10);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.fallback_localization'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_FallbackLocalizationService'));
        }, 1 => 'handleHydrate'], 400);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.extension'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_ExtensionService'));
        }, 1 => 'saveExtensionData'], 10);
        $instance->addListener('sulu_document_manager.publish', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.extension'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_ExtensionService'));
        }, 1 => 'saveExtensionData'], 10);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.extension'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_ExtensionService'));
        }, 1 => 'handleHydrate'], -10);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.order'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_OrderService'));
        }, 1 => 'handlePersist'], 0);
        $instance->addListener('sulu_document_manager.metadata_load', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.order'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_OrderService'));
        }, 1 => 'handleMetadataLoad'], 0);
        $instance->addListener('sulu_document_manager.reorder', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.order'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_OrderService'));
        }, 1 => 'handleReorder'], 0);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.security'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_SecurityService'));
        }, 1 => 'handlePersist'], 0);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.security'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_SecurityService'));
        }, 1 => 'handlePersistCreate'], 3);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.security'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_SecurityService'));
        }, 1 => 'handleHydrate'], 0);
        $instance->addListener('sulu_document_manager.copy', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.webspace'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_WebspaceService'));
        }, 1 => 'deleteUnavailableLocales'], 256);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.webspace'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_WebspaceService'));
        }, 1 => 'handleWebspace'], 0);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.webspace'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_WebspaceService'));
        }, 1 => 'handleWebspace'], -10);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.route'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_RouteService'));
        }, 1 => 'handleSetNodeOnPersist'], 490);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.route'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_RouteService'));
        }, 1 => 'handlePersist'], 5);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.route'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_RouteService'));
        }, 1 => 'handleHydrate'], 0);
        $instance->addListener('sulu_document_manager.remove', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.route'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_RouteService'));
        }, 1 => 'handleRemove'], 550);
        $instance->addListener('sulu_document_manager.publish', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.route'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_RouteService'));
        }, 1 => 'handlePublish'], 0);
        $instance->addListener('sulu_document_manager.metadata_load', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.target'] ?? ($this->privates['sulu_document_manager.document.subscriber.target'] = new \Sulu\Component\Content\Document\Subscriber\TargetSubscriber()));
        }, 1 => 'handleMetadataLoad'], 0);
        $instance->addListener('sulu_document_manager.metadata_load', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.robot'] ?? ($this->privates['sulu_document_manager.document.subscriber.robot'] = new \Sulu\Component\Content\Document\Subscriber\RobotSubscriber()));
        }, 1 => 'handleMetadataLoad'], 0);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.publish'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_PublishService'));
        }, 1 => 'createNodeInPublicWorkspace'], -490);
        $instance->addListener('sulu_document_manager.remove', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.publish'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_PublishService'));
        }, 1 => 'removeNodeFromPublicWorkspace'], 0);
        $instance->addListener('sulu_document_manager.move', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.publish'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_PublishService'));
        }, 1 => 'moveNodeInPublicWorkspace'], 0);
        $instance->addListener('sulu_document_manager.copy', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.publish'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_PublishService'));
        }, 1 => 'copyNodeInPublicWorkspace'], 0);
        $instance->addListener('sulu_document_manager.reorder', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.publish'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_PublishService'));
        }, 1 => 'reorderNodeInPublicWorkspace'], 0);
        $instance->addListener('sulu_document_manager.publish', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.publish'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_PublishService'));
        }, 1 => 'setNodeFromPublicWorkspaceForPublishing'], 512);
        $instance->addListener('sulu_document_manager.unpublish', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.publish'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_PublishService'));
        }, 1 => 'setNodeFromPublicWorkspaceForUnpublishing'], 512);
        $instance->addListener('sulu_document_manager.unpublish', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.publish'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_PublishService'));
        }, 1 => 'removePropertiesFromPublicWorkspace'], 0);
        $instance->addListener('sulu_document_manager.remove_draft', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.publish'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_PublishService'));
        }, 1 => 'copyPropertiesFromPublicWorkspace'], 0);
        $instance->addListener('sulu_document_manager.flush', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.publish'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_PublishService'));
        }, 1 => 'flushPublicWorkspace'], 0);
        $instance->addListener('sulu_document_manager.remove', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.compat.content_mapper'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_Compat_ContentMapperService'));
        }, 1 => 'handlePreRemove'], 510);
        $instance->addListener('sulu_document_manager.remove', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.compat.content_mapper'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_Compat_ContentMapperService'));
        }, 1 => 'handlePostRemove'], -100);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.compat.content_mapper'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_Compat_ContentMapperService'));
        }, 1 => 'handlePersist'], 0);
        $instance->addListener('sulu_document_manager.flush', [0 => function () {
            return ($this->privates['sulu_document_manager.document.subscriber.compat.content_mapper'] ?? $this->load('getSuluDocumentManager_Document_Subscriber_Compat_ContentMapperService'));
        }, 1 => 'handleFlush'], 0);
        $instance->addListener('sulu_document_manager.remove', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.behavior.remove_content'] ?? $this->load('getSuluDocumentManager_Subscriber_Behavior_RemoveContentService'));
        }, 1 => 'handleRemove'], 550);
        $instance->addListener('sulu_document_manager.publish', [0 => function () {
            return ($this->privates['sulu_http_cache.event_subscriber.invalidation'] ?? $this->load('getSuluHttpCache_EventSubscriber_InvalidationService'));
        }, 1 => 'invalidateDocumentBeforePublishing'], 1024);
        $instance->addListener('sulu_document_manager.unpublish', [0 => function () {
            return ($this->privates['sulu_http_cache.event_subscriber.invalidation'] ?? $this->load('getSuluHttpCache_EventSubscriber_InvalidationService'));
        }, 1 => 'invalidateDocumentBeforeUnpublishing'], 1024);
        $instance->addListener('sulu_document_manager.remove', [0 => function () {
            return ($this->privates['sulu_http_cache.event_subscriber.invalidation'] ?? $this->load('getSuluHttpCache_EventSubscriber_InvalidationService'));
        }, 1 => 'invalidateDocumentBeforeRemoving'], 1024);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.core.instantiator'] ?? $this->load('getSuluDocumentManager_Subscriber_Core_InstantiatorService'));
        }, 1 => 'handleHydrate'], 500);
        $instance->addListener('sulu_document_manager.create', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.core.instantiator'] ?? $this->load('getSuluDocumentManager_Subscriber_Core_InstantiatorService'));
        }, 1 => 'handleCreate'], 500);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.core.registrator'] ?? $this->load('getSuluDocumentManager_Subscriber_Core_RegistratorService'));
        }, 1 => 'handleDefaultLocale'], 520);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.core.registrator'] ?? $this->load('getSuluDocumentManager_Subscriber_Core_RegistratorService'));
        }, 1 => 'handleDocumentFromRegistry'], 510);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.core.registrator'] ?? $this->load('getSuluDocumentManager_Subscriber_Core_RegistratorService'));
        }, 1 => 'handleStopPropagationAndResetLocale'], 509);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.core.registrator'] ?? $this->load('getSuluDocumentManager_Subscriber_Core_RegistratorService'));
        }, 1 => 'handleHydrate'], 490);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.core.registrator'] ?? $this->load('getSuluDocumentManager_Subscriber_Core_RegistratorService'));
        }, 1 => 'handleEndHydrate'], -500);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.core.registrator'] ?? $this->load('getSuluDocumentManager_Subscriber_Core_RegistratorService'));
        }, 1 => 'handlePersist'], 450);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.core.registrator'] ?? $this->load('getSuluDocumentManager_Subscriber_Core_RegistratorService'));
        }, 1 => 'handleNodeFromRegistry'], 510);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.core.registrator'] ?? $this->load('getSuluDocumentManager_Subscriber_Core_RegistratorService'));
        }, 1 => 'handleEndPersist'], -500);
        $instance->addListener('sulu_document_manager.remove', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.core.registrator'] ?? $this->load('getSuluDocumentManager_Subscriber_Core_RegistratorService'));
        }, 1 => 'handleRemove'], 490);
        $instance->addListener('sulu_document_manager.clear', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.core.registrator'] ?? $this->load('getSuluDocumentManager_Subscriber_Core_RegistratorService'));
        }, 1 => 'handleClear'], 500);
        $instance->addListener('sulu_document_manager.reorder', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.core.registrator'] ?? $this->load('getSuluDocumentManager_Subscriber_Core_RegistratorService'));
        }, 1 => 'handleNodeFromRegistry'], 510);
        $instance->addListener('sulu_document_manager.configure_options', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.core.registrator'] ?? $this->load('getSuluDocumentManager_Subscriber_Core_RegistratorService'));
        }, 1 => 'configureOptions'], 0);
        $instance->addListener('sulu_document_manager.remove_draft', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.core.registrator'] ?? $this->load('getSuluDocumentManager_Subscriber_Core_RegistratorService'));
        }, 1 => 'handleNodeFromRegistry'], 512);
        $instance->addListener('sulu_document_manager.restore', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.core.registrator'] ?? $this->load('getSuluDocumentManager_Subscriber_Core_RegistratorService'));
        }, 1 => 'handleNodeFromRegistry'], 512);
        $instance->addListener('sulu_document_manager.reorder', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.phpcr.reorder'] ?? $this->load('getSuluDocumentManager_Subscriber_Phpcr_ReorderService'));
        }, 1 => 'handleReorder'], 500);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.phpcr.mixin'] ?? $this->load('getSuluDocumentManager_Subscriber_Phpcr_MixinService'));
        }, 1 => 'setDocumentMixinsOnNode'], 468);
        $instance->addListener('sulu_document_manager.publish', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.phpcr.mixin'] ?? $this->load('getSuluDocumentManager_Subscriber_Phpcr_MixinService'));
        }, 1 => 'setDocumentMixinsOnNode'], 468);
        $instance->addListener('sulu_document_manager.find', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.phpcr.find'] ?? $this->load('getSuluDocumentManager_Subscriber_Phpcr_FindService'));
        }, 1 => 'handleFind'], 500);
        $instance->addListener('sulu_document_manager.configure_options', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.phpcr.find'] ?? $this->load('getSuluDocumentManager_Subscriber_Phpcr_FindService'));
        }, 1 => 'configureOptions'], 0);
        $instance->addListener('sulu_document_manager.query.create', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.phpcr.query'] ?? $this->load('getSuluDocumentManager_Subscriber_Phpcr_QueryService'));
        }, 1 => 'handleCreate'], 500);
        $instance->addListener('sulu_document_manager.query.create_builder', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.phpcr.query'] ?? $this->load('getSuluDocumentManager_Subscriber_Phpcr_QueryService'));
        }, 1 => 'handleCreateBuilder'], 500);
        $instance->addListener('sulu_document_manager.query.execute', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.phpcr.query'] ?? $this->load('getSuluDocumentManager_Subscriber_Phpcr_QueryService'));
        }, 1 => 'handleQueryExecute'], 500);
        $instance->addListener('sulu_document_manager.move', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.phpcr.general'] ?? $this->load('getSuluDocumentManager_Subscriber_Phpcr_GeneralService'));
        }, 1 => 'handleMove'], 400);
        $instance->addListener('sulu_document_manager.copy', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.phpcr.general'] ?? $this->load('getSuluDocumentManager_Subscriber_Phpcr_GeneralService'));
        }, 1 => 'handleCopy'], 400);
        $instance->addListener('sulu_document_manager.clear', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.phpcr.general'] ?? $this->load('getSuluDocumentManager_Subscriber_Phpcr_GeneralService'));
        }, 1 => 'handleClear'], 500);
        $instance->addListener('sulu_document_manager.flush', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.phpcr.general'] ?? $this->load('getSuluDocumentManager_Subscriber_Phpcr_GeneralService'));
        }, 1 => 'handleFlush'], 500);
        $instance->addListener('sulu_document_manager.remove', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.phpcr.remove'] ?? $this->load('getSuluDocumentManager_Subscriber_Phpcr_RemoveService'));
        }, 1 => 'handleRemove'], 500);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.core.mapping'] ?? $this->load('getSuluDocumentManager_Subscriber_Core_MappingService'));
        }, 1 => 'handleHydrate'], -100);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.core.mapping'] ?? $this->load('getSuluDocumentManager_Subscriber_Core_MappingService'));
        }, 1 => 'handleMapping'], -100);
        $instance->addListener('sulu_document_manager.publish', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.core.mapping'] ?? $this->load('getSuluDocumentManager_Subscriber_Core_MappingService'));
        }, 1 => 'handleMapping'], -128);
        $instance->addListener('sulu_document_manager.refresh', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.phpcr.refresh'] ?? $this->load('getSuluDocumentManager_Subscriber_Phpcr_RefreshService'));
        }, 1 => 'refreshDocument'], 0);
        $instance->addListener('sulu_document_manager.remove_draft', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.phpcr.refresh'] ?? $this->load('getSuluDocumentManager_Subscriber_Phpcr_RefreshService'));
        }, 1 => 'refreshDocumentForDeleteDraft'], -512);
        $instance->addListener('sulu_document_manager.configure_options', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.security'] ?? ($this->privates['sulu_document_manager.subscriber.security'] = new \Sulu\Bundle\DocumentManagerBundle\Document\Subscriber\SecuritySubscriber(NULL)));
        }, 1 => 'setDefaultUser'], 0);
        $instance->addListener('sulu_document_manager.configure_options', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.behavior.auto_name'] ?? $this->load('getSuluDocumentManager_Subscriber_Behavior_AutoNameService'));
        }, 1 => 'configureOptions'], 0);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.behavior.auto_name'] ?? $this->load('getSuluDocumentManager_Subscriber_Behavior_AutoNameService'));
        }, 1 => 'handleScheduleRename'], 0);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.behavior.auto_name'] ?? $this->load('getSuluDocumentManager_Subscriber_Behavior_AutoNameService'));
        }, 1 => 'handlePersist'], 480);
        $instance->addListener('sulu_document_manager.move', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.behavior.auto_name'] ?? $this->load('getSuluDocumentManager_Subscriber_Behavior_AutoNameService'));
        }, 1 => 'handleMove'], 480);
        $instance->addListener('sulu_document_manager.copy', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.behavior.auto_name'] ?? $this->load('getSuluDocumentManager_Subscriber_Behavior_AutoNameService'));
        }, 1 => 'handleCopy'], 480);
        $instance->addListener('sulu_document_manager.flush', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.behavior.auto_name'] ?? $this->load('getSuluDocumentManager_Subscriber_Behavior_AutoNameService'));
        }, 1 => 'handleRename'], 510);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.behavior.path.explicit'] ?? $this->load('getSuluDocumentManager_Subscriber_Behavior_Path_ExplicitService'));
        }, 1 => 'handlePersist'], 485);
        $instance->addListener('sulu_document_manager.configure_options', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.behavior.path.explicit'] ?? $this->load('getSuluDocumentManager_Subscriber_Behavior_Path_ExplicitService'));
        }, 1 => 'configureOptions'], 0);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_document_manager.suscriber.behavior.blame'] ?? $this->load('getSuluDocumentManager_Suscriber_Behavior_BlameService'));
        }, 1 => 'setBlamesOnDocument'], 0);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.suscriber.behavior.blame'] ?? $this->load('getSuluDocumentManager_Suscriber_Behavior_BlameService'));
        }, 1 => 'setBlamesOnNodeForPersist'], 0);
        $instance->addListener('sulu_document_manager.publish', [0 => function () {
            return ($this->privates['sulu_document_manager.suscriber.behavior.blame'] ?? $this->load('getSuluDocumentManager_Suscriber_Behavior_BlameService'));
        }, 1 => 'setBlamesOnNodeForPublish'], 0);
        $instance->addListener('sulu_document_manager.restore', [0 => function () {
            return ($this->privates['sulu_document_manager.suscriber.behavior.blame'] ?? $this->load('getSuluDocumentManager_Suscriber_Behavior_BlameService'));
        }, 1 => 'setChangerForRestore'], -32);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_document_manager.suscriber.behavior.author'] ?? $this->load('getSuluDocumentManager_Suscriber_Behavior_AuthorService'));
        }, 1 => 'setAuthorOnDocument'], 0);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.suscriber.behavior.author'] ?? $this->load('getSuluDocumentManager_Suscriber_Behavior_AuthorService'));
        }, 1 => 'setAuthorOnNode'], 0);
        $instance->addListener('sulu_document_manager.publish', [0 => function () {
            return ($this->privates['sulu_document_manager.suscriber.behavior.author'] ?? $this->load('getSuluDocumentManager_Suscriber_Behavior_AuthorService'));
        }, 1 => 'setAuthorOnNode'], 0);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.suscriber.behavior.timestamp'] ?? $this->load('getSuluDocumentManager_Suscriber_Behavior_TimestampService'));
        }, 1 => 'setTimestampsOnNodeForPersist'], 0);
        $instance->addListener('sulu_document_manager.publish', [0 => function () {
            return ($this->privates['sulu_document_manager.suscriber.behavior.timestamp'] ?? $this->load('getSuluDocumentManager_Suscriber_Behavior_TimestampService'));
        }, 1 => 'setTimestampsOnNodeForPublish'], 0);
        $instance->addListener('sulu_document_manager.restore', [0 => function () {
            return ($this->privates['sulu_document_manager.suscriber.behavior.timestamp'] ?? $this->load('getSuluDocumentManager_Suscriber_Behavior_TimestampService'));
        }, 1 => 'setChangedForRestore'], -32);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_document_manager.suscriber.behavior.timestamp'] ?? $this->load('getSuluDocumentManager_Suscriber_Behavior_TimestampService'));
        }, 1 => 'setTimestampsOnDocument'], 0);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_document_manager.suscriber.behavior.node_name'] ?? ($this->privates['sulu_document_manager.suscriber.behavior.node_name'] = new \Sulu\Component\DocumentManager\Subscriber\Behavior\Mapping\NodeNameSubscriber()));
        }, 1 => 'setFinalNodeName'], 0);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.suscriber.behavior.node_name'] ?? ($this->privates['sulu_document_manager.suscriber.behavior.node_name'] = new \Sulu\Component\DocumentManager\Subscriber\Behavior\Mapping\NodeNameSubscriber()));
        }, 1 => 'setInitialNodeName'], 0);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.suscriber.behavior.node_name'] ?? ($this->privates['sulu_document_manager.suscriber.behavior.node_name'] = new \Sulu\Component\DocumentManager\Subscriber\Behavior\Mapping\NodeNameSubscriber()));
        }, 1 => 'setFinalNodeName'], -480);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_document_manager.suscriber.behavior.uuid'] ?? ($this->privates['sulu_document_manager.suscriber.behavior.uuid'] = new \Sulu\Component\DocumentManager\Subscriber\Behavior\Mapping\UuidSubscriber()));
        }, 1 => 'handleUuid'], 0);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.suscriber.behavior.uuid'] ?? ($this->privates['sulu_document_manager.suscriber.behavior.uuid'] = new \Sulu\Component\DocumentManager\Subscriber\Behavior\Mapping\UuidSubscriber()));
        }, 1 => 'handleUuid'], 0);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_document_manager.suscriber.behavior.locale'] ?? $this->load('getSuluDocumentManager_Suscriber_Behavior_LocaleService'));
        }, 1 => 'handleLocale'], 410);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.suscriber.behavior.locale'] ?? $this->load('getSuluDocumentManager_Suscriber_Behavior_LocaleService'));
        }, 1 => 'handleLocale'], 410);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_document_manager.suscriber.behavior.parent'] ?? $this->load('getSuluDocumentManager_Suscriber_Behavior_ParentService'));
        }, 1 => 'handleHydrate'], 0);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.suscriber.behavior.parent'] ?? $this->load('getSuluDocumentManager_Suscriber_Behavior_ParentService'));
        }, 1 => 'handleChangeParent'], 0);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.suscriber.behavior.parent'] ?? $this->load('getSuluDocumentManager_Suscriber_Behavior_ParentService'));
        }, 1 => 'handleSetParentNodeFromDocument'], 490);
        $instance->addListener('sulu_document_manager.move', [0 => function () {
            return ($this->privates['sulu_document_manager.suscriber.behavior.parent'] ?? $this->load('getSuluDocumentManager_Suscriber_Behavior_ParentService'));
        }, 1 => 'handleMove'], 0);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_document_manager.suscriber.behavior.children'] ?? $this->load('getSuluDocumentManager_Suscriber_Behavior_ChildrenService'));
        }, 1 => 'handleHydrate'], 0);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.behavior.path'] ?? $this->load('getSuluDocumentManager_Subscriber_Behavior_PathService'));
        }, 1 => 'setInitialPath'], 0);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.behavior.path'] ?? $this->load('getSuluDocumentManager_Subscriber_Behavior_PathService'));
        }, 1 => 'setFinalPath'], -495);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.behavior.path'] ?? $this->load('getSuluDocumentManager_Subscriber_Behavior_PathService'));
        }, 1 => 'setFinalPath'], 0);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.behavior.filing'] ?? $this->load('getSuluDocumentManager_Subscriber_Behavior_FilingService'));
        }, 1 => 'handlePersist'], 485);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.behavior.alias'] ?? $this->load('getSuluDocumentManager_Subscriber_Behavior_AliasService'));
        }, 1 => 'handlePersist'], 490);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_document_manager.subscriber.behavior.base_path'] ?? $this->load('getSuluDocumentManager_Subscriber_Behavior_BasePathService'));
        }, 1 => 'handlePersist'], 500);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_custom_urls.subscriber'] ?? $this->load('getSuluCustomUrls_SubscriberService'));
        }, 1 => 'handlePersist'], 0);
        $instance->addListener('sulu_document_manager.remove', [0 => function () {
            return ($this->privates['sulu_custom_urls.subscriber'] ?? $this->load('getSuluCustomUrls_SubscriberService'));
        }, 1 => 'handleRemove'], 550);
        $instance->addListener('sulu_document_manager.publish', [0 => function () {
            return ($this->privates['sulu_custom_urls.event_subscriber.invalidation'] ?? $this->load('getSuluCustomUrls_EventSubscriber_InvalidationService'));
        }, 1 => 'invalidateDocumentBeforePublishing'], 1024);
        $instance->addListener('sulu_document_manager.remove', [0 => function () {
            return ($this->privates['sulu_custom_urls.event_subscriber.invalidation'] ?? $this->load('getSuluCustomUrls_EventSubscriber_InvalidationService'));
        }, 1 => 'invalidateDocumentBeforeRemoving'], 1024);
        $instance->addListener('sulu_document_manager.hydrate', [0 => function () {
            return ($this->privates['sulu_route.subscriber.routable'] ?? $this->load('getSuluRoute_Subscriber_RoutableService'));
        }, 1 => 'handleHydrate'], 0);
        $instance->addListener('sulu_document_manager.persist', [0 => function () {
            return ($this->privates['sulu_route.subscriber.routable'] ?? $this->load('getSuluRoute_Subscriber_RoutableService'));
        }, 1 => 'handlePersist'], -2000);
        $instance->addListener('sulu_document_manager.remove', [0 => function () {
            return ($this->privates['sulu_route.subscriber.routable'] ?? $this->load('getSuluRoute_Subscriber_RoutableService'));
        }, 1 => 'handleRemove'], 1024);
        $instance->addListener('sulu_document_manager.publish', [0 => function () {
            return ($this->privates['sulu_route.subscriber.routable'] ?? $this->load('getSuluRoute_Subscriber_RoutableService'));
        }, 1 => 'handlePublish'], -2000);
        $instance->addListener('sulu_document_manager.copy', [0 => function () {
            return ($this->privates['sulu_route.subscriber.routable'] ?? $this->load('getSuluRoute_Subscriber_RoutableService'));
        }, 1 => 'handleCopy'], -2000);
        $instance->addListener('sulu_document_manager.publish', [0 => function () {
            return ($this->privates['sulu_route.subscriber.page_tree_route'] ?? $this->load('getSuluRoute_Subscriber_PageTreeRouteService'));
        }, 1 => 'handlePublish'], 10);
        $instance->addListener('sulu_document_manager.move', [0 => function () {
            return ($this->privates['sulu_route.subscriber.page_tree_route'] ?? $this->load('getSuluRoute_Subscriber_PageTreeRouteService'));
        }, 1 => 'handleMove'], -1000);

        return $instance;
    }

    /**
     * Gets the private 'sulu_document_manager.metadata_factory' shared service.
     *
     * @return \Sulu\Component\DocumentManager\Metadata\MetadataFactory
     */
    protected function getSuluDocumentManager_MetadataFactoryService()
    {
        return $this->privates['sulu_document_manager.metadata_factory'] = new \Sulu\Component\DocumentManager\Metadata\MetadataFactory(($this->services['sulu_document_manager.metadata_factory.base'] ?? $this->getSuluDocumentManager_MetadataFactory_BaseService()));
    }

    /**
     * Gets the private 'sulu_document_manager.namespace_registry' shared service.
     *
     * @return \Sulu\Component\DocumentManager\NamespaceRegistry
     */
    protected function getSuluDocumentManager_NamespaceRegistryService()
    {
        return $this->privates['sulu_document_manager.namespace_registry'] = new \Sulu\Component\DocumentManager\NamespaceRegistry($this->parameters['sulu_document_manager.namespace_mapping']);
    }

    /**
     * Gets the private 'sulu_document_manager.node_manager' shared service.
     *
     * @return \Sulu\Component\DocumentManager\NodeManager
     */
    protected function getSuluDocumentManager_NodeManagerService()
    {
        $a = ($this->services['doctrine_phpcr.session'] ?? $this->getDoctrinePhpcr_SessionService());

        if (isset($this->privates['sulu_document_manager.node_manager'])) {
            return $this->privates['sulu_document_manager.node_manager'];
        }

        return $this->privates['sulu_document_manager.node_manager'] = new \Sulu\Component\DocumentManager\NodeManager($a);
    }

    /**
     * Gets the private 'sulu_document_manager.path_builder' shared service.
     *
     * @return \Sulu\Component\DocumentManager\PathBuilder
     */
    protected function getSuluDocumentManager_PathBuilderService()
    {
        return $this->privates['sulu_document_manager.path_builder'] = new \Sulu\Component\DocumentManager\PathBuilder(($this->privates['sulu_document_manager.path_segment_registry'] ?? $this->getSuluDocumentManager_PathSegmentRegistryService()));
    }

    /**
     * Gets the private 'sulu_document_manager.path_segment_registry' shared service.
     *
     * @return \Sulu\Component\DocumentManager\PathSegmentRegistry
     */
    protected function getSuluDocumentManager_PathSegmentRegistryService()
    {
        return $this->privates['sulu_document_manager.path_segment_registry'] = new \Sulu\Component\DocumentManager\PathSegmentRegistry($this->parameters['sulu_document_manager.segments']);
    }

    /**
     * Gets the private 'sulu_document_manager.proxy_factory' shared service.
     *
     * @return \Sulu\Component\DocumentManager\ProxyFactory
     */
    protected function getSuluDocumentManager_ProxyFactoryService()
    {
        return $this->privates['sulu_document_manager.proxy_factory'] = new \Sulu\Component\DocumentManager\ProxyFactory(new \ProxyManager\Factory\LazyLoadingGhostFactory(($this->privates['sulu_core.proxy_manager.configuration'] ?? $this->getSuluCore_ProxyManager_ConfigurationService())), ($this->privates['sulu_document_manager.event_dispatcher.standard'] ?? $this->getSuluDocumentManager_EventDispatcher_StandardService()), ($this->privates['sulu_document_manager.document_registry'] ?? ($this->privates['sulu_document_manager.document_registry'] = new \Sulu\Component\DocumentManager\DocumentRegistry('en'))), ($this->privates['sulu_document_manager.metadata_factory'] ?? $this->getSuluDocumentManager_MetadataFactoryService()));
    }

    /**
     * Gets the private 'sulu_markup.parser' shared service.
     *
     * @return \Sulu\Bundle\MarkupBundle\Markup\HtmlMarkupParser
     */
    protected function getSuluMarkup_ParserService()
    {
        return $this->privates['sulu_markup.parser'] = new \Sulu\Bundle\MarkupBundle\Markup\HtmlMarkupParser(new \Sulu\Bundle\MarkupBundle\Tag\TagRegistry(['html' => ['sulu' => ['link' => new \Sulu\Bundle\MarkupBundle\Markup\LinkTag(new \Sulu\Bundle\MarkupBundle\Markup\Link\LinkProviderPool(['media' => new \Sulu\Bundle\MediaBundle\Markup\Link\MediaLinkProvider(($this->services['sulu.repository.media'] ?? $this->getSulu_Repository_MediaService()), ($this->services['sulu_media.media_manager'] ?? $this->getSuluMedia_MediaManagerService())), 'page' => new \Sulu\Bundle\PageBundle\Markup\Link\PageLinkProvider(($this->services['sulu_page.content_repository'] ?? $this->getSuluPage_ContentRepositoryService()), ($this->services['sulu_core.webspace.webspace_manager'] ?? $this->getSuluCore_Webspace_WebspaceManagerService()), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->services['translator'] ?? $this->getTranslatorService()), 'dev', ($this->privates['sulu_security.access_control_manager'] ?? $this->getSuluSecurity_AccessControlManagerService()), NULL)]), (($this->hasParameter("sulu.preview")) ? ($this->getParameter("sulu.preview")) : (false)))]]]), new \Sulu\Bundle\MarkupBundle\Markup\DelegatingTagExtractor([0 => ($this->services['sulu_markup.parser.html_extractor'] ?? ($this->services['sulu_markup.parser.html_extractor'] = new \Sulu\Bundle\MarkupBundle\Markup\HtmlTagExtractor('sulu')))]));
    }

    /**
     * Gets the private 'sulu_markup.response_listener' shared service.
     *
     * @return \Sulu\Bundle\MarkupBundle\Listener\MarkupListener
     */
    protected function getSuluMarkup_ResponseListenerService()
    {
        return $this->privates['sulu_markup.response_listener'] = new \Sulu\Bundle\MarkupBundle\Listener\MarkupListener(['html' => ($this->privates['sulu_markup.parser'] ?? $this->getSuluMarkup_ParserService())]);
    }

    /**
     * Gets the private 'sulu_media.type_manager' shared service.
     *
     * @return \Sulu\Bundle\MediaBundle\Media\TypeManager\TypeManager
     */
    protected function getSuluMedia_TypeManagerService()
    {
        return $this->privates['sulu_media.type_manager'] = new \Sulu\Bundle\MediaBundle\Media\TypeManager\TypeManager(($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService()), $this->parameters['sulu_media.media.types'], []);
    }

    /**
     * Gets the private 'sulu_page.export.manager' shared service.
     *
     * @return \Sulu\Component\Export\Manager\ExportManager
     */
    protected function getSuluPage_Export_ManagerService()
    {
        $this->privates['sulu_page.export.manager'] = $instance = new \Sulu\Component\Export\Manager\ExportManager(($this->services['sulu.content.type_manager'] ?? $this->getSulu_Content_TypeManagerService()));

        $instance->add('number', '1.2.xliff', ['translate' => true]);
        $instance->add('text_line', '1.2.xliff', ['translate' => true]);
        $instance->add('text_area', '1.2.xliff', ['translate' => true]);
        $instance->add('text_editor', '1.2.xliff', ['translate' => true]);
        $instance->add('resource_locator', '1.2.xliff', ['translate' => false]);
        $instance->add('block', '1.2.xliff', ['translate' => false]);
        $instance->add('contact_account_selection', '1.2.xliff', ['translate' => false]);
        $instance->add('single_contact_selection', '1.2.xliff', ['translate' => false]);
        $instance->add('contact_selection', '1.2.xliff', ['translate' => false]);
        $instance->add('single_account_selection', '1.2.xliff', ['translate' => false]);
        $instance->add('account_selection', '1.2.xliff', ['translate' => false]);
        $instance->add('media_selection', '1.2.xliff', ['translate' => false]);
        $instance->add('single_media_selection', '1.2.xliff', ['translate' => false]);
        $instance->add('image_map', '1.2.xliff', ['translate' => false]);
        $instance->add('category_selection', '1.2.xliff', ['translate' => false]);
        $instance->add('single_category_selection', '1.2.xliff', ['translate' => false]);
        $instance->add('single_snippet_selection', '1.2.xliff', ['translate' => false]);
        $instance->add('snippet_selection', '1.2.xliff', ['translate' => false]);
        $instance->add('smart_content', '1.2.xliff', ['translate' => false]);
        $instance->add('teaser_selection', '1.2.xliff', ['translate' => false]);
        $instance->add('page_selection', '1.2.xliff', ['translate' => false]);
        $instance->add('single_page_selection', '1.2.xliff', ['translate' => false]);
        $instance->add('phone', '1.2.xliff', ['translate' => false]);
        $instance->add('password', '1.2.xliff', ['translate' => false]);
        $instance->add('url', '1.2.xliff', ['translate' => false]);
        $instance->add('email', '1.2.xliff', ['translate' => false]);
        $instance->add('date', '1.2.xliff', ['translate' => false]);
        $instance->add('datetime', '1.2.xliff', ['translate' => false]);
        $instance->add('time', '1.2.xliff', ['translate' => false]);
        $instance->add('color', '1.2.xliff', ['translate' => false]);
        $instance->add('checkbox', '1.2.xliff', ['translate' => false]);
        $instance->add('select', '1.2.xliff', ['translate' => false]);
        $instance->add('single_select', '1.2.xliff', ['translate' => false]);
        $instance->add('tag_selection', '1.2.xliff', ['translate' => false]);
        $instance->add('location', '1.2.xliff', ['translate' => false]);
        $instance->add('route', '1.2.xliff', ['translate' => false]);
        $instance->add('page_tree_route', '1.2.xliff', ['translate' => false]);

        return $instance;
    }

    /**
     * Gets the private 'sulu_page.import.manager' shared service.
     *
     * @return \Sulu\Component\Import\Manager\ImportManager
     */
    protected function getSuluPage_Import_ManagerService()
    {
        return $this->privates['sulu_page.import.manager'] = new \Sulu\Component\Import\Manager\ImportManager(($this->services['sulu.content.type_manager'] ?? $this->getSulu_Content_TypeManagerService()));
    }

    /**
     * Gets the private 'sulu_route.routing.provider' shared service.
     *
     * @return \Sulu\Bundle\RouteBundle\Routing\RouteProvider
     */
    protected function getSuluRoute_Routing_ProviderService($lazyLoad = true)
    {
        if ($lazyLoad) {
            return $this->privates['sulu_route.routing.provider'] = $this->createProxy('RouteProvider_9d934be', function () {
                return \RouteProvider_9d934be::staticProxyConstructor(function (&$wrappedInstance, \ProxyManager\Proxy\LazyLoadingInterface $proxy) {
                    $wrappedInstance = $this->getSuluRoute_Routing_ProviderService(false);

                    $proxy->setProxyInitializer(null);

                    return true;
                });
            });
        }

        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/RouteBundle/Routing/RouteProvider.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/RouteBundle/Routing/Defaults/RouteDefaultsProviderInterface.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/RouteBundle/Routing/Defaults/RouteDefaultsProvider.php';
        include_once \dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/PageBundle/Preview/PageRouteDefaultsProvider.php';
        include_once \dirname(__DIR__, 5).'/vendor/ocramius/proxy-manager/src/ProxyManager/Factory/LazyLoadingValueHolderFactory.php';

        return new \Sulu\Bundle\RouteBundle\Routing\RouteProvider(($this->services['sulu.repository.route'] ?? $this->getSulu_Repository_RouteService()), ($this->services['sulu_core.webspace.request_analyzer'] ?? $this->getSuluCore_Webspace_RequestAnalyzerService()), new \Sulu\Bundle\RouteBundle\Routing\Defaults\RouteDefaultsProvider([0 => new \Sulu\Bundle\PageBundle\Preview\PageRouteDefaultsProvider(($this->services['sulu_page.structure.factory'] ?? $this->getSuluPage_Structure_FactoryService()), ($this->services['sulu_document_manager.document_inspector'] ?? $this->getSuluDocumentManager_DocumentInspectorService()), ($this->services['sulu.content.structure_manager'] ?? $this->getSulu_Content_StructureManagerService()))]), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), new \ProxyManager\Factory\LazyLoadingValueHolderFactory(($this->privates['sulu_core.proxy_manager.configuration'] ?? $this->getSuluCore_ProxyManager_ConfigurationService())), ['utf8' => true]);
    }

    /**
     * Gets the private 'sulu_security.access_control_manager' shared service.
     *
     * @return \Sulu\Component\Security\Authorization\AccessControl\AccessControlManager
     */
    protected function getSuluSecurity_AccessControlManagerService()
    {
        $a = ($this->services['sulu_security.mask_converter'] ?? $this->getSuluSecurity_MaskConverterService());
        $b = ($this->services['sulu.repository.role'] ?? $this->getSulu_Repository_RoleService());

        $this->privates['sulu_security.access_control_manager'] = $instance = new \Sulu\Component\Security\Authorization\AccessControl\AccessControlManager($a, ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->privates['sulu_security.system_store'] ?? $this->getSuluSecurity_SystemStoreService()), new RewindableGenerator(function () {
            yield 0 => ($this->services['sulu_media.collection_repository'] ?? $this->getSuluMedia_CollectionRepositoryService());
            yield 1 => ($this->services['sulu_page.content_repository'] ?? $this->getSuluPage_ContentRepositoryService());
        }, 2), $b);

        $instance->addAccessControlProvider(new \Sulu\Component\Security\Authorization\AccessControl\PhpcrAccessControlProvider(($this->services['sulu_document_manager.document_manager'] ?? $this->getSuluDocumentManager_DocumentManagerService()), $b, $this->parameters['permissions']));
        $instance->addAccessControlProvider(new \Sulu\Component\Security\Authorization\AccessControl\DoctrineAccessControlProvider(($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService()), $b, ($this->services['sulu.repository.access_control'] ?? $this->getSulu_Repository_AccessControlService()), $a));

        return $instance;
    }

    /**
     * Gets the private 'sulu_security.access_control_query_enhancer' shared service.
     *
     * @return \Sulu\Bundle\SecurityBundle\AccessControl\AccessControlQueryEnhancer
     */
    protected function getSuluSecurity_AccessControlQueryEnhancerService()
    {
        return $this->privates['sulu_security.access_control_query_enhancer'] = new \Sulu\Bundle\SecurityBundle\AccessControl\AccessControlQueryEnhancer(($this->privates['sulu_security.system_store'] ?? $this->getSuluSecurity_SystemStoreService()), ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService()));
    }

    /**
     * Gets the private 'sulu_security.system_listener' shared service.
     *
     * @return \Sulu\Bundle\SecurityBundle\EventListener\SystemListener
     */
    protected function getSuluSecurity_SystemListenerService()
    {
        return $this->privates['sulu_security.system_listener'] = new \Sulu\Bundle\SecurityBundle\EventListener\SystemListener(($this->privates['sulu_security.system_store'] ?? $this->getSuluSecurity_SystemStoreService()), ($this->services['sulu_core.webspace.request_analyzer'] ?? $this->getSuluCore_Webspace_RequestAnalyzerService()), 'website');
    }

    /**
     * Gets the private 'sulu_security.system_store' shared service.
     *
     * @return \Sulu\Bundle\SecurityBundle\System\SystemStore
     */
    protected function getSuluSecurity_SystemStoreService()
    {
        return $this->privates['sulu_security.system_store'] = new \Sulu\Bundle\SecurityBundle\System\SystemStore(($this->services['sulu.repository.role'] ?? $this->getSulu_Repository_RoleService()));
    }

    /**
     * Gets the private 'sulu_tag.tag_request_handler' shared service.
     *
     * @return \Sulu\Component\Tag\Request\TagRequestHandler
     */
    protected function getSuluTag_TagRequestHandlerService()
    {
        return $this->privates['sulu_tag.tag_request_handler'] = new \Sulu\Component\Tag\Request\TagRequestHandler(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())));
    }

    /**
     * Gets the private 'sulu_website.analytics.repository' shared service.
     *
     * @return \Sulu\Bundle\WebsiteBundle\Entity\AnalyticsRepository
     */
    protected function getSuluWebsite_Analytics_RepositoryService()
    {
        $this->privates['sulu_website.analytics.repository'] = $instance = ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService())->getRepository('SuluWebsiteBundle:Analytics');

        $instance->setEnvironment('dev');

        return $instance;
    }

    /**
     * Gets the private 'sulu_website.analytics.response_listener' shared service.
     *
     * @return \Sulu\Bundle\WebsiteBundle\EventListener\AppendAnalyticsListener
     */
    protected function getSuluWebsite_Analytics_ResponseListenerService()
    {
        return $this->privates['sulu_website.analytics.response_listener'] = new \Sulu\Bundle\WebsiteBundle\EventListener\AppendAnalyticsListener(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()), ($this->services['sulu_core.webspace.request_analyzer'] ?? $this->getSuluCore_Webspace_RequestAnalyzerService()), ($this->privates['sulu_website.analytics.repository'] ?? $this->getSuluWebsite_Analytics_RepositoryService()), 'dev', (($this->hasParameter("sulu.preview")) ? ($this->getParameter("sulu.preview")) : ("")));
    }

    /**
     * Gets the private 'sulu_website.event_listener.translator' shared service.
     *
     * @return \Sulu\Bundle\WebsiteBundle\EventListener\TranslatorListener
     */
    protected function getSuluWebsite_EventListener_TranslatorService()
    {
        return $this->privates['sulu_website.event_listener.translator'] = new \Sulu\Bundle\WebsiteBundle\EventListener\TranslatorListener(($this->services['translator'] ?? $this->getTranslatorService()));
    }

    /**
     * Gets the private 'sulu_website.router_listener' shared service.
     *
     * @return \Sulu\Bundle\WebsiteBundle\EventListener\RouterListener
     */
    protected function getSuluWebsite_RouterListenerService()
    {
        return $this->privates['sulu_website.router_listener'] = new \Sulu\Bundle\WebsiteBundle\EventListener\RouterListener(new \Symfony\Component\HttpKernel\EventListener\RouterListener(($this->services['router'] ?? $this->getRouterService()), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->privates['router.request_context'] ?? $this->getRouter_RequestContextService()), ($this->privates['monolog.logger.request'] ?? $this->getMonolog_Logger_RequestService()), \dirname(__DIR__, 5), true), ($this->services['sulu_core.webspace.request_analyzer'] ?? $this->getSuluCore_Webspace_RequestAnalyzerService()));
    }

    /**
     * Gets the private 'sulu_website.routing.request_listener' shared service.
     *
     * @return \Sulu\Bundle\WebsiteBundle\Routing\RequestListener
     */
    protected function getSuluWebsite_Routing_RequestListenerService()
    {
        return $this->privates['sulu_website.routing.request_listener'] = new \Sulu\Bundle\WebsiteBundle\Routing\RequestListener(($this->services['router'] ?? $this->getRouterService()), ($this->services['sulu_core.webspace.request_analyzer'] ?? $this->getSuluCore_Webspace_RequestAnalyzerService()));
    }

    /**
     * Gets the private 'sulu_website.segment_subscriber' shared service.
     *
     * @return \Sulu\Bundle\WebsiteBundle\EventListener\SegmentSubscriber
     */
    protected function getSuluWebsite_SegmentSubscriberService()
    {
        return $this->privates['sulu_website.segment_subscriber'] = new \Sulu\Bundle\WebsiteBundle\EventListener\SegmentSubscriber('X-Sulu-Segment', ($this->services['sulu_core.webspace.request_analyzer'] ?? $this->getSuluCore_Webspace_RequestAnalyzerService()), '_ss');
    }

    /**
     * Gets the private 'twig.loader.native_filesystem' shared service.
     *
     * @return \Twig\Loader\FilesystemLoader
     */
    protected function getTwig_Loader_NativeFilesystemService()
    {
        $this->privates['twig.loader.native_filesystem'] = $instance = new \Twig\Loader\FilesystemLoader([], \dirname(__DIR__, 5));

        $instance->addPath((\dirname(__DIR__, 5).'/vendor/symfony/swiftmailer-bundle/Resources/views'), 'Swiftmailer');
        $instance->addPath((\dirname(__DIR__, 5).'/vendor/symfony/swiftmailer-bundle/Resources/views'), '!Swiftmailer');
        $instance->addPath((\dirname(__DIR__, 5).'/vendor/doctrine/doctrine-bundle/Resources/views'), 'Doctrine');
        $instance->addPath((\dirname(__DIR__, 5).'/vendor/doctrine/doctrine-bundle/Resources/views'), '!Doctrine');
        $instance->addPath((\dirname(__DIR__, 5).'/vendor/doctrine/phpcr-bundle/src/Resources/views'), 'DoctrinePHPCR');
        $instance->addPath((\dirname(__DIR__, 5).'/vendor/doctrine/phpcr-bundle/src/Resources/views'), '!DoctrinePHPCR');
        $instance->addPath((\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SecurityBundle/Resources/views'), 'SuluSecurity');
        $instance->addPath((\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SecurityBundle/Resources/views'), '!SuluSecurity');
        $instance->addPath((\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/PageBundle/Resources/views'), 'SuluPage');
        $instance->addPath((\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/PageBundle/Resources/views'), '!SuluPage');
        $instance->addPath((\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Resources/views'), 'SuluWebsite');
        $instance->addPath((\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle/Resources/views'), '!SuluWebsite');
        $instance->addPath((\dirname(__DIR__, 5).'/vendor/symfony/web-profiler-bundle/Resources/views'), 'WebProfiler');
        $instance->addPath((\dirname(__DIR__, 5).'/vendor/symfony/web-profiler-bundle/Resources/views'), '!WebProfiler');
        $instance->addPath((\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/TestBundle/Resources/views'), 'SuluTest');
        $instance->addPath((\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/TestBundle/Resources/views'), '!SuluTest');
        $instance->addPath((\dirname(__DIR__, 5).'/vendor/symfony/debug-bundle/Resources/views'), 'Debug');
        $instance->addPath((\dirname(__DIR__, 5).'/vendor/symfony/debug-bundle/Resources/views'), '!Debug');
        $instance->addPath((\dirname(__DIR__, 5).'/templates'));
        $instance->addPath((\dirname(__DIR__, 5).'/vendor/symfony/twig-bridge/Resources/views/Email'), 'email');
        $instance->addPath((\dirname(__DIR__, 5).'/vendor/symfony/twig-bridge/Resources/views/Email'), '!email');
        $instance->addPath((\dirname(__DIR__, 5).'/vendor/symfony/twig-bridge/Resources/views/Form'));

        return $instance;
    }

    /**
     * Gets the private 'var_dumper.html_dumper' shared service.
     *
     * @return \Symfony\Component\VarDumper\Dumper\HtmlDumper
     */
    protected function getVarDumper_HtmlDumperService()
    {
        $this->privates['var_dumper.html_dumper'] = $instance = new \Symfony\Component\VarDumper\Dumper\HtmlDumper(NULL, 'UTF-8', 0);

        $instance->setDisplayOptions(['fileLinkFormat' => ($this->privates['debug.file_link_formatter'] ?? $this->getDebug_FileLinkFormatterService())]);

        return $instance;
    }

    /**
     * Gets the public 'cache_clearer' alias.
     *
     * @return object The ".container.private.cache_clearer" service.
     */
    protected function getCacheClearerService()
    {
        trigger_deprecation('symfony/framework-bundle', '5.2', 'Accessing the "cache_clearer" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.cache_clearer');
    }

    /**
     * Gets the public 'filesystem' alias.
     *
     * @return object The ".container.private.filesystem" service.
     */
    protected function getFilesystemService()
    {
        trigger_deprecation('symfony/framework-bundle', '5.2', 'Accessing the "filesystem" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.filesystem');
    }

    /**
     * Gets the public 'security.csrf.token_manager' alias.
     *
     * @return object The ".container.private.security.csrf.token_manager" service.
     */
    protected function getSecurity_Csrf_TokenManagerService()
    {
        trigger_deprecation('symfony/framework-bundle', '5.2', 'Accessing the "security.csrf.token_manager" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.security.csrf.token_manager');
    }

    /**
     * Gets the public 'form.factory' alias.
     *
     * @return object The ".container.private.form.factory" service.
     */
    protected function getForm_FactoryService()
    {
        trigger_deprecation('symfony/framework-bundle', '5.2', 'Accessing the "form.factory" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.form.factory');
    }

    /**
     * Gets the public 'form.type.file' alias.
     *
     * @return object The ".container.private.form.type.file" service.
     */
    protected function getForm_Type_FileService()
    {
        trigger_deprecation('symfony/framework-bundle', '5.2', 'Accessing the "form.type.file" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.form.type.file');
    }

    /**
     * Gets the public 'validator' alias.
     *
     * @return object The ".container.private.validator" service.
     */
    protected function getValidatorService()
    {
        trigger_deprecation('symfony/framework-bundle', '5.2', 'Accessing the "validator" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.validator');
    }

    /**
     * Gets the public 'serializer' alias.
     *
     * @return object The ".container.private.serializer" service.
     */
    protected function getSerializerService()
    {
        trigger_deprecation('symfony/framework-bundle', '5.2', 'Accessing the "serializer" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.serializer');
    }

    /**
     * Gets the public 'twig' alias.
     *
     * @return object The ".container.private.twig" service.
     */
    protected function getTwigService()
    {
        trigger_deprecation('symfony/twig-bundle', '5.2', 'Accessing the "twig" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.twig');
    }

    public function getParameter(string $name)
    {
        if (isset($this->buildParameters[$name])) {
            return $this->buildParameters[$name];
        }

        if (!(isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters))) {
            throw new InvalidArgumentException(sprintf('The parameter "%s" must be defined.', $name));
        }
        if (isset($this->loadedDynamicParameters[$name])) {
            return $this->loadedDynamicParameters[$name] ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
        }

        return $this->parameters[$name];
    }

    public function hasParameter(string $name): bool
    {
        if (isset($this->buildParameters[$name])) {
            return true;
        }

        return isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters);
    }

    public function setParameter(string $name, $value): void
    {
        throw new LogicException('Impossible to call set() on a frozen ParameterBag.');
    }

    public function getParameterBag(): ParameterBagInterface
    {
        if (null === $this->parameterBag) {
            $parameters = $this->parameters;
            foreach ($this->loadedDynamicParameters as $name => $loaded) {
                $parameters[$name] = $loaded ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
            }
            foreach ($this->buildParameters as $name => $value) {
                $parameters[$name] = $value;
            }
            $this->parameterBag = new FrozenParameterBag($parameters);
        }

        return $this->parameterBag;
    }

    private $loadedDynamicParameters = [
        'kernel.runtime_environment' => false,
        'kernel.build_dir' => false,
        'kernel.cache_dir' => false,
        'kernel.secret' => false,
        'session.save_path' => false,
        'validator.mapping.cache.file' => false,
        'debug.container.dump' => false,
        'serializer.mapping.cache.file' => false,
        'swiftmailer.spool.default.memory.path' => false,
        'sulu.cache_dir' => false,
        'sulu_core.proxy_cache_dir' => false,
        'doctrine.orm.proxy_dir' => false,
        'massive_search.metadata.prefix' => false,
        'massive_search.metadata.cache_dir' => false,
        'sulu_website.sitemap.dump_dir' => false,
    ];
    private $dynamicParameters = [];

    private function getDynamicParameter(string $name)
    {
        switch ($name) {
            case 'kernel.runtime_environment': $value = $this->getEnv('default:kernel.environment:APP_RUNTIME_ENV'); break;
            case 'kernel.build_dir': $value = $this->targetDir.''; break;
            case 'kernel.cache_dir': $value = $this->targetDir.''; break;
            case 'kernel.secret': $value = $this->getEnv('APP_SECRET'); break;
            case 'session.save_path': $value = ($this->targetDir.''.'/sessions'); break;
            case 'validator.mapping.cache.file': $value = ($this->targetDir.''.'/validation.php'); break;
            case 'debug.container.dump': $value = ($this->targetDir.''.'/App_KernelDevDebugContainer.xml'); break;
            case 'serializer.mapping.cache.file': $value = ($this->targetDir.''.'/serialization.php'); break;
            case 'swiftmailer.spool.default.memory.path': $value = ($this->targetDir.''.'/swiftmailer/spool/default'); break;
            case 'sulu.cache_dir': $value = ($this->targetDir.''.'/sulu'); break;
            case 'sulu_core.proxy_cache_dir': $value = ($this->targetDir.''.'/sulu/proxies'); break;
            case 'doctrine.orm.proxy_dir': $value = ($this->targetDir.''.'/doctrine/orm/Proxies'); break;
            case 'massive_search.metadata.prefix': $value = $this->getEnv('resolve:MASSIVE_SEARCH_PREFIX'); break;
            case 'massive_search.metadata.cache_dir': $value = ($this->targetDir.''.'/massive-search'); break;
            case 'sulu_website.sitemap.dump_dir': $value = ($this->targetDir.''.'/sulu/sitemaps'); break;
            default: throw new InvalidArgumentException(sprintf('The dynamic parameter "%s" must be defined.', $name));
        }
        $this->loadedDynamicParameters[$name] = true;

        return $this->dynamicParameters[$name] = $value;
    }

    protected function getDefaultParameters(): array
    {
        return [
            'kernel.project_dir' => \dirname(__DIR__, 5),
            'kernel.environment' => 'dev',
            'kernel.debug' => true,
            'kernel.logs_dir' => (\dirname(__DIR__, 4).'/log/preview'),
            'kernel.bundles' => [
                'FrameworkBundle' => 'Symfony\\Bundle\\FrameworkBundle\\FrameworkBundle',
                'TwigBundle' => 'Symfony\\Bundle\\TwigBundle\\TwigBundle',
                'MonologBundle' => 'Symfony\\Bundle\\MonologBundle\\MonologBundle',
                'SwiftmailerBundle' => 'Symfony\\Bundle\\SwiftmailerBundle\\SwiftmailerBundle',
                'SuluCoreBundle' => 'Sulu\\Bundle\\CoreBundle\\SuluCoreBundle',
                'DoctrineBundle' => 'Doctrine\\Bundle\\DoctrineBundle\\DoctrineBundle',
                'DoctrineFixturesBundle' => 'Doctrine\\Bundle\\FixturesBundle\\DoctrineFixturesBundle',
                'DoctrinePHPCRBundle' => 'Doctrine\\Bundle\\PHPCRBundle\\DoctrinePHPCRBundle',
                'FOSRestBundle' => 'FOS\\RestBundle\\FOSRestBundle',
                'RestRoutingBundle' => 'HandcraftedInTheAlps\\RestRoutingBundle\\RestRoutingBundle',
                'JMSSerializerBundle' => 'JMS\\SerializerBundle\\JMSSerializerBundle',
                'MassiveSearchBundle' => 'Massive\\Bundle\\SearchBundle\\MassiveSearchBundle',
                'FOSHttpCacheBundle' => 'FOS\\HttpCacheBundle\\FOSHttpCacheBundle',
                'SuluSearchBundle' => 'Sulu\\Bundle\\SearchBundle\\SuluSearchBundle',
                'SuluPersistenceBundle' => 'Sulu\\Bundle\\PersistenceBundle\\SuluPersistenceBundle',
                'SuluContactBundle' => 'Sulu\\Bundle\\ContactBundle\\SuluContactBundle',
                'SuluMediaBundle' => 'Sulu\\Bundle\\MediaBundle\\SuluMediaBundle',
                'SuluSecurityBundle' => 'Sulu\\Bundle\\SecurityBundle\\SuluSecurityBundle',
                'SuluCategoryBundle' => 'Sulu\\Bundle\\CategoryBundle\\SuluCategoryBundle',
                'SuluSnippetBundle' => 'Sulu\\Bundle\\SnippetBundle\\SuluSnippetBundle',
                'SuluPageBundle' => 'Sulu\\Bundle\\PageBundle\\SuluPageBundle',
                'SuluTagBundle' => 'Sulu\\Bundle\\TagBundle\\SuluTagBundle',
                'SuluWebsiteBundle' => 'Sulu\\Bundle\\WebsiteBundle\\SuluWebsiteBundle',
                'SuluLocationBundle' => 'Sulu\\Bundle\\LocationBundle\\SuluLocationBundle',
                'SuluHttpCacheBundle' => 'Sulu\\Bundle\\HttpCacheBundle\\SuluHttpCacheBundle',
                'SuluDocumentManagerBundle' => 'Sulu\\Bundle\\DocumentManagerBundle\\SuluDocumentManagerBundle',
                'SuluHashBundle' => 'Sulu\\Bundle\\HashBundle\\SuluHashBundle',
                'SuluCustomUrlBundle' => 'Sulu\\Bundle\\CustomUrlBundle\\SuluCustomUrlBundle',
                'SuluRouteBundle' => 'Sulu\\Bundle\\RouteBundle\\SuluRouteBundle',
                'SuluMarkupBundle' => 'Sulu\\Bundle\\MarkupBundle\\SuluMarkupBundle',
                'PhpcrMigrationsBundle' => 'DTL\\Bundle\\PhpcrMigrations\\PhpcrMigrationsBundle',
                'MassiveBuildBundle' => 'Massive\\Bundle\\BuildBundle\\MassiveBuildBundle',
                'WebProfilerBundle' => 'Symfony\\Bundle\\WebProfilerBundle\\WebProfilerBundle',
                'SuluTestBundle' => 'Sulu\\Bundle\\TestBundle\\SuluTestBundle',
                'DebugBundle' => 'Symfony\\Bundle\\DebugBundle\\DebugBundle',
                'CmfRoutingBundle' => 'Symfony\\Cmf\\Bundle\\RoutingBundle\\CmfRoutingBundle',
                'StofDoctrineExtensionsBundle' => 'Stof\\DoctrineExtensionsBundle\\StofDoctrineExtensionsBundle',
            ],
            'kernel.bundles_metadata' => [
                'FrameworkBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/symfony/framework-bundle'),
                    'namespace' => 'Symfony\\Bundle\\FrameworkBundle',
                ],
                'TwigBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/symfony/twig-bundle'),
                    'namespace' => 'Symfony\\Bundle\\TwigBundle',
                ],
                'MonologBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/symfony/monolog-bundle'),
                    'namespace' => 'Symfony\\Bundle\\MonologBundle',
                ],
                'SwiftmailerBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/symfony/swiftmailer-bundle'),
                    'namespace' => 'Symfony\\Bundle\\SwiftmailerBundle',
                ],
                'SuluCoreBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CoreBundle'),
                    'namespace' => 'Sulu\\Bundle\\CoreBundle',
                ],
                'DoctrineBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/doctrine/doctrine-bundle'),
                    'namespace' => 'Doctrine\\Bundle\\DoctrineBundle',
                ],
                'DoctrineFixturesBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/doctrine/doctrine-fixtures-bundle'),
                    'namespace' => 'Doctrine\\Bundle\\FixturesBundle',
                ],
                'DoctrinePHPCRBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/doctrine/phpcr-bundle/src'),
                    'namespace' => 'Doctrine\\Bundle\\PHPCRBundle',
                ],
                'FOSRestBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/friendsofsymfony/rest-bundle'),
                    'namespace' => 'FOS\\RestBundle',
                ],
                'RestRoutingBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/handcraftedinthealps/rest-routing-bundle'),
                    'namespace' => 'HandcraftedInTheAlps\\RestRoutingBundle',
                ],
                'JMSSerializerBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/jms/serializer-bundle'),
                    'namespace' => 'JMS\\SerializerBundle',
                ],
                'MassiveSearchBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/massive/search-bundle'),
                    'namespace' => 'Massive\\Bundle\\SearchBundle',
                ],
                'FOSHttpCacheBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/friendsofsymfony/http-cache-bundle/src'),
                    'namespace' => 'FOS\\HttpCacheBundle',
                ],
                'SuluSearchBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SearchBundle'),
                    'namespace' => 'Sulu\\Bundle\\SearchBundle',
                ],
                'SuluPersistenceBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/PersistenceBundle'),
                    'namespace' => 'Sulu\\Bundle\\PersistenceBundle',
                ],
                'SuluContactBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/ContactBundle'),
                    'namespace' => 'Sulu\\Bundle\\ContactBundle',
                ],
                'SuluMediaBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle'),
                    'namespace' => 'Sulu\\Bundle\\MediaBundle',
                ],
                'SuluSecurityBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SecurityBundle'),
                    'namespace' => 'Sulu\\Bundle\\SecurityBundle',
                ],
                'SuluCategoryBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CategoryBundle'),
                    'namespace' => 'Sulu\\Bundle\\CategoryBundle',
                ],
                'SuluSnippetBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SnippetBundle'),
                    'namespace' => 'Sulu\\Bundle\\SnippetBundle',
                ],
                'SuluPageBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/PageBundle'),
                    'namespace' => 'Sulu\\Bundle\\PageBundle',
                ],
                'SuluTagBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/TagBundle'),
                    'namespace' => 'Sulu\\Bundle\\TagBundle',
                ],
                'SuluWebsiteBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/WebsiteBundle'),
                    'namespace' => 'Sulu\\Bundle\\WebsiteBundle',
                ],
                'SuluLocationBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/LocationBundle'),
                    'namespace' => 'Sulu\\Bundle\\LocationBundle',
                ],
                'SuluHttpCacheBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/HttpCacheBundle'),
                    'namespace' => 'Sulu\\Bundle\\HttpCacheBundle',
                ],
                'SuluDocumentManagerBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/DocumentManagerBundle'),
                    'namespace' => 'Sulu\\Bundle\\DocumentManagerBundle',
                ],
                'SuluHashBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/HashBundle'),
                    'namespace' => 'Sulu\\Bundle\\HashBundle',
                ],
                'SuluCustomUrlBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CustomUrlBundle'),
                    'namespace' => 'Sulu\\Bundle\\CustomUrlBundle',
                ],
                'SuluRouteBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/RouteBundle'),
                    'namespace' => 'Sulu\\Bundle\\RouteBundle',
                ],
                'SuluMarkupBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MarkupBundle'),
                    'namespace' => 'Sulu\\Bundle\\MarkupBundle',
                ],
                'PhpcrMigrationsBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/dantleech/phpcr-migrations-bundle'),
                    'namespace' => 'DTL\\Bundle\\PhpcrMigrations',
                ],
                'MassiveBuildBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/massive/build-bundle'),
                    'namespace' => 'Massive\\Bundle\\BuildBundle',
                ],
                'WebProfilerBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/symfony/web-profiler-bundle'),
                    'namespace' => 'Symfony\\Bundle\\WebProfilerBundle',
                ],
                'SuluTestBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/TestBundle'),
                    'namespace' => 'Sulu\\Bundle\\TestBundle',
                ],
                'DebugBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/symfony/debug-bundle'),
                    'namespace' => 'Symfony\\Bundle\\DebugBundle',
                ],
                'CmfRoutingBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/symfony-cmf/routing-bundle/src'),
                    'namespace' => 'Symfony\\Cmf\\Bundle\\RoutingBundle',
                ],
                'StofDoctrineExtensionsBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/stof/doctrine-extensions-bundle'),
                    'namespace' => 'Stof\\DoctrineExtensionsBundle',
                ],
            ],
            'kernel.charset' => 'UTF-8',
            'kernel.container_class' => 'App_KernelDevDebugContainer',
            'sulu.context' => 'website',
            'sulu.common_cache_dir' => (\dirname(__DIR__, 3).'/common/dev'),
            'sulu.preview' => true,
            'container.dumper.inline_class_loader' => true,
            'env(MASSIVE_SEARCH_PREFIX)' => 'massive',
            'env(PHPCR_WORKSPACE)' => 'default',
            'default_locale' => 'en',
            'event_dispatcher.event_aliases' => [
                'Symfony\\Component\\Console\\Event\\ConsoleCommandEvent' => 'console.command',
                'Symfony\\Component\\Console\\Event\\ConsoleErrorEvent' => 'console.error',
                'Symfony\\Component\\Console\\Event\\ConsoleSignalEvent' => 'console.signal',
                'Symfony\\Component\\Console\\Event\\ConsoleTerminateEvent' => 'console.terminate',
                'Symfony\\Component\\Form\\Event\\PreSubmitEvent' => 'form.pre_submit',
                'Symfony\\Component\\Form\\Event\\SubmitEvent' => 'form.submit',
                'Symfony\\Component\\Form\\Event\\PostSubmitEvent' => 'form.post_submit',
                'Symfony\\Component\\Form\\Event\\PreSetDataEvent' => 'form.pre_set_data',
                'Symfony\\Component\\Form\\Event\\PostSetDataEvent' => 'form.post_set_data',
                'Symfony\\Component\\HttpKernel\\Event\\ControllerArgumentsEvent' => 'kernel.controller_arguments',
                'Symfony\\Component\\HttpKernel\\Event\\ControllerEvent' => 'kernel.controller',
                'Symfony\\Component\\HttpKernel\\Event\\ResponseEvent' => 'kernel.response',
                'Symfony\\Component\\HttpKernel\\Event\\FinishRequestEvent' => 'kernel.finish_request',
                'Symfony\\Component\\HttpKernel\\Event\\RequestEvent' => 'kernel.request',
                'Symfony\\Component\\HttpKernel\\Event\\ViewEvent' => 'kernel.view',
                'Symfony\\Component\\HttpKernel\\Event\\ExceptionEvent' => 'kernel.exception',
                'Symfony\\Component\\HttpKernel\\Event\\TerminateEvent' => 'kernel.terminate',
            ],
            'fragment.renderer.hinclude.global_template' => NULL,
            'fragment.path' => '/_fragment',
            'kernel.http_method_override' => true,
            'kernel.trusted_hosts' => [

            ],
            'kernel.default_locale' => 'en',
            'kernel.error_controller' => 'error_controller',
            'debug.file_link_format' => NULL,
            'session.metadata.storage_key' => '_sf2_meta',
            'session.storage.options' => [
                'cache_limiter' => '0',
                'name' => 'SULUSESSID',
                'cookie_secure' => 'auto',
                'cookie_httponly' => true,
                'cookie_samesite' => 'lax',
                'gc_probability' => 1,
            ],
            'session.metadata.update_threshold' => 0,
            'form.type_extension.csrf.enabled' => true,
            'form.type_extension.csrf.field_name' => '_token',
            'asset.request_context.base_path' => NULL,
            'asset.request_context.secure' => NULL,
            'validator.translation_domain' => 'validators',
            'translator.logging' => false,
            'translator.default_path' => (\dirname(__DIR__, 5).'/translations'),
            'data_collector.templates' => [

            ],
            'debug.error_handler.throw_at' => -1,
            'router.request_context.host' => 'localhost',
            'router.request_context.scheme' => 'http',
            'router.request_context.base_url' => '',
            'router.resource' => 'kernel::loadRoutes',
            'request_listener.http_port' => 80,
            'request_listener.https_port' => 443,
            'twig.form.resources' => [
                0 => 'form_div_layout.html.twig',
            ],
            'twig.default_path' => (\dirname(__DIR__, 5).'/templates'),
            'monolog.use_microseconds' => true,
            'monolog.swift_mailer.handlers' => [

            ],
            'monolog.handlers_to_channels' => [
                'monolog.handler.console' => [
                    'type' => 'exclusive',
                    'elements' => [
                        0 => 'event',
                        1 => 'doctrine',
                        2 => 'console',
                    ],
                ],
                'monolog.handler.main' => [
                    'type' => 'exclusive',
                    'elements' => [
                        0 => 'event',
                    ],
                ],
            ],
            'swiftmailer.mailer.default.transport.name' => 'dynamic',
            'swiftmailer.mailer.default.spool.enabled' => true,
            'swiftmailer.mailer.default.plugin.impersonate' => NULL,
            'swiftmailer.mailer.default.single_address' => NULL,
            'swiftmailer.mailer.default.delivery.enabled' => true,
            'swiftmailer.spool.enabled' => true,
            'swiftmailer.delivery.enabled' => true,
            'swiftmailer.single_address' => NULL,
            'swiftmailer.mailers' => [
                'default' => 'swiftmailer.mailer.default',
            ],
            'swiftmailer.default_mailer' => 'default',
            'sulu_core.locales' => [
                0 => 'de',
                1 => 'en',
            ],
            'sulu_core.translated_locales' => [
                'de' => 'Deutsch',
                'en' => 'English',
            ],
            'sulu_core.translations' => [
                0 => 'de',
                1 => 'en',
            ],
            'sulu_core.fallback_locale' => 'en',
            'sulu.content.language.namespace' => 'i18n',
            'sulu.content.language.default' => 'en',
            'sulu.content.node_names.base' => 'cmf',
            'sulu.content.node_names.content' => 'contents',
            'sulu.content.node_names.route' => 'routes',
            'sulu.content.node_names.snippet' => 'snippets',
            'sulu.content.structure.default_types' => [
                'snippet' => 'default',
            ],
            'sulu.content.structure.default_type.snippet' => 'default',
            'sulu.content.structure.required_properties' => [
                'home' => [
                    0 => 'title',
                ],
                'page' => [
                    0 => 'title',
                ],
                'snippet' => [
                    0 => 'title',
                ],
            ],
            'sulu.content.structure.required_tags' => [
                'home' => [
                    0 => 'sulu.rlp',
                ],
                'page' => [
                    0 => 'sulu.rlp',
                ],
            ],
            'sulu.content.internal_prefix' => '',
            'sulu.content.structure.type_map' => [
                'page' => 'Sulu\\Component\\Content\\Compat\\Structure\\PageBridge',
                'home' => 'Sulu\\Component\\Content\\Compat\\Structure\\PageBridge',
                'snippet' => 'Sulu\\Component\\Content\\Compat\\Structure\\SnippetBridge',
            ],
            'sulu.content.structure.paths' => [
                'page' => [
                    0 => [
                        'path' => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/PageBundle/DependencyInjection/../Content/templates'),
                        'type' => 'page',
                    ],
                    1 => [
                        'path' => (\dirname(__DIR__, 5).'/config/templates/pages'),
                        'type' => 'page',
                    ],
                    2 => [
                        'path' => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CoreBundle/DependencyInjection/../Content/templates'),
                        'type' => 'page',
                    ],
                ],
                'home' => [
                    0 => [
                        'path' => (\dirname(__DIR__, 5).'/config/templates/pages'),
                        'type' => 'home',
                    ],
                ],
                'snippet' => [
                    0 => [
                        'path' => (\dirname(__DIR__, 5).'/config/templates/snippets'),
                        'type' => 'snippet',
                    ],
                ],
            ],
            'sulu.content.path_cleaner.replacer_loader.file_locator.class' => 'Symfony\\Component\\Config\\FileLocator',
            'sulu.content.path_cleaner.replacer_loader.class' => 'Sulu\\Bundle\\CoreBundle\\DataFixtures\\ReplacerXmlLoader',
            'sulu.content.path_cleaner.class' => 'Sulu\\Component\\PHPCR\\PathCleanup',
            'sulu.content.template_resolver.class' => 'Sulu\\Component\\Content\\Template\\TemplateResolver',
            'sulu.content.mapper.class' => 'Sulu\\Component\\Content\\Mapper\\ContentMapper',
            'sulu.content.structure_manager.class' => 'Sulu\\Component\\Content\\Compat\\StructureManager',
            'sulu.content.webspace_structure_provider.cache.class' => 'Doctrine\\Common\\Cache\\FilesystemCache',
            'sulu.content.webspace_structure_provider.class' => 'Sulu\\Component\\Webspace\\StructureProvider\\WebspaceStructureProvider',
            'sulu.content.type_manager.class' => 'Sulu\\Component\\Content\\ContentTypeManager',
            'sulu.content.type.number.class' => 'Sulu\\Component\\Content\\Types\\Number',
            'sulu.content.type.text_line.class' => 'Sulu\\Component\\Content\\Types\\TextLine',
            'sulu.content.type.text_area.class' => 'Sulu\\Component\\Content\\Types\\TextArea',
            'sulu.content.type.text_editor.class' => 'Sulu\\Component\\Content\\Types\\TextEditor',
            'sulu.content.type.resource_locator.class' => 'Sulu\\Component\\Content\\Types\\ResourceLocator',
            'sulu.content.type.block.class' => 'Sulu\\Component\\Content\\Types\\BlockContentType',
            'sulu.content.resource_locator.mapper.phpcr.class' => 'Sulu\\Component\\Content\\Types\\ResourceLocator\\Mapper\\PhpcrMapper',
            'sulu.content.query_executor.class' => 'Sulu\\Component\\Content\\Query\\ContentQueryExecutor',
            'sulu.cache.warmer.structure.class' => 'Sulu\\Bundle\\CoreBundle\\Cache\\StructureWarmer',
            'sulu.util.node_helper.class' => 'Sulu\\Component\\Util\\SuluNodeHelper',
            'sulu_core.webspace.config_dir' => (\dirname(__DIR__, 5).'/config/webspaces'),
            'sulu_core.webspace.cache_class' => 'websiteWebspaceCollectionCache',
            'sulu_core.webspace.base_class' => 'WebspaceCollection',
            'sulu_core.cache.memoize.default_lifetime' => 1,
            'sulu_core.cache.memoize.cache.class' => 'Doctrine\\Common\\Cache\\ArrayCache',
            'sulu_core.cache.memoize.class' => 'Sulu\\Component\\Cache\\Memoize',
            'sulu.fields_defaults.translations' => [
                'id' => 'public.id',
                'title' => 'public.title',
                'name' => 'public.name',
                'created' => 'public.created',
                'changed' => 'public.changed',
            ],
            'sulu.fields_defaults.widths' => [
                'id' => '50px',
            ],
            'sulu.phpcr.session.class' => 'Sulu\\Component\\PHPCR\\SessionManager\\SessionManager',
            'sulu_core.build.builder.database.class' => 'Sulu\\Bundle\\CoreBundle\\Build\\DatabaseBuilder',
            'sulu_core.build.builder.phpcr.class' => 'Sulu\\Bundle\\CoreBundle\\Build\\PhpcrBuilder',
            'sulu_core.build.builder.phpcr_migrations.class' => 'Sulu\\Bundle\\CoreBundle\\Build\\PhpcrMigrationsBuilder',
            'sulu_core.build.builder.fixtures.class' => 'Sulu\\Bundle\\CoreBundle\\Build\\FixturesBuilder',
            'sulu.core.localization_manager.class' => 'Sulu\\Component\\Localization\\Manager\\LocalizationManager',
            'sulu.core.localization_manager.core_provider.class' => 'Sulu\\Component\\Localization\\Provider\\LocalizationProvider',
            'doctrine.dbal.logger.chain.class' => 'Doctrine\\DBAL\\Logging\\LoggerChain',
            'doctrine.dbal.logger.profiling.class' => 'Doctrine\\DBAL\\Logging\\DebugStack',
            'doctrine.dbal.logger.class' => 'Symfony\\Bridge\\Doctrine\\Logger\\DbalLogger',
            'doctrine.dbal.configuration.class' => 'Doctrine\\DBAL\\Configuration',
            'doctrine.data_collector.class' => 'Doctrine\\Bundle\\DoctrineBundle\\DataCollector\\DoctrineDataCollector',
            'doctrine.dbal.connection.event_manager.class' => 'Symfony\\Bridge\\Doctrine\\ContainerAwareEventManager',
            'doctrine.dbal.connection_factory.class' => 'Doctrine\\Bundle\\DoctrineBundle\\ConnectionFactory',
            'doctrine.dbal.events.mysql_session_init.class' => 'Doctrine\\DBAL\\Event\\Listeners\\MysqlSessionInit',
            'doctrine.dbal.events.oracle_session_init.class' => 'Doctrine\\DBAL\\Event\\Listeners\\OracleSessionInit',
            'doctrine.class' => 'Doctrine\\Bundle\\DoctrineBundle\\Registry',
            'doctrine.entity_managers' => [
                'default' => 'doctrine.orm.default_entity_manager',
            ],
            'doctrine.default_entity_manager' => 'default',
            'doctrine.dbal.connection_factory.types' => [

            ],
            'doctrine.connections' => [
                'default' => 'doctrine.dbal.default_connection',
            ],
            'doctrine.default_connection' => 'default',
            'doctrine.orm.configuration.class' => 'Doctrine\\ORM\\Configuration',
            'doctrine.orm.entity_manager.class' => 'Doctrine\\ORM\\EntityManager',
            'doctrine.orm.manager_configurator.class' => 'Doctrine\\Bundle\\DoctrineBundle\\ManagerConfigurator',
            'doctrine.orm.cache.array.class' => 'Doctrine\\Common\\Cache\\ArrayCache',
            'doctrine.orm.cache.apc.class' => 'Doctrine\\Common\\Cache\\ApcCache',
            'doctrine.orm.cache.memcache.class' => 'Doctrine\\Common\\Cache\\MemcacheCache',
            'doctrine.orm.cache.memcache_host' => 'localhost',
            'doctrine.orm.cache.memcache_port' => 11211,
            'doctrine.orm.cache.memcache_instance.class' => 'Memcache',
            'doctrine.orm.cache.memcached.class' => 'Doctrine\\Common\\Cache\\MemcachedCache',
            'doctrine.orm.cache.memcached_host' => 'localhost',
            'doctrine.orm.cache.memcached_port' => 11211,
            'doctrine.orm.cache.memcached_instance.class' => 'Memcached',
            'doctrine.orm.cache.redis.class' => 'Doctrine\\Common\\Cache\\RedisCache',
            'doctrine.orm.cache.redis_host' => 'localhost',
            'doctrine.orm.cache.redis_port' => 6379,
            'doctrine.orm.cache.redis_instance.class' => 'Redis',
            'doctrine.orm.cache.xcache.class' => 'Doctrine\\Common\\Cache\\XcacheCache',
            'doctrine.orm.cache.wincache.class' => 'Doctrine\\Common\\Cache\\WinCacheCache',
            'doctrine.orm.cache.zenddata.class' => 'Doctrine\\Common\\Cache\\ZendDataCache',
            'doctrine.orm.metadata.driver_chain.class' => 'Doctrine\\Persistence\\Mapping\\Driver\\MappingDriverChain',
            'doctrine.orm.metadata.annotation.class' => 'Doctrine\\ORM\\Mapping\\Driver\\AnnotationDriver',
            'doctrine.orm.metadata.xml.class' => 'Doctrine\\ORM\\Mapping\\Driver\\SimplifiedXmlDriver',
            'doctrine.orm.metadata.yml.class' => 'Doctrine\\ORM\\Mapping\\Driver\\SimplifiedYamlDriver',
            'doctrine.orm.metadata.php.class' => 'Doctrine\\ORM\\Mapping\\Driver\\PHPDriver',
            'doctrine.orm.metadata.staticphp.class' => 'Doctrine\\ORM\\Mapping\\Driver\\StaticPHPDriver',
            'doctrine.orm.proxy_cache_warmer.class' => 'Symfony\\Bridge\\Doctrine\\CacheWarmer\\ProxyCacheWarmer',
            'form.type_guesser.doctrine.class' => 'Symfony\\Bridge\\Doctrine\\Form\\DoctrineOrmTypeGuesser',
            'doctrine.orm.validator.unique.class' => 'Symfony\\Bridge\\Doctrine\\Validator\\Constraints\\UniqueEntityValidator',
            'doctrine.orm.validator_initializer.class' => 'Symfony\\Bridge\\Doctrine\\Validator\\DoctrineInitializer',
            'doctrine.orm.security.user.provider.class' => 'Symfony\\Bridge\\Doctrine\\Security\\User\\EntityUserProvider',
            'doctrine.orm.listeners.resolve_target_entity.class' => 'Doctrine\\ORM\\Tools\\ResolveTargetEntityListener',
            'doctrine.orm.listeners.attach_entity_listeners.class' => 'Doctrine\\ORM\\Tools\\AttachEntityListenersListener',
            'doctrine.orm.naming_strategy.default.class' => 'Doctrine\\ORM\\Mapping\\DefaultNamingStrategy',
            'doctrine.orm.naming_strategy.underscore.class' => 'Doctrine\\ORM\\Mapping\\UnderscoreNamingStrategy',
            'doctrine.orm.quote_strategy.default.class' => 'Doctrine\\ORM\\Mapping\\DefaultQuoteStrategy',
            'doctrine.orm.quote_strategy.ansi.class' => 'Doctrine\\ORM\\Mapping\\AnsiQuoteStrategy',
            'doctrine.orm.entity_listener_resolver.class' => 'Doctrine\\Bundle\\DoctrineBundle\\Mapping\\ContainerEntityListenerResolver',
            'doctrine.orm.second_level_cache.default_cache_factory.class' => 'Doctrine\\ORM\\Cache\\DefaultCacheFactory',
            'doctrine.orm.second_level_cache.default_region.class' => 'Doctrine\\ORM\\Cache\\Region\\DefaultRegion',
            'doctrine.orm.second_level_cache.filelock_region.class' => 'Doctrine\\ORM\\Cache\\Region\\FileLockRegion',
            'doctrine.orm.second_level_cache.logger_chain.class' => 'Doctrine\\ORM\\Cache\\Logging\\CacheLoggerChain',
            'doctrine.orm.second_level_cache.logger_statistics.class' => 'Doctrine\\ORM\\Cache\\Logging\\StatisticsCacheLogger',
            'doctrine.orm.second_level_cache.cache_configuration.class' => 'Doctrine\\ORM\\Cache\\CacheConfiguration',
            'doctrine.orm.second_level_cache.regions_configuration.class' => 'Doctrine\\ORM\\Cache\\RegionsConfiguration',
            'doctrine.orm.auto_generate_proxy_classes' => true,
            'doctrine.orm.proxy_namespace' => 'Proxies',
            'doctrine_phpcr.sessions' => [
                'default' => 'doctrine_phpcr.default_session',
                'live' => 'doctrine_phpcr.live_session',
            ],
            'doctrine_phpcr.odm.document_managers' => [

            ],
            'doctrine_phpcr.default_session' => 'default',
            'doctrine_phpcr.odm.default_document_manager' => '',
            'doctrine_phpcr.dump_max_line_length' => 120,
            'doctrine_phpcr.form.type_guess' => [

            ],
            'massive_search.search_manager.class' => 'Massive\\Bundle\\SearchBundle\\Search\\SearchManager',
            'massive_search.object_to_document_converter.class' => 'Massive\\Bundle\\SearchBundle\\Search\\ObjectToDocumentConverter',
            'massive_search.expression_language.class' => 'Massive\\Bundle\\SearchBundle\\Search\\ExpressionLanguage\\MassiveSearchExpressionLanguage',
            'massive_search.search.adapter.zend_lucene.class' => 'Massive\\Bundle\\SearchBundle\\Search\\Adapter\\ZendLuceneAdapter',
            'massive_search.search.adapter.test.class' => 'Massive\\Bundle\\SearchBundle\\Search\\Adapter\\TestAdapter',
            'massive_search.factory_default.class' => 'Massive\\Bundle\\SearchBundle\\Search\\Factory',
            'massive_search.controller.rest.class' => 'Massive\\Bundle\\SearchBundle\\Controller\\SearchController',
            'massive_search.events.index' => 'massive_search.index',
            'massive_search.events.deindex' => 'massive_search.deindex',
            'massive_search.adapter.zend_lucene.basepath' => (\dirname(__DIR__, 4).'/indexes'),
            'massive_search.adapter.zend_lucene.hide_index_exception' => false,
            'massive_search.adapter.zend_lucene.encoding' => 'UTF-8',
            'massive_search.metadata.debug' => true,
            'massive_search.metadata.driver.xml.class' => 'Massive\\Bundle\\SearchBundle\\Search\\Metadata\\Driver\\XmlDriver',
            'massive_search.metadata.driver.annotation.class' => 'Symfony\\Cmf\\Bundle\\TreeUiBundle\\Tree\\Metadata\\Driver\\AnnotationDriver',
            'massive_search.metadata.driver.chain.class' => 'Metadata\\Driver\\DriverChain',
            'massive_search.metadata.file_locator.class' => 'Metadata\\Driver\\FileLocator',
            'massive_search.metadata.factory.class' => 'Metadata\\MetadataFactory',
            'massive_search.metadata.field_evaluator.class' => 'Massive\\Bundle\\SearchBundle\\Search\\Metadata\\FieldEvaluator',
            'massive_search.metadata.cache.file_cache.class' => 'Metadata\\Cache\\FileCache',
            'massive_search.metadata.provider.default.class' => 'Massive\\Bundle\\SearchBundle\\Search\\Metadata\\Provider\\DefaultProvider',
            'massive_search.metadata.provider.chain.class' => 'Massive\\Bundle\\SearchBundle\\Search\\Metadata\\Provider\\ChainProvider',
            'fos_http_cache.debug_header' => 'X-Cache-Debug',
            'fos_http_cache.cacheable.response.additional_status' => [

            ],
            'fos_http_cache.proxy_client.symfony.options' => [
                'tags_header' => 'X-Cache-Tags',
                'tags_method' => 'PURGETAGS',
                'purge_method' => 'PURGE',
            ],
            'fos_http_cache.cache_manager.generate_url_type' => 0,
            'fos_http_cache.compiler_pass.tag_annotations' => false,
            'fos_http_cache.tag_handler.response_header' => 'X-Cache-Tags',
            'fos_http_cache.tag_handler.separator' => ',',
            'fos_http_cache.tag_handler.strict' => false,
            'sulu_search.indexes' => [
                'snippet' => [
                    'name' => 'sulu_snippet.snippets',
                    'icon' => 'su-snippet',
                    'view' => [
                        'name' => 'sulu_snippet.edit_form',
                        'result_to_view' => [
                            'id' => 'id',
                            'locale' => 'locale',
                        ],
                    ],
                    'security_context' => 'sulu.global.snippets',
                    'contexts' => [

                    ],
                ],
                'category' => [
                    'name' => 'sulu_category.categories',
                    'icon' => 'su-tag',
                    'view' => [
                        'name' => 'sulu_category.edit_form',
                        'result_to_view' => [
                            'id' => 'id',
                            'locale' => 'locale',
                        ],
                    ],
                    'security_context' => 'sulu.settings.categories',
                    'contexts' => [

                    ],
                ],
                'media' => [
                    'name' => 'sulu_media.media',
                    'icon' => 'su-image',
                    'view' => [
                        'name' => 'sulu_media.form',
                        'result_to_view' => [
                            'id' => 'id',
                            'locale' => 'locale',
                        ],
                    ],
                    'security_context' => 'sulu.media.collections',
                    'contexts' => [

                    ],
                ],
                'contact' => [
                    'name' => 'sulu_contact.people',
                    'icon' => 'su-user',
                    'view' => [
                        'name' => 'sulu_contact.contact_edit_form',
                        'result_to_view' => [
                            'id' => 'id',
                            'locale' => 'locale',
                        ],
                    ],
                    'security_context' => 'sulu.contact.people',
                    'contexts' => [

                    ],
                ],
                'account' => [
                    'name' => 'sulu_contact.organizations',
                    'icon' => 'su-house',
                    'view' => [
                        'name' => 'sulu_contact.account_edit_form',
                        'result_to_view' => [
                            'id' => 'id',
                            'locale' => 'locale',
                        ],
                    ],
                    'security_context' => 'sulu.contact.organizations',
                    'contexts' => [

                    ],
                ],
                'page_example' => [
                    'name' => 'example.com',
                    'icon' => 'su-document',
                    'view' => [
                        'name' => 'sulu_page.page_edit_form',
                        'result_to_view' => [
                            'id' => 'id',
                            'locale' => 'locale',
                            'properties/webspace_key' => 'webspace',
                        ],
                    ],
                    'security_context' => 'sulu.webspaces.example',
                ],
                'page_example_published' => [
                    'name' => 'example.com',
                    'icon' => 'su-document',
                    'view' => [
                        'name' => 'sulu_page.page_edit_form',
                        'result_to_view' => [
                            'id' => 'id',
                            'locale' => 'locale',
                            'properties/webspace_key' => 'webspace',
                        ],
                    ],
                    'security_context' => 'sulu.webspaces.example',
                    'contexts' => [
                        0 => 'website',
                    ],
                ],
            ],
            'sulu_search.website.indexes' => [
                0 => 'page_#webspace#_published',
            ],
            'sulu_search.controller.search.class' => 'Sulu\\Bundle\\SearchBundle\\Controller\\SearchController',
            'sulu_search.search.factory.class' => 'Sulu\\Bundle\\SearchBundle\\Search\\Factory',
            'sulu_search.build.index.class' => 'Sulu\\Bundle\\SearchBundle\\Build\\IndexBuilder',
            'sulu.persistence.event_subscriber.orm.timestampable.class' => 'Sulu\\Component\\Persistence\\EventSubscriber\\ORM\\TimestampableSubscriber',
            'sulu.persistence.event_subscriber.orm.user_blame.class' => 'Sulu\\Component\\Persistence\\EventSubscriber\\ORM\\UserBlameSubscriber',
            'sulu.persistence.event_subscriber.orm.metadata.class' => 'Sulu\\Component\\Persistence\\EventSubscriber\\ORM\\MetadataSubscriber',
            'sulu_contact.contact_title.entity' => 'SuluContactBundle:ContactTitle',
            'sulu_contact.position.entity' => 'SuluContactBundle:Position',
            'sulu_contact.defaults' => [
                'phoneType' => '1',
                'phoneTypeMobile' => '3',
                'phoneTypeIsdn' => '1',
                'emailType' => '1',
                'addressType' => '1',
                'urlType' => '1',
                'faxType' => '1',
                'socialMediaProfileType' => '1',
                'country' => 'AT',
            ],
            'sulu_contact.form_of_address' => [
                'male' => [
                    'id' => 0,
                    'name' => 'male',
                    'translation' => 'contact.contacts.formOfAddress.male',
                ],
                'female' => [
                    'id' => 1,
                    'name' => 'female',
                    'translation' => 'contact.contacts.formOfAddress.female',
                ],
            ],
            'sulu_contact.contact_form.category_root' => NULL,
            'sulu_contact.account_form.category_root' => NULL,
            'sulu.model.contact.class' => 'Sulu\\Bundle\\ContactBundle\\Entity\\Contact',
            'sulu.repository.contact.class' => 'Sulu\\Bundle\\ContactBundle\\Entity\\ContactRepository',
            'sulu.model.account.class' => 'Sulu\\Bundle\\ContactBundle\\Entity\\Account',
            'sulu.repository.account.class' => 'Sulu\\Bundle\\ContactBundle\\Entity\\AccountRepository',
            'sulu.persistence.objects' => [
                'sulu' => [
                    'route' => [
                        'model' => 'Sulu\\Bundle\\RouteBundle\\Entity\\Route',
                        'repository' => 'Sulu\\Bundle\\RouteBundle\\Entity\\RouteRepository',
                    ],
                    'tag' => [
                        'model' => 'Sulu\\Bundle\\TagBundle\\Entity\\Tag',
                        'repository' => 'Sulu\\Bundle\\TagBundle\\Entity\\TagRepository',
                    ],
                    'category' => [
                        'model' => 'Sulu\\Bundle\\CategoryBundle\\Entity\\Category',
                        'repository' => 'Sulu\\Bundle\\CategoryBundle\\Entity\\CategoryRepository',
                    ],
                    'category_meta' => [
                        'model' => 'Sulu\\Bundle\\CategoryBundle\\Entity\\CategoryMeta',
                        'repository' => 'Sulu\\Bundle\\CategoryBundle\\Entity\\CategoryMetaRepository',
                    ],
                    'category_translation' => [
                        'model' => 'Sulu\\Bundle\\CategoryBundle\\Entity\\CategoryTranslation',
                        'repository' => 'Sulu\\Bundle\\CategoryBundle\\Entity\\CategoryTranslationRepository',
                    ],
                    'keyword' => [
                        'model' => 'Sulu\\Bundle\\CategoryBundle\\Entity\\Keyword',
                        'repository' => 'Sulu\\Bundle\\CategoryBundle\\Entity\\KeywordRepository',
                    ],
                    'user' => [
                        'model' => 'Sulu\\Bundle\\SecurityBundle\\Entity\\User',
                        'repository' => 'Sulu\\Bundle\\SecurityBundle\\Entity\\UserRepository',
                    ],
                    'role' => [
                        'model' => 'Sulu\\Bundle\\SecurityBundle\\Entity\\Role',
                        'repository' => 'Sulu\\Bundle\\SecurityBundle\\Entity\\RoleRepository',
                    ],
                    'role_setting' => [
                        'model' => 'Sulu\\Bundle\\SecurityBundle\\Entity\\RoleSetting',
                        'repository' => 'Sulu\\Bundle\\SecurityBundle\\Entity\\RoleSettingRepository',
                    ],
                    'access_control' => [
                        'model' => 'Sulu\\Bundle\\SecurityBundle\\Entity\\AccessControl',
                        'repository' => 'Sulu\\Bundle\\SecurityBundle\\Entity\\AccessControlRepository',
                    ],
                    'media' => [
                        'model' => 'Sulu\\Bundle\\MediaBundle\\Entity\\Media',
                        'repository' => 'Sulu\\Bundle\\MediaBundle\\Entity\\MediaRepository',
                    ],
                    'contact' => [
                        'model' => 'Sulu\\Bundle\\ContactBundle\\Entity\\Contact',
                        'repository' => 'Sulu\\Bundle\\ContactBundle\\Entity\\ContactRepository',
                    ],
                    'account' => [
                        'model' => 'Sulu\\Bundle\\ContactBundle\\Entity\\Account',
                        'repository' => 'Sulu\\Bundle\\ContactBundle\\Entity\\AccountRepository',
                    ],
                ],
            ],
            'sulu.model.collection.class' => 'Sulu\\Bundle\\MediaBundle\\Entity\\Collection',
            'sulu_media.image_format_files' => [
                0 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/MediaBundle/DependencyInjection/../Resources/config/image-formats.xml'),
                1 => (\dirname(__DIR__, 5).'/config/image-formats.xml'),
            ],
            'sulu_media.system_collections' => [
                'sulu_media' => [
                    'meta_title' => [
                        'en' => 'Sulu media',
                        'de' => 'Sulu Medien',
                    ],
                    'collections' => [
                        'preview_image' => [
                            'meta_title' => [
                                'en' => 'Preview images',
                                'de' => 'Vorschaubilder',
                            ],
                        ],
                    ],
                ],
                'sulu_contact' => [
                    'meta_title' => [
                        'en' => 'Sulu contacts',
                        'de' => 'Sulu Kontakte',
                    ],
                    'collections' => [
                        'contact' => [
                            'meta_title' => [
                                'en' => 'People',
                                'de' => 'Personen',
                            ],
                        ],
                        'account' => [
                            'meta_title' => [
                                'en' => 'Organizations',
                                'de' => 'Organisationen',
                            ],
                        ],
                    ],
                ],
            ],
            'sulu_media.format_cache.media_proxy_path' => '/uploads/media/{slug}',
            'sulu_media.media_manager.media_download_path' => '/media/{id}/download/{slug}',
            'sulu_media.media_manager.media_download_path_admin' => '/admin/media/{id}/download/{slug}',
            'sulu_media.format_manager.response_headers' => [
                'Expires' => '+1 month',
                'Pragma' => 'public',
                'Cache-Control' => 'public',
            ],
            'sulu_media.format_manager.default_imagine_options' => [
                'jpeg_quality' => 100,
                'webp_quality' => 100,
            ],
            'sulu_media.format_cache.path' => (\dirname(__DIR__, 5).'/public/uploads/media'),
            'sulu_media.format_cache.save_image' => true,
            'sulu_media.format_cache.segments' => 10,
            'sulu_media.ghost_script.path' => 'gs',
            'sulu_media.media.blocked_file_types' => [

            ],
            'sulu_media.collection.type.default' => [
                'id' => 1,
            ],
            'sulu_media.collection.previews.format' => 'sulu-50x50',
            'sulu_media.media.types' => [
                0 => [
                    'type' => 'document',
                    'mimeTypes' => [
                        0 => '*',
                    ],
                ],
                1 => [
                    'type' => 'image',
                    'mimeTypes' => [
                        0 => 'image/*',
                    ],
                ],
                2 => [
                    'type' => 'video',
                    'mimeTypes' => [
                        0 => 'video/*',
                    ],
                ],
                3 => [
                    'type' => 'audio',
                    'mimeTypes' => [
                        0 => 'audio/*',
                    ],
                ],
            ],
            'sulu_media.search.default_image_format' => 'sulu-100x100',
            'sulu_media.disposition_type.default' => 'attachment',
            'sulu_media.disposition_type.mime_types_inline' => [

            ],
            'sulu_media.disposition_type.mime_types_attachment' => [

            ],
            'sulu_media.upload.max_filesize' => 256,
            'sulu_media.media.max_file_size' => '256MB',
            'sulu_media.adobe_creative_key' => NULL,
            'sulu_media.admin.class' => 'Sulu\\Bundle\\MediaBundle\\Admin\\MediaAdmin',
            'sulu_media.media_manager.class' => 'Sulu\\Bundle\\MediaBundle\\Media\\Manager\\MediaManager',
            'sulu_media.collection_repository.class' => 'Sulu\\Bundle\\MediaBundle\\Entity\\CollectionRepository',
            'sulu_media.file_validator.class' => 'Sulu\\Bundle\\MediaBundle\\Media\\FileValidator\\FileValidator',
            'sulu_media.format_manager.class' => 'Sulu\\Bundle\\MediaBundle\\Media\\FormatManager\\FormatManager',
            'sulu_media.format_cache_clearer.class' => 'Sulu\\Bundle\\MediaBundle\\Media\\FormatCache\\FormatCacheClearer',
            'sulu_media.format_cache.class' => 'Sulu\\Bundle\\MediaBundle\\Media\\FormatCache\\LocalFormatCache',
            'sulu_media.image.converter.class' => 'Sulu\\Bundle\\MediaBundle\\Media\\ImageConverter\\ImagineImageConverter',
            'sulu_media.image.scaler.class' => 'Sulu\\Bundle\\MediaBundle\\Media\\ImageConverter\\Scaler\\Scaler',
            'sulu_media.image.cropper.class' => 'Sulu\\Bundle\\MediaBundle\\Media\\ImageConverter\\Cropper\\Cropper',
            'sulu_media.image.transformation_pool.class' => 'Sulu\\Bundle\\MediaBundle\\Media\\ImageConverter\\TransformationPool',
            'sulu_media.image.transformation.crop.class' => 'Sulu\\Bundle\\MediaBundle\\Media\\ImageConverter\\Transformation\\CropTransformation',
            'sulu_media.media_selection.class' => 'Sulu\\Bundle\\MediaBundle\\Content\\Types\\MediaSelectionContentType',
            'sulu_media.collection_manager.class' => 'Sulu\\Bundle\\MediaBundle\\Collection\\Manager\\CollectionManager',
            'sulu_media.type_manager.class' => 'Sulu\\Bundle\\MediaBundle\\Media\\TypeManager\\TypeManager',
            'sulu_media.format_options_manager.class' => 'Sulu\\Bundle\\MediaBundle\\Media\\FormatOptions\\FormatOptionsManager',
            'sulu_media.collection_entity' => 'SuluMediaBundle:Collection',
            'sulu_media.format_options_entity' => 'SuluMediaBundle:FormatOptions',
            'sulu_media.entity.file_version_meta' => 'SuluMediaBundle:FileVersionMeta',
            'sulu_media.twig_extension.disposition_type.class' => 'Sulu\\Bundle\\MediaBundle\\Twig\\DispositionTypeTwigExtension',
            'sulu_media.twig_extension.media.class' => 'Sulu\\Bundle\\MediaBundle\\Twig\\MediaTwigExtension',
            'tmp' => 'Sulu\\Bundle\\MediaBundle\\Twig\\MediaTwigExtension',
            'sulu_media.video_thumbnail_generator.class' => 'Sulu\\Bundle\\MediaBundle\\Media\\Video\\VideoThumbnailService',
            'sulu_media.search.subscriber.structure_media.class' => 'Sulu\\Bundle\\MediaBundle\\Search\\Subscriber\\StructureMediaSearchSubscriber',
            'sulu_media.search.subscriber.media.class' => 'Sulu\\Bundle\\MediaBundle\\Search\\Subscriber\\MediaSearchSubscriber',
            'sulu_media.format_manager.mime_types' => [
                0 => 'image/*',
                1 => 'application/pdf',
            ],
            'sulu.model.media.class' => 'Sulu\\Bundle\\MediaBundle\\Entity\\Media',
            'sulu.repository.media.class' => 'Sulu\\Bundle\\MediaBundle\\Entity\\MediaRepository',
            'sulu_media.media.storage' => 'local',
            'sulu_media.media.storage.local.path' => (\dirname(__DIR__, 4).'/uploads/media'),
            'sulu_media.media.storage.local.segments' => 10,
            'sulu_security.system' => 'Sulu',
            'sulu_security.security_types.fixture' => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/SecurityBundle/DependencyInjection/../DataFixtures/security-types.xml'),
            'sulu_security.reset_password.mail.token_send_limit' => 3,
            'sulu_security.reset_password.mail.sender' => '',
            'sulu_security.reset_password.mail.subject' => 'sulu_security.reset_mail_subject',
            'sulu_security.reset_password.mail.template' => '@SuluSecurity/mail_templates/reset_password.html.twig',
            'sulu_security.reset_password.mail.translation_domain' => 'admin',
            'sulu_security.permissions' => [
                'view' => 64,
                'add' => 32,
                'edit' => 16,
                'delete' => 8,
                'archive' => 4,
                'live' => 2,
                'security' => 1,
            ],
            'permissions' => [
                'view' => 64,
                'add' => 32,
                'edit' => 16,
                'delete' => 8,
                'archive' => 4,
                'live' => 2,
                'security' => 1,
            ],
            'sulu_security.admin.class' => 'Sulu\\Bundle\\SecurityBundle\\Admin\\SecurityAdmin',
            'sulu_security.authentication_entry_point.class' => 'Sulu\\Bundle\\SecurityBundle\\Security\\AuthenticationEntryPoint',
            'sulu_security.authentication_handler.class' => 'Sulu\\Bundle\\SecurityBundle\\Security\\AuthenticationHandler',
            'sulu_security.mask_converter.class' => 'Sulu\\Component\\Security\\Authorization\\MaskConverter',
            'sulu_security.salt_generator.class' => 'Sulu\\Component\\Security\\Authentication\\SaltGenerator',
            'sulu_security.token_generator.class' => 'Sulu\\Bundle\\SecurityBundle\\Util\\TokenGenerator',
            'sulu_security.security_context_voter.class' => 'Sulu\\Component\\Security\\Authorization\\SecurityContextVoter',
            'sulu_security.access_control_manager.class' => 'Sulu\\Component\\Security\\Authorization\\AccessControl\\AccessControlManager',
            'sulu_security.phpcr_access_control_provider.class' => 'Sulu\\Component\\Security\\Authorization\\AccessControl\\PhpcrAccessControlProvider',
            'sulu_security.doctrine_access_control_provider.class' => 'Sulu\\Component\\Security\\Authorization\\AccessControl\\DoctrineAccessControlProvider',
            'sulu_security.permission_controller.class' => 'Sulu\\Bundle\\SecurityBundle\\Controller\\PermissionController',
            'sulu_security.group_repository.class' => 'Sulu\\Bundle\\SecurityBundle\\Entity\\GroupRepository',
            'sulu_security.user_repository.class' => 'Sulu\\Bundle\\SecurityBundle\\Entity\\UserRepository',
            'sulu_security.user_setting_repository.class' => 'Sulu\\Bundle\\SecurityBundle\\Entity\\UserSettingRepository',
            'sulu_security.user_repository_factory.class' => 'Sulu\\Component\\Security\\Authentication\\UserRepositoryFactory',
            'sulu_security.build.user.class' => 'Sulu\\Bundle\\SecurityBundle\\Build\\UserBuilder',
            'sulu_security.entity.role' => 'SuluSecurityBundle:Role',
            'sulu_security.entity.group' => 'SuluSecurityBundle:Group',
            'sulu_security.entity.user_setting' => 'SuluSecurityBundle:UserSetting',
            'sulu_security.profile_controller.class' => 'Sulu\\Bundle\\SecurityBundle\\Controller\\ProfileController',
            'sulu.model.user.class' => 'Sulu\\Bundle\\SecurityBundle\\Entity\\User',
            'sulu.repository.user.class' => 'Sulu\\Bundle\\SecurityBundle\\Entity\\UserRepository',
            'sulu.model.role.class' => 'Sulu\\Bundle\\SecurityBundle\\Entity\\Role',
            'sulu.repository.role.class' => 'Sulu\\Bundle\\SecurityBundle\\Entity\\RoleRepository',
            'sulu.model.role_setting.class' => 'Sulu\\Bundle\\SecurityBundle\\Entity\\RoleSetting',
            'sulu.repository.role_setting.class' => 'Sulu\\Bundle\\SecurityBundle\\Entity\\RoleSettingRepository',
            'sulu.model.access_control.class' => 'Sulu\\Bundle\\SecurityBundle\\Entity\\AccessControl',
            'sulu.repository.access_control.class' => 'Sulu\\Bundle\\SecurityBundle\\Entity\\AccessControlRepository',
            'sulu.model.category.class' => 'Sulu\\Bundle\\CategoryBundle\\Entity\\Category',
            'sulu.repository.category.class' => 'Sulu\\Bundle\\CategoryBundle\\Entity\\CategoryRepository',
            'sulu.model.category_meta.class' => 'Sulu\\Bundle\\CategoryBundle\\Entity\\CategoryMeta',
            'sulu.repository.category_meta.class' => 'Sulu\\Bundle\\CategoryBundle\\Entity\\CategoryMetaRepository',
            'sulu.model.category_translation.class' => 'Sulu\\Bundle\\CategoryBundle\\Entity\\CategoryTranslation',
            'sulu.repository.category_translation.class' => 'Sulu\\Bundle\\CategoryBundle\\Entity\\CategoryTranslationRepository',
            'sulu.model.keyword.class' => 'Sulu\\Bundle\\CategoryBundle\\Entity\\Keyword',
            'sulu.repository.keyword.class' => 'Sulu\\Bundle\\CategoryBundle\\Entity\\KeywordRepository',
            'sulu_snippet.content-type.default_enabled' => true,
            'sulu_snippet.twig.snippet.cache_lifetime' => 1,
            'sulu_snippet.repository.class' => 'Sulu\\Bundle\\SnippetBundle\\Snippet\\SnippetRepository',
            'sulu_snippet.controller.snippet.class' => 'Sulu\\Bundle\\SnippetBundle\\Controller\\SnippetController',
            'sulu_snippet.twig.snippet.class' => 'Sulu\\Bundle\\SnippetBundle\\Twig\\SnippetTwigExtension',
            'sulu_snippet.twig.snippet.memoized.class' => 'Sulu\\Bundle\\SnippetBundle\\Twig\\MemoizedSnippetTwigExtension',
            'sulu_snippet.form.snippet.class' => 'Sulu\\Bundle\\SnippetBundle\\Form\\SnippetType',
            'sulu_snippet.document.snippet_initializer.class' => 'Sulu\\Bundle\\SnippetBundle\\Document\\SnippetInitializer',
            'sulu_snippet.export.snippet.formats' => [
                '1.2.xliff' => '@SuluPage/Export/Snippet/1.2.xliff.twig',
            ],
            'sulu_page.search.mapping' => [
                'Sulu\\Bundle\\PageBundle\\Document\\PageDocument' => [
                    'index' => 'page',
                    'decorate_index' => true,
                ],
                'Sulu\\Bundle\\PageBundle\\Document\\HomeDocument' => [
                    'index' => 'page',
                    'decorate_index' => true,
                ],
                'Sulu\\Bundle\\SnippetBundle\\Document\\SnippetDocument' => [
                    'index' => 'snippet',
                    'decorate_index' => false,
                ],
            ],
            'sulu_page.search.metadata.provider.structure.class' => 'Sulu\\Bundle\\PageBundle\\Search\\Metadata\\StructureProvider',
            'sulu_page.search.event_subscriber.blame_timestamp.class' => 'Sulu\\Bundle\\PageBundle\\Search\\EventSubscriber\\BlameTimestampSubscriber',
            'sulu_page.search.event_subscriber.structure.class' => 'Sulu\\Bundle\\PageBundle\\Search\\EventSubscriber\\StructureSubscriber',
            'sulu_search.event_listener.hit.class' => 'Sulu\\Bundle\\PageBundle\\Search\\EventListener\\HitListener',
            'sulu_page.admin.class' => 'Sulu\\Bundle\\PageBundle\\Admin\\PageAdmin',
            'sulu_page.node_repository.class' => 'Sulu\\Bundle\\PageBundle\\Repository\\NodeRepository',
            'sulu_page.rl_repository.class' => 'Sulu\\Bundle\\PageBundle\\Repository\\ResourceLocatorRepository',
            'sulu_page.extension.seo.class' => 'Sulu\\Bundle\\PageBundle\\Content\\Structure\\SeoStructureExtension',
            'sulu_page.extension.excerpt.class' => 'Sulu\\Bundle\\PageBundle\\Content\\Structure\\ExcerptStructureExtension',
            'sulu_page.smart_content.data_provider_pool.class' => 'Sulu\\Component\\SmartContent\\DataProviderPool',
            'sulu_page.smart_content.data_provider.content.query_builder.class' => 'Sulu\\Component\\Content\\SmartContent\\QueryBuilder',
            'sulu_page.smart_content.data_provider.page.class' => 'Sulu\\Component\\Content\\SmartContent\\PageDataProvider',
            'sulu_page.smart_content.data_provider.content.proxy_factory.class' => 'ProxyManager\\Factory\\LazyLoadingValueHolderFactory',
            'sulu_page.smart_content.content_type.class' => 'Sulu\\Component\\SmartContent\\ContentType',
            'sulu_page.extension.manager.class' => 'Sulu\\Component\\Content\\Extension\\ExtensionManager',
            'sulu_page.export.webspace.formats' => [
                '1.2.xliff' => '@SuluPage/Export/Webspace/1.2.xliff.twig',
            ],
            'sulu_page.default_author' => true,
            'sulu_page.seo' => [
                'max_title_length' => 70,
                'max_description_length' => 320,
                'max_keywords' => 5,
                'keywords_separator' => ',',
                'url_prefix' => 'www.yoursite.com/{locale}',
            ],
            'sulu.model.tag.class' => 'Sulu\\Bundle\\TagBundle\\Entity\\Tag',
            'sulu.repository.tag.class' => 'Sulu\\Bundle\\TagBundle\\Entity\\TagRepository',
            'sulu_website.navigation.cache.lifetime' => 1,
            'sulu_website.content.cache.lifetime' => 1,
            'sulu_website.sitemap.cache.lifetime' => 1,
            'sulu_website.enabled_twig_attributes' => [
                'urls' => false,
            ],
            'sulu_website.segment_switch_url' => '/_sulu_segment_switch',
            'sulu_website.segment_cookie_name' => '_ss',
            'sulu_website.segment_header' => 'X-Sulu-Segment',
            'sulu_website.admin.class' => 'Sulu\\Bundle\\WebsiteBundle\\Admin\\WebsiteAdmin',
            'sulu_website.navigation_mapper.class' => 'Sulu\\Bundle\\WebsiteBundle\\Navigation\\NavigationMapper',
            'sulu_website.sitemap.class' => 'Sulu\\Bundle\\WebsiteBundle\\Sitemap\\SitemapGenerator',
            'sulu_website.twig.content_path.class' => 'Sulu\\Bundle\\WebsiteBundle\\Twig\\Content\\ContentPathTwigExtension',
            'sulu_website.twig.navigation.class' => 'Sulu\\Bundle\\WebsiteBundle\\Twig\\Navigation\\NavigationTwigExtension',
            'sulu_website.twig.navigation.memoized.class' => 'Sulu\\Bundle\\WebsiteBundle\\Twig\\Navigation\\MemoizedNavigationTwigExtension',
            'sulu_website.twig.sitemap.class' => 'Sulu\\Bundle\\WebsiteBundle\\Twig\\Sitemap\\SitemapTwigExtension',
            'sulu_website.twig.sitemap.memoized.class' => 'Sulu\\Bundle\\WebsiteBundle\\Twig\\Sitemap\\MemoizedSitemapTwigExtension',
            'sulu_website.twig.content.class' => 'Sulu\\Bundle\\WebsiteBundle\\Twig\\Content\\ContentTwigExtension',
            'sulu_website.twig.content.memoized.class' => 'Sulu\\Bundle\\WebsiteBundle\\Twig\\Content\\MemoizedContentTwigExtension',
            'sulu_website.twig.meta.class' => 'Sulu\\Bundle\\WebsiteBundle\\Twig\\Meta\\MetaTwigExtension',
            'sulu_website.twig.seo.class' => 'Sulu\\Bundle\\WebsiteBundle\\Twig\\Seo\\SeoTwigExtension',
            'sulu_website.twig.util.class' => 'Sulu\\Bundle\\WebsiteBundle\\Twig\\Core\\UtilTwigExtension',
            'sulu_website.routing.portal_loader.class' => 'Sulu\\Bundle\\WebsiteBundle\\Routing\\PortalLoader',
            'sulu_website.resolver.request_analyzer.class' => 'Sulu\\Bundle\\WebsiteBundle\\Resolver\\RequestAnalyzerResolver',
            'sulu_website.resolver.structure.class' => 'Sulu\\Bundle\\WebsiteBundle\\Resolver\\StructureResolver',
            'sulu_website.resolver.parameter.class' => 'Sulu\\Bundle\\WebsiteBundle\\Resolver\\ParameterResolver',
            'sulu_website.navigation_mapper.query_builder.class' => 'Sulu\\Bundle\\WebsiteBundle\\Navigation\\NavigationQueryBuilder',
            'sulu_website.sitemap.query_builder.class' => 'Sulu\\Bundle\\WebsiteBundle\\Sitemap\\SitemapContentQueryBuilder',
            'sulu_website.data_collector.sulu_collector.class' => 'Sulu\\Bundle\\WebsiteBundle\\DataCollector\\SuluCollector',
            'sulu_location.content.type.location.class' => 'Sulu\\Bundle\\LocationBundle\\Content\\Types\\LocationContentType',
            'sulu_location.guzzle.client.class' => 'GuzzleHttp\\Client',
            'sulu_location.geolocator.nominatim.class' => 'Sulu\\Bundle\\LocationBundle\\Geolocator\\Service\\NominatimGeolocator',
            'sulu_location.geolocator.google.class' => 'Sulu\\Bundle\\LocationBundle\\Geolocator\\Service\\GoogleGeolocator',
            'sulu_location.geolocator.name' => 'nominatim',
            'sulu_location.geolocator.service.nominatim.api_key' => '',
            'sulu_location.geolocator.service.nominatim.endpoint' => 'http://open.mapquestapi.com/nominatim/v1/search.php',
            'sulu_location.geolocator.service.google.api_key' => '',
            'sulu_http_cache.cache.max_age' => 240,
            'sulu_http_cache.cache.shared_max_age' => 240,
            'sulu_document_manager.mapping' => [
                0 => [
                    'alias' => 'custom_url',
                    'class' => 'Sulu\\Component\\CustomUrl\\Document\\CustomUrlDocument',
                    'phpcr_type' => 'sulu:custom_url',
                    'mapping' => [
                        'published' => [
                            'property' => 'published',
                            'encoding' => 'content',
                            'mapped' => true,
                            'multiple' => false,
                            'default' => NULL,
                        ],
                        'baseDomain' => [
                            'property' => 'baseDomain',
                            'encoding' => 'content',
                            'mapped' => true,
                            'multiple' => false,
                            'default' => NULL,
                        ],
                        'domainParts' => [
                            'property' => 'domainParts',
                            'type' => 'json_array',
                            'encoding' => 'content',
                            'mapped' => true,
                            'multiple' => false,
                            'default' => NULL,
                        ],
                        'canonical' => [
                            'property' => 'canonical',
                            'encoding' => 'content',
                            'mapped' => true,
                            'multiple' => false,
                            'default' => NULL,
                        ],
                        'redirect' => [
                            'property' => 'redirect',
                            'encoding' => 'content',
                            'mapped' => true,
                            'multiple' => false,
                            'default' => NULL,
                        ],
                        'targetLocale' => [
                            'property' => 'targetLocale',
                            'encoding' => 'content',
                            'mapped' => true,
                            'multiple' => false,
                            'default' => NULL,
                        ],
                    ],
                ],
                1 => [
                    'alias' => 'custom_url_route',
                    'class' => 'Sulu\\Component\\CustomUrl\\Document\\RouteDocument',
                    'phpcr_type' => 'sulu:custom_url_route',
                    'mapping' => [
                        'locale' => [
                            'property' => 'locale',
                            'encoding' => 'content',
                            'mapped' => true,
                            'multiple' => false,
                            'default' => NULL,
                        ],
                    ],
                ],
                2 => [
                    'alias' => 'page',
                    'class' => 'Sulu\\Bundle\\PageBundle\\Document\\PageDocument',
                    'phpcr_type' => 'sulu:page',
                    'form_type' => 'Sulu\\Bundle\\PageBundle\\Form\\Type\\PageDocumentType',
                    'set_default_author' => true,
                    'mapping' => [

                    ],
                ],
                3 => [
                    'alias' => 'home',
                    'class' => 'Sulu\\Bundle\\PageBundle\\Document\\HomeDocument',
                    'phpcr_type' => 'sulu:home',
                    'form_type' => 'Sulu\\Bundle\\PageBundle\\Form\\Type\\HomeDocumentType',
                    'set_default_author' => true,
                    'mapping' => [

                    ],
                ],
                4 => [
                    'alias' => 'route',
                    'class' => 'Sulu\\Bundle\\PageBundle\\Document\\RouteDocument',
                    'phpcr_type' => 'sulu:path',
                    'mapping' => [

                    ],
                ],
                5 => [
                    'alias' => 'snippet',
                    'class' => 'Sulu\\Bundle\\SnippetBundle\\Document\\SnippetDocument',
                    'phpcr_type' => 'sulu:snippet',
                    'form_type' => 'Sulu\\Bundle\\SnippetBundle\\Form\\SnippetType',
                    'mapping' => [

                    ],
                ],
            ],
            'sulu_document_manager.namespace_mapping' => [
                'extension_localized' => 'i18n',
                'system' => 'sulu',
                'system_localized' => 'i18n',
                'content' => NULL,
                'content_localized' => 'i18n',
            ],
            'sulu_document_manager.versioning.enabled' => false,
            'sulu_document_manager.show_drafts' => true,
            'sulu_document_manager.slugifier' => 'Sulu\\Bundle\\DocumentManagerBundle\\Slugifier\\Urlizer::urlize',
            'sulu_document_manager.segments' => [
                'custom_urls' => 'custom-urls',
                'custom_urls_items' => 'items',
                'custom_urls_routes' => 'routes',
                'base' => 'cmf',
                'content' => 'contents',
                'route' => 'routes',
                'snippet' => 'snippets',
            ],
            'sulu_custom_urls.uri_filter_regexp' => NULL,
            'sulu_route.mappings' => [

            ],
            'sulu_route.resource_key_mappings' => [

            ],
            'sulu_route.routing.uri_filter_regexp' => NULL,
            'sulu.model.route.class' => 'Sulu\\Bundle\\RouteBundle\\Entity\\Route',
            'sulu.repository.route.class' => 'Sulu\\Bundle\\RouteBundle\\Entity\\RouteRepository',
            'phpcr_migrations.version_node_name' => 'jcr:versions',
            'phpcr_migrations.paths' => [
                0 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/PageBundle/Resources/phpcr-migrations'),
                1 => (\dirname(__DIR__, 5).'/vendor/sulu/sulu/src/Sulu/Bundle/CustomUrlBundle/Resources/phpcr-migrations'),
            ],
            'massive_build.command.build.class' => 'Sulu\\Bundle\\CoreBundle\\CommandOptional\\SuluBuildCommand',
            'massive_build.build.registry.class' => 'Massive\\Bundle\\BuildBundle\\Build\\BuildRegistry',
            'env(VAR_DUMPER_SERVER)' => '127.0.0.1:9912',
            'cmf_routing.uri_filter_regexp' => '',
            'cmf_routing.default_controller' => NULL,
            'cmf_routing.generic_controller' => NULL,
            'cmf_routing.controllers_by_type' => [

            ],
            'cmf_routing.controllers_by_class' => [

            ],
            'cmf_routing.templates_by_class' => [

            ],
            'cmf_routing.route_collection_limit' => 0,
            'cmf_routing.dynamic.limit_candidates' => 20,
            'cmf_routing.dynamic.locales' => [

            ],
            'cmf_routing.dynamic.auto_locale_pattern' => false,
            'cmf_routing.replace_symfony_router' => true,
            'stof_doctrine_extensions.listener.tree.class' => 'Gedmo\\Tree\\TreeListener',
            'stof_doctrine_extensions.default_locale' => 'en',
            'stof_doctrine_extensions.translation_fallback' => false,
            'stof_doctrine_extensions.persist_default_translation' => false,
            'stof_doctrine_extensions.skip_translation_on_load' => false,
            'stof_doctrine_extensions.listener.translatable.class' => 'Gedmo\\Translatable\\TranslatableListener',
            'stof_doctrine_extensions.listener.timestampable.class' => 'Gedmo\\Timestampable\\TimestampableListener',
            'stof_doctrine_extensions.listener.blameable.class' => 'Gedmo\\Blameable\\BlameableListener',
            'stof_doctrine_extensions.listener.sluggable.class' => 'Gedmo\\Sluggable\\SluggableListener',
            'stof_doctrine_extensions.listener.loggable.class' => 'Gedmo\\Loggable\\LoggableListener',
            'stof_doctrine_extensions.listener.sortable.class' => 'Gedmo\\Sortable\\SortableListener',
            'stof_doctrine_extensions.listener.softdeleteable.class' => 'Gedmo\\SoftDeleteable\\SoftDeleteableListener',
            'stof_doctrine_extensions.listener.uploadable.class' => 'Gedmo\\Uploadable\\UploadableListener',
            'stof_doctrine_extensions.listener.reference_integrity.class' => 'Gedmo\\ReferenceIntegrity\\ReferenceIntegrityListener',
            'doctrine_phpcr.migrate.migrators' => [

            ],
            'sulu_media.image.formats' => [
                'sulu-400x400' => [
                    'key' => 'sulu-400x400',
                    'internal' => true,
                    'meta' => [
                        'title' => [
                            'en' => 'Contact avatar (Sulu)',
                            'de' => 'Kontaktavatar (Sulu)',
                            'fr' => 'Avatar du contact (Sulu)',
                            'nl' => 'Contact avatar (Sulu)',
                        ],
                    ],
                    'scale' => [
                        'x' => 400,
                        'y' => 400,
                        'mode' => 2,
                        'retina' => false,
                        'forceRatio' => true,
                    ],
                    'transformations' => [

                    ],
                    'options' => [
                        'jpeg_quality' => 100,
                        'webp_quality' => 100,
                    ],
                ],
                'sulu-260x' => [
                    'key' => 'sulu-260x',
                    'internal' => true,
                    'meta' => [
                        'title' => [
                            'en' => 'Masonry preview (Sulu)',
                            'de' => 'Masonry Vorschau (Sulu)',
                            'fr' => 'Prévisualisation maçonnerie (Sulu)',
                            'nl' => 'Masonry voorbeeld (Sulu)',
                        ],
                    ],
                    'scale' => [
                        'x' => 260,
                        'y' => NULL,
                        'mode' => 2,
                        'retina' => false,
                        'forceRatio' => true,
                    ],
                    'transformations' => [

                    ],
                    'options' => [
                        'jpeg_quality' => 100,
                        'webp_quality' => 100,
                    ],
                ],
                'sulu-170x170' => [
                    'key' => 'sulu-170x170',
                    'internal' => true,
                    'meta' => [
                        'title' => [
                            'en' => 'Search (Sulu)',
                            'de' => 'Suche (Sulu)',
                            'fr' => 'Recherche (Sulu)',
                            'nl' => 'Zoeken (Sulu)',
                        ],
                    ],
                    'scale' => [
                        'x' => 170,
                        'y' => 170,
                        'mode' => 2,
                        'retina' => false,
                        'forceRatio' => true,
                    ],
                    'transformations' => [

                    ],
                    'options' => [
                        'jpeg_quality' => 100,
                        'webp_quality' => 100,
                    ],
                ],
                'sulu-100x100-inset' => [
                    'key' => 'sulu-100x100-inset',
                    'internal' => true,
                    'meta' => [
                        'title' => [
                            'en' => 'Organization card (Sulu)',
                            'de' => 'Organisationskarte (Sulu)',
                            'fr' => 'Carte d\'organisation (Sulu)',
                            'nl' => 'Organisatie kaart (Sulu)',
                        ],
                    ],
                    'scale' => [
                        'x' => 100,
                        'y' => 100,
                        'mode' => 1,
                        'retina' => false,
                        'forceRatio' => true,
                    ],
                    'transformations' => [

                    ],
                    'options' => [
                        'jpeg_quality' => 100,
                        'webp_quality' => 100,
                    ],
                ],
                'sulu-50x50' => [
                    'key' => 'sulu-50x50',
                    'internal' => true,
                    'meta' => [
                        'title' => [
                            'en' => 'Small thumbnail (Sulu)',
                            'de' => 'Kleines Thumbnail (Sulu)',
                            'fr' => 'Image miniature (Sulu)',
                            'nl' => 'Kleine thumbnail (Sulu)',
                        ],
                    ],
                    'scale' => [
                        'x' => 50,
                        'y' => 50,
                        'mode' => 2,
                        'retina' => false,
                        'forceRatio' => true,
                    ],
                    'transformations' => [

                    ],
                    'options' => [
                        'jpeg_quality' => 100,
                        'webp_quality' => 100,
                    ],
                ],
                'sulu-25x25' => [
                    'key' => 'sulu-25x25',
                    'internal' => true,
                    'meta' => [
                        'title' => [
                            'en' => 'Micro thumbnail',
                            'de' => 'Mikro Thumbnail',
                            'fr' => 'Image micro',
                            'nl' => 'Micro thumbnail',
                        ],
                    ],
                    'scale' => [
                        'x' => 25,
                        'y' => 25,
                        'mode' => 2,
                        'retina' => false,
                        'forceRatio' => true,
                    ],
                    'transformations' => [

                    ],
                    'options' => [
                        'jpeg_quality' => 100,
                        'webp_quality' => 100,
                    ],
                ],
                'sulu-40x40' => [
                    'key' => 'sulu-40x40',
                    'internal' => true,
                    'meta' => [
                        'title' => [
                            'en' => 'Small thumbnail (Sulu)',
                            'de' => 'Kleines Thumbnail (Sulu)',
                            'fr' => 'Image miniature (Sulu)',
                            'nl' => 'Kleine thumbnail (Sulu)',
                        ],
                    ],
                    'scale' => [
                        'x' => 40,
                        'y' => 40,
                        'mode' => 2,
                        'retina' => false,
                        'forceRatio' => true,
                    ],
                    'transformations' => [

                    ],
                    'options' => [
                        'jpeg_quality' => 100,
                        'webp_quality' => 100,
                    ],
                ],
                'sulu-240x' => [
                    'key' => 'sulu-240x',
                    'internal' => true,
                    'meta' => [
                        'title' => [
                            'en' => 'Masonry preview (Sulu)',
                            'de' => 'Masonry Vorschau (Sulu)',
                            'fr' => 'Prévisualisation maçonnerie (Sulu)',
                            'nl' => 'Masonry voorbeeld (Sulu)',
                        ],
                    ],
                    'scale' => [
                        'x' => 240,
                        'y' => NULL,
                        'mode' => 2,
                        'retina' => false,
                        'forceRatio' => true,
                    ],
                    'transformations' => [

                    ],
                    'options' => [
                        'jpeg_quality' => 100,
                        'webp_quality' => 100,
                    ],
                ],
                'sulu-400x400-inset' => [
                    'key' => 'sulu-400x400-inset',
                    'internal' => true,
                    'meta' => [
                        'title' => [
                            'en' => 'Organization logo (Sulu)',
                            'de' => 'Organisationslogo (Sulu)',
                            'fr' => 'Logo d\'organisation (Sulu)',
                            'nl' => 'Organisatie logo (Sulu)',
                        ],
                    ],
                    'scale' => [
                        'x' => 400,
                        'y' => 400,
                        'mode' => 1,
                        'retina' => false,
                        'forceRatio' => true,
                    ],
                    'transformations' => [

                    ],
                    'options' => [
                        'jpeg_quality' => 100,
                        'webp_quality' => 100,
                    ],
                ],
                'sulu-100x100' => [
                    'key' => 'sulu-100x100',
                    'internal' => true,
                    'meta' => [
                        'title' => [
                            'en' => 'Contact card (Sulu)',
                            'de' => 'Personenkarte (Sulu)',
                            'fr' => 'Carte personnelle (Sulu)',
                            'nl' => 'Contact kaart (Sulu)',
                        ],
                    ],
                    'scale' => [
                        'x' => 100,
                        'y' => 100,
                        'mode' => 2,
                        'retina' => false,
                        'forceRatio' => true,
                    ],
                    'transformations' => [

                    ],
                    'options' => [
                        'jpeg_quality' => 100,
                        'webp_quality' => 100,
                    ],
                ],
            ],
            'sulu_category.entity.category' => 'Sulu\\Bundle\\CategoryBundle\\Entity\\Category',
            'sulu_category.entity.keyword' => 'Sulu\\Bundle\\CategoryBundle\\Entity\\Keyword',
            'sulu.version' => '2.2.3',
            'app.version' => NULL,
            'sulu_snippet.areas' => [
                'default' => [
                    'key' => 'default',
                    'template' => 'default',
                    'title' => [
                        'de' => 'Standard',
                        'en' => 'Default',
                    ],
                ],
            ],
            'console.command.ids' => [
                0 => 'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\LoadFixtureCommand',
                1 => 'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\WorkspaceQueryCommand',
                2 => 'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\MigratorMigrateCommand',
                3 => 'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\NodeDumpCommand',
                4 => 'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\NodeMoveCommand',
                5 => 'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\NodeRemoveCommand',
                6 => 'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\NodesUpdateCommand',
                7 => 'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\NodeTouchCommand',
                8 => 'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\NodeTypeListCommand',
                9 => 'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\NodeTypeRegisterCommand',
                10 => 'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\PhpcrShellCommand',
                11 => 'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\RepositoryInitCommand',
                12 => 'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\WorkspaceCreateCommand',
                13 => 'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\WorkspaceDeleteCommand',
                14 => 'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\WorkspaceExportCommand',
                15 => 'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\WorkspaceImportCommand',
                16 => 'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\WorkspaceListCommand',
                17 => 'console.command.public_alias.Doctrine\\Bundle\\PHPCRBundle\\Command\\WorkspacePurgeCommand',
                18 => 'console.command.public_alias.sulu_page.command.workspace_import',
                19 => 'console.command.public_alias.sulu_route.move_page_tree_command',
                20 => 'phpcr_migrations.command.status',
                21 => 'phpcr_migrations.command.migrate',
                22 => 'phpcr_migrations.command.initialize',
                23 => 'console.command.public_alias.massive_build.command.build',
            ],
        ];
    }

    protected function throw($message)
    {
        throw new RuntimeException($message);
    }
}
