<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('nl', array (
  'validators' => 
  array (
    'This value should be false.' => 'Deze waarde moet onwaar zijn.',
    'This value should be true.' => 'Deze waarde moet waar zijn.',
    'This value should be of type {{ type }}.' => 'Deze waarde moet van het type {{ type }} zijn.',
    'This value should be blank.' => 'Deze waarde moet leeg zijn.',
    'The value you selected is not a valid choice.' => 'De geselecteerde waarde is geen geldige optie.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'Selecteer ten minste {{ limit }} optie.|Selecteer ten minste {{ limit }} opties.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'Selecteer maximaal {{ limit }} optie.|Selecteer maximaal {{ limit }} opties.',
    'One or more of the given values is invalid.' => 'Eén of meer van de ingegeven waarden zijn ongeldig.',
    'This field was not expected.' => 'Dit veld werd niet verwacht.',
    'This field is missing.' => 'Dit veld ontbreekt.',
    'This value is not a valid date.' => 'Deze waarde is geen geldige datum.',
    'This value is not a valid datetime.' => 'Deze waarde is geen geldige datum en tijd.',
    'This value is not a valid email address.' => 'Deze waarde is geen geldig e-mailadres.',
    'The file could not be found.' => 'Het bestand kon niet gevonden worden.',
    'The file is not readable.' => 'Het bestand is niet leesbaar.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'Het bestand is te groot ({{ size }} {{ suffix }}). Toegestane maximum grootte is {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'Het mime type van het bestand is ongeldig ({{ type }}). Toegestane mime types zijn {{ types }}.',
    'This value should be {{ limit }} or less.' => 'Deze waarde moet {{ limit }} of minder zijn.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'Deze waarde is te lang. Hij mag maximaal {{ limit }} teken bevatten.|Deze waarde is te lang. Hij mag maximaal {{ limit }} tekens bevatten.',
    'This value should be {{ limit }} or more.' => 'Deze waarde moet {{ limit }} of meer zijn.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'Deze waarde is te kort. Hij moet tenminste {{ limit }} teken bevatten.|Deze waarde is te kort. Hij moet tenminste {{ limit }} tekens bevatten.',
    'This value should not be blank.' => 'Deze waarde mag niet leeg zijn.',
    'This value should not be null.' => 'Deze waarde mag niet null zijn.',
    'This value should be null.' => 'Deze waarde moet null zijn.',
    'This value is not valid.' => 'Deze waarde is niet geldig.',
    'This value is not a valid time.' => 'Deze waarde is geen geldige tijd.',
    'This value is not a valid URL.' => 'Deze waarde is geen geldige URL.',
    'The two values should be equal.' => 'De twee waarden moeten gelijk zijn.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'Het bestand is te groot. Toegestane maximum grootte is {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'Het bestand is te groot.',
    'The file could not be uploaded.' => 'Het bestand kon niet worden geüpload.',
    'This value should be a valid number.' => 'Deze waarde moet een geldig getal zijn.',
    'This file is not a valid image.' => 'Dit bestand is geen geldige afbeelding.',
    'This is not a valid IP address.' => 'Dit is geen geldig IP-adres.',
    'This value is not a valid language.' => 'Deze waarde is geen geldige taal.',
    'This value is not a valid locale.' => 'Deze waarde is geen geldige locale.',
    'This value is not a valid country.' => 'Deze waarde is geen geldig land.',
    'This value is already used.' => 'Deze waarde wordt al gebruikt.',
    'The size of the image could not be detected.' => 'De grootte van de afbeelding kon niet bepaald worden.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'De afbeelding is te breed ({{ width }}px). De maximaal toegestane breedte is {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'De afbeelding is niet breed genoeg ({{ width }}px). De minimaal verwachte breedte is {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'De afbeelding is te hoog ({{ height }}px). De maximaal toegestane hoogte is {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'De afbeelding is niet hoog genoeg ({{ height }}px). De minimaal verwachte hoogte is {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'Deze waarde moet het huidige wachtwoord van de gebruiker zijn.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'Deze waarde moet exact {{ limit }} teken lang zijn.|Deze waarde moet exact {{ limit }} tekens lang zijn.',
    'The file was only partially uploaded.' => 'Het bestand is slechts gedeeltelijk geüpload.',
    'No file was uploaded.' => 'Er is geen bestand geüpload.',
    'No temporary folder was configured in php.ini.' => 'Er is geen tijdelijke map geconfigureerd in php.ini, of de gespecificeerde map bestaat niet.',
    'Cannot write temporary file to disk.' => 'Kan het tijdelijke bestand niet wegschrijven op disk.',
    'A PHP extension caused the upload to fail.' => 'De upload is mislukt vanwege een PHP-extensie.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'Deze collectie moet {{ limit }} element of meer bevatten.|Deze collectie moet {{ limit }} elementen of meer bevatten.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'Deze collectie moet {{ limit }} element of minder bevatten.|Deze collectie moet {{ limit }} elementen of minder bevatten.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'Deze collectie moet exact {{ limit }} element bevatten.|Deze collectie moet exact {{ limit }} elementen bevatten.',
    'Invalid card number.' => 'Ongeldig creditcardnummer.',
    'Unsupported card type or invalid card number.' => 'Niet-ondersteund type creditcard of ongeldig nummer.',
    'This is not a valid International Bank Account Number (IBAN).' => 'Dit is geen geldig internationaal bankrekeningnummer (IBAN).',
    'This value is not a valid ISBN-10.' => 'Deze waarde is geen geldige ISBN-10.',
    'This value is not a valid ISBN-13.' => 'Deze waarde is geen geldige ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'Deze waarde is geen geldige ISBN-10 of ISBN-13 waarde.',
    'This value is not a valid ISSN.' => 'Deze waarde is geen geldige ISSN waarde.',
    'This value is not a valid currency.' => 'Deze waarde is geen geldige valuta.',
    'This value should be equal to {{ compared_value }}.' => 'Deze waarde moet gelijk zijn aan {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'Deze waarde moet groter zijn dan {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'Deze waarde moet groter dan of gelijk aan {{ compared_value }} zijn.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Deze waarde moet identiek zijn aan {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'Deze waarde moet minder zijn dan {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'Deze waarde moet minder dan of gelijk aan {{ compared_value }} zijn.',
    'This value should not be equal to {{ compared_value }}.' => 'Deze waarde mag niet gelijk zijn aan {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Deze waarde mag niet identiek zijn aan {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'De afbeeldingsverhouding is te groot ({{ ratio }}). Maximale verhouding is {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'De afbeeldingsverhouding is te klein ({{ ratio }}). Minimale verhouding is {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'De afbeelding is vierkant ({{ width }}x{{ height }}px). Vierkante afbeeldingen zijn niet toegestaan.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'De afbeelding is liggend ({{ width }}x{{ height }}px). Liggende afbeeldingen zijn niet toegestaan.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'De afbeelding is staand ({{ width }}x{{ height }}px). Staande afbeeldingen zijn niet toegestaan.',
    'An empty file is not allowed.' => 'Lege bestanden zijn niet toegestaan.',
    'The host could not be resolved.' => 'De hostnaam kon niet worden bepaald.',
    'This value does not match the expected {{ charset }} charset.' => 'Deze waarde is niet in de verwachte tekencodering {{ charset }}.',
    'This is not a valid Business Identifier Code (BIC).' => 'Dit is geen geldige bedrijfsidentificatiecode (BIC/SWIFT).',
    'Error' => 'Fout',
    'This is not a valid UUID.' => 'Dit is geen geldige UUID.',
    'This value should be a multiple of {{ compared_value }}.' => 'Deze waarde zou een meervoud van {{ compared_value }} moeten zijn.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'Deze bedrijfsidentificatiecode (BIC) is niet gekoppeld aan IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'Deze waarde moet geldige JSON zijn.',
    'This collection should contain only unique elements.' => 'Deze collectie moet alleen unieke elementen bevatten.',
    'This value should be positive.' => 'Deze waarde moet positief zijn.',
    'This value should be either positive or zero.' => 'Deze waarde moet positief of gelijk aan nul zijn.',
    'This value should be negative.' => 'Deze waarde moet negatief zijn.',
    'This value should be either negative or zero.' => 'Deze waarde moet negatief of gelijk aan nul zijn.',
    'This value is not a valid timezone.' => 'Deze waarde is geen geldige tijdzone.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'Dit wachtwoord is gelekt vanwege een data-inbreuk, het moet niet worden gebruikt. Kies een ander wachtwoord.',
    'This value should be between {{ min }} and {{ max }}.' => 'Deze waarde moet zich tussen {{ min }} en {{ max }} bevinden.',
    'This value is not a valid hostname.' => 'Deze waarde is geen geldige hostnaam.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'Het aantal elementen van deze collectie moet een veelvoud zijn van {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'Deze waarde moet voldoen aan tenminste een van de volgende voorwaarden:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Elk element van deze collectie moet voldoen aan zijn eigen set voorwaarden.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'Deze waarde is geen geldig International Securities Identification Number (ISIN).',
    'This form should not contain extra fields.' => 'Dit formulier mag geen extra velden bevatten.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'Het geüploade bestand is te groot. Probeer een kleiner bestand te uploaden.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'De CSRF-token is ongeldig. Probeer het formulier opnieuw te versturen.',
    'This value is not a valid HTML5 color.' => 'Dit is geen geldige HTML5 kleur.',
    'Please enter a valid birthdate.' => 'Vul een geldige geboortedatum in.',
    'The selected choice is invalid.' => 'Deze keuze is ongeldig.',
    'The collection is invalid.' => 'Deze collectie is ongeldig.',
    'Please select a valid color.' => 'Kies een geldige kleur.',
    'Please select a valid country.' => 'Kies een geldige landnaam.',
    'Please select a valid currency.' => 'Kies een geldige valuta.',
    'Please choose a valid date interval.' => 'Kies een geldig tijdinterval.',
    'Please enter a valid date and time.' => 'Vul een geldige datum en tijd in.',
    'Please enter a valid date.' => 'Vul een geldige datum in.',
    'Please select a valid file.' => 'Kies een geldig bestand.',
    'The hidden field is invalid.' => 'Het verborgen veld is incorrect.',
    'Please enter an integer.' => 'Vul een geldig getal in.',
    'Please select a valid language.' => 'Kies een geldige taal.',
    'Please select a valid locale.' => 'Kies een geldige locale.',
    'Please enter a valid money amount.' => 'Vul een geldig bedrag in.',
    'Please enter a number.' => 'Vul een geldig getal in.',
    'The password is invalid.' => 'Het wachtwoord is incorrect.',
    'Please enter a percentage value.' => 'Vul een geldig percentage in.',
    'The values do not match.' => 'De waardes komen niet overeen.',
    'Please enter a valid time.' => 'Vul een geldige tijd in.',
    'Please select a valid timezone.' => 'Vul een geldige tijdzone in.',
    'Please enter a valid URL.' => 'Vul een geldige URL in.',
    'Please enter a valid search term.' => 'Vul een geldige zoekterm in.',
    'Please provide a valid phone number.' => 'Vul een geldig telefoonnummer in.',
    'The checkbox has an invalid value.' => 'De checkbox heeft een incorrecte waarde.',
    'Please enter a valid email address.' => 'Vul een geldig e-mailadres in.',
    'Please select a valid option.' => 'Kies een geldige optie.',
    'Please select a valid range.' => 'Kies een geldig bereik.',
    'Please enter a valid week.' => 'Vul een geldige week in.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'Er heeft zich een authenticatieprobleem voorgedaan.',
    'Authentication credentials could not be found.' => 'Authenticatiegegevens konden niet worden gevonden.',
    'Authentication request could not be processed due to a system problem.' => 'Authenticatieaanvraag kon niet worden verwerkt door een technisch probleem.',
    'Invalid credentials.' => 'Ongeldige inloggegevens.',
    'Cookie has already been used by someone else.' => 'Cookie is al door een ander persoon gebruikt.',
    'Not privileged to request the resource.' => 'Onvoldoende rechten om de aanvraag te verwerken.',
    'Invalid CSRF token.' => 'CSRF-code is ongeldig.',
    'No authentication provider found to support the authentication token.' => 'Geen authenticatieprovider gevonden die de authenticatietoken ondersteunt.',
    'No session available, it either timed out or cookies are not enabled.' => 'Geen sessie beschikbaar, mogelijk is deze verlopen of cookies zijn uitgeschakeld.',
    'No token could be found.' => 'Er kon geen authenticatietoken worden gevonden.',
    'Username could not be found.' => 'Gebruikersnaam kon niet worden gevonden.',
    'Account has expired.' => 'Account is verlopen.',
    'Credentials have expired.' => 'Authenticatiegegevens zijn verlopen.',
    'Account is disabled.' => 'Account is gedeactiveerd.',
    'Account is locked.' => 'Account is geblokkeerd.',
    'Too many failed login attempts, please try again later.' => 'Te veel onjuiste inlogpogingen, probeer het later nogmaals.',
    'Invalid or expired login link.' => 'Ongeldige of verlopen inloglink.',
  ),
));

$catalogueEn = new MessageCatalogue('en', array (
  'validators' => 
  array (
    'This value should be false.' => 'This value should be false.',
    'This value should be true.' => 'This value should be true.',
    'This value should be of type {{ type }}.' => 'This value should be of type {{ type }}.',
    'This value should be blank.' => 'This value should be blank.',
    'The value you selected is not a valid choice.' => 'The value you selected is not a valid choice.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.',
    'One or more of the given values is invalid.' => 'One or more of the given values is invalid.',
    'This field was not expected.' => 'This field was not expected.',
    'This field is missing.' => 'This field is missing.',
    'This value is not a valid date.' => 'This value is not a valid date.',
    'This value is not a valid datetime.' => 'This value is not a valid datetime.',
    'This value is not a valid email address.' => 'This value is not a valid email address.',
    'The file could not be found.' => 'The file could not be found.',
    'The file is not readable.' => 'The file is not readable.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.',
    'This value should be {{ limit }} or less.' => 'This value should be {{ limit }} or less.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.',
    'This value should be {{ limit }} or more.' => 'This value should be {{ limit }} or more.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.',
    'This value should not be blank.' => 'This value should not be blank.',
    'This value should not be null.' => 'This value should not be null.',
    'This value should be null.' => 'This value should be null.',
    'This value is not valid.' => 'This value is not valid.',
    'This value is not a valid time.' => 'This value is not a valid time.',
    'This value is not a valid URL.' => 'This value is not a valid URL.',
    'The two values should be equal.' => 'The two values should be equal.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'The file is too large.',
    'The file could not be uploaded.' => 'The file could not be uploaded.',
    'This value should be a valid number.' => 'This value should be a valid number.',
    'This file is not a valid image.' => 'This file is not a valid image.',
    'This is not a valid IP address.' => 'This is not a valid IP address.',
    'This value is not a valid language.' => 'This value is not a valid language.',
    'This value is not a valid locale.' => 'This value is not a valid locale.',
    'This value is not a valid country.' => 'This value is not a valid country.',
    'This value is already used.' => 'This value is already used.',
    'The size of the image could not be detected.' => 'The size of the image could not be detected.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'This value should be the user\'s current password.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.',
    'The file was only partially uploaded.' => 'The file was only partially uploaded.',
    'No file was uploaded.' => 'No file was uploaded.',
    'No temporary folder was configured in php.ini.' => 'No temporary folder was configured in php.ini, or the configured folder does not exist.',
    'Cannot write temporary file to disk.' => 'Cannot write temporary file to disk.',
    'A PHP extension caused the upload to fail.' => 'A PHP extension caused the upload to fail.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.',
    'Invalid card number.' => 'Invalid card number.',
    'Unsupported card type or invalid card number.' => 'Unsupported card type or invalid card number.',
    'This is not a valid International Bank Account Number (IBAN).' => 'This is not a valid International Bank Account Number (IBAN).',
    'This value is not a valid ISBN-10.' => 'This value is not a valid ISBN-10.',
    'This value is not a valid ISBN-13.' => 'This value is not a valid ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'This value is neither a valid ISBN-10 nor a valid ISBN-13.',
    'This value is not a valid ISSN.' => 'This value is not a valid ISSN.',
    'This value is not a valid currency.' => 'This value is not a valid currency.',
    'This value should be equal to {{ compared_value }}.' => 'This value should be equal to {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'This value should be greater than {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'This value should be greater than or equal to {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should be identical to {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'This value should be less than {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'This value should be less than or equal to {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'This value should not be equal to {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.',
    'An empty file is not allowed.' => 'An empty file is not allowed.',
    'The host could not be resolved.' => 'The host could not be resolved.',
    'This value does not match the expected {{ charset }} charset.' => 'This value does not match the expected {{ charset }} charset.',
    'This is not a valid Business Identifier Code (BIC).' => 'This is not a valid Business Identifier Code (BIC).',
    'Error' => 'Error',
    'This is not a valid UUID.' => 'This is not a valid UUID.',
    'This value should be a multiple of {{ compared_value }}.' => 'This value should be a multiple of {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'This value should be valid JSON.',
    'This collection should contain only unique elements.' => 'This collection should contain only unique elements.',
    'This value should be positive.' => 'This value should be positive.',
    'This value should be either positive or zero.' => 'This value should be either positive or zero.',
    'This value should be negative.' => 'This value should be negative.',
    'This value should be either negative or zero.' => 'This value should be either negative or zero.',
    'This value is not a valid timezone.' => 'This value is not a valid timezone.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'This password has been leaked in a data breach, it must not be used. Please use another password.',
    'This value should be between {{ min }} and {{ max }}.' => 'This value should be between {{ min }} and {{ max }}.',
    'This value is not a valid hostname.' => 'This value is not a valid hostname.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'The number of elements in this collection should be a multiple of {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'This value should satisfy at least one of the following constraints:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Each element of this collection should satisfy its own set of constraints.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'This value is not a valid International Securities Identification Number (ISIN).',
    'This form should not contain extra fields.' => 'This form should not contain extra fields.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'The uploaded file was too large. Please try to upload a smaller file.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'The CSRF token is invalid. Please try to resubmit the form.',
    'This value is not a valid HTML5 color.' => 'This value is not a valid HTML5 color.',
    'Please enter a valid birthdate.' => 'Please enter a valid birthdate.',
    'The selected choice is invalid.' => 'The selected choice is invalid.',
    'The collection is invalid.' => 'The collection is invalid.',
    'Please select a valid color.' => 'Please select a valid color.',
    'Please select a valid country.' => 'Please select a valid country.',
    'Please select a valid currency.' => 'Please select a valid currency.',
    'Please choose a valid date interval.' => 'Please choose a valid date interval.',
    'Please enter a valid date and time.' => 'Please enter a valid date and time.',
    'Please enter a valid date.' => 'Please enter a valid date.',
    'Please select a valid file.' => 'Please select a valid file.',
    'The hidden field is invalid.' => 'The hidden field is invalid.',
    'Please enter an integer.' => 'Please enter an integer.',
    'Please select a valid language.' => 'Please select a valid language.',
    'Please select a valid locale.' => 'Please select a valid locale.',
    'Please enter a valid money amount.' => 'Please enter a valid money amount.',
    'Please enter a number.' => 'Please enter a number.',
    'The password is invalid.' => 'The password is invalid.',
    'Please enter a percentage value.' => 'Please enter a percentage value.',
    'The values do not match.' => 'The values do not match.',
    'Please enter a valid time.' => 'Please enter a valid time.',
    'Please select a valid timezone.' => 'Please select a valid timezone.',
    'Please enter a valid URL.' => 'Please enter a valid URL.',
    'Please enter a valid search term.' => 'Please enter a valid search term.',
    'Please provide a valid phone number.' => 'Please provide a valid phone number.',
    'The checkbox has an invalid value.' => 'The checkbox has an invalid value.',
    'Please enter a valid email address.' => 'Please enter a valid email address.',
    'Please select a valid option.' => 'Please select a valid option.',
    'Please select a valid range.' => 'Please select a valid range.',
    'Please enter a valid week.' => 'Please enter a valid week.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'An authentication exception occurred.',
    'Authentication credentials could not be found.' => 'Authentication credentials could not be found.',
    'Authentication request could not be processed due to a system problem.' => 'Authentication request could not be processed due to a system problem.',
    'Invalid credentials.' => 'Invalid credentials.',
    'Cookie has already been used by someone else.' => 'Cookie has already been used by someone else.',
    'Not privileged to request the resource.' => 'Not privileged to request the resource.',
    'Invalid CSRF token.' => 'Invalid CSRF token.',
    'No authentication provider found to support the authentication token.' => 'No authentication provider found to support the authentication token.',
    'No session available, it either timed out or cookies are not enabled.' => 'No session available, it either timed out or cookies are not enabled.',
    'No token could be found.' => 'No token could be found.',
    'Username could not be found.' => 'Username could not be found.',
    'Account has expired.' => 'Account has expired.',
    'Credentials have expired.' => 'Credentials have expired.',
    'Account is disabled.' => 'Account is disabled.',
    'Account is locked.' => 'Account is locked.',
    'Too many failed login attempts, please try again later.' => 'Too many failed login attempts, please try again later.',
    'Invalid or expired login link.' => 'Invalid or expired login link.',
  ),
  'admin' => 
  array (
    'sulu_search.search' => 'Search',
    'sulu_search.everything' => 'Everything',
    'sulu_search.search_hint' => 'Use (*) in your query as a placeholder for parts of a word.',
    'sulu_search.nothing_found' => 'Nothing could be found for your search term.',
    'sulu_contact.contacts' => 'Contacts',
    'sulu_contact.organizations' => 'Organizations',
    'sulu_contact.organization' => 'Organization',
    'sulu_contact.people' => 'People',
    'sulu_contact.contact_selection_overlay_title' => 'Choose contacts',
    'sulu_contact.account_selection_overlay_title' => 'Choose accounts',
    'sulu_contact.contact_selection_label' => '{count} {count, plural, =1 {contact} other {contacts}} selected',
    'sulu_contact.account_selection_label' => '{count} {count, plural, =1 {account} other {accounts}} selected',
    'sulu_contact.contact_account_selection_label' => '{count} {count, plural, =1 {contact} other {contacts}} selected',
    'sulu_contact.avatar' => 'Avatar',
    'sulu_contact.logo' => 'Logo',
    'sulu_contact.name' => 'Name',
    'sulu_contact.first_name' => 'First Name',
    'sulu_contact.last_name' => 'Last Name',
    'sulu_contact.contact_details' => 'Contact details',
    'sulu_contact.addresses' => 'Addresses',
    'sulu_contact.bank_accounts' => 'Bank accounts',
    'sulu_contact.email' => 'Email',
    'sulu_contact.primary_address' => 'Primary address',
    'sulu_contact.delivery_address' => 'Delivery address',
    'sulu_contact.billing_address' => 'Billing address',
    'sulu_contact.city' => 'City',
    'sulu_contact.zip' => 'ZIP',
    'sulu_contact.street' => 'Street',
    'sulu_contact.number' => 'Number',
    'sulu_contact.address_line' => 'Addressline',
    'sulu_contact.state' => 'Region',
    'sulu_contact.country' => 'Country',
    'sulu_contact.postbox_number' => 'Postbox #',
    'sulu_contact.postbox_zip' => 'Postbox ZIP',
    'sulu_contact.postbox_city' => 'Postbox City',
    'sulu_contact.phone' => 'Phone',
    'sulu_contact.fax' => 'Fax',
    'sulu_contact.website' => 'Website',
    'sulu_contact.social_media' => 'Social Media',
    'sulu_contact.birthday' => 'Birthday',
    'sulu_contact.title' => 'Title',
    'sulu_contact.salutation' => 'Salutation',
    'sulu_contact.form_of_address' => 'Form of Address',
    'sulu_contact.male_form_of_address' => 'Mr.',
    'sulu_contact.female_form_of_address' => 'Ms.',
    'sulu_contact.position' => 'Position',
    'sulu_contact.corporation' => 'Corporation',
    'sulu_contact.main_contact' => 'Main Contact',
    'sulu_contact.uid' => 'UID',
    'sulu_contact.register_number' => 'Register Number',
    'sulu_contact.jurisdiction' => 'Jurisdiction',
    'sulu_contact.note' => 'Note',
    'sulu_contact.parent_company' => 'Parent Company',
    'sulu_contact.upload_avatar_info_text' => 'Drop image or click to change avatar',
    'sulu_contact.upload_logo_info_text' => 'Drop image or click to change logo',
    'sulu_contact.no_contact_selected' => 'No contact selected',
    'sulu_contact.single_contact_selection_overlay_title' => 'Choose contact',
    'sulu_contact.no_account_selected' => 'No account selected',
    'sulu_contact.single_account_selection_overlay_title' => 'Choose account',
    'sulu_contact.taxonomies' => 'Taxonomies',
    'sulu_contact.add_address' => 'Add address',
    'sulu_contact.edit_address' => 'Edit address',
    'sulu_contact.add_bank_account' => 'Add bank account',
    'sulu_contact.edit_bank_account' => 'Edit bank account',
    'sulu_contact.work' => 'Work',
    'sulu_contact.private' => 'Private',
    'sulu_contact.mobile' => 'Mobile',
    'sulu_contact.bank' => 'Bank',
    'sulu_contact.iban' => 'IBAN',
    'sulu_contact.bic' => 'BIC',
    'sulu_contact.edit_title_overlay_title' => 'Edit titles',
    'sulu_contact.edit_position_overlay_title' => 'Edit positions',
    'sulu_contact.documents' => 'Documents',
    'sulu_contact.delete_media_warning_title' => 'Remove document assignment?',
    'sulu_contact.delete_media_warning_text' => 'This operation removes the selected document assignments. The document itself will not be deleted. Do you really wish to proceed?',
    'sulu_contact.add_contact_to_organization' => 'Add contact to organization',
    'sulu_contact.latitude' => 'Latitude',
    'sulu_contact.longitude' => 'Longitude',
    'sulu_media.media' => 'Media',
    'sulu_media.all_media' => 'All media',
    'sulu_media.audio' => 'Audio',
    'sulu_media.document' => 'Document',
    'sulu_media.image' => 'Image',
    'sulu_media.video' => 'Video',
    'sulu_media.copy_url' => 'Copy URL',
    'sulu_media.download_masterfile' => 'Download master file',
    'sulu_media.select_media_singular' => 'Select media',
    'sulu_media.select_media_plural' => 'Select media',
    'sulu_media.reset_selection' => 'Reset selection',
    'sulu_media.copy_masterfile_url' => 'Copy master file URL',
    'sulu_media.copy_masterfile_url_website' => 'Copy master file URL (Website)',
    'sulu_media.information_taxonomy' => 'Information and Taxonomy',
    'sulu_media.upload' => 'Upload',
    'sulu_media.upload_new_version' => 'Upload new version',
    'sulu_media.media_selected_singular' => 'media element selected',
    'sulu_media.media_selected_plural' => 'media elements selected',
    'sulu_media.drop_files_to_upload' => 'Upload files per drag`n`drop',
    'sulu_media.click_here_to_upload' => 'or click here to upload files',
    'sulu_media.add_collection' => 'Add collection',
    'sulu_media.remove_collection' => 'Delete collection',
    'sulu_media.remove_collection_warning' => 'This operation deletes a collection and cannot be undone. Do you really wish to proceed?',
    'sulu_media.move_collection' => 'Move collection',
    'sulu_media.edit_collection' => 'Edit collection',
    'sulu_media.download_media' => 'Download media',
    'sulu_media.download_counter' => 'Download count',
    'sulu_media.delete_media' => 'Delete media',
    'sulu_media.delete_media_warning_title' => 'Delete media',
    'sulu_media.delete_media_warning_text' => 'This operation deletes a media and cannot be undone. Do you really wish to proceed?',
    'sulu_media.delete_preview_image_warning_title' => 'Delete preview image',
    'sulu_media.delete_preview_image_warning_text' => 'This operation deletes the preview image and cannot be undone. Do you really wish to proceed?',
    'sulu_media.thumbnail' => 'Thumbnail',
    'sulu_media.type' => 'Type',
    'sulu_media.version' => 'Version',
    'sulu_media.size' => 'Filesize',
    'sulu_media.mime_type' => 'MIME-Type',
    'sulu_media.license' => 'License',
    'sulu_media.copyright' => 'Copyright Information',
    'sulu_media.credits' => 'Credits',
    'sulu_media.taxonomies' => 'Taxonomies',
    'sulu_media.history' => 'History',
    'sulu_media.formats' => 'Formats',
    'sulu_media.all_collections' => 'All collections',
    'sulu_media.move_media' => 'Move media',
    'sulu_media.upload_server_error' => 'There was an error while uploading one or multiple files to the server.',
    'sulu_media.set_focus_point' => 'Set focus point',
    'sulu_media.define_crops' => 'Define crops',
    'sulu_media.upload_preview_image' => 'Upload preview image',
    'sulu_media.delete_preview_image' => 'Delete preview image',
    'sulu_media.cropped' => 'Cropped',
    'sulu_media.double_click_crop_and_maximize' => 'A double-click maximizes and centers the area',
    'sulu_media.min_size_notification' => 'Minimal size reached',
    'sulu_media.left_top' => 'Left top',
    'sulu_media.top' => 'Top',
    'sulu_media.right_top' => 'Right top',
    'sulu_media.left' => 'Left',
    'sulu_media.middle' => 'Middle',
    'sulu_media.right' => 'Right',
    'sulu_media.left_bottom' => 'Left bottom',
    'sulu_media.bottom' => 'Bottom',
    'sulu_media.right_bottom' => 'Right bottom',
    'sulu_media.hotspots' => 'Hotspots',
    'sulu_media.add_hotspot' => 'Add hotspot',
    'sulu_media.hotspot_type' => 'Hotspot type',
    'sulu_media.form_type' => 'Form type',
    'sulu_media.circle' => 'Circle',
    'sulu_media.point' => 'Point',
    'sulu_media.rectangle' => 'Rectangle',
    'sulu_security.roles' => 'User roles',
    'sulu_security.user_name' => 'Username',
    'sulu_security.enable_user' => 'Enable User',
    'sulu_security.user_locked' => 'User locked',
    'sulu_security.permissions' => 'Permissions',
    'sulu_security.password' => 'Password',
    'sulu_security.email' => 'Email',
    'sulu_security.system' => 'System',
    'sulu_security.system_language' => 'System language',
    'sulu_security.reset_mail_subject' => 'Reset your Sulu password',
    'sulu_security.reset_mail_message' => 'To reset your Sulu password please click on the following link or copy/paste it to your browser:',
    'sulu_security.view' => 'View',
    'sulu_security.add' => 'Add',
    'sulu_security.edit' => 'Edit',
    'sulu_security.delete' => 'Delete',
    'sulu_security.live' => 'Live',
    'sulu_security.security' => 'Security',
    'sulu_security.system_permission_heading' => 'Activate permissions for {system}',
    'sulu_security.inherit_permissions_title' => 'Inherit permissions?',
    'sulu_security.inherit_permissions_label' => 'Override permissions of sub elements',
    'sulu_security.move_permission_title' => 'Notice',
    'sulu_security.move_permission_warning' => 'Permissions from the parent element will not be transferred.',
    'sulu_category.categories' => 'Categories',
    'sulu_category.key' => 'Key',
    'sulu_category.name' => 'Name',
    'sulu_category.keywords' => 'Keywords',
    'sulu_category.keyword' => 'Keyword',
    'sulu_category.multiple_usage' => 'Multiple Usage',
    'sulu_category.all_categories' => 'All categories',
    'sulu_category.no_category_selected' => 'No category selected',
    'sulu_category.single_category_selection_overlay_title' => 'Choose category',
    'sulu_snippet.selection_overlay_title' => 'Choose snippets',
    'sulu_snippet.selection_label' => '{count} {count, plural, =1 {snippet} other {snippets}} selected',
    'sulu_snippet.no_snippet_selected' => 'No snippet selected',
    'sulu_snippet.single_snippet_selection_overlay_title' => 'Choose snippet',
    'sulu_snippet.snippets' => 'Snippets',
    'sulu_snippet.snippet' => 'Snippet',
    'sulu_snippet.default_snippets' => 'Default Snippets',
    'sulu_snippet.snippet_area' => 'Type or area',
    'sulu_snippet.taxonomies' => 'Taxonomies',
    'sulu_snippet.webspace_default_snippet' => '%webspaceKey% default snippet',
    'sulu_page.webspaces' => 'Webspaces',
    'sulu_page.selection_label' => '{count} {count, plural, =1 {page} other {pages}} selected',
    'sulu_page.selection_overlay_title' => 'Choose pages',
    'sulu_page.seo' => 'SEO',
    'sulu_page.excerpt' => 'Excerpt & Taxonomies',
    'sulu_page.title' => 'Title',
    'sulu_page.show_ghost_and_shadow' => 'Show ghost and shadow pages',
    'sulu_page.no_page_selected' => 'No page selected',
    'sulu_page.single_selection_overlay_title' => 'Choose page',
    'sulu_page.settings' => 'Settings',
    'sulu_page.show_page_in' => 'Show page in',
    'sulu_page.no_navigation' => 'no navigation',
    'sulu_page.all_navigations' => 'all navigations',
    'sulu_page.page_type' => 'Page Type',
    'sulu_page.content' => 'Content',
    'sulu_page.pages' => 'Pages',
    'sulu_page.page' => 'Page',
    'sulu_page.internal_link' => 'Internal Link',
    'sulu_page.external_link' => 'External Link',
    'sulu_page.link_title' => 'Link Title',
    'sulu_page.linked_content' => 'Linked Content',
    'sulu_page.url' => 'URL',
    'sulu_page.shadow_page' => 'Shadow Page',
    'sulu_page.enable_shadow_page' => 'Enable Shadow Page',
    'sulu_page.enable_shadow_page_info_text' => 'This function is disabled if the current locale is already used as shadow locale.',
    'sulu_page.shadow_locale' => 'Shadow Locale',
    'sulu_page.editing_information' => 'Editing Information',
    'sulu_page.authored_date' => 'Authored Date',
    'sulu_page.author' => 'Author',
    'sulu_page.changelog' => 'Changelog',
    'sulu_page.text_for_more_link' => 'Text for more link',
    'sulu_page.icons' => 'Icons',
    'sulu_page.images' => 'Images',
    'sulu_page.edited' => 'edited',
    'sulu_page.search_result' => 'Search Engine Result Pages Preview (SERP)',
    'sulu_page.meta_title' => 'Title (Meta title)',
    'sulu_page.meta_title_info_text' => 'The meta title is limited to 55 characters.',
    'sulu_page.meta_description' => 'Description (Meta description)',
    'sulu_page.meta_description_info_text' => 'The meta description is limited to 320 characters.',
    'sulu_page.meta_keywords' => 'Keywords (Meta keywords)',
    'sulu_page.meta_keywords_info_text' => 'Please use a maximum of 5 keywords, dependant from the content of the page, separated by commas.',
    'sulu_page.canonical_url' => 'Canonical URL  (Canonical tag)',
    'sulu_page.no_index' => 'no-index (page will not be indexed by search engines)',
    'sulu_page.no_follow' => 'no-follow (links on this page will not be followed by the search engine)',
    'sulu_page.hide_in_sitemap' => 'Hide in sitemap',
    'sulu_page.delete_draft' => 'Delete draft',
    'sulu_page.delete_draft_warning_title' => 'Delete Draft?',
    'sulu_page.delete_draft_warning_text' => 'Do you really want to delete the draft? All data will be lost. The published page will not be changed.',
    'sulu_page.unpublish_warning_title' => 'Set to unpublished?',
    'sulu_page.unpublish_warning_text' => 'Do you really want to unpublish the page? All website links will be lost. This setting can be changed at any time without data loss.',
    'sulu_page.unpublish' => 'Set to unpublished',
    'sulu_page.restore_version' => 'Restore version?',
    'sulu_page.restore_version_text' => 'A new draft will be created. An existing draft version will be overwritten',
    'sulu_page.hide_block_label' => 'Don\'t display on public website',
    'sulu_page.hide_block_description' => 'This block will not be published, but remains editable in the admin.',
    'sulu_page.segment_label' => 'Assign segment',
    'sulu_page.segment_description' => 'The block will be automatically filtered on the website by the chosen segment.',
    'sulu_page.target_groups_label' => 'Assign target groups',
    'sulu_page.target_groups_description' => 'The block will only be visible for the selected target groups.',
    'sulu_tag.tags' => 'Tags',
    'sulu_tag.tag' => 'Tag',
    'sulu_website.analytics' => 'Analytics',
    'sulu_website.all_domains' => 'All domains',
    'sulu_website.domains' => 'Domains',
    'sulu_website.google_analytics' => 'Google Analytics',
    'sulu_website.google_tag_manager' => 'Google Tag Manager',
    'sulu_website.matomo' => 'Matomo',
    'sulu_website.custom_analytics' => 'Custom',
    'sulu_website.script' => 'Script',
    'sulu_website.key' => 'Key',
    'sulu_website.matomo_url' => 'URL',
    'sulu_website.matomo_id' => 'Site-ID',
    'sulu_website.position' => 'Position',
    'sulu_website.head_open' => 'Head open',
    'sulu_website.head_close' => 'Head close',
    'sulu_website.body_open' => 'Body open',
    'sulu_website.body_close' => 'Body close',
    'sulu_website.cache_clear' => 'Clear website cache',
    'sulu_website.cache_clear_warning_title' => 'Clear website cache?',
    'sulu_website.cache_clear_warning_text' => 'This operation will clear the entire cache for all webspaces. Do you really wish to proceed?',
    'sulu_location.latitude' => 'Latitude',
    'sulu_location.longitude' => 'Longitude',
    'sulu_location.zoom' => 'Zoom',
    'sulu_location.select_location' => 'Select location',
    'sulu_location.additional_information' => 'Additional Information',
    'sulu_location.title' => 'Title',
    'sulu_location.street' => 'Street',
    'sulu_location.number' => 'Number',
    'sulu_location.code' => 'Code',
    'sulu_location.town' => 'Town',
    'sulu_location.country' => 'Country',
    'sulu_custom_url.custom_urls' => 'Custom URLs',
    'sulu_custom_url.custom_url' => 'Custom URL',
    'sulu_custom_url.published' => 'Published',
    'sulu_custom_url.base_domain' => 'Base domain',
    'sulu_custom_url.target_page' => 'Target page',
    'sulu_custom_url.target_locale' => 'Localization',
    'sulu_custom_url.redirect' => 'Redirect',
    'sulu_custom_url.redirect_info' => 'The custom URL will be redirected to URL of the linked page.',
    'sulu_custom_url.canonical' => 'Canonical URL',
    'sulu_custom_url.canonical_info' => 'When the Canonical URL has been activated only the linked page will be indexed by search engines',
    'sulu_custom_url.no_index' => 'No Index',
    'sulu_custom_url.no_index_info' => 'The page will not be indexed by search engines.',
    'sulu_custom_url.no_follow' => 'No Follow',
    'sulu_custom_url.no_follow_info' => 'The links on the page will not be followed by search engines.',
    'sulu_custom_url.target_title' => 'Target page',
    'sulu_admin.add' => 'Add',
    'sulu_admin.add_block' => 'Add block',
    'sulu_admin.delete' => 'Delete',
    'sulu_admin.move' => 'Move',
    'sulu_admin.move_items' => 'Move items',
    'sulu_admin.copy' => 'Copy',
    'sulu_admin.order' => 'Order',
    'sulu_admin.of' => 'of',
    'sulu_admin.page' => 'Page',
    'sulu_admin.per_page' => 'Items per page',
    'sulu_admin.save' => 'Save',
    'sulu_admin.save_draft' => 'Save as draft',
    'sulu_admin.save_publish' => 'Save and publish',
    'sulu_admin.publish' => 'Publish',
    'sulu_admin.create' => 'Create',
    'sulu_admin.edit' => 'Edit',
    'sulu_admin.object' => 'Object',
    'sulu_admin.objects' => 'Objects',
    'sulu_admin.reached_end_of_list' => 'You reached the end of the list',
    'sulu_admin.confirm' => 'Confirm',
    'sulu_admin.ok' => 'Ok',
    'sulu_admin.cancel' => 'Cancel',
    'sulu_admin.apply' => 'Apply',
    'sulu_admin.yes' => 'Yes',
    'sulu_admin.no' => 'No',
    'sulu_admin.type' => 'Type',
    'sulu_admin.default' => 'Default',
    'sulu_admin.error_required' => 'This field must have a value',
    'sulu_admin.error_minlength' => 'The minimal length of this field was undershot',
    'sulu_admin.error_minitems' => 'This field has too few selections',
    'sulu_admin.welcome' => 'Welcome',
    'sulu_admin.reset_password' => 'Reset password',
    'sulu_admin.reset_password_error' => 'The passwords do not match',
    'sulu_admin.back_to_website' => 'Back to website',
    'sulu_admin.username_or_email' => 'Username or Email',
    'sulu_admin.password' => 'Password',
    'sulu_admin.repeat_password' => 'Repeat password',
    'sulu_admin.login' => 'Login',
    'sulu_admin.login_error' => 'This Email/Password combination is wrong. Please try again.',
    'sulu_admin.to_login' => 'Back to login',
    'sulu_admin.reset' => 'Reset',
    'sulu_admin.reset_resend' => 'Resend',
    'sulu_admin.forgot_password' => 'Forgot password',
    'sulu_admin.forgot_password_success' => 'An email with instructions how to reset your password has been sent if a user was found',
    'sulu_admin.list_search_placeholder' => 'Search…',
    'sulu_admin.error' => 'Error',
    'sulu_admin.warning' => 'Warning',
    'sulu_admin.close' => 'Close',
    'sulu_admin.id' => 'ID',
    'sulu_admin.key' => 'Key',
    'sulu_admin.title' => 'Title',
    'sulu_admin.name' => 'Name',
    'sulu_admin.description' => 'Description',
    'sulu_admin.url' => 'URL',
    'sulu_admin.creator' => 'Creator',
    'sulu_admin.created' => 'Created on',
    'sulu_admin.changer' => 'Changer',
    'sulu_admin.changed' => 'Changed on',
    'sulu_admin.published' => 'Published on',
    'sulu_admin.authored' => 'Authored on',
    'sulu_admin.author' => 'Author',
    'sulu_admin.delete_warning_title' => 'Delete?',
    'sulu_admin.delete_warning_text' => 'This operation deletes data and cannot be undone. Do you really wish to proceed?',
    'sulu_admin.delete_linked_warning_title' => 'Confirm deletion',
    'sulu_admin.delete_linked_warning_text' => 'This item is referenced by the following items, are you sure you want to delete it?',
    'sulu_admin.delete_selection_warning_text' => 'This operation deletes {count} {count, plural, =1 {item} other {items}} and cannot be undone. Do you really wish to proceed?',
    'sulu_admin.item_not_deletable' => 'Item cannot be deleted',
    'sulu_admin.delete_linked_abort_text' => 'This item cannot be deleted as long as it has sub items. Delete the following sub items or remove the relation:',
    'sulu_admin.ghost_dialog_title' => 'Copy language?',
    'sulu_admin.ghost_dialog_description' => 'This page does not exist in this language. Do you want to copy content from another language?',
    'sulu_admin.choose_language' => 'Choose language',
    'sulu_admin.characters_left' => 'characters left',
    'sulu_admin.segments_left' => 'segments left',
    'sulu_admin.copy_locale' => 'Copy locale',
    'sulu_admin.choose_target_locale' => 'Choose target locales',
    'sulu_admin.copy_locale_dialog_description' => '* New locale will be created',
    'sulu_admin.move_copy_overlay_title' => 'Choose parent-page',
    'sulu_admin.filter_overlay_title' => 'Configure {fieldLabel}',
    'sulu_admin.data_source' => 'Select source',
    'sulu_admin.choose_data_source' => 'Choose source',
    'sulu_admin.include_sub_elements' => 'Include sub elements',
    'sulu_admin.filter_by_categories' => 'Filter by categories',
    'sulu_admin.any_category_description' => 'Use elements that use any category',
    'sulu_admin.all_categories_description' => 'Use elements that use all categories',
    'sulu_admin.choose_categories' => 'Choose categories',
    'sulu_admin.filter_by_tags' => 'Filter by tags',
    'sulu_admin.any_tag_description' => 'Use elements that use any tag',
    'sulu_admin.all_tags_description' => 'Use elements that use all tags',
    'sulu_admin.filter_by_types' => 'Filter by types',
    'sulu_admin.all_types' => 'All types selected',
    'sulu_admin.no_types' => 'No types selected',
    'sulu_admin.target_groups' => 'Target groups',
    'sulu_admin.use_target_groups' => 'Use target groups',
    'sulu_admin.sort_by' => 'Sort by',
    'sulu_admin.ascending' => 'Ascending',
    'sulu_admin.descending' => 'Descending',
    'sulu_admin.present_as' => 'Present as',
    'sulu_admin.limit_result_to' => 'Limit result to',
    'sulu_admin.smart_content_label' => '{count} {count, plural, =1 {element} other {elements}} selected',
    'sulu_admin.smart_content_block_preview' => 'Smart Content {limit, select, undefined{} other{displaying up to {limit} elements}}',
    'sulu_admin.order_warning_title' => 'Rearrange items',
    'sulu_admin.order_warning_text' => 'The operation you are about to do will rearrange items.',
    'sulu_admin.activate_all' => 'Activate all',
    'sulu_admin.deactivate_all' => 'Deactivate all',
    'sulu_admin.all_selected' => 'All selected',
    'sulu_admin.none_selected' => 'None selected',
    'sulu_admin.please_choose' => 'Please choose',
    'sulu_admin.column_options' => 'Column options',
    'sulu_admin.changelog_line_changer' => 'Last change {changer, select, undefined{} other{from {changer}}} at {changed}',
    'sulu_admin.changelog_line_creator' => 'Created {creator, select, undefined{} other{by {creator}}} at {created}',
    'sulu_admin.settings' => 'Settings',
    'sulu_admin.move_selected' => 'Move selected',
    'sulu_admin.details' => 'Details',
    'sulu_admin.edit_entries' => 'Edit entries',
    'sulu_admin.paragraph' => 'Paragraph',
    'sulu_admin.heading1' => 'Heading 1',
    'sulu_admin.heading2' => 'Heading 2',
    'sulu_admin.heading3' => 'Heading 3',
    'sulu_admin.heading4' => 'Heading 4',
    'sulu_admin.heading5' => 'Heading 5',
    'sulu_admin.heading6' => 'Heading 6',
    'sulu_admin.dirty_warning_dialog_title' => 'Leave form?',
    'sulu_admin.dirty_warning_dialog_text' => 'Changes you made will not be saved.',
    'sulu_admin.export' => 'Export',
    'sulu_admin.export_overlay_title' => 'Configure data format',
    'sulu_admin.delimiter' => 'Delimiter',
    'sulu_admin.enclosure' => 'Enclosure',
    'sulu_admin.escape' => 'Escape',
    'sulu_admin.new_line' => 'New line',
    'sulu_admin.delimiter_description' => 'Character for column separation.',
    'sulu_admin.enclosure_description' => 'Enclose multiple word entries.',
    'sulu_admin.escape_description' => 'Add-on for special characters.',
    'sulu_admin.new_line_description' => 'Character for line brake.',
    'sulu_admin.delimiter_tab' => 'Tab',
    'sulu_admin.enclosure_nothing' => 'Nothing',
    'sulu_admin.link' => 'Link',
    'sulu_admin.link_title' => 'Alternative title',
    'sulu_admin.link_target' => 'Link Target',
    'sulu_admin.link_url' => 'Link URL',
    'sulu_admin.mail_subject' => 'E-Mail Subject',
    'sulu_admin.mail_body' => 'E-Mail Text',
    'sulu_admin.show_history' => 'Show history',
    'sulu_admin.history' => 'History',
    'sulu_admin.resource_locator_history_delete_warning' => 'The URL will be deleted for all draft and live versions. This cannot be undone. Do you wish to proceed?',
    'sulu_admin.has_changed_warning_dialog_title' => 'Content will be overwritten!',
    'sulu_admin.has_changed_warning_dialog_text' => 'This content has been edited by another user. When you save the content this data will get lost.',
    'sulu_admin.edit_profile' => 'Edit profile',
    'sulu_admin.no_permissions' => 'No permissions',
    'sulu_admin.no_options_available' => 'No options available',
    'sulu_admin.form_contains_invalid_values' => 'The form contains invalid values',
    'sulu_admin.form_save_server_error' => 'There was an error when trying to save the form',
    'sulu_admin.form_used_by' => 'This form is currently used by',
    'sulu_admin.refresh_url' => 'Refresh URL',
    'sulu_admin.from' => 'from',
    'sulu_admin.until' => 'until',
    'sulu_admin.external_link' => 'External Link',
    'sulu_admin.internal_link' => 'Internal Link',
    'sulu_admin.block_settings' => 'Block settings',
    'sulu_admin.hide_block' => 'Hide this block on website',
    'sulu_admin.segment' => 'Segment',
    'sulu_admin.missing_type_dialog_title' => 'Choose new template',
    'sulu_admin.missing_type_dialog_description' => 'The template for the copied page does not exist in this webspace.',
    'sulu_preview.auto' => 'Auto',
    'sulu_preview.desktop' => 'Desktop',
    'sulu_preview.tablet' => 'Tablet',
    'sulu_preview.smartphone' => 'Smartphone',
    'sulu_preview.reload' => 'Reload',
    'sulu_preview.open_in_window' => 'Open in window',
  ),
));
$catalogue->addFallbackCatalogue($catalogueEn);

return $catalogue;
