<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('ja', array (
  'validators' => 
  array (
    'This value should be false.' => 'falseでなければなりません。',
    'This value should be true.' => 'trueでなければなりません。',
    'This value should be of type {{ type }}.' => '型は{{ type }}でなければなりません。',
    'This value should be blank.' => '空でなければなりません。',
    'The value you selected is not a valid choice.' => '有効な選択肢ではありません。',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => '{{ limit }}個以上選択してください。',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => '{{ limit }}個以内で選択してください。',
    'One or more of the given values is invalid.' => '無効な選択肢が含まれています。',
    'This field was not expected.' => 'このフィールドは予期されていませんでした。',
    'This field is missing.' => 'このフィールドは、欠落しています。',
    'This value is not a valid date.' => '有効な日付ではありません。',
    'This value is not a valid datetime.' => '有効な日時ではありません。',
    'This value is not a valid email address.' => '有効なメールアドレスではありません。',
    'The file could not be found.' => 'ファイルが見つかりません。',
    'The file is not readable.' => 'ファイルを読み込めません。',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'ファイルのサイズが大きすぎます({{ size }} {{ suffix }})。有効な最大サイズは{{ limit }} {{ suffix }}です。',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'ファイルのMIMEタイプが無効です({{ type }})。有効なMIMEタイプは{{ types }}です。',
    'This value should be {{ limit }} or less.' => '{{ limit }}以下でなければなりません。',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => '値が長すぎます。{{ limit }}文字以内でなければなりません。',
    'This value should be {{ limit }} or more.' => '{{ limit }}以上でなければなりません。',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => '値が短すぎます。{{ limit }}文字以上でなければなりません。',
    'This value should not be blank.' => '空であってはなりません。',
    'This value should not be null.' => 'nullであってはなりません。',
    'This value should be null.' => 'nullでなければなりません。',
    'This value is not valid.' => '有効な値ではありません。',
    'This value is not a valid time.' => '有効な時刻ではありません。',
    'This value is not a valid URL.' => '有効なURLではありません。',
    'The two values should be equal.' => '2つの値が同じでなければなりません。',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'ファイルのサイズが大きすぎます。有効な最大サイズは{{ limit }} {{ suffix }}です。',
    'The file is too large.' => 'ファイルのサイズが大きすぎます。',
    'The file could not be uploaded.' => 'ファイルをアップロードできませんでした。',
    'This value should be a valid number.' => '有効な数字ではありません。',
    'This file is not a valid image.' => 'ファイルが画像ではありません。',
    'This is not a valid IP address.' => '有効なIPアドレスではありません。',
    'This value is not a valid language.' => '有効な言語名ではありません。',
    'This value is not a valid locale.' => '有効なロケールではありません。',
    'This value is not a valid country.' => '有効な国名ではありません。',
    'This value is already used.' => '既に使用されています。',
    'The size of the image could not be detected.' => '画像のサイズが検出できません。',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => '画像の幅が大きすぎます({{ width }}ピクセル)。{{ max_width }}ピクセルまでにしてください。',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => '画像の幅が小さすぎます({{ width }}ピクセル)。{{ min_width }}ピクセル以上にしてください。',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => '画像の高さが大きすぎます({{ height }}ピクセル)。{{ max_height }}ピクセルまでにしてください。',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => '画像の高さが小さすぎます({{ height }}ピクセル)。{{ min_height }}ピクセル以上にしてください。',
    'This value should be the user\'s current password.' => 'ユーザーの現在のパスワードでなければなりません。',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'ちょうど{{ limit }}文字でなければなりません。',
    'The file was only partially uploaded.' => 'ファイルのアップロードは完全ではありません。',
    'No file was uploaded.' => 'ファイルがアップロードされていません。',
    'No temporary folder was configured in php.ini.' => 'php.iniで一時フォルダが設定されていません。',
    'Cannot write temporary file to disk.' => '一時ファイルをディスクに書き込むことができません。',
    'A PHP extension caused the upload to fail.' => 'PHP拡張によってアップロードに失敗しました。',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => '{{ limit }}個以上の要素を含んでなければいけません。',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => '要素は{{ limit }}個までです。',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => '要素はちょうど{{ limit }}個でなければなりません。',
    'Invalid card number.' => '無効なカード番号です。',
    'Unsupported card type or invalid card number.' => '未対応のカード種類又は無効なカード番号です。',
    'This is not a valid International Bank Account Number (IBAN).' => '有効なIBANコードではありません。',
    'This value is not a valid ISBN-10.' => '有効なISBN-10コードではありません。',
    'This value is not a valid ISBN-13.' => '有効なISBN-13コードではありません。',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => '有効なISBN-10コード又はISBN-13コードではありません。',
    'This value is not a valid ISSN.' => '有効なISSNコードではありません。',
    'This value is not a valid currency.' => '有効な貨幣ではありません。',
    'This value should be equal to {{ compared_value }}.' => '{{ compared_value }}と等しくなければなりません。',
    'This value should be greater than {{ compared_value }}.' => '{{ compared_value }}より大きくなければなりません。',
    'This value should be greater than or equal to {{ compared_value }}.' => '{{ compared_value }}以上でなければなりません。',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => '{{ compared_value_type }}としての{{ compared_value }}と等しくなければなりません。',
    'This value should be less than {{ compared_value }}.' => '{{ compared_value }}未満でなければなりません。',
    'This value should be less than or equal to {{ compared_value }}.' => '{{ compared_value }}以下でなければなりません。',
    'This value should not be equal to {{ compared_value }}.' => '{{ compared_value }}と等しくてはいけません。',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => '{{ compared_value_type }}としての{{ compared_value }}と等しくてはいけません。',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => '画像のアスペクト比が大きすぎます({{ ratio }})。{{ max_ratio }}までにしてください。',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => '画像のアスペクト比が小さすぎます({{ ratio }})。{{ min_ratio }}以上にしてください。',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => '画像が正方形になっています({{ width }}x{{ height }}ピクセル)。正方形の画像は許可されていません。',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => '画像が横向きになっています({{ width }}x{{ height }}ピクセル)。横向きの画像は許可されていません。',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => '画像が縦向きになっています({{ width }}x{{ height }}ピクセル)。縦向きの画像は許可されていません。',
    'An empty file is not allowed.' => '空のファイルは許可されていません。',
    'The host could not be resolved.' => 'ホストを解決できませんでした。',
    'This value does not match the expected {{ charset }} charset.' => 'この値は予期される文字コード（{{ charset }}）と異なります。',
    'This is not a valid Business Identifier Code (BIC).' => '有効なSWIFTコードではありません。',
    'Error' => 'エラー',
    'This is not a valid UUID.' => '有効なUUIDではありません。',
    'This value should be a multiple of {{ compared_value }}.' => '{{ compared_value }}の倍数でなければなりません。',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'このSWIFTコードはIBANコード（{{ iban }}）に関連付けられていません。',
    'This value should be valid JSON.' => 'JSONでなければなりません。',
    'This collection should contain only unique elements.' => '要素は重複してはなりません。',
    'This value should be positive.' => '正の数でなければなりません。',
    'This value should be either positive or zero.' => '正の数、または0でなければなりません。',
    'This value should be negative.' => '負の数でなければなりません。',
    'This value should be either negative or zero.' => '負の数、または0でなければなりません。',
    'This value is not a valid timezone.' => '有効なタイムゾーンではありません。',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'このパスワードは漏洩している為使用できません。',
    'This value should be between {{ min }} and {{ max }}.' => '{{ min }}以上{{ max }}以下でなければなりません。',
    'This value is not a valid hostname.' => '有効なホスト名ではありません。',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => '要素の数は{{ compared_value }}の倍数でなければなりません。',
    'This value should satisfy at least one of the following constraints:' => '以下の制約のうち少なくとも1つを満たす必要があります:',
    'Each element of this collection should satisfy its own set of constraints.' => 'コレクションの各要素は、それぞれの制約を満たす必要があります。',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'この値は有効な国際証券識別番号（ISIN）ではありません。',
    'This form should not contain extra fields.' => 'フィールドグループに追加のフィールドを含んではなりません。',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'アップロードされたファイルが大きすぎます。小さなファイルで再度アップロードしてください。',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'CSRFトークンが無効です、再送信してください。',
    'This value is not a valid HTML5 color.' => '有効なHTML5の色ではありません。',
    'Please enter a valid birthdate.' => '有効な生年月日を入力してください。',
    'The selected choice is invalid.' => '選択した値は無効です。',
    'The collection is invalid.' => 'コレクションは無効です。',
    'Please select a valid color.' => '有効な色を選択してください。',
    'Please select a valid country.' => '有効な国を選択してください。',
    'Please select a valid currency.' => '有効な通貨を選択してください。',
    'Please choose a valid date interval.' => '有効な日付間隔を選択してください。',
    'Please enter a valid date and time.' => '有効な日時を入力してください。',
    'Please enter a valid date.' => '有効な日付を入力してください。',
    'Please select a valid file.' => '有効なファイルを選択してください。',
    'The hidden field is invalid.' => '隠しフィールドが無効です。',
    'Please enter an integer.' => '整数で入力してください。',
    'Please select a valid language.' => '有効な言語を選択してください。',
    'Please select a valid locale.' => '有効なロケールを選択してください。',
    'Please enter a valid money amount.' => '有効な金額を入力してください。',
    'Please enter a number.' => '数値で入力してください。',
    'The password is invalid.' => 'パスワードが無効です。',
    'Please enter a percentage value.' => 'パーセント値で入力してください。',
    'The values do not match.' => '値が一致しません。',
    'Please enter a valid time.' => '有効な時間を入力してください。',
    'Please select a valid timezone.' => '有効なタイムゾーンを選択してください。',
    'Please enter a valid URL.' => '有効なURLを入力してください。',
    'Please enter a valid search term.' => '有効な検索語を入力してください。',
    'Please provide a valid phone number.' => '有効な電話番号を入力してください。',
    'The checkbox has an invalid value.' => 'チェックボックスの値が無効です。',
    'Please enter a valid email address.' => '有効なメールアドレスを入力してください。',
    'Please select a valid option.' => '有効な値を選択してください。',
    'Please select a valid range.' => '有効な範囲を選択してください。',
    'Please enter a valid week.' => '有効な週を入力してください。',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => '認証エラーが発生しました。',
    'Authentication credentials could not be found.' => '認証資格がありません。',
    'Authentication request could not be processed due to a system problem.' => 'システムの問題により認証要求を処理できませんでした。',
    'Invalid credentials.' => '資格が無効です。',
    'Cookie has already been used by someone else.' => 'Cookie が別のユーザーで使用されています。',
    'Not privileged to request the resource.' => 'リソースをリクエストする権限がありません。',
    'Invalid CSRF token.' => 'CSRF トークンが無効です。',
    'No authentication provider found to support the authentication token.' => '認証トークンをサポートする認証プロバイダーが見つかりません。',
    'No session available, it either timed out or cookies are not enabled.' => '利用可能なセッションがありません。タイムアウトしたか、Cookie が無効になっています。',
    'No token could be found.' => 'トークンが見つかりません。',
    'Username could not be found.' => 'ユーザー名が見つかりません。',
    'Account has expired.' => 'アカウントが有効期限切れです。',
    'Credentials have expired.' => '資格が有効期限切れです。',
    'Account is disabled.' => 'アカウントが無効です。',
    'Account is locked.' => 'アカウントはロックされています。',
    'Too many failed login attempts, please try again later.' => 'ログイン試行回数を超えました。しばらくして再度お試しください。',
    'Invalid or expired login link.' => 'ログインリンクが有効期限切れ、もしくは無効です。',
  ),
));

$catalogueEn = new MessageCatalogue('en', array (
  'validators' => 
  array (
    'This value should be false.' => 'This value should be false.',
    'This value should be true.' => 'This value should be true.',
    'This value should be of type {{ type }}.' => 'This value should be of type {{ type }}.',
    'This value should be blank.' => 'This value should be blank.',
    'The value you selected is not a valid choice.' => 'The value you selected is not a valid choice.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.',
    'One or more of the given values is invalid.' => 'One or more of the given values is invalid.',
    'This field was not expected.' => 'This field was not expected.',
    'This field is missing.' => 'This field is missing.',
    'This value is not a valid date.' => 'This value is not a valid date.',
    'This value is not a valid datetime.' => 'This value is not a valid datetime.',
    'This value is not a valid email address.' => 'This value is not a valid email address.',
    'The file could not be found.' => 'The file could not be found.',
    'The file is not readable.' => 'The file is not readable.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.',
    'This value should be {{ limit }} or less.' => 'This value should be {{ limit }} or less.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.',
    'This value should be {{ limit }} or more.' => 'This value should be {{ limit }} or more.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.',
    'This value should not be blank.' => 'This value should not be blank.',
    'This value should not be null.' => 'This value should not be null.',
    'This value should be null.' => 'This value should be null.',
    'This value is not valid.' => 'This value is not valid.',
    'This value is not a valid time.' => 'This value is not a valid time.',
    'This value is not a valid URL.' => 'This value is not a valid URL.',
    'The two values should be equal.' => 'The two values should be equal.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'The file is too large.',
    'The file could not be uploaded.' => 'The file could not be uploaded.',
    'This value should be a valid number.' => 'This value should be a valid number.',
    'This file is not a valid image.' => 'This file is not a valid image.',
    'This is not a valid IP address.' => 'This is not a valid IP address.',
    'This value is not a valid language.' => 'This value is not a valid language.',
    'This value is not a valid locale.' => 'This value is not a valid locale.',
    'This value is not a valid country.' => 'This value is not a valid country.',
    'This value is already used.' => 'This value is already used.',
    'The size of the image could not be detected.' => 'The size of the image could not be detected.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'This value should be the user\'s current password.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.',
    'The file was only partially uploaded.' => 'The file was only partially uploaded.',
    'No file was uploaded.' => 'No file was uploaded.',
    'No temporary folder was configured in php.ini.' => 'No temporary folder was configured in php.ini, or the configured folder does not exist.',
    'Cannot write temporary file to disk.' => 'Cannot write temporary file to disk.',
    'A PHP extension caused the upload to fail.' => 'A PHP extension caused the upload to fail.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.',
    'Invalid card number.' => 'Invalid card number.',
    'Unsupported card type or invalid card number.' => 'Unsupported card type or invalid card number.',
    'This is not a valid International Bank Account Number (IBAN).' => 'This is not a valid International Bank Account Number (IBAN).',
    'This value is not a valid ISBN-10.' => 'This value is not a valid ISBN-10.',
    'This value is not a valid ISBN-13.' => 'This value is not a valid ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'This value is neither a valid ISBN-10 nor a valid ISBN-13.',
    'This value is not a valid ISSN.' => 'This value is not a valid ISSN.',
    'This value is not a valid currency.' => 'This value is not a valid currency.',
    'This value should be equal to {{ compared_value }}.' => 'This value should be equal to {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'This value should be greater than {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'This value should be greater than or equal to {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should be identical to {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'This value should be less than {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'This value should be less than or equal to {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'This value should not be equal to {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.',
    'An empty file is not allowed.' => 'An empty file is not allowed.',
    'The host could not be resolved.' => 'The host could not be resolved.',
    'This value does not match the expected {{ charset }} charset.' => 'This value does not match the expected {{ charset }} charset.',
    'This is not a valid Business Identifier Code (BIC).' => 'This is not a valid Business Identifier Code (BIC).',
    'Error' => 'Error',
    'This is not a valid UUID.' => 'This is not a valid UUID.',
    'This value should be a multiple of {{ compared_value }}.' => 'This value should be a multiple of {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'This value should be valid JSON.',
    'This collection should contain only unique elements.' => 'This collection should contain only unique elements.',
    'This value should be positive.' => 'This value should be positive.',
    'This value should be either positive or zero.' => 'This value should be either positive or zero.',
    'This value should be negative.' => 'This value should be negative.',
    'This value should be either negative or zero.' => 'This value should be either negative or zero.',
    'This value is not a valid timezone.' => 'This value is not a valid timezone.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'This password has been leaked in a data breach, it must not be used. Please use another password.',
    'This value should be between {{ min }} and {{ max }}.' => 'This value should be between {{ min }} and {{ max }}.',
    'This value is not a valid hostname.' => 'This value is not a valid hostname.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'The number of elements in this collection should be a multiple of {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'This value should satisfy at least one of the following constraints:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Each element of this collection should satisfy its own set of constraints.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'This value is not a valid International Securities Identification Number (ISIN).',
    'This form should not contain extra fields.' => 'This form should not contain extra fields.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'The uploaded file was too large. Please try to upload a smaller file.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'The CSRF token is invalid. Please try to resubmit the form.',
    'This value is not a valid HTML5 color.' => 'This value is not a valid HTML5 color.',
    'Please enter a valid birthdate.' => 'Please enter a valid birthdate.',
    'The selected choice is invalid.' => 'The selected choice is invalid.',
    'The collection is invalid.' => 'The collection is invalid.',
    'Please select a valid color.' => 'Please select a valid color.',
    'Please select a valid country.' => 'Please select a valid country.',
    'Please select a valid currency.' => 'Please select a valid currency.',
    'Please choose a valid date interval.' => 'Please choose a valid date interval.',
    'Please enter a valid date and time.' => 'Please enter a valid date and time.',
    'Please enter a valid date.' => 'Please enter a valid date.',
    'Please select a valid file.' => 'Please select a valid file.',
    'The hidden field is invalid.' => 'The hidden field is invalid.',
    'Please enter an integer.' => 'Please enter an integer.',
    'Please select a valid language.' => 'Please select a valid language.',
    'Please select a valid locale.' => 'Please select a valid locale.',
    'Please enter a valid money amount.' => 'Please enter a valid money amount.',
    'Please enter a number.' => 'Please enter a number.',
    'The password is invalid.' => 'The password is invalid.',
    'Please enter a percentage value.' => 'Please enter a percentage value.',
    'The values do not match.' => 'The values do not match.',
    'Please enter a valid time.' => 'Please enter a valid time.',
    'Please select a valid timezone.' => 'Please select a valid timezone.',
    'Please enter a valid URL.' => 'Please enter a valid URL.',
    'Please enter a valid search term.' => 'Please enter a valid search term.',
    'Please provide a valid phone number.' => 'Please provide a valid phone number.',
    'The checkbox has an invalid value.' => 'The checkbox has an invalid value.',
    'Please enter a valid email address.' => 'Please enter a valid email address.',
    'Please select a valid option.' => 'Please select a valid option.',
    'Please select a valid range.' => 'Please select a valid range.',
    'Please enter a valid week.' => 'Please enter a valid week.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'An authentication exception occurred.',
    'Authentication credentials could not be found.' => 'Authentication credentials could not be found.',
    'Authentication request could not be processed due to a system problem.' => 'Authentication request could not be processed due to a system problem.',
    'Invalid credentials.' => 'Invalid credentials.',
    'Cookie has already been used by someone else.' => 'Cookie has already been used by someone else.',
    'Not privileged to request the resource.' => 'Not privileged to request the resource.',
    'Invalid CSRF token.' => 'Invalid CSRF token.',
    'No authentication provider found to support the authentication token.' => 'No authentication provider found to support the authentication token.',
    'No session available, it either timed out or cookies are not enabled.' => 'No session available, it either timed out or cookies are not enabled.',
    'No token could be found.' => 'No token could be found.',
    'Username could not be found.' => 'Username could not be found.',
    'Account has expired.' => 'Account has expired.',
    'Credentials have expired.' => 'Credentials have expired.',
    'Account is disabled.' => 'Account is disabled.',
    'Account is locked.' => 'Account is locked.',
    'Too many failed login attempts, please try again later.' => 'Too many failed login attempts, please try again later.',
    'Invalid or expired login link.' => 'Invalid or expired login link.',
  ),
  'admin' => 
  array (
    'sulu_search.search' => 'Search',
    'sulu_search.everything' => 'Everything',
    'sulu_search.search_hint' => 'Use (*) in your query as a placeholder for parts of a word.',
    'sulu_search.nothing_found' => 'Nothing could be found for your search term.',
    'sulu_contact.contacts' => 'Contacts',
    'sulu_contact.organizations' => 'Organizations',
    'sulu_contact.organization' => 'Organization',
    'sulu_contact.people' => 'People',
    'sulu_contact.contact_selection_overlay_title' => 'Choose contacts',
    'sulu_contact.account_selection_overlay_title' => 'Choose accounts',
    'sulu_contact.contact_selection_label' => '{count} {count, plural, =1 {contact} other {contacts}} selected',
    'sulu_contact.account_selection_label' => '{count} {count, plural, =1 {account} other {accounts}} selected',
    'sulu_contact.contact_account_selection_label' => '{count} {count, plural, =1 {contact} other {contacts}} selected',
    'sulu_contact.avatar' => 'Avatar',
    'sulu_contact.logo' => 'Logo',
    'sulu_contact.name' => 'Name',
    'sulu_contact.first_name' => 'First Name',
    'sulu_contact.last_name' => 'Last Name',
    'sulu_contact.contact_details' => 'Contact details',
    'sulu_contact.addresses' => 'Addresses',
    'sulu_contact.bank_accounts' => 'Bank accounts',
    'sulu_contact.email' => 'Email',
    'sulu_contact.primary_address' => 'Primary address',
    'sulu_contact.delivery_address' => 'Delivery address',
    'sulu_contact.billing_address' => 'Billing address',
    'sulu_contact.city' => 'City',
    'sulu_contact.zip' => 'ZIP',
    'sulu_contact.street' => 'Street',
    'sulu_contact.number' => 'Number',
    'sulu_contact.address_line' => 'Addressline',
    'sulu_contact.state' => 'Region',
    'sulu_contact.country' => 'Country',
    'sulu_contact.postbox_number' => 'Postbox #',
    'sulu_contact.postbox_zip' => 'Postbox ZIP',
    'sulu_contact.postbox_city' => 'Postbox City',
    'sulu_contact.phone' => 'Phone',
    'sulu_contact.fax' => 'Fax',
    'sulu_contact.website' => 'Website',
    'sulu_contact.social_media' => 'Social Media',
    'sulu_contact.birthday' => 'Birthday',
    'sulu_contact.title' => 'Title',
    'sulu_contact.salutation' => 'Salutation',
    'sulu_contact.form_of_address' => 'Form of Address',
    'sulu_contact.male_form_of_address' => 'Mr.',
    'sulu_contact.female_form_of_address' => 'Ms.',
    'sulu_contact.position' => 'Position',
    'sulu_contact.corporation' => 'Corporation',
    'sulu_contact.main_contact' => 'Main Contact',
    'sulu_contact.uid' => 'UID',
    'sulu_contact.register_number' => 'Register Number',
    'sulu_contact.jurisdiction' => 'Jurisdiction',
    'sulu_contact.note' => 'Note',
    'sulu_contact.parent_company' => 'Parent Company',
    'sulu_contact.upload_avatar_info_text' => 'Drop image or click to change avatar',
    'sulu_contact.upload_logo_info_text' => 'Drop image or click to change logo',
    'sulu_contact.no_contact_selected' => 'No contact selected',
    'sulu_contact.single_contact_selection_overlay_title' => 'Choose contact',
    'sulu_contact.no_account_selected' => 'No account selected',
    'sulu_contact.single_account_selection_overlay_title' => 'Choose account',
    'sulu_contact.taxonomies' => 'Taxonomies',
    'sulu_contact.add_address' => 'Add address',
    'sulu_contact.edit_address' => 'Edit address',
    'sulu_contact.add_bank_account' => 'Add bank account',
    'sulu_contact.edit_bank_account' => 'Edit bank account',
    'sulu_contact.work' => 'Work',
    'sulu_contact.private' => 'Private',
    'sulu_contact.mobile' => 'Mobile',
    'sulu_contact.bank' => 'Bank',
    'sulu_contact.iban' => 'IBAN',
    'sulu_contact.bic' => 'BIC',
    'sulu_contact.edit_title_overlay_title' => 'Edit titles',
    'sulu_contact.edit_position_overlay_title' => 'Edit positions',
    'sulu_contact.documents' => 'Documents',
    'sulu_contact.delete_media_warning_title' => 'Remove document assignment?',
    'sulu_contact.delete_media_warning_text' => 'This operation removes the selected document assignments. The document itself will not be deleted. Do you really wish to proceed?',
    'sulu_contact.add_contact_to_organization' => 'Add contact to organization',
    'sulu_contact.latitude' => 'Latitude',
    'sulu_contact.longitude' => 'Longitude',
    'sulu_media.media' => 'Media',
    'sulu_media.all_media' => 'All media',
    'sulu_media.audio' => 'Audio',
    'sulu_media.document' => 'Document',
    'sulu_media.image' => 'Image',
    'sulu_media.video' => 'Video',
    'sulu_media.copy_url' => 'Copy URL',
    'sulu_media.download_masterfile' => 'Download master file',
    'sulu_media.select_media_singular' => 'Select media',
    'sulu_media.select_media_plural' => 'Select media',
    'sulu_media.reset_selection' => 'Reset selection',
    'sulu_media.copy_masterfile_url' => 'Copy master file URL',
    'sulu_media.copy_masterfile_url_website' => 'Copy master file URL (Website)',
    'sulu_media.information_taxonomy' => 'Information and Taxonomy',
    'sulu_media.upload' => 'Upload',
    'sulu_media.upload_new_version' => 'Upload new version',
    'sulu_media.media_selected_singular' => 'media element selected',
    'sulu_media.media_selected_plural' => 'media elements selected',
    'sulu_media.drop_files_to_upload' => 'Upload files per drag`n`drop',
    'sulu_media.click_here_to_upload' => 'or click here to upload files',
    'sulu_media.add_collection' => 'Add collection',
    'sulu_media.remove_collection' => 'Delete collection',
    'sulu_media.remove_collection_warning' => 'This operation deletes a collection and cannot be undone. Do you really wish to proceed?',
    'sulu_media.move_collection' => 'Move collection',
    'sulu_media.edit_collection' => 'Edit collection',
    'sulu_media.download_media' => 'Download media',
    'sulu_media.download_counter' => 'Download count',
    'sulu_media.delete_media' => 'Delete media',
    'sulu_media.delete_media_warning_title' => 'Delete media',
    'sulu_media.delete_media_warning_text' => 'This operation deletes a media and cannot be undone. Do you really wish to proceed?',
    'sulu_media.delete_preview_image_warning_title' => 'Delete preview image',
    'sulu_media.delete_preview_image_warning_text' => 'This operation deletes the preview image and cannot be undone. Do you really wish to proceed?',
    'sulu_media.thumbnail' => 'Thumbnail',
    'sulu_media.type' => 'Type',
    'sulu_media.version' => 'Version',
    'sulu_media.size' => 'Filesize',
    'sulu_media.mime_type' => 'MIME-Type',
    'sulu_media.license' => 'License',
    'sulu_media.copyright' => 'Copyright Information',
    'sulu_media.credits' => 'Credits',
    'sulu_media.taxonomies' => 'Taxonomies',
    'sulu_media.history' => 'History',
    'sulu_media.formats' => 'Formats',
    'sulu_media.all_collections' => 'All collections',
    'sulu_media.move_media' => 'Move media',
    'sulu_media.upload_server_error' => 'There was an error while uploading one or multiple files to the server.',
    'sulu_media.set_focus_point' => 'Set focus point',
    'sulu_media.define_crops' => 'Define crops',
    'sulu_media.upload_preview_image' => 'Upload preview image',
    'sulu_media.delete_preview_image' => 'Delete preview image',
    'sulu_media.cropped' => 'Cropped',
    'sulu_media.double_click_crop_and_maximize' => 'A double-click maximizes and centers the area',
    'sulu_media.min_size_notification' => 'Minimal size reached',
    'sulu_media.left_top' => 'Left top',
    'sulu_media.top' => 'Top',
    'sulu_media.right_top' => 'Right top',
    'sulu_media.left' => 'Left',
    'sulu_media.middle' => 'Middle',
    'sulu_media.right' => 'Right',
    'sulu_media.left_bottom' => 'Left bottom',
    'sulu_media.bottom' => 'Bottom',
    'sulu_media.right_bottom' => 'Right bottom',
    'sulu_media.hotspots' => 'Hotspots',
    'sulu_media.add_hotspot' => 'Add hotspot',
    'sulu_media.hotspot_type' => 'Hotspot type',
    'sulu_media.form_type' => 'Form type',
    'sulu_media.circle' => 'Circle',
    'sulu_media.point' => 'Point',
    'sulu_media.rectangle' => 'Rectangle',
    'sulu_security.roles' => 'User roles',
    'sulu_security.user_name' => 'Username',
    'sulu_security.enable_user' => 'Enable User',
    'sulu_security.user_locked' => 'User locked',
    'sulu_security.permissions' => 'Permissions',
    'sulu_security.password' => 'Password',
    'sulu_security.email' => 'Email',
    'sulu_security.system' => 'System',
    'sulu_security.system_language' => 'System language',
    'sulu_security.reset_mail_subject' => 'Reset your Sulu password',
    'sulu_security.reset_mail_message' => 'To reset your Sulu password please click on the following link or copy/paste it to your browser:',
    'sulu_security.view' => 'View',
    'sulu_security.add' => 'Add',
    'sulu_security.edit' => 'Edit',
    'sulu_security.delete' => 'Delete',
    'sulu_security.live' => 'Live',
    'sulu_security.security' => 'Security',
    'sulu_security.system_permission_heading' => 'Activate permissions for {system}',
    'sulu_security.inherit_permissions_title' => 'Inherit permissions?',
    'sulu_security.inherit_permissions_label' => 'Override permissions of sub elements',
    'sulu_security.move_permission_title' => 'Notice',
    'sulu_security.move_permission_warning' => 'Permissions from the parent element will not be transferred.',
    'sulu_category.categories' => 'Categories',
    'sulu_category.key' => 'Key',
    'sulu_category.name' => 'Name',
    'sulu_category.keywords' => 'Keywords',
    'sulu_category.keyword' => 'Keyword',
    'sulu_category.multiple_usage' => 'Multiple Usage',
    'sulu_category.all_categories' => 'All categories',
    'sulu_category.no_category_selected' => 'No category selected',
    'sulu_category.single_category_selection_overlay_title' => 'Choose category',
    'sulu_snippet.selection_overlay_title' => 'Choose snippets',
    'sulu_snippet.selection_label' => '{count} {count, plural, =1 {snippet} other {snippets}} selected',
    'sulu_snippet.no_snippet_selected' => 'No snippet selected',
    'sulu_snippet.single_snippet_selection_overlay_title' => 'Choose snippet',
    'sulu_snippet.snippets' => 'Snippets',
    'sulu_snippet.snippet' => 'Snippet',
    'sulu_snippet.default_snippets' => 'Default Snippets',
    'sulu_snippet.snippet_area' => 'Type or area',
    'sulu_snippet.taxonomies' => 'Taxonomies',
    'sulu_snippet.webspace_default_snippet' => '%webspaceKey% default snippet',
    'sulu_page.webspaces' => 'Webspaces',
    'sulu_page.selection_label' => '{count} {count, plural, =1 {page} other {pages}} selected',
    'sulu_page.selection_overlay_title' => 'Choose pages',
    'sulu_page.seo' => 'SEO',
    'sulu_page.excerpt' => 'Excerpt & Taxonomies',
    'sulu_page.title' => 'Title',
    'sulu_page.show_ghost_and_shadow' => 'Show ghost and shadow pages',
    'sulu_page.no_page_selected' => 'No page selected',
    'sulu_page.single_selection_overlay_title' => 'Choose page',
    'sulu_page.settings' => 'Settings',
    'sulu_page.show_page_in' => 'Show page in',
    'sulu_page.no_navigation' => 'no navigation',
    'sulu_page.all_navigations' => 'all navigations',
    'sulu_page.page_type' => 'Page Type',
    'sulu_page.content' => 'Content',
    'sulu_page.pages' => 'Pages',
    'sulu_page.page' => 'Page',
    'sulu_page.internal_link' => 'Internal Link',
    'sulu_page.external_link' => 'External Link',
    'sulu_page.link_title' => 'Link Title',
    'sulu_page.linked_content' => 'Linked Content',
    'sulu_page.url' => 'URL',
    'sulu_page.shadow_page' => 'Shadow Page',
    'sulu_page.enable_shadow_page' => 'Enable Shadow Page',
    'sulu_page.enable_shadow_page_info_text' => 'This function is disabled if the current locale is already used as shadow locale.',
    'sulu_page.shadow_locale' => 'Shadow Locale',
    'sulu_page.editing_information' => 'Editing Information',
    'sulu_page.authored_date' => 'Authored Date',
    'sulu_page.author' => 'Author',
    'sulu_page.changelog' => 'Changelog',
    'sulu_page.text_for_more_link' => 'Text for more link',
    'sulu_page.icons' => 'Icons',
    'sulu_page.images' => 'Images',
    'sulu_page.edited' => 'edited',
    'sulu_page.search_result' => 'Search Engine Result Pages Preview (SERP)',
    'sulu_page.meta_title' => 'Title (Meta title)',
    'sulu_page.meta_title_info_text' => 'The meta title is limited to 55 characters.',
    'sulu_page.meta_description' => 'Description (Meta description)',
    'sulu_page.meta_description_info_text' => 'The meta description is limited to 320 characters.',
    'sulu_page.meta_keywords' => 'Keywords (Meta keywords)',
    'sulu_page.meta_keywords_info_text' => 'Please use a maximum of 5 keywords, dependant from the content of the page, separated by commas.',
    'sulu_page.canonical_url' => 'Canonical URL  (Canonical tag)',
    'sulu_page.no_index' => 'no-index (page will not be indexed by search engines)',
    'sulu_page.no_follow' => 'no-follow (links on this page will not be followed by the search engine)',
    'sulu_page.hide_in_sitemap' => 'Hide in sitemap',
    'sulu_page.delete_draft' => 'Delete draft',
    'sulu_page.delete_draft_warning_title' => 'Delete Draft?',
    'sulu_page.delete_draft_warning_text' => 'Do you really want to delete the draft? All data will be lost. The published page will not be changed.',
    'sulu_page.unpublish_warning_title' => 'Set to unpublished?',
    'sulu_page.unpublish_warning_text' => 'Do you really want to unpublish the page? All website links will be lost. This setting can be changed at any time without data loss.',
    'sulu_page.unpublish' => 'Set to unpublished',
    'sulu_page.restore_version' => 'Restore version?',
    'sulu_page.restore_version_text' => 'A new draft will be created. An existing draft version will be overwritten',
    'sulu_page.hide_block_label' => 'Don\'t display on public website',
    'sulu_page.hide_block_description' => 'This block will not be published, but remains editable in the admin.',
    'sulu_page.segment_label' => 'Assign segment',
    'sulu_page.segment_description' => 'The block will be automatically filtered on the website by the chosen segment.',
    'sulu_page.target_groups_label' => 'Assign target groups',
    'sulu_page.target_groups_description' => 'The block will only be visible for the selected target groups.',
    'sulu_tag.tags' => 'Tags',
    'sulu_tag.tag' => 'Tag',
    'sulu_website.analytics' => 'Analytics',
    'sulu_website.all_domains' => 'All domains',
    'sulu_website.domains' => 'Domains',
    'sulu_website.google_analytics' => 'Google Analytics',
    'sulu_website.google_tag_manager' => 'Google Tag Manager',
    'sulu_website.matomo' => 'Matomo',
    'sulu_website.custom_analytics' => 'Custom',
    'sulu_website.script' => 'Script',
    'sulu_website.key' => 'Key',
    'sulu_website.matomo_url' => 'URL',
    'sulu_website.matomo_id' => 'Site-ID',
    'sulu_website.position' => 'Position',
    'sulu_website.head_open' => 'Head open',
    'sulu_website.head_close' => 'Head close',
    'sulu_website.body_open' => 'Body open',
    'sulu_website.body_close' => 'Body close',
    'sulu_website.cache_clear' => 'Clear website cache',
    'sulu_website.cache_clear_warning_title' => 'Clear website cache?',
    'sulu_website.cache_clear_warning_text' => 'This operation will clear the entire cache for all webspaces. Do you really wish to proceed?',
    'sulu_location.latitude' => 'Latitude',
    'sulu_location.longitude' => 'Longitude',
    'sulu_location.zoom' => 'Zoom',
    'sulu_location.select_location' => 'Select location',
    'sulu_location.additional_information' => 'Additional Information',
    'sulu_location.title' => 'Title',
    'sulu_location.street' => 'Street',
    'sulu_location.number' => 'Number',
    'sulu_location.code' => 'Code',
    'sulu_location.town' => 'Town',
    'sulu_location.country' => 'Country',
    'sulu_custom_url.custom_urls' => 'Custom URLs',
    'sulu_custom_url.custom_url' => 'Custom URL',
    'sulu_custom_url.published' => 'Published',
    'sulu_custom_url.base_domain' => 'Base domain',
    'sulu_custom_url.target_page' => 'Target page',
    'sulu_custom_url.target_locale' => 'Localization',
    'sulu_custom_url.redirect' => 'Redirect',
    'sulu_custom_url.redirect_info' => 'The custom URL will be redirected to URL of the linked page.',
    'sulu_custom_url.canonical' => 'Canonical URL',
    'sulu_custom_url.canonical_info' => 'When the Canonical URL has been activated only the linked page will be indexed by search engines',
    'sulu_custom_url.no_index' => 'No Index',
    'sulu_custom_url.no_index_info' => 'The page will not be indexed by search engines.',
    'sulu_custom_url.no_follow' => 'No Follow',
    'sulu_custom_url.no_follow_info' => 'The links on the page will not be followed by search engines.',
    'sulu_custom_url.target_title' => 'Target page',
    'sulu_admin.add' => 'Add',
    'sulu_admin.add_block' => 'Add block',
    'sulu_admin.delete' => 'Delete',
    'sulu_admin.move' => 'Move',
    'sulu_admin.move_items' => 'Move items',
    'sulu_admin.copy' => 'Copy',
    'sulu_admin.order' => 'Order',
    'sulu_admin.of' => 'of',
    'sulu_admin.page' => 'Page',
    'sulu_admin.per_page' => 'Items per page',
    'sulu_admin.save' => 'Save',
    'sulu_admin.save_draft' => 'Save as draft',
    'sulu_admin.save_publish' => 'Save and publish',
    'sulu_admin.publish' => 'Publish',
    'sulu_admin.create' => 'Create',
    'sulu_admin.edit' => 'Edit',
    'sulu_admin.object' => 'Object',
    'sulu_admin.objects' => 'Objects',
    'sulu_admin.reached_end_of_list' => 'You reached the end of the list',
    'sulu_admin.confirm' => 'Confirm',
    'sulu_admin.ok' => 'Ok',
    'sulu_admin.cancel' => 'Cancel',
    'sulu_admin.apply' => 'Apply',
    'sulu_admin.yes' => 'Yes',
    'sulu_admin.no' => 'No',
    'sulu_admin.type' => 'Type',
    'sulu_admin.default' => 'Default',
    'sulu_admin.error_required' => 'This field must have a value',
    'sulu_admin.error_minlength' => 'The minimal length of this field was undershot',
    'sulu_admin.error_minitems' => 'This field has too few selections',
    'sulu_admin.welcome' => 'Welcome',
    'sulu_admin.reset_password' => 'Reset password',
    'sulu_admin.reset_password_error' => 'The passwords do not match',
    'sulu_admin.back_to_website' => 'Back to website',
    'sulu_admin.username_or_email' => 'Username or Email',
    'sulu_admin.password' => 'Password',
    'sulu_admin.repeat_password' => 'Repeat password',
    'sulu_admin.login' => 'Login',
    'sulu_admin.login_error' => 'This Email/Password combination is wrong. Please try again.',
    'sulu_admin.to_login' => 'Back to login',
    'sulu_admin.reset' => 'Reset',
    'sulu_admin.reset_resend' => 'Resend',
    'sulu_admin.forgot_password' => 'Forgot password',
    'sulu_admin.forgot_password_success' => 'An email with instructions how to reset your password has been sent if a user was found',
    'sulu_admin.list_search_placeholder' => 'Search…',
    'sulu_admin.error' => 'Error',
    'sulu_admin.warning' => 'Warning',
    'sulu_admin.close' => 'Close',
    'sulu_admin.id' => 'ID',
    'sulu_admin.key' => 'Key',
    'sulu_admin.title' => 'Title',
    'sulu_admin.name' => 'Name',
    'sulu_admin.description' => 'Description',
    'sulu_admin.url' => 'URL',
    'sulu_admin.creator' => 'Creator',
    'sulu_admin.created' => 'Created on',
    'sulu_admin.changer' => 'Changer',
    'sulu_admin.changed' => 'Changed on',
    'sulu_admin.published' => 'Published on',
    'sulu_admin.authored' => 'Authored on',
    'sulu_admin.author' => 'Author',
    'sulu_admin.delete_warning_title' => 'Delete?',
    'sulu_admin.delete_warning_text' => 'This operation deletes data and cannot be undone. Do you really wish to proceed?',
    'sulu_admin.delete_linked_warning_title' => 'Confirm deletion',
    'sulu_admin.delete_linked_warning_text' => 'This item is referenced by the following items, are you sure you want to delete it?',
    'sulu_admin.delete_selection_warning_text' => 'This operation deletes {count} {count, plural, =1 {item} other {items}} and cannot be undone. Do you really wish to proceed?',
    'sulu_admin.item_not_deletable' => 'Item cannot be deleted',
    'sulu_admin.delete_linked_abort_text' => 'This item cannot be deleted as long as it has sub items. Delete the following sub items or remove the relation:',
    'sulu_admin.ghost_dialog_title' => 'Copy language?',
    'sulu_admin.ghost_dialog_description' => 'This page does not exist in this language. Do you want to copy content from another language?',
    'sulu_admin.choose_language' => 'Choose language',
    'sulu_admin.characters_left' => 'characters left',
    'sulu_admin.segments_left' => 'segments left',
    'sulu_admin.copy_locale' => 'Copy locale',
    'sulu_admin.choose_target_locale' => 'Choose target locales',
    'sulu_admin.copy_locale_dialog_description' => '* New locale will be created',
    'sulu_admin.move_copy_overlay_title' => 'Choose parent-page',
    'sulu_admin.filter_overlay_title' => 'Configure {fieldLabel}',
    'sulu_admin.data_source' => 'Select source',
    'sulu_admin.choose_data_source' => 'Choose source',
    'sulu_admin.include_sub_elements' => 'Include sub elements',
    'sulu_admin.filter_by_categories' => 'Filter by categories',
    'sulu_admin.any_category_description' => 'Use elements that use any category',
    'sulu_admin.all_categories_description' => 'Use elements that use all categories',
    'sulu_admin.choose_categories' => 'Choose categories',
    'sulu_admin.filter_by_tags' => 'Filter by tags',
    'sulu_admin.any_tag_description' => 'Use elements that use any tag',
    'sulu_admin.all_tags_description' => 'Use elements that use all tags',
    'sulu_admin.filter_by_types' => 'Filter by types',
    'sulu_admin.all_types' => 'All types selected',
    'sulu_admin.no_types' => 'No types selected',
    'sulu_admin.target_groups' => 'Target groups',
    'sulu_admin.use_target_groups' => 'Use target groups',
    'sulu_admin.sort_by' => 'Sort by',
    'sulu_admin.ascending' => 'Ascending',
    'sulu_admin.descending' => 'Descending',
    'sulu_admin.present_as' => 'Present as',
    'sulu_admin.limit_result_to' => 'Limit result to',
    'sulu_admin.smart_content_label' => '{count} {count, plural, =1 {element} other {elements}} selected',
    'sulu_admin.smart_content_block_preview' => 'Smart Content {limit, select, undefined{} other{displaying up to {limit} elements}}',
    'sulu_admin.order_warning_title' => 'Rearrange items',
    'sulu_admin.order_warning_text' => 'The operation you are about to do will rearrange items.',
    'sulu_admin.activate_all' => 'Activate all',
    'sulu_admin.deactivate_all' => 'Deactivate all',
    'sulu_admin.all_selected' => 'All selected',
    'sulu_admin.none_selected' => 'None selected',
    'sulu_admin.please_choose' => 'Please choose',
    'sulu_admin.column_options' => 'Column options',
    'sulu_admin.changelog_line_changer' => 'Last change {changer, select, undefined{} other{from {changer}}} at {changed}',
    'sulu_admin.changelog_line_creator' => 'Created {creator, select, undefined{} other{by {creator}}} at {created}',
    'sulu_admin.settings' => 'Settings',
    'sulu_admin.move_selected' => 'Move selected',
    'sulu_admin.details' => 'Details',
    'sulu_admin.edit_entries' => 'Edit entries',
    'sulu_admin.paragraph' => 'Paragraph',
    'sulu_admin.heading1' => 'Heading 1',
    'sulu_admin.heading2' => 'Heading 2',
    'sulu_admin.heading3' => 'Heading 3',
    'sulu_admin.heading4' => 'Heading 4',
    'sulu_admin.heading5' => 'Heading 5',
    'sulu_admin.heading6' => 'Heading 6',
    'sulu_admin.dirty_warning_dialog_title' => 'Leave form?',
    'sulu_admin.dirty_warning_dialog_text' => 'Changes you made will not be saved.',
    'sulu_admin.export' => 'Export',
    'sulu_admin.export_overlay_title' => 'Configure data format',
    'sulu_admin.delimiter' => 'Delimiter',
    'sulu_admin.enclosure' => 'Enclosure',
    'sulu_admin.escape' => 'Escape',
    'sulu_admin.new_line' => 'New line',
    'sulu_admin.delimiter_description' => 'Character for column separation.',
    'sulu_admin.enclosure_description' => 'Enclose multiple word entries.',
    'sulu_admin.escape_description' => 'Add-on for special characters.',
    'sulu_admin.new_line_description' => 'Character for line brake.',
    'sulu_admin.delimiter_tab' => 'Tab',
    'sulu_admin.enclosure_nothing' => 'Nothing',
    'sulu_admin.link' => 'Link',
    'sulu_admin.link_title' => 'Alternative title',
    'sulu_admin.link_target' => 'Link Target',
    'sulu_admin.link_url' => 'Link URL',
    'sulu_admin.mail_subject' => 'E-Mail Subject',
    'sulu_admin.mail_body' => 'E-Mail Text',
    'sulu_admin.show_history' => 'Show history',
    'sulu_admin.history' => 'History',
    'sulu_admin.resource_locator_history_delete_warning' => 'The URL will be deleted for all draft and live versions. This cannot be undone. Do you wish to proceed?',
    'sulu_admin.has_changed_warning_dialog_title' => 'Content will be overwritten!',
    'sulu_admin.has_changed_warning_dialog_text' => 'This content has been edited by another user. When you save the content this data will get lost.',
    'sulu_admin.edit_profile' => 'Edit profile',
    'sulu_admin.no_permissions' => 'No permissions',
    'sulu_admin.no_options_available' => 'No options available',
    'sulu_admin.form_contains_invalid_values' => 'The form contains invalid values',
    'sulu_admin.form_save_server_error' => 'There was an error when trying to save the form',
    'sulu_admin.form_used_by' => 'This form is currently used by',
    'sulu_admin.refresh_url' => 'Refresh URL',
    'sulu_admin.from' => 'from',
    'sulu_admin.until' => 'until',
    'sulu_admin.external_link' => 'External Link',
    'sulu_admin.internal_link' => 'Internal Link',
    'sulu_admin.block_settings' => 'Block settings',
    'sulu_admin.hide_block' => 'Hide this block on website',
    'sulu_admin.segment' => 'Segment',
    'sulu_admin.missing_type_dialog_title' => 'Choose new template',
    'sulu_admin.missing_type_dialog_description' => 'The template for the copied page does not exist in this webspace.',
    'sulu_preview.auto' => 'Auto',
    'sulu_preview.desktop' => 'Desktop',
    'sulu_preview.tablet' => 'Tablet',
    'sulu_preview.smartphone' => 'Smartphone',
    'sulu_preview.reload' => 'Reload',
    'sulu_preview.open_in_window' => 'Open in window',
  ),
));
$catalogue->addFallbackCatalogue($catalogueEn);

return $catalogue;
