<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('fr', array (
  'validators' => 
  array (
    'This value should be false.' => 'Cette valeur doit être fausse.',
    'This value should be true.' => 'Cette valeur doit être vraie.',
    'This value should be of type {{ type }}.' => 'Cette valeur doit être de type {{ type }}.',
    'This value should be blank.' => 'Cette valeur doit être vide.',
    'The value you selected is not a valid choice.' => 'Cette valeur doit être l\'un des choix proposés.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'Vous devez sélectionner au moins {{ limit }} choix.|Vous devez sélectionner au moins {{ limit }} choix.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'Vous devez sélectionner au maximum {{ limit }} choix.|Vous devez sélectionner au maximum {{ limit }} choix.',
    'One or more of the given values is invalid.' => 'Une ou plusieurs des valeurs soumises sont invalides.',
    'This field was not expected.' => 'Ce champ n\'a pas été prévu.',
    'This field is missing.' => 'Ce champ est manquant.',
    'This value is not a valid date.' => 'Cette valeur n\'est pas une date valide.',
    'This value is not a valid datetime.' => 'Cette valeur n\'est pas une date valide.',
    'This value is not a valid email address.' => 'Cette valeur n\'est pas une adresse email valide.',
    'The file could not be found.' => 'Le fichier n\'a pas été trouvé.',
    'The file is not readable.' => 'Le fichier n\'est pas lisible.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'Le fichier est trop volumineux ({{ size }} {{ suffix }}). Sa taille ne doit pas dépasser {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'Le type du fichier est invalide ({{ type }}). Les types autorisés sont {{ types }}.',
    'This value should be {{ limit }} or less.' => 'Cette valeur doit être inférieure ou égale à {{ limit }}.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'Cette chaîne est trop longue. Elle doit avoir au maximum {{ limit }} caractère.|Cette chaîne est trop longue. Elle doit avoir au maximum {{ limit }} caractères.',
    'This value should be {{ limit }} or more.' => 'Cette valeur doit être supérieure ou égale à {{ limit }}.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'Cette chaîne est trop courte. Elle doit avoir au minimum {{ limit }} caractère.|Cette chaîne est trop courte. Elle doit avoir au minimum {{ limit }} caractères.',
    'This value should not be blank.' => 'Cette valeur ne doit pas être vide.',
    'This value should not be null.' => 'Cette valeur ne doit pas être nulle.',
    'This value should be null.' => 'Cette valeur doit être nulle.',
    'This value is not valid.' => 'Cette valeur n\'est pas valide.',
    'This value is not a valid time.' => 'Cette valeur n\'est pas une heure valide.',
    'This value is not a valid URL.' => 'Cette valeur n\'est pas une URL valide.',
    'The two values should be equal.' => 'Les deux valeurs doivent être identiques.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'Le fichier est trop volumineux. Sa taille ne doit pas dépasser {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'Le fichier est trop volumineux.',
    'The file could not be uploaded.' => 'Le téléchargement de ce fichier est impossible.',
    'This value should be a valid number.' => 'Cette valeur doit être un nombre.',
    'This file is not a valid image.' => 'Ce fichier n\'est pas une image valide.',
    'This is not a valid IP address.' => 'Cette adresse IP n\'est pas valide.',
    'This value is not a valid language.' => 'Cette langue n\'est pas valide.',
    'This value is not a valid locale.' => 'Ce paramètre régional n\'est pas valide.',
    'This value is not a valid country.' => 'Ce pays n\'est pas valide.',
    'This value is already used.' => 'Cette valeur est déjà utilisée.',
    'The size of the image could not be detected.' => 'La taille de l\'image n\'a pas pu être détectée.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'La largeur de l\'image est trop grande ({{ width }}px). La largeur maximale autorisée est de {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'La largeur de l\'image est trop petite ({{ width }}px). La largeur minimale attendue est de {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'La hauteur de l\'image est trop grande ({{ height }}px). La hauteur maximale autorisée est de {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'La hauteur de l\'image est trop petite ({{ height }}px). La hauteur minimale attendue est de {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'Cette valeur doit être le mot de passe actuel de l\'utilisateur.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'Cette chaîne doit avoir exactement {{ limit }} caractère.|Cette chaîne doit avoir exactement {{ limit }} caractères.',
    'The file was only partially uploaded.' => 'Le fichier a été partiellement transféré.',
    'No file was uploaded.' => 'Aucun fichier n\'a été transféré.',
    'No temporary folder was configured in php.ini.' => 'Aucun répertoire temporaire n\'a été configuré dans le php.ini.',
    'Cannot write temporary file to disk.' => 'Impossible d\'écrire le fichier temporaire sur le disque.',
    'A PHP extension caused the upload to fail.' => 'Une extension PHP a empêché le transfert du fichier.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'Cette collection doit contenir {{ limit }} élément ou plus.|Cette collection doit contenir {{ limit }} éléments ou plus.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'Cette collection doit contenir {{ limit }} élément ou moins.|Cette collection doit contenir {{ limit }} éléments ou moins.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'Cette collection doit contenir exactement {{ limit }} élément.|Cette collection doit contenir exactement {{ limit }} éléments.',
    'Invalid card number.' => 'Numéro de carte invalide.',
    'Unsupported card type or invalid card number.' => 'Type de carte non supporté ou numéro invalide.',
    'This is not a valid International Bank Account Number (IBAN).' => 'Le numéro IBAN (International Bank Account Number) saisi n\'est pas valide.',
    'This value is not a valid ISBN-10.' => 'Cette valeur n\'est pas un code ISBN-10 valide.',
    'This value is not a valid ISBN-13.' => 'Cette valeur n\'est pas un code ISBN-13 valide.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'Cette valeur n\'est ni un code ISBN-10, ni un code ISBN-13 valide.',
    'This value is not a valid ISSN.' => 'Cette valeur n\'est pas un code ISSN valide.',
    'This value is not a valid currency.' => 'Cette valeur n\'est pas une devise valide.',
    'This value should be equal to {{ compared_value }}.' => 'Cette valeur doit être égale à {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'Cette valeur doit être supérieure à {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'Cette valeur doit être supérieure ou égale à {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Cette valeur doit être identique à {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'Cette valeur doit être inférieure à {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'Cette valeur doit être inférieure ou égale à {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'Cette valeur ne doit pas être égale à {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Cette valeur ne doit pas être identique à {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'Le rapport largeur/hauteur de l\'image est trop grand ({{ ratio }}). Le rapport maximal autorisé est {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'Le rapport largeur/hauteur de l\'image est trop petit ({{ ratio }}). Le rapport minimal attendu est {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'L\'image est carrée ({{ width }}x{{ height }}px). Les images carrées ne sont pas autorisées.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'L\'image est au format paysage ({{ width }}x{{ height }}px). Les images au format paysage ne sont pas autorisées.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'L\'image est au format portrait ({{ width }}x{{ height }}px). Les images au format portrait ne sont pas autorisées.',
    'An empty file is not allowed.' => 'Un fichier vide n\'est pas autorisé.',
    'The host could not be resolved.' => 'Le nom de domaine n\'a pas pu être résolu.',
    'This value does not match the expected {{ charset }} charset.' => 'Cette valeur ne correspond pas au jeu de caractères {{ charset }} attendu.',
    'This is not a valid Business Identifier Code (BIC).' => 'Ce n\'est pas un code universel d\'identification des banques (BIC) valide.',
    'Error' => 'Erreur',
    'This is not a valid UUID.' => 'Ceci n\'est pas un UUID valide.',
    'This value should be a multiple of {{ compared_value }}.' => 'Cette valeur doit être un multiple de {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'Ce code d\'identification d\'entreprise (BIC) n\'est pas associé à l\'IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'Cette valeur doit être un JSON valide.',
    'This collection should contain only unique elements.' => 'Cette collection ne doit pas comporter de doublons.',
    'This value should be positive.' => 'Cette valeur doit être strictement positive.',
    'This value should be either positive or zero.' => 'Cette valeur doit être supérieure ou égale à zéro.',
    'This value should be negative.' => 'Cette valeur doit être strictement négative.',
    'This value should be either negative or zero.' => 'Cette valeur doit être inférieure ou égale à zéro.',
    'This value is not a valid timezone.' => 'Cette valeur n\'est pas un fuseau horaire valide.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'Ce mot de passe a été divulgué lors d\'une fuite de données, il ne doit plus être utilisé. Veuillez utiliser un autre mot de passe.',
    'This value should be between {{ min }} and {{ max }}.' => 'Cette valeur doit être comprise entre {{ min }} et {{ max }}.',
    'This value is not a valid hostname.' => 'Cette valeur n\'est pas un nom d\'hôte valide.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'Le nombre d\'éléments de cette collection doit être un multiple de {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'Cette valeur doit satisfaire à au moins une des contraintes suivantes :',
    'Each element of this collection should satisfy its own set of constraints.' => 'Chaque élément de cette collection doit satisfaire à son propre jeu de contraintes.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'Cette valeur n\'est pas un code international de sécurité valide (ISIN).',
    'This form should not contain extra fields.' => 'Ce formulaire ne doit pas contenir des champs supplémentaires.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'Le fichier téléchargé est trop volumineux. Merci d\'essayer d\'envoyer un fichier plus petit.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'Le jeton CSRF est invalide. Veuillez renvoyer le formulaire.',
    'This value is not a valid HTML5 color.' => 'Cette valeur n\'est pas une couleur HTML5 valide.',
    'Please enter a valid birthdate.' => 'Veuillez entrer une date de naissance valide.',
    'The selected choice is invalid.' => 'Le choix sélectionné est invalide.',
    'The collection is invalid.' => 'La collection est invalide.',
    'Please select a valid color.' => 'Veuillez sélectionner une couleur valide.',
    'Please select a valid country.' => 'Veuillez sélectionner un pays valide.',
    'Please select a valid currency.' => 'Veuillez sélectionner une devise valide.',
    'Please choose a valid date interval.' => 'Veuillez choisir un intervalle de dates valide.',
    'Please enter a valid date and time.' => 'Veuillez saisir une date et une heure valides.',
    'Please enter a valid date.' => 'Veuillez entrer une date valide.',
    'Please select a valid file.' => 'Veuillez sélectionner un fichier valide.',
    'The hidden field is invalid.' => 'Le champ masqué n\'est pas valide.',
    'Please enter an integer.' => 'Veuillez saisir un entier.',
    'Please select a valid language.' => 'Veuillez sélectionner une langue valide.',
    'Please select a valid locale.' => 'Veuillez sélectionner une langue valide.',
    'Please enter a valid money amount.' => 'Veuillez saisir un montant valide.',
    'Please enter a number.' => 'Veuillez saisir un nombre.',
    'The password is invalid.' => 'Le mot de passe est invalide.',
    'Please enter a percentage value.' => 'Veuillez saisir un pourcentage valide.',
    'The values do not match.' => 'Les valeurs ne correspondent pas.',
    'Please enter a valid time.' => 'Veuillez saisir une heure valide.',
    'Please select a valid timezone.' => 'Veuillez sélectionner un fuseau horaire valide.',
    'Please enter a valid URL.' => 'Veuillez saisir une URL valide.',
    'Please enter a valid search term.' => 'Veuillez saisir un terme de recherche valide.',
    'Please provide a valid phone number.' => 'Veuillez fournir un numéro de téléphone valide.',
    'The checkbox has an invalid value.' => 'La case à cocher a une valeur non valide.',
    'Please enter a valid email address.' => 'Veuillez saisir une adresse email valide.',
    'Please select a valid option.' => 'Veuillez sélectionner une option valide.',
    'Please select a valid range.' => 'Veuillez sélectionner une plage valide.',
    'Please enter a valid week.' => 'Veuillez entrer une semaine valide.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'Une exception d\'authentification s\'est produite.',
    'Authentication credentials could not be found.' => 'Les identifiants d\'authentification n\'ont pas pu être trouvés.',
    'Authentication request could not be processed due to a system problem.' => 'La requête d\'authentification n\'a pas pu être executée à cause d\'un problème système.',
    'Invalid credentials.' => 'Identifiants invalides.',
    'Cookie has already been used by someone else.' => 'Le cookie a déjà été utilisé par quelqu\'un d\'autre.',
    'Not privileged to request the resource.' => 'Privilèges insuffisants pour accéder à la ressource.',
    'Invalid CSRF token.' => 'Jeton CSRF invalide.',
    'No authentication provider found to support the authentication token.' => 'Aucun fournisseur d\'authentification n\'a été trouvé pour supporter le jeton d\'authentification.',
    'No session available, it either timed out or cookies are not enabled.' => 'Aucune session disponible, celle-ci a expiré ou les cookies ne sont pas activés.',
    'No token could be found.' => 'Aucun jeton n\'a pu être trouvé.',
    'Username could not be found.' => 'Le nom d\'utilisateur n\'a pas pu être trouvé.',
    'Account has expired.' => 'Le compte a expiré.',
    'Credentials have expired.' => 'Les identifiants ont expiré.',
    'Account is disabled.' => 'Le compte est désactivé.',
    'Account is locked.' => 'Le compte est bloqué.',
    'Too many failed login attempts, please try again later.' => 'Plusieurs tentatives de connexion ont échoué, veuillez réessayer plus tard.',
    'Invalid or expired login link.' => 'Lien de connexion invalide ou expiré.',
  ),
  'admin' => 
  array (
    'sulu_admin.add' => 'Ajouter',
    'sulu_admin.add_block' => 'Ajouter un bloc',
    'sulu_admin.delete' => 'Supprimer',
    'sulu_admin.move' => 'Déplacer',
    'sulu_admin.move_items' => 'Déplacer les éléments',
    'sulu_admin.copy' => 'Copier',
    'sulu_admin.order' => 'Trier',
    'sulu_admin.of' => 'de',
    'sulu_admin.page' => 'Page',
    'sulu_admin.per_page' => 'Éléments par page',
    'sulu_admin.save' => 'Enregistrer',
    'sulu_admin.save_draft' => 'Enregistrer comme brouillon',
    'sulu_admin.save_publish' => 'Enregistrer et publier',
    'sulu_admin.publish' => 'Publier',
    'sulu_admin.create' => 'Créer',
    'sulu_admin.edit' => 'Modifier',
    'sulu_admin.object' => 'Objet',
    'sulu_admin.objects' => 'Objets',
    'sulu_admin.reached_end_of_list' => 'Vous êtes arrivé à la fin de la liste',
    'sulu_admin.confirm' => 'Confirmez',
    'sulu_admin.ok' => 'Ok',
    'sulu_admin.cancel' => 'Annuler',
    'sulu_admin.apply' => 'Appliquer',
    'sulu_admin.yes' => 'Oui',
    'sulu_admin.no' => 'Non',
    'sulu_admin.type' => 'Type',
    'sulu_admin.default' => 'Par défaut',
    'sulu_admin.error_required' => 'Ce champ doit avoir une valeur',
    'sulu_admin.error_minlength' => 'La longueur minimale de ce champ n\'est pas atteinte',
    'sulu_admin.error_minitems' => 'Ce champ n\'as pas suffisamment de sélections',
    'sulu_admin.welcome' => 'Bienvenue',
    'sulu_admin.reset_password' => 'Réinitialiser le mot de passe',
    'sulu_admin.reset_password_error' => 'Les mots de passe ne correspondent pas',
    'sulu_admin.back_to_website' => 'Retour au site web',
    'sulu_admin.username_or_email' => 'Nom d\'utilisateur ou email',
    'sulu_admin.password' => 'Mot de passe',
    'sulu_admin.repeat_password' => 'Répéter le mot de passe',
    'sulu_admin.login' => 'Se connecter',
    'sulu_admin.login_error' => 'Cette combinaison e-mail/mot de passe est incorrecte. Veuillez réessayer.',
    'sulu_admin.to_login' => 'Retour à la connexion',
    'sulu_admin.reset' => 'Réinitialiser',
    'sulu_admin.reset_resend' => 'Renvoyer',
    'sulu_admin.forgot_password' => 'Mot de passe oublié',
    'sulu_admin.forgot_password_success' => 'Un email contenant les instructions pour réinitialiser votre mot de passe a été envoyé si un utilisateur a été trouvé',
    'sulu_admin.list_search_placeholder' => 'Rechercher…',
    'sulu_admin.error' => 'Erreur',
    'sulu_admin.warning' => 'Avertissement',
    'sulu_admin.close' => 'Fermer',
    'sulu_admin.id' => 'ID',
    'sulu_admin.key' => 'Clé',
    'sulu_admin.title' => 'Titre',
    'sulu_admin.name' => 'Nom',
    'sulu_admin.description' => 'Description',
    'sulu_admin.url' => 'URL',
    'sulu_admin.creator' => 'Auteur',
    'sulu_admin.created' => 'Créé le',
    'sulu_admin.changer' => 'Changeur',
    'sulu_admin.changed' => 'Modifié le',
    'sulu_admin.published' => 'Publié le',
    'sulu_admin.authored' => 'Créé le',
    'sulu_admin.author' => 'Auteur',
    'sulu_admin.delete_warning_title' => 'Supprimer?',
    'sulu_admin.delete_warning_text' => 'Cette opération supprime un média et ne peut pas être annulée. Voulez-vous vraiment continuer ?',
    'sulu_admin.delete_linked_warning_title' => 'Confirmer la suppression',
    'sulu_admin.delete_linked_warning_text' => 'Cet élément est référencé par les éléments suivants, êtes-vous sûr de vouloir le supprimer ?',
    'sulu_admin.delete_selection_warning_text' => 'Cette opération supprime {count} {count, plural, =1 {élément} other {éléments}} et ne peut pas être annulée. Voulez-vous vraiment continuer ?',
    'sulu_admin.item_not_deletable' => 'L\'élément ne peut pas être supprimé',
    'sulu_admin.delete_linked_abort_text' => 'Cet élément ne peut pas être supprimé tant qu\'il contient des sous-éléments. Supprimez les sous-éléments suivants ou supprimez la relation :',
    'sulu_admin.ghost_dialog_title' => 'Copier la langue ?',
    'sulu_admin.ghost_dialog_description' => 'Cette page n\'existe pas dans cette langue. Voulez-vous copier le contenu d\'une autre langue ?',
    'sulu_admin.choose_language' => 'Choisir la langue',
    'sulu_admin.characters_left' => 'caractères restants',
    'sulu_admin.segments_left' => 'segments restants',
    'sulu_admin.copy_locale' => 'Copier la langue',
    'sulu_admin.choose_target_locale' => 'Choisir la langue cible',
    'sulu_admin.copy_locale_dialog_description' => '* Une nouvelle langue sera créée',
    'sulu_admin.move_copy_overlay_title' => 'Choisir la page parente',
    'sulu_admin.filter_overlay_title' => 'Configurer {fieldLabel}',
    'sulu_admin.data_source' => 'Sélectionner la source',
    'sulu_admin.choose_data_source' => 'Choisir la source',
    'sulu_admin.include_sub_elements' => 'Inclure les sous-éléments',
    'sulu_admin.filter_by_categories' => 'Filtrer par catégories',
    'sulu_admin.any_category_description' => 'Utiliser des éléments qui utilisent n\'importe quelle catégorie',
    'sulu_admin.all_categories_description' => 'Utiliser des éléments qui utilisent toutes les catégories',
    'sulu_admin.choose_categories' => 'Choisir les catégories',
    'sulu_admin.filter_by_tags' => 'Filtrer par étiquettes',
    'sulu_admin.any_tag_description' => 'Utiliser des éléments qui utilisent n\'importe quel étiquette',
    'sulu_admin.all_tags_description' => 'Utiliser des éléments qui utilisent toutes les étiquettes',
    'sulu_admin.filter_by_types' => 'Filtrer par types',
    'sulu_admin.all_types' => 'Tous les types sélectionnés',
    'sulu_admin.no_types' => 'Aucun type sélectionné',
    'sulu_admin.target_groups' => 'Groupes cibles',
    'sulu_admin.use_target_groups' => 'Utiliser les groupes cibles',
    'sulu_admin.sort_by' => 'Trier par',
    'sulu_admin.ascending' => 'Ascendant',
    'sulu_admin.descending' => 'Descendant',
    'sulu_admin.present_as' => 'Présenter en tant que',
    'sulu_admin.limit_result_to' => 'Limiter le résultat à',
    'sulu_admin.smart_content_label' => '{count} {count, plural, zero {} =1 {élément sélectionné} other {éléments sélectionnés}}',
    'sulu_admin.smart_content_block_preview' => 'Smart Content {limit, select, undefined{} other{afficher jusqu\'à {limit} éléments}}',
    'sulu_admin.order_warning_title' => 'Réorganiser les éléments',
    'sulu_admin.order_warning_text' => 'L\'opération que vous êtes sur le point de faire réarrangera les éléments.',
    'sulu_admin.activate_all' => 'Tout activer',
    'sulu_admin.deactivate_all' => 'Tout désactiver',
    'sulu_admin.all_selected' => 'Tous les éléments sélectionnés',
    'sulu_admin.none_selected' => 'Aucune sélection',
    'sulu_admin.please_choose' => 'Veuillez choisir',
    'sulu_admin.column_options' => 'Options des colonnes',
    'sulu_admin.changelog_line_changer' => 'Dernière modification {changer, select, undefined{} other{par {changer}}} le {changed}',
    'sulu_admin.changelog_line_creator' => 'Créé {creator, select, undefined{} other{par {creator}}} le {created}',
    'sulu_admin.settings' => 'Réglages',
    'sulu_admin.move_selected' => 'Déplacer la sélection',
    'sulu_admin.details' => 'Détails',
    'sulu_admin.edit_entries' => 'Modifier les entrées',
    'sulu_admin.paragraph' => 'Paragraphe',
    'sulu_admin.heading1' => 'Titre 1',
    'sulu_admin.heading2' => 'Titre 2',
    'sulu_admin.heading3' => 'Titre 3',
    'sulu_admin.heading4' => 'Titre 4',
    'sulu_admin.heading5' => 'Titre 5',
    'sulu_admin.heading6' => 'Titre 6',
    'sulu_admin.dirty_warning_dialog_title' => 'Quitter le formulaire ?',
    'sulu_admin.dirty_warning_dialog_text' => 'Les modifications que vous avez apportées ne seront pas enregistrées.',
    'sulu_admin.export' => 'Exporter',
    'sulu_admin.export_overlay_title' => 'Configurer le format des données',
    'sulu_admin.delimiter' => 'Délimiteur',
    'sulu_admin.enclosure' => 'Caractère d\'encadrement',
    'sulu_admin.escape' => 'Échapper',
    'sulu_admin.new_line' => 'Nouvelle ligne',
    'sulu_admin.delimiter_description' => 'Caractère pour la séparation des colonnes.',
    'sulu_admin.enclosure_description' => 'Encadrez les mots.',
    'sulu_admin.escape_description' => 'Add-on pour caractères spéciaux.',
    'sulu_admin.new_line_description' => 'Caractère de retour à la ligne.',
    'sulu_admin.delimiter_tab' => 'Onglet',
    'sulu_admin.enclosure_nothing' => 'Rien',
    'sulu_admin.link' => 'Lien',
    'sulu_admin.link_title' => 'Titre alternatif',
    'sulu_admin.link_target' => 'Cible du lien',
    'sulu_admin.link_url' => 'URL du lien',
    'sulu_admin.mail_subject' => 'Sujet de l\'e-mail',
    'sulu_admin.mail_body' => 'Texte de l\'e-mail',
    'sulu_admin.show_history' => 'Afficher l\'historique',
    'sulu_admin.history' => 'Historique',
    'sulu_admin.resource_locator_history_delete_warning' => 'L\'URL sera supprimée pour toutes les versions brouillons et publiées. Cette opération ne peut pas être annulée. Voulez-vous continuer ?',
    'sulu_admin.has_changed_warning_dialog_title' => 'Le contenu sera écrasé !',
    'sulu_admin.has_changed_warning_dialog_text' => 'Ce contenu a été modifier par un autre utilisateur. Lorsque vous enregistrez le contenu, ces modifications seront perdues.',
    'sulu_admin.edit_profile' => 'Modifier le profil',
    'sulu_admin.no_permissions' => 'Aucune permission',
    'sulu_admin.no_options_available' => 'Aucune option disponible',
    'sulu_admin.form_contains_invalid_values' => 'Le formulaire contient des valeurs non valides',
    'sulu_admin.form_save_server_error' => 'Une erreur s\'est produite lors de l\'enregistrement du formulaire',
    'sulu_admin.form_used_by' => 'Ce formulaire est actuellement utilisé par',
    'sulu_admin.refresh_url' => 'Rafraichir l\'URL',
    'sulu_admin.from' => 'de',
    'sulu_admin.until' => 'jusqu\'à',
    'sulu_admin.external_link' => 'Lien externe',
    'sulu_admin.internal_link' => 'Lien interne',
    'sulu_admin.block_settings' => 'Réglage du bloc',
    'sulu_admin.hide_block' => 'Masquer ce bloc sur le site',
    'sulu_admin.segment' => 'Segment',
    'sulu_admin.missing_type_dialog_title' => 'Choisir un nouveau modèle',
    'sulu_admin.missing_type_dialog_description' => 'Le modèle de la page copiée n\'existe pas dans cet espace web.',
    'sulu_audience_targeting.target_groups' => 'Groupes cibles',
    'sulu_audience_targeting.no_target_group' => 'Pas de groupe cible',
    'sulu_audience_targeting.active' => 'Actif',
    'sulu_audience_targeting.priority' => 'Priorité',
    'sulu_audience_targeting.rules' => 'Règles',
    'sulu_audience_targeting.rules_info_text' => 'Les visiteurs correspondant à UNE de ces règles seront ajoutés au groupe cible.',
    'sulu_audience_targeting.assigned_at' => 'Attribué à',
    'sulu_audience_targeting.conditions' => 'Conditions',
    'sulu_audience_targeting.configure_rule' => 'Configurer la règle',
    'sulu_audience_targeting.each_page_visit' => 'chaque visite de page',
    'sulu_audience_targeting.each_session' => 'chaque session',
    'sulu_audience_targeting.first_visit' => 'première visite',
    'sulu_audience_targeting.conditions_info_text' => 'Les visiteurs correspondant à TOUTES ces conditions seront ajoutés au groupe cible.',
    'sulu_audience_targeting.add_condition' => 'Ajouter une condition',
    'sulu_audience_targeting.locale' => 'Langue',
    'sulu_audience_targeting.referrer' => 'Referrer',
    'sulu_audience_targeting.query_string' => 'Query String',
    'sulu_audience_targeting.browser' => 'Navigateur',
    'sulu_audience_targeting.operating_system' => 'Système d\'exploitation',
    'sulu_audience_targeting.device_type' => 'Type de périphérique',
    'sulu_audience_targeting.query_string_parameter' => 'Paramètre',
    'sulu_audience_targeting.query_string_value' => 'Valeur',
    'sulu_audience_targeting.smartphone' => 'Téléphone',
    'sulu_audience_targeting.tablet' => 'Tablette',
    'sulu_audience_targeting.desktop' => 'Ordinateur',
    'sulu_category.categories' => 'Catégories',
    'sulu_category.key' => 'Clé',
    'sulu_category.name' => 'Nom',
    'sulu_category.keywords' => 'Mots clés',
    'sulu_category.keyword' => 'Mot clé',
    'sulu_category.multiple_usage' => 'Usage multiple',
    'sulu_category.all_categories' => 'Toutes les catégories',
    'sulu_category.no_category_selected' => 'Aucune catégorie sélectionnée',
    'sulu_category.single_category_selection_overlay_title' => 'Choisir une catégorie',
    'sulu_contact.contacts' => 'Contacts',
    'sulu_contact.organizations' => 'Sociétés',
    'sulu_contact.organization' => 'Société',
    'sulu_contact.people' => 'Personnes',
    'sulu_contact.contact_selection_overlay_title' => 'Choisissez un contact',
    'sulu_contact.account_selection_overlay_title' => 'Choisissez un compte',
    'sulu_contact.contact_selection_label' => '{count} {count, plural, =1 {contact} other {contacts}} sélectionnés',
    'sulu_contact.account_selection_label' => '{count} {count, plural, zero {} =1 {élément sélectionné} other {éléments sélectionnés}}',
    'sulu_contact.contact_account_selection_label' => '{count} {count, plural, =1 {contact} other {contacts}} sélectionnés',
    'sulu_contact.avatar' => 'Avatar',
    'sulu_contact.logo' => 'Logo',
    'sulu_contact.name' => 'Nom',
    'sulu_contact.first_name' => 'Prénom',
    'sulu_contact.last_name' => 'Nom de famille',
    'sulu_contact.contact_details' => 'Informations du contact',
    'sulu_contact.addresses' => 'Adresses',
    'sulu_contact.bank_accounts' => 'Comptes bancaires',
    'sulu_contact.email' => 'E-mail',
    'sulu_contact.primary_address' => 'Adresse principale',
    'sulu_contact.delivery_address' => 'Adresse de livraison',
    'sulu_contact.billing_address' => 'Adresse de facturation',
    'sulu_contact.city' => 'Ville',
    'sulu_contact.zip' => 'Code postal',
    'sulu_contact.street' => 'Rue',
    'sulu_contact.number' => 'Numéro',
    'sulu_contact.address_line' => 'Ligne d\'adresse',
    'sulu_contact.state' => 'Région',
    'sulu_contact.country' => 'Pays',
    'sulu_contact.postbox_number' => 'Case postale',
    'sulu_contact.postbox_zip' => 'Code postal de la case postale',
    'sulu_contact.postbox_city' => 'Ville de la case postale',
    'sulu_contact.phone' => 'Téléphone',
    'sulu_contact.fax' => 'Fax',
    'sulu_contact.website' => 'Site Web',
    'sulu_contact.social_media' => 'Réseaux sociaux',
    'sulu_contact.birthday' => 'Anniversaire',
    'sulu_contact.title' => 'Titre',
    'sulu_contact.salutation' => 'Civilité',
    'sulu_contact.form_of_address' => 'Titre de civilité',
    'sulu_contact.male_form_of_address' => 'M.',
    'sulu_contact.female_form_of_address' => 'Mme',
    'sulu_contact.position' => 'Poste',
    'sulu_contact.corporation' => 'Entreprise',
    'sulu_contact.main_contact' => 'Contact principal',
    'sulu_contact.uid' => 'UID',
    'sulu_contact.register_number' => 'Numéro de registre',
    'sulu_contact.jurisdiction' => 'Juridiction',
    'sulu_contact.note' => 'Note',
    'sulu_contact.parent_company' => 'Société mère',
    'sulu_contact.upload_avatar_info_text' => 'Déposez l\'image ou cliquez pour changer d\'avatar',
    'sulu_contact.upload_logo_info_text' => 'Déposez l\'image ou cliquez pour changer le logo',
    'sulu_contact.no_contact_selected' => 'Aucun contact sélectionné',
    'sulu_contact.single_contact_selection_overlay_title' => 'Choisissez un contact',
    'sulu_contact.no_account_selected' => 'Aucun compte sélectionné',
    'sulu_contact.single_account_selection_overlay_title' => 'Choisissez un compte',
    'sulu_contact.taxonomies' => 'Catégorisation',
    'sulu_contact.add_address' => 'Ajouter une adresse',
    'sulu_contact.edit_address' => 'Modifier l\'adresse',
    'sulu_contact.add_bank_account' => 'Ajouter un compte bancaire',
    'sulu_contact.edit_bank_account' => 'Modifier le compte bancaire',
    'sulu_contact.work' => 'Travail',
    'sulu_contact.private' => 'Privé',
    'sulu_contact.mobile' => 'Téléphone mobile',
    'sulu_contact.bank' => 'Banque',
    'sulu_contact.iban' => 'IBAN',
    'sulu_contact.bic' => 'BIC',
    'sulu_contact.edit_title_overlay_title' => 'Modifier les titres',
    'sulu_contact.edit_position_overlay_title' => 'Modifier les postes',
    'sulu_contact.documents' => 'Documents',
    'sulu_contact.delete_media_warning_title' => 'Supprimer l\'attribution du document ?',
    'sulu_contact.delete_media_warning_text' => 'Cette opération supprime les attributions de documents sélectionnées. Le document lui-même ne sera pas supprimé. Voulez-vous vraiment continuer ?',
    'sulu_contact.add_contact_to_organization' => 'Ajouter un contact à l\'organisation',
    'sulu_contact.latitude' => 'Latitude',
    'sulu_contact.longitude' => 'Longitude',
    'sulu_custom_url.custom_urls' => 'URLs personnalisées',
    'sulu_custom_url.custom_url' => 'URL personnalisée',
    'sulu_custom_url.published' => 'Publié',
    'sulu_custom_url.base_domain' => 'Domaine de base',
    'sulu_custom_url.target_page' => 'Page cible',
    'sulu_custom_url.target_locale' => 'Traduction',
    'sulu_custom_url.redirect' => 'Rediriger',
    'sulu_custom_url.redirect_info' => 'L\'URL personnalisée sera redirigée vers l\'URL de la page liée.',
    'sulu_custom_url.canonical' => 'URL canonique',
    'sulu_custom_url.canonical_info' => 'Lorsque l\'URL canonique a été activée, seule la page liée sera indexée par les moteurs de recherche',
    'sulu_custom_url.no_index' => 'Pas d\'index',
    'sulu_custom_url.no_index_info' => 'La page ne sera pas indexée par les moteurs de recherche.',
    'sulu_custom_url.no_follow' => 'Ne pas suivre',
    'sulu_custom_url.no_follow_info' => 'Les liens sur la page ne seront pas consultés par les moteurs de recherche.',
    'sulu_custom_url.target_title' => 'Page cible',
    'sulu_location.latitude' => 'Latitude',
    'sulu_location.longitude' => 'Longitude',
    'sulu_location.zoom' => 'Zoom',
    'sulu_location.select_location' => 'Sélectionnez un lieu',
    'sulu_location.additional_information' => 'Informations supplémentaires',
    'sulu_location.title' => 'Titre',
    'sulu_location.street' => 'Rue',
    'sulu_location.number' => 'Numéro',
    'sulu_location.code' => 'Code postal',
    'sulu_location.town' => 'Ville',
    'sulu_location.country' => 'Pays',
    'sulu_media.media' => 'Média',
    'sulu_media.all_media' => 'Tous les médias',
    'sulu_media.audio' => 'Audio',
    'sulu_media.document' => 'Document',
    'sulu_media.image' => 'Image',
    'sulu_media.video' => 'Vidéo',
    'sulu_media.copy_url' => 'Copier l\'URL',
    'sulu_media.download_masterfile' => 'Télécharger le fichier maître',
    'sulu_media.select_media_singular' => 'Sélectionner un média',
    'sulu_media.select_media_plural' => 'Sélectionner un média',
    'sulu_media.reset_selection' => 'Réinitialiser la sélection',
    'sulu_media.copy_masterfile_url' => 'Copier l\'URL du fichier maître',
    'sulu_media.copy_masterfile_url_website' => 'Copier l\'URL du fichier maître (site web)',
    'sulu_media.information_taxonomy' => 'Informations et catégories',
    'sulu_media.upload' => 'Télécharger',
    'sulu_media.upload_new_version' => 'Télécharger une nouvelle version',
    'sulu_media.media_selected_singular' => 'élément média sélectionné',
    'sulu_media.media_selected_plural' => 'éléments médias sélectionnés',
    'sulu_media.drop_files_to_upload' => 'Télécharger des fichiers par glisser-déposer',
    'sulu_media.click_here_to_upload' => 'ou cliquez ici pour télécharger des fichiers',
    'sulu_media.add_collection' => 'Ajouter une collection',
    'sulu_media.remove_collection' => 'Supprimer la collection',
    'sulu_media.remove_collection_warning' => 'Cette opération supprime une collection et ne peut pas être annulée. Voulez-vous vraiment continuer?',
    'sulu_media.move_collection' => 'Déplacer la collection',
    'sulu_media.edit_collection' => 'Modifier la collection',
    'sulu_media.download_media' => 'Télécharger le média',
    'sulu_media.download_counter' => 'Nombre de téléchargements',
    'sulu_media.delete_media' => 'Supprimer le média',
    'sulu_media.delete_media_warning_title' => 'Supprimer le média',
    'sulu_media.delete_media_warning_text' => 'Cette opération supprime un média et ne peut pas être annulée. Voulez-vous vraiment continuer ?',
    'sulu_media.delete_preview_image_warning_title' => 'Supprimer l\'image de prévisualisation',
    'sulu_media.delete_preview_image_warning_text' => 'Cette opération supprime l\'image de prévisualisation et ne peut pas être annulée. Voulez-vous vraiment continuer ?',
    'sulu_media.thumbnail' => 'Vignette',
    'sulu_media.type' => 'Type',
    'sulu_media.version' => 'Version',
    'sulu_media.size' => 'Taille du fichier',
    'sulu_media.mime_type' => 'Type MIME',
    'sulu_media.license' => 'Licence',
    'sulu_media.copyright' => 'Informations sur les droits d\'auteur',
    'sulu_media.credits' => 'Crédits',
    'sulu_media.taxonomies' => 'Catégorisation',
    'sulu_media.history' => 'Historique',
    'sulu_media.formats' => 'Formats',
    'sulu_media.all_collections' => 'Toutes les collections',
    'sulu_media.move_media' => 'Déplacer le média',
    'sulu_media.upload_server_error' => 'Il y a eu une erreur lors du téléchargement d\'un ou de plusieurs fichiers sur le serveur.',
    'sulu_media.set_focus_point' => 'Définir la mise au point',
    'sulu_media.define_crops' => 'Définir le recadrage',
    'sulu_media.upload_preview_image' => 'Télécharger l\'image de prévisualisation',
    'sulu_media.delete_preview_image' => 'Supprimer l\'image de prévisualisation',
    'sulu_media.cropped' => 'Recadré',
    'sulu_media.double_click_crop_and_maximize' => 'Un double-clic maximise et centre la zone',
    'sulu_media.min_size_notification' => 'Taille minimale atteinte',
    'sulu_media.left_top' => 'Haut gauche',
    'sulu_media.top' => 'Haut',
    'sulu_media.right_top' => 'Haut-droit',
    'sulu_media.left' => 'Gauche',
    'sulu_media.middle' => 'Milieu',
    'sulu_media.right' => 'Droite',
    'sulu_media.left_bottom' => 'Bas gauche',
    'sulu_media.bottom' => 'Bas',
    'sulu_media.right_bottom' => 'Bas droite',
    'sulu_media.hotspots' => 'Point d\'accès',
    'sulu_media.add_hotspot' => 'Ajouter un point d\'accès',
    'sulu_media.hotspot_type' => 'Type de point d\'accès',
    'sulu_media.form_type' => 'Type de formulaire',
    'sulu_media.circle' => 'Cercle',
    'sulu_media.point' => 'Point',
    'sulu_media.rectangle' => 'Rectangle',
    'sulu_page.webspaces' => 'Espaces web',
    'sulu_page.selection_label' => '{count} {count, plural, =1 {page sélectionnée} other {pages sélectionnées}}',
    'sulu_page.selection_overlay_title' => 'Choisir les pages',
    'sulu_page.seo' => 'SEO',
    'sulu_page.excerpt' => 'Extraits & catégories',
    'sulu_page.title' => 'Titre',
    'sulu_page.show_ghost_and_shadow' => 'Montrer les pages fantômes et alternatives',
    'sulu_page.no_page_selected' => 'Aucune page sélectionnée',
    'sulu_page.single_selection_overlay_title' => 'Choisir une page',
    'sulu_page.settings' => 'Réglages',
    'sulu_page.show_page_in' => 'Afficher la page dans',
    'sulu_page.no_navigation' => 'pas de navigation',
    'sulu_page.all_navigations' => 'toutes les navigations',
    'sulu_page.page_type' => 'Type de page',
    'sulu_page.content' => 'Contenus',
    'sulu_page.pages' => 'Pages',
    'sulu_page.page' => 'Page',
    'sulu_page.internal_link' => 'Lien interne',
    'sulu_page.external_link' => 'Lien externe',
    'sulu_page.link_title' => 'Titre du lien',
    'sulu_page.linked_content' => 'Contenu lié',
    'sulu_page.url' => 'URL',
    'sulu_page.shadow_page' => 'Page alternative',
    'sulu_page.enable_shadow_page' => 'Activé la page alternative',
    'sulu_page.enable_shadow_page_info_text' => 'Cette fonction est désactivée si la langue actuelle est déjà utilisée comme langue alternative.',
    'sulu_page.shadow_locale' => 'Langue alternative',
    'sulu_page.editing_information' => 'Modifier les informations',
    'sulu_page.authored_date' => 'Date de création',
    'sulu_page.author' => 'Auteur',
    'sulu_page.changelog' => 'Historique des modifications',
    'sulu_page.text_for_more_link' => 'Texte pour plus de liens',
    'sulu_page.icons' => 'Icônes',
    'sulu_page.images' => 'Images',
    'sulu_page.edited' => 'édité',
    'sulu_page.search_result' => 'Aperçu de la page de résultats des moteurs de recherche (SERP)',
    'sulu_page.meta_title' => 'Titre (méta titre)',
    'sulu_page.meta_title_info_text' => 'Le méta titre est limité à 55 caractères.',
    'sulu_page.meta_description' => 'Description (méta description)',
    'sulu_page.meta_description_info_text' => 'La méta description est limitée à 320 caractères.',
    'sulu_page.meta_keywords' => 'Mots-clés (méta mots-clés)',
    'sulu_page.meta_keywords_info_text' => 'Veuillez utiliser un maximum de 5 mots-clés, en fonction du contenu de la page, séparés par des virgules.',
    'sulu_page.canonical_url' => 'URL canonique (étiquette canonique)',
    'sulu_page.no_index' => 'no-index (la page ne sera pas indexée par les moteurs de recherche)',
    'sulu_page.no_follow' => 'no-follow (les liens sur la page ne seront pas consultés par les moteurs de recherche)',
    'sulu_page.hide_in_sitemap' => 'Cacher dans le plan du site',
    'sulu_page.delete_draft' => 'Supprimer le brouillon',
    'sulu_page.delete_draft_warning_title' => 'Supprimer le brouillon?',
    'sulu_page.delete_draft_warning_text' => 'Voulez-vous vraiment supprimer le brouillon ? Toutes les données seront perdues. La page publiée ne sera pas modifiée.',
    'sulu_page.unpublish_warning_title' => 'Définir comme non publié?',
    'sulu_page.unpublish_warning_text' => 'Voulez-vous vraiment annuler la publication de la page ? Tous les liens du site Web seront perdus. Ce paramètre peut être modifié à tout moment sans perte de données.',
    'sulu_page.unpublish' => 'Définir comme non publié',
    'sulu_page.restore_version' => 'Restaurer la version ?',
    'sulu_page.restore_version_text' => 'Un nouveau brouillon sera créé. Une version existante sera remplacée',
    'sulu_page.hide_block_label' => 'Ne pas afficher sur le site web public',
    'sulu_page.hide_block_description' => 'Le bloc ne sera pas publié, mais reste modifiable dans l\'admin.',
    'sulu_page.segment_label' => 'Attribuer un segment',
    'sulu_page.segment_description' => 'Le bloc sera automatiquement filtré sur le site pour le segment choisi.',
    'sulu_page.target_groups_label' => 'Attribuer des groupes cibles',
    'sulu_page.target_groups_description' => 'Le bloc ne sera visible que pour les groupes cibles sélectionnés.',
    'sulu_preview.auto' => 'Automatique',
    'sulu_preview.desktop' => 'Ordinateur',
    'sulu_preview.tablet' => 'Tablette',
    'sulu_preview.smartphone' => 'Téléphone',
    'sulu_preview.reload' => 'Recharger',
    'sulu_preview.open_in_window' => 'Ouvrir dans la fenêtre',
    'sulu_search.search' => 'Rechercher',
    'sulu_search.everything' => 'Tout',
    'sulu_search.search_hint' => 'Utilisez (*) dans votre requête pour remplacer une partie d\'un mot.',
    'sulu_search.nothing_found' => 'Rien n\'a été trouvé pour votre terme de recherche.',
    'sulu_security.roles' => 'Rôles utilisateur',
    'sulu_security.user_name' => 'Nom d\'utilisateur',
    'sulu_security.enable_user' => 'Activer l\'utilisateur',
    'sulu_security.user_locked' => 'Utilisateur verrouillé',
    'sulu_security.permissions' => 'Permissions',
    'sulu_security.password' => 'Mot de passe',
    'sulu_security.email' => 'Courriel',
    'sulu_security.system' => 'Système',
    'sulu_security.system_language' => 'Langue du système',
    'sulu_security.reset_mail_subject' => 'Réinitialiser votre mot de passe Sulu',
    'sulu_security.reset_mail_message' => 'Pour réinitialiser votre mot de passe Sulu, veuillez cliquer sur le lien suivant ou le copier/coller dans votre navigateur :',
    'sulu_security.view' => 'Voir',
    'sulu_security.add' => 'Ajouter',
    'sulu_security.edit' => 'Editer',
    'sulu_security.delete' => 'Supprimer',
    'sulu_security.live' => 'En direct',
    'sulu_security.security' => 'Sécurité',
    'sulu_security.system_permission_heading' => 'Activer les permissions pour {system}',
    'sulu_security.inherit_permissions_title' => 'Hériter les permissions ?',
    'sulu_security.inherit_permissions_label' => 'Remplacer les permissions des sous-éléments',
    'sulu_security.move_permission_title' => 'Notice',
    'sulu_security.move_permission_warning' => 'Les permissions de l\'élément parent ne seront pas transférées.',
    'sulu_snippet.selection_overlay_title' => 'Choisir des fragments',
    'sulu_snippet.selection_label' => '{count} {count, plural, =1 {fragment sélectionné} other {fragments sélectionnés}}',
    'sulu_snippet.no_snippet_selected' => 'Aucun fragment sélectionné',
    'sulu_snippet.single_snippet_selection_overlay_title' => 'Choisir un fragment',
    'sulu_snippet.snippets' => 'Fragments',
    'sulu_snippet.snippet' => 'Fragment',
    'sulu_snippet.default_snippets' => 'Fragment par défaut',
    'sulu_snippet.snippet_area' => 'Type ou zone',
    'sulu_snippet.taxonomies' => 'Catégorisation',
    'sulu_snippet.webspace_default_snippet' => '%webspaceKey% fragment par défaut',
    'sulu_tag.tags' => 'Étiquettes',
    'sulu_tag.tag' => 'Étiquette',
    'sulu_website.analytics' => 'Statistiques',
    'sulu_website.all_domains' => 'Tous les domaines',
    'sulu_website.domains' => 'Domaines',
    'sulu_website.google_analytics' => 'Google Analytics',
    'sulu_website.google_tag_manager' => 'Gestionnaire d\'étiquettes Google',
    'sulu_website.matomo' => 'Matomo',
    'sulu_website.custom_analytics' => 'Personnalisé',
    'sulu_website.script' => 'Script',
    'sulu_website.key' => 'Clé',
    'sulu_website.matomo_url' => 'URL',
    'sulu_website.matomo_id' => 'Identifiant du site',
    'sulu_website.position' => 'Position',
    'sulu_website.head_open' => 'Entête ouvert',
    'sulu_website.head_close' => 'Entête fermé',
    'sulu_website.body_open' => 'Ouvrir le contenu',
    'sulu_website.body_close' => 'Fermer le contenu',
    'sulu_website.cache_clear' => 'Vider le cache du site',
    'sulu_website.cache_clear_warning_title' => 'Vider le cache du site ?',
    'sulu_website.cache_clear_warning_text' => 'Cette opération va effacer le cache entier pour tous les espaces web. Voulez-vous vraiment continuer?',
  ),
));

$catalogueEn = new MessageCatalogue('en', array (
  'validators' => 
  array (
    'This value should be false.' => 'This value should be false.',
    'This value should be true.' => 'This value should be true.',
    'This value should be of type {{ type }}.' => 'This value should be of type {{ type }}.',
    'This value should be blank.' => 'This value should be blank.',
    'The value you selected is not a valid choice.' => 'The value you selected is not a valid choice.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.',
    'One or more of the given values is invalid.' => 'One or more of the given values is invalid.',
    'This field was not expected.' => 'This field was not expected.',
    'This field is missing.' => 'This field is missing.',
    'This value is not a valid date.' => 'This value is not a valid date.',
    'This value is not a valid datetime.' => 'This value is not a valid datetime.',
    'This value is not a valid email address.' => 'This value is not a valid email address.',
    'The file could not be found.' => 'The file could not be found.',
    'The file is not readable.' => 'The file is not readable.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.',
    'This value should be {{ limit }} or less.' => 'This value should be {{ limit }} or less.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.',
    'This value should be {{ limit }} or more.' => 'This value should be {{ limit }} or more.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.',
    'This value should not be blank.' => 'This value should not be blank.',
    'This value should not be null.' => 'This value should not be null.',
    'This value should be null.' => 'This value should be null.',
    'This value is not valid.' => 'This value is not valid.',
    'This value is not a valid time.' => 'This value is not a valid time.',
    'This value is not a valid URL.' => 'This value is not a valid URL.',
    'The two values should be equal.' => 'The two values should be equal.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'The file is too large.',
    'The file could not be uploaded.' => 'The file could not be uploaded.',
    'This value should be a valid number.' => 'This value should be a valid number.',
    'This file is not a valid image.' => 'This file is not a valid image.',
    'This is not a valid IP address.' => 'This is not a valid IP address.',
    'This value is not a valid language.' => 'This value is not a valid language.',
    'This value is not a valid locale.' => 'This value is not a valid locale.',
    'This value is not a valid country.' => 'This value is not a valid country.',
    'This value is already used.' => 'This value is already used.',
    'The size of the image could not be detected.' => 'The size of the image could not be detected.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'This value should be the user\'s current password.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.',
    'The file was only partially uploaded.' => 'The file was only partially uploaded.',
    'No file was uploaded.' => 'No file was uploaded.',
    'No temporary folder was configured in php.ini.' => 'No temporary folder was configured in php.ini, or the configured folder does not exist.',
    'Cannot write temporary file to disk.' => 'Cannot write temporary file to disk.',
    'A PHP extension caused the upload to fail.' => 'A PHP extension caused the upload to fail.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.',
    'Invalid card number.' => 'Invalid card number.',
    'Unsupported card type or invalid card number.' => 'Unsupported card type or invalid card number.',
    'This is not a valid International Bank Account Number (IBAN).' => 'This is not a valid International Bank Account Number (IBAN).',
    'This value is not a valid ISBN-10.' => 'This value is not a valid ISBN-10.',
    'This value is not a valid ISBN-13.' => 'This value is not a valid ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'This value is neither a valid ISBN-10 nor a valid ISBN-13.',
    'This value is not a valid ISSN.' => 'This value is not a valid ISSN.',
    'This value is not a valid currency.' => 'This value is not a valid currency.',
    'This value should be equal to {{ compared_value }}.' => 'This value should be equal to {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'This value should be greater than {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'This value should be greater than or equal to {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should be identical to {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'This value should be less than {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'This value should be less than or equal to {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'This value should not be equal to {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.',
    'An empty file is not allowed.' => 'An empty file is not allowed.',
    'The host could not be resolved.' => 'The host could not be resolved.',
    'This value does not match the expected {{ charset }} charset.' => 'This value does not match the expected {{ charset }} charset.',
    'This is not a valid Business Identifier Code (BIC).' => 'This is not a valid Business Identifier Code (BIC).',
    'Error' => 'Error',
    'This is not a valid UUID.' => 'This is not a valid UUID.',
    'This value should be a multiple of {{ compared_value }}.' => 'This value should be a multiple of {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'This value should be valid JSON.',
    'This collection should contain only unique elements.' => 'This collection should contain only unique elements.',
    'This value should be positive.' => 'This value should be positive.',
    'This value should be either positive or zero.' => 'This value should be either positive or zero.',
    'This value should be negative.' => 'This value should be negative.',
    'This value should be either negative or zero.' => 'This value should be either negative or zero.',
    'This value is not a valid timezone.' => 'This value is not a valid timezone.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'This password has been leaked in a data breach, it must not be used. Please use another password.',
    'This value should be between {{ min }} and {{ max }}.' => 'This value should be between {{ min }} and {{ max }}.',
    'This value is not a valid hostname.' => 'This value is not a valid hostname.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'The number of elements in this collection should be a multiple of {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'This value should satisfy at least one of the following constraints:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Each element of this collection should satisfy its own set of constraints.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'This value is not a valid International Securities Identification Number (ISIN).',
    'This form should not contain extra fields.' => 'This form should not contain extra fields.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'The uploaded file was too large. Please try to upload a smaller file.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'The CSRF token is invalid. Please try to resubmit the form.',
    'This value is not a valid HTML5 color.' => 'This value is not a valid HTML5 color.',
    'Please enter a valid birthdate.' => 'Please enter a valid birthdate.',
    'The selected choice is invalid.' => 'The selected choice is invalid.',
    'The collection is invalid.' => 'The collection is invalid.',
    'Please select a valid color.' => 'Please select a valid color.',
    'Please select a valid country.' => 'Please select a valid country.',
    'Please select a valid currency.' => 'Please select a valid currency.',
    'Please choose a valid date interval.' => 'Please choose a valid date interval.',
    'Please enter a valid date and time.' => 'Please enter a valid date and time.',
    'Please enter a valid date.' => 'Please enter a valid date.',
    'Please select a valid file.' => 'Please select a valid file.',
    'The hidden field is invalid.' => 'The hidden field is invalid.',
    'Please enter an integer.' => 'Please enter an integer.',
    'Please select a valid language.' => 'Please select a valid language.',
    'Please select a valid locale.' => 'Please select a valid locale.',
    'Please enter a valid money amount.' => 'Please enter a valid money amount.',
    'Please enter a number.' => 'Please enter a number.',
    'The password is invalid.' => 'The password is invalid.',
    'Please enter a percentage value.' => 'Please enter a percentage value.',
    'The values do not match.' => 'The values do not match.',
    'Please enter a valid time.' => 'Please enter a valid time.',
    'Please select a valid timezone.' => 'Please select a valid timezone.',
    'Please enter a valid URL.' => 'Please enter a valid URL.',
    'Please enter a valid search term.' => 'Please enter a valid search term.',
    'Please provide a valid phone number.' => 'Please provide a valid phone number.',
    'The checkbox has an invalid value.' => 'The checkbox has an invalid value.',
    'Please enter a valid email address.' => 'Please enter a valid email address.',
    'Please select a valid option.' => 'Please select a valid option.',
    'Please select a valid range.' => 'Please select a valid range.',
    'Please enter a valid week.' => 'Please enter a valid week.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'An authentication exception occurred.',
    'Authentication credentials could not be found.' => 'Authentication credentials could not be found.',
    'Authentication request could not be processed due to a system problem.' => 'Authentication request could not be processed due to a system problem.',
    'Invalid credentials.' => 'Invalid credentials.',
    'Cookie has already been used by someone else.' => 'Cookie has already been used by someone else.',
    'Not privileged to request the resource.' => 'Not privileged to request the resource.',
    'Invalid CSRF token.' => 'Invalid CSRF token.',
    'No authentication provider found to support the authentication token.' => 'No authentication provider found to support the authentication token.',
    'No session available, it either timed out or cookies are not enabled.' => 'No session available, it either timed out or cookies are not enabled.',
    'No token could be found.' => 'No token could be found.',
    'Username could not be found.' => 'Username could not be found.',
    'Account has expired.' => 'Account has expired.',
    'Credentials have expired.' => 'Credentials have expired.',
    'Account is disabled.' => 'Account is disabled.',
    'Account is locked.' => 'Account is locked.',
    'Too many failed login attempts, please try again later.' => 'Too many failed login attempts, please try again later.',
    'Invalid or expired login link.' => 'Invalid or expired login link.',
  ),
  'admin' => 
  array (
    'sulu_search.search' => 'Search',
    'sulu_search.everything' => 'Everything',
    'sulu_search.search_hint' => 'Use (*) in your query as a placeholder for parts of a word.',
    'sulu_search.nothing_found' => 'Nothing could be found for your search term.',
    'sulu_contact.contacts' => 'Contacts',
    'sulu_contact.organizations' => 'Organizations',
    'sulu_contact.organization' => 'Organization',
    'sulu_contact.people' => 'People',
    'sulu_contact.contact_selection_overlay_title' => 'Choose contacts',
    'sulu_contact.account_selection_overlay_title' => 'Choose accounts',
    'sulu_contact.contact_selection_label' => '{count} {count, plural, =1 {contact} other {contacts}} selected',
    'sulu_contact.account_selection_label' => '{count} {count, plural, =1 {account} other {accounts}} selected',
    'sulu_contact.contact_account_selection_label' => '{count} {count, plural, =1 {contact} other {contacts}} selected',
    'sulu_contact.avatar' => 'Avatar',
    'sulu_contact.logo' => 'Logo',
    'sulu_contact.name' => 'Name',
    'sulu_contact.first_name' => 'First Name',
    'sulu_contact.last_name' => 'Last Name',
    'sulu_contact.contact_details' => 'Contact details',
    'sulu_contact.addresses' => 'Addresses',
    'sulu_contact.bank_accounts' => 'Bank accounts',
    'sulu_contact.email' => 'Email',
    'sulu_contact.primary_address' => 'Primary address',
    'sulu_contact.delivery_address' => 'Delivery address',
    'sulu_contact.billing_address' => 'Billing address',
    'sulu_contact.city' => 'City',
    'sulu_contact.zip' => 'ZIP',
    'sulu_contact.street' => 'Street',
    'sulu_contact.number' => 'Number',
    'sulu_contact.address_line' => 'Addressline',
    'sulu_contact.state' => 'Region',
    'sulu_contact.country' => 'Country',
    'sulu_contact.postbox_number' => 'Postbox #',
    'sulu_contact.postbox_zip' => 'Postbox ZIP',
    'sulu_contact.postbox_city' => 'Postbox City',
    'sulu_contact.phone' => 'Phone',
    'sulu_contact.fax' => 'Fax',
    'sulu_contact.website' => 'Website',
    'sulu_contact.social_media' => 'Social Media',
    'sulu_contact.birthday' => 'Birthday',
    'sulu_contact.title' => 'Title',
    'sulu_contact.salutation' => 'Salutation',
    'sulu_contact.form_of_address' => 'Form of Address',
    'sulu_contact.male_form_of_address' => 'Mr.',
    'sulu_contact.female_form_of_address' => 'Ms.',
    'sulu_contact.position' => 'Position',
    'sulu_contact.corporation' => 'Corporation',
    'sulu_contact.main_contact' => 'Main Contact',
    'sulu_contact.uid' => 'UID',
    'sulu_contact.register_number' => 'Register Number',
    'sulu_contact.jurisdiction' => 'Jurisdiction',
    'sulu_contact.note' => 'Note',
    'sulu_contact.parent_company' => 'Parent Company',
    'sulu_contact.upload_avatar_info_text' => 'Drop image or click to change avatar',
    'sulu_contact.upload_logo_info_text' => 'Drop image or click to change logo',
    'sulu_contact.no_contact_selected' => 'No contact selected',
    'sulu_contact.single_contact_selection_overlay_title' => 'Choose contact',
    'sulu_contact.no_account_selected' => 'No account selected',
    'sulu_contact.single_account_selection_overlay_title' => 'Choose account',
    'sulu_contact.taxonomies' => 'Taxonomies',
    'sulu_contact.add_address' => 'Add address',
    'sulu_contact.edit_address' => 'Edit address',
    'sulu_contact.add_bank_account' => 'Add bank account',
    'sulu_contact.edit_bank_account' => 'Edit bank account',
    'sulu_contact.work' => 'Work',
    'sulu_contact.private' => 'Private',
    'sulu_contact.mobile' => 'Mobile',
    'sulu_contact.bank' => 'Bank',
    'sulu_contact.iban' => 'IBAN',
    'sulu_contact.bic' => 'BIC',
    'sulu_contact.edit_title_overlay_title' => 'Edit titles',
    'sulu_contact.edit_position_overlay_title' => 'Edit positions',
    'sulu_contact.documents' => 'Documents',
    'sulu_contact.delete_media_warning_title' => 'Remove document assignment?',
    'sulu_contact.delete_media_warning_text' => 'This operation removes the selected document assignments. The document itself will not be deleted. Do you really wish to proceed?',
    'sulu_contact.add_contact_to_organization' => 'Add contact to organization',
    'sulu_contact.latitude' => 'Latitude',
    'sulu_contact.longitude' => 'Longitude',
    'sulu_media.media' => 'Media',
    'sulu_media.all_media' => 'All media',
    'sulu_media.audio' => 'Audio',
    'sulu_media.document' => 'Document',
    'sulu_media.image' => 'Image',
    'sulu_media.video' => 'Video',
    'sulu_media.copy_url' => 'Copy URL',
    'sulu_media.download_masterfile' => 'Download master file',
    'sulu_media.select_media_singular' => 'Select media',
    'sulu_media.select_media_plural' => 'Select media',
    'sulu_media.reset_selection' => 'Reset selection',
    'sulu_media.copy_masterfile_url' => 'Copy master file URL',
    'sulu_media.copy_masterfile_url_website' => 'Copy master file URL (Website)',
    'sulu_media.information_taxonomy' => 'Information and Taxonomy',
    'sulu_media.upload' => 'Upload',
    'sulu_media.upload_new_version' => 'Upload new version',
    'sulu_media.media_selected_singular' => 'media element selected',
    'sulu_media.media_selected_plural' => 'media elements selected',
    'sulu_media.drop_files_to_upload' => 'Upload files per drag`n`drop',
    'sulu_media.click_here_to_upload' => 'or click here to upload files',
    'sulu_media.add_collection' => 'Add collection',
    'sulu_media.remove_collection' => 'Delete collection',
    'sulu_media.remove_collection_warning' => 'This operation deletes a collection and cannot be undone. Do you really wish to proceed?',
    'sulu_media.move_collection' => 'Move collection',
    'sulu_media.edit_collection' => 'Edit collection',
    'sulu_media.download_media' => 'Download media',
    'sulu_media.download_counter' => 'Download count',
    'sulu_media.delete_media' => 'Delete media',
    'sulu_media.delete_media_warning_title' => 'Delete media',
    'sulu_media.delete_media_warning_text' => 'This operation deletes a media and cannot be undone. Do you really wish to proceed?',
    'sulu_media.delete_preview_image_warning_title' => 'Delete preview image',
    'sulu_media.delete_preview_image_warning_text' => 'This operation deletes the preview image and cannot be undone. Do you really wish to proceed?',
    'sulu_media.thumbnail' => 'Thumbnail',
    'sulu_media.type' => 'Type',
    'sulu_media.version' => 'Version',
    'sulu_media.size' => 'Filesize',
    'sulu_media.mime_type' => 'MIME-Type',
    'sulu_media.license' => 'License',
    'sulu_media.copyright' => 'Copyright Information',
    'sulu_media.credits' => 'Credits',
    'sulu_media.taxonomies' => 'Taxonomies',
    'sulu_media.history' => 'History',
    'sulu_media.formats' => 'Formats',
    'sulu_media.all_collections' => 'All collections',
    'sulu_media.move_media' => 'Move media',
    'sulu_media.upload_server_error' => 'There was an error while uploading one or multiple files to the server.',
    'sulu_media.set_focus_point' => 'Set focus point',
    'sulu_media.define_crops' => 'Define crops',
    'sulu_media.upload_preview_image' => 'Upload preview image',
    'sulu_media.delete_preview_image' => 'Delete preview image',
    'sulu_media.cropped' => 'Cropped',
    'sulu_media.double_click_crop_and_maximize' => 'A double-click maximizes and centers the area',
    'sulu_media.min_size_notification' => 'Minimal size reached',
    'sulu_media.left_top' => 'Left top',
    'sulu_media.top' => 'Top',
    'sulu_media.right_top' => 'Right top',
    'sulu_media.left' => 'Left',
    'sulu_media.middle' => 'Middle',
    'sulu_media.right' => 'Right',
    'sulu_media.left_bottom' => 'Left bottom',
    'sulu_media.bottom' => 'Bottom',
    'sulu_media.right_bottom' => 'Right bottom',
    'sulu_media.hotspots' => 'Hotspots',
    'sulu_media.add_hotspot' => 'Add hotspot',
    'sulu_media.hotspot_type' => 'Hotspot type',
    'sulu_media.form_type' => 'Form type',
    'sulu_media.circle' => 'Circle',
    'sulu_media.point' => 'Point',
    'sulu_media.rectangle' => 'Rectangle',
    'sulu_security.roles' => 'User roles',
    'sulu_security.user_name' => 'Username',
    'sulu_security.enable_user' => 'Enable User',
    'sulu_security.user_locked' => 'User locked',
    'sulu_security.permissions' => 'Permissions',
    'sulu_security.password' => 'Password',
    'sulu_security.email' => 'Email',
    'sulu_security.system' => 'System',
    'sulu_security.system_language' => 'System language',
    'sulu_security.reset_mail_subject' => 'Reset your Sulu password',
    'sulu_security.reset_mail_message' => 'To reset your Sulu password please click on the following link or copy/paste it to your browser:',
    'sulu_security.view' => 'View',
    'sulu_security.add' => 'Add',
    'sulu_security.edit' => 'Edit',
    'sulu_security.delete' => 'Delete',
    'sulu_security.live' => 'Live',
    'sulu_security.security' => 'Security',
    'sulu_security.system_permission_heading' => 'Activate permissions for {system}',
    'sulu_security.inherit_permissions_title' => 'Inherit permissions?',
    'sulu_security.inherit_permissions_label' => 'Override permissions of sub elements',
    'sulu_security.move_permission_title' => 'Notice',
    'sulu_security.move_permission_warning' => 'Permissions from the parent element will not be transferred.',
    'sulu_category.categories' => 'Categories',
    'sulu_category.key' => 'Key',
    'sulu_category.name' => 'Name',
    'sulu_category.keywords' => 'Keywords',
    'sulu_category.keyword' => 'Keyword',
    'sulu_category.multiple_usage' => 'Multiple Usage',
    'sulu_category.all_categories' => 'All categories',
    'sulu_category.no_category_selected' => 'No category selected',
    'sulu_category.single_category_selection_overlay_title' => 'Choose category',
    'sulu_snippet.selection_overlay_title' => 'Choose snippets',
    'sulu_snippet.selection_label' => '{count} {count, plural, =1 {snippet} other {snippets}} selected',
    'sulu_snippet.no_snippet_selected' => 'No snippet selected',
    'sulu_snippet.single_snippet_selection_overlay_title' => 'Choose snippet',
    'sulu_snippet.snippets' => 'Snippets',
    'sulu_snippet.snippet' => 'Snippet',
    'sulu_snippet.default_snippets' => 'Default Snippets',
    'sulu_snippet.snippet_area' => 'Type or area',
    'sulu_snippet.taxonomies' => 'Taxonomies',
    'sulu_snippet.webspace_default_snippet' => '%webspaceKey% default snippet',
    'sulu_page.webspaces' => 'Webspaces',
    'sulu_page.selection_label' => '{count} {count, plural, =1 {page} other {pages}} selected',
    'sulu_page.selection_overlay_title' => 'Choose pages',
    'sulu_page.seo' => 'SEO',
    'sulu_page.excerpt' => 'Excerpt & Taxonomies',
    'sulu_page.title' => 'Title',
    'sulu_page.show_ghost_and_shadow' => 'Show ghost and shadow pages',
    'sulu_page.no_page_selected' => 'No page selected',
    'sulu_page.single_selection_overlay_title' => 'Choose page',
    'sulu_page.settings' => 'Settings',
    'sulu_page.show_page_in' => 'Show page in',
    'sulu_page.no_navigation' => 'no navigation',
    'sulu_page.all_navigations' => 'all navigations',
    'sulu_page.page_type' => 'Page Type',
    'sulu_page.content' => 'Content',
    'sulu_page.pages' => 'Pages',
    'sulu_page.page' => 'Page',
    'sulu_page.internal_link' => 'Internal Link',
    'sulu_page.external_link' => 'External Link',
    'sulu_page.link_title' => 'Link Title',
    'sulu_page.linked_content' => 'Linked Content',
    'sulu_page.url' => 'URL',
    'sulu_page.shadow_page' => 'Shadow Page',
    'sulu_page.enable_shadow_page' => 'Enable Shadow Page',
    'sulu_page.enable_shadow_page_info_text' => 'This function is disabled if the current locale is already used as shadow locale.',
    'sulu_page.shadow_locale' => 'Shadow Locale',
    'sulu_page.editing_information' => 'Editing Information',
    'sulu_page.authored_date' => 'Authored Date',
    'sulu_page.author' => 'Author',
    'sulu_page.changelog' => 'Changelog',
    'sulu_page.text_for_more_link' => 'Text for more link',
    'sulu_page.icons' => 'Icons',
    'sulu_page.images' => 'Images',
    'sulu_page.edited' => 'edited',
    'sulu_page.search_result' => 'Search Engine Result Pages Preview (SERP)',
    'sulu_page.meta_title' => 'Title (Meta title)',
    'sulu_page.meta_title_info_text' => 'The meta title is limited to 55 characters.',
    'sulu_page.meta_description' => 'Description (Meta description)',
    'sulu_page.meta_description_info_text' => 'The meta description is limited to 320 characters.',
    'sulu_page.meta_keywords' => 'Keywords (Meta keywords)',
    'sulu_page.meta_keywords_info_text' => 'Please use a maximum of 5 keywords, dependant from the content of the page, separated by commas.',
    'sulu_page.canonical_url' => 'Canonical URL  (Canonical tag)',
    'sulu_page.no_index' => 'no-index (page will not be indexed by search engines)',
    'sulu_page.no_follow' => 'no-follow (links on this page will not be followed by the search engine)',
    'sulu_page.hide_in_sitemap' => 'Hide in sitemap',
    'sulu_page.delete_draft' => 'Delete draft',
    'sulu_page.delete_draft_warning_title' => 'Delete Draft?',
    'sulu_page.delete_draft_warning_text' => 'Do you really want to delete the draft? All data will be lost. The published page will not be changed.',
    'sulu_page.unpublish_warning_title' => 'Set to unpublished?',
    'sulu_page.unpublish_warning_text' => 'Do you really want to unpublish the page? All website links will be lost. This setting can be changed at any time without data loss.',
    'sulu_page.unpublish' => 'Set to unpublished',
    'sulu_page.restore_version' => 'Restore version?',
    'sulu_page.restore_version_text' => 'A new draft will be created. An existing draft version will be overwritten',
    'sulu_page.hide_block_label' => 'Don\'t display on public website',
    'sulu_page.hide_block_description' => 'This block will not be published, but remains editable in the admin.',
    'sulu_page.segment_label' => 'Assign segment',
    'sulu_page.segment_description' => 'The block will be automatically filtered on the website by the chosen segment.',
    'sulu_page.target_groups_label' => 'Assign target groups',
    'sulu_page.target_groups_description' => 'The block will only be visible for the selected target groups.',
    'sulu_tag.tags' => 'Tags',
    'sulu_tag.tag' => 'Tag',
    'sulu_website.analytics' => 'Analytics',
    'sulu_website.all_domains' => 'All domains',
    'sulu_website.domains' => 'Domains',
    'sulu_website.google_analytics' => 'Google Analytics',
    'sulu_website.google_tag_manager' => 'Google Tag Manager',
    'sulu_website.matomo' => 'Matomo',
    'sulu_website.custom_analytics' => 'Custom',
    'sulu_website.script' => 'Script',
    'sulu_website.key' => 'Key',
    'sulu_website.matomo_url' => 'URL',
    'sulu_website.matomo_id' => 'Site-ID',
    'sulu_website.position' => 'Position',
    'sulu_website.head_open' => 'Head open',
    'sulu_website.head_close' => 'Head close',
    'sulu_website.body_open' => 'Body open',
    'sulu_website.body_close' => 'Body close',
    'sulu_website.cache_clear' => 'Clear website cache',
    'sulu_website.cache_clear_warning_title' => 'Clear website cache?',
    'sulu_website.cache_clear_warning_text' => 'This operation will clear the entire cache for all webspaces. Do you really wish to proceed?',
    'sulu_location.latitude' => 'Latitude',
    'sulu_location.longitude' => 'Longitude',
    'sulu_location.zoom' => 'Zoom',
    'sulu_location.select_location' => 'Select location',
    'sulu_location.additional_information' => 'Additional Information',
    'sulu_location.title' => 'Title',
    'sulu_location.street' => 'Street',
    'sulu_location.number' => 'Number',
    'sulu_location.code' => 'Code',
    'sulu_location.town' => 'Town',
    'sulu_location.country' => 'Country',
    'sulu_custom_url.custom_urls' => 'Custom URLs',
    'sulu_custom_url.custom_url' => 'Custom URL',
    'sulu_custom_url.published' => 'Published',
    'sulu_custom_url.base_domain' => 'Base domain',
    'sulu_custom_url.target_page' => 'Target page',
    'sulu_custom_url.target_locale' => 'Localization',
    'sulu_custom_url.redirect' => 'Redirect',
    'sulu_custom_url.redirect_info' => 'The custom URL will be redirected to URL of the linked page.',
    'sulu_custom_url.canonical' => 'Canonical URL',
    'sulu_custom_url.canonical_info' => 'When the Canonical URL has been activated only the linked page will be indexed by search engines',
    'sulu_custom_url.no_index' => 'No Index',
    'sulu_custom_url.no_index_info' => 'The page will not be indexed by search engines.',
    'sulu_custom_url.no_follow' => 'No Follow',
    'sulu_custom_url.no_follow_info' => 'The links on the page will not be followed by search engines.',
    'sulu_custom_url.target_title' => 'Target page',
    'sulu_admin.add' => 'Add',
    'sulu_admin.add_block' => 'Add block',
    'sulu_admin.delete' => 'Delete',
    'sulu_admin.move' => 'Move',
    'sulu_admin.move_items' => 'Move items',
    'sulu_admin.copy' => 'Copy',
    'sulu_admin.order' => 'Order',
    'sulu_admin.of' => 'of',
    'sulu_admin.page' => 'Page',
    'sulu_admin.per_page' => 'Items per page',
    'sulu_admin.save' => 'Save',
    'sulu_admin.save_draft' => 'Save as draft',
    'sulu_admin.save_publish' => 'Save and publish',
    'sulu_admin.publish' => 'Publish',
    'sulu_admin.create' => 'Create',
    'sulu_admin.edit' => 'Edit',
    'sulu_admin.object' => 'Object',
    'sulu_admin.objects' => 'Objects',
    'sulu_admin.reached_end_of_list' => 'You reached the end of the list',
    'sulu_admin.confirm' => 'Confirm',
    'sulu_admin.ok' => 'Ok',
    'sulu_admin.cancel' => 'Cancel',
    'sulu_admin.apply' => 'Apply',
    'sulu_admin.yes' => 'Yes',
    'sulu_admin.no' => 'No',
    'sulu_admin.type' => 'Type',
    'sulu_admin.default' => 'Default',
    'sulu_admin.error_required' => 'This field must have a value',
    'sulu_admin.error_minlength' => 'The minimal length of this field was undershot',
    'sulu_admin.error_minitems' => 'This field has too few selections',
    'sulu_admin.welcome' => 'Welcome',
    'sulu_admin.reset_password' => 'Reset password',
    'sulu_admin.reset_password_error' => 'The passwords do not match',
    'sulu_admin.back_to_website' => 'Back to website',
    'sulu_admin.username_or_email' => 'Username or Email',
    'sulu_admin.password' => 'Password',
    'sulu_admin.repeat_password' => 'Repeat password',
    'sulu_admin.login' => 'Login',
    'sulu_admin.login_error' => 'This Email/Password combination is wrong. Please try again.',
    'sulu_admin.to_login' => 'Back to login',
    'sulu_admin.reset' => 'Reset',
    'sulu_admin.reset_resend' => 'Resend',
    'sulu_admin.forgot_password' => 'Forgot password',
    'sulu_admin.forgot_password_success' => 'An email with instructions how to reset your password has been sent if a user was found',
    'sulu_admin.list_search_placeholder' => 'Search…',
    'sulu_admin.error' => 'Error',
    'sulu_admin.warning' => 'Warning',
    'sulu_admin.close' => 'Close',
    'sulu_admin.id' => 'ID',
    'sulu_admin.key' => 'Key',
    'sulu_admin.title' => 'Title',
    'sulu_admin.name' => 'Name',
    'sulu_admin.description' => 'Description',
    'sulu_admin.url' => 'URL',
    'sulu_admin.creator' => 'Creator',
    'sulu_admin.created' => 'Created on',
    'sulu_admin.changer' => 'Changer',
    'sulu_admin.changed' => 'Changed on',
    'sulu_admin.published' => 'Published on',
    'sulu_admin.authored' => 'Authored on',
    'sulu_admin.author' => 'Author',
    'sulu_admin.delete_warning_title' => 'Delete?',
    'sulu_admin.delete_warning_text' => 'This operation deletes data and cannot be undone. Do you really wish to proceed?',
    'sulu_admin.delete_linked_warning_title' => 'Confirm deletion',
    'sulu_admin.delete_linked_warning_text' => 'This item is referenced by the following items, are you sure you want to delete it?',
    'sulu_admin.delete_selection_warning_text' => 'This operation deletes {count} {count, plural, =1 {item} other {items}} and cannot be undone. Do you really wish to proceed?',
    'sulu_admin.item_not_deletable' => 'Item cannot be deleted',
    'sulu_admin.delete_linked_abort_text' => 'This item cannot be deleted as long as it has sub items. Delete the following sub items or remove the relation:',
    'sulu_admin.ghost_dialog_title' => 'Copy language?',
    'sulu_admin.ghost_dialog_description' => 'This page does not exist in this language. Do you want to copy content from another language?',
    'sulu_admin.choose_language' => 'Choose language',
    'sulu_admin.characters_left' => 'characters left',
    'sulu_admin.segments_left' => 'segments left',
    'sulu_admin.copy_locale' => 'Copy locale',
    'sulu_admin.choose_target_locale' => 'Choose target locales',
    'sulu_admin.copy_locale_dialog_description' => '* New locale will be created',
    'sulu_admin.move_copy_overlay_title' => 'Choose parent-page',
    'sulu_admin.filter_overlay_title' => 'Configure {fieldLabel}',
    'sulu_admin.data_source' => 'Select source',
    'sulu_admin.choose_data_source' => 'Choose source',
    'sulu_admin.include_sub_elements' => 'Include sub elements',
    'sulu_admin.filter_by_categories' => 'Filter by categories',
    'sulu_admin.any_category_description' => 'Use elements that use any category',
    'sulu_admin.all_categories_description' => 'Use elements that use all categories',
    'sulu_admin.choose_categories' => 'Choose categories',
    'sulu_admin.filter_by_tags' => 'Filter by tags',
    'sulu_admin.any_tag_description' => 'Use elements that use any tag',
    'sulu_admin.all_tags_description' => 'Use elements that use all tags',
    'sulu_admin.filter_by_types' => 'Filter by types',
    'sulu_admin.all_types' => 'All types selected',
    'sulu_admin.no_types' => 'No types selected',
    'sulu_admin.target_groups' => 'Target groups',
    'sulu_admin.use_target_groups' => 'Use target groups',
    'sulu_admin.sort_by' => 'Sort by',
    'sulu_admin.ascending' => 'Ascending',
    'sulu_admin.descending' => 'Descending',
    'sulu_admin.present_as' => 'Present as',
    'sulu_admin.limit_result_to' => 'Limit result to',
    'sulu_admin.smart_content_label' => '{count} {count, plural, =1 {element} other {elements}} selected',
    'sulu_admin.smart_content_block_preview' => 'Smart Content {limit, select, undefined{} other{displaying up to {limit} elements}}',
    'sulu_admin.order_warning_title' => 'Rearrange items',
    'sulu_admin.order_warning_text' => 'The operation you are about to do will rearrange items.',
    'sulu_admin.activate_all' => 'Activate all',
    'sulu_admin.deactivate_all' => 'Deactivate all',
    'sulu_admin.all_selected' => 'All selected',
    'sulu_admin.none_selected' => 'None selected',
    'sulu_admin.please_choose' => 'Please choose',
    'sulu_admin.column_options' => 'Column options',
    'sulu_admin.changelog_line_changer' => 'Last change {changer, select, undefined{} other{from {changer}}} at {changed}',
    'sulu_admin.changelog_line_creator' => 'Created {creator, select, undefined{} other{by {creator}}} at {created}',
    'sulu_admin.settings' => 'Settings',
    'sulu_admin.move_selected' => 'Move selected',
    'sulu_admin.details' => 'Details',
    'sulu_admin.edit_entries' => 'Edit entries',
    'sulu_admin.paragraph' => 'Paragraph',
    'sulu_admin.heading1' => 'Heading 1',
    'sulu_admin.heading2' => 'Heading 2',
    'sulu_admin.heading3' => 'Heading 3',
    'sulu_admin.heading4' => 'Heading 4',
    'sulu_admin.heading5' => 'Heading 5',
    'sulu_admin.heading6' => 'Heading 6',
    'sulu_admin.dirty_warning_dialog_title' => 'Leave form?',
    'sulu_admin.dirty_warning_dialog_text' => 'Changes you made will not be saved.',
    'sulu_admin.export' => 'Export',
    'sulu_admin.export_overlay_title' => 'Configure data format',
    'sulu_admin.delimiter' => 'Delimiter',
    'sulu_admin.enclosure' => 'Enclosure',
    'sulu_admin.escape' => 'Escape',
    'sulu_admin.new_line' => 'New line',
    'sulu_admin.delimiter_description' => 'Character for column separation.',
    'sulu_admin.enclosure_description' => 'Enclose multiple word entries.',
    'sulu_admin.escape_description' => 'Add-on for special characters.',
    'sulu_admin.new_line_description' => 'Character for line brake.',
    'sulu_admin.delimiter_tab' => 'Tab',
    'sulu_admin.enclosure_nothing' => 'Nothing',
    'sulu_admin.link' => 'Link',
    'sulu_admin.link_title' => 'Alternative title',
    'sulu_admin.link_target' => 'Link Target',
    'sulu_admin.link_url' => 'Link URL',
    'sulu_admin.mail_subject' => 'E-Mail Subject',
    'sulu_admin.mail_body' => 'E-Mail Text',
    'sulu_admin.show_history' => 'Show history',
    'sulu_admin.history' => 'History',
    'sulu_admin.resource_locator_history_delete_warning' => 'The URL will be deleted for all draft and live versions. This cannot be undone. Do you wish to proceed?',
    'sulu_admin.has_changed_warning_dialog_title' => 'Content will be overwritten!',
    'sulu_admin.has_changed_warning_dialog_text' => 'This content has been edited by another user. When you save the content this data will get lost.',
    'sulu_admin.edit_profile' => 'Edit profile',
    'sulu_admin.no_permissions' => 'No permissions',
    'sulu_admin.no_options_available' => 'No options available',
    'sulu_admin.form_contains_invalid_values' => 'The form contains invalid values',
    'sulu_admin.form_save_server_error' => 'There was an error when trying to save the form',
    'sulu_admin.form_used_by' => 'This form is currently used by',
    'sulu_admin.refresh_url' => 'Refresh URL',
    'sulu_admin.from' => 'from',
    'sulu_admin.until' => 'until',
    'sulu_admin.external_link' => 'External Link',
    'sulu_admin.internal_link' => 'Internal Link',
    'sulu_admin.block_settings' => 'Block settings',
    'sulu_admin.hide_block' => 'Hide this block on website',
    'sulu_admin.segment' => 'Segment',
    'sulu_admin.missing_type_dialog_title' => 'Choose new template',
    'sulu_admin.missing_type_dialog_description' => 'The template for the copied page does not exist in this webspace.',
    'sulu_preview.auto' => 'Auto',
    'sulu_preview.desktop' => 'Desktop',
    'sulu_preview.tablet' => 'Tablet',
    'sulu_preview.smartphone' => 'Smartphone',
    'sulu_preview.reload' => 'Reload',
    'sulu_preview.open_in_window' => 'Open in window',
  ),
));
$catalogue->addFallbackCatalogue($catalogueEn);

return $catalogue;
